/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity.villager;

import com.destroystokyo.paper.entity.villager.ReputationType;
import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.Map;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class Reputation {
    private final Map<ReputationType, Integer> reputation;

    public Reputation() {
        this(new EnumMap<ReputationType, Integer>(ReputationType.class));
    }

    public Reputation(Map<ReputationType, Integer> reputation) {
        Preconditions.checkNotNull(reputation, (Object)"reputation cannot be null");
        this.reputation = reputation;
    }

    public int getReputation(ReputationType type) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"the reputation type cannot be null");
        return this.reputation.getOrDefault((Object)type, 0);
    }

    public void setReputation(ReputationType type, int value) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"the reputation type cannot be null");
        this.reputation.put(type, value);
    }

    public boolean hasReputationSet(ReputationType type) {
        return this.reputation.containsKey((Object)type);
    }
}

