package io.papermc.paper.registry.keys;

import static net.kyori.adventure.key.Key.key;

import io.papermc.paper.generated.GeneratedFrom;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import net.kyori.adventure.key.Key;
import org.bukkit.damage.DamageType;
import org.jspecify.annotations.NullMarked;

/**
 * Vanilla keys for {@link RegistryKey#DAMAGE_TYPE}.
 *
 * @apiNote The fields provided here are a direct representation of
 * what is available from the vanilla game source. They may be
 * changed (including removals) on any Minecraft version
 * bump, so cross-version compatibility is not provided on the
 * same level as it is on most of the other API.
 */
@SuppressWarnings({
        "unused",
        "SpellCheckingInspection"
})
@NullMarked
@GeneratedFrom("1.21.8")
public final class DamageTypeKeys {
    /**
     * {@code minecraft:arrow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> ARROW = create(key("arrow"));

    /**
     * {@code minecraft:bad_respawn_point}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> BAD_RESPAWN_POINT = create(key("bad_respawn_point"));

    /**
     * {@code minecraft:cactus}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> CACTUS = create(key("cactus"));

    /**
     * {@code minecraft:campfire}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> CAMPFIRE = create(key("campfire"));

    /**
     * {@code minecraft:cramming}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> CRAMMING = create(key("cramming"));

    /**
     * {@code minecraft:dragon_breath}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> DRAGON_BREATH = create(key("dragon_breath"));

    /**
     * {@code minecraft:drown}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> DROWN = create(key("drown"));

    /**
     * {@code minecraft:dry_out}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> DRY_OUT = create(key("dry_out"));

    /**
     * {@code minecraft:ender_pearl}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> ENDER_PEARL = create(key("ender_pearl"));

    /**
     * {@code minecraft:explosion}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> EXPLOSION = create(key("explosion"));

    /**
     * {@code minecraft:fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> FALL = create(key("fall"));

    /**
     * {@code minecraft:falling_anvil}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> FALLING_ANVIL = create(key("falling_anvil"));

    /**
     * {@code minecraft:falling_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> FALLING_BLOCK = create(key("falling_block"));

    /**
     * {@code minecraft:falling_stalactite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> FALLING_STALACTITE = create(key("falling_stalactite"));

    /**
     * {@code minecraft:fireball}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> FIREBALL = create(key("fireball"));

    /**
     * {@code minecraft:fireworks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> FIREWORKS = create(key("fireworks"));

    /**
     * {@code minecraft:fly_into_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> FLY_INTO_WALL = create(key("fly_into_wall"));

    /**
     * {@code minecraft:freeze}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> FREEZE = create(key("freeze"));

    /**
     * {@code minecraft:generic}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> GENERIC = create(key("generic"));

    /**
     * {@code minecraft:generic_kill}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> GENERIC_KILL = create(key("generic_kill"));

    /**
     * {@code minecraft:hot_floor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> HOT_FLOOR = create(key("hot_floor"));

    /**
     * {@code minecraft:in_fire}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> IN_FIRE = create(key("in_fire"));

    /**
     * {@code minecraft:in_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> IN_WALL = create(key("in_wall"));

    /**
     * {@code minecraft:indirect_magic}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> INDIRECT_MAGIC = create(key("indirect_magic"));

    /**
     * {@code minecraft:lava}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> LAVA = create(key("lava"));

    /**
     * {@code minecraft:lightning_bolt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> LIGHTNING_BOLT = create(key("lightning_bolt"));

    /**
     * {@code minecraft:mace_smash}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> MACE_SMASH = create(key("mace_smash"));

    /**
     * {@code minecraft:magic}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> MAGIC = create(key("magic"));

    /**
     * {@code minecraft:mob_attack}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> MOB_ATTACK = create(key("mob_attack"));

    /**
     * {@code minecraft:mob_attack_no_aggro}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> MOB_ATTACK_NO_AGGRO = create(key("mob_attack_no_aggro"));

    /**
     * {@code minecraft:mob_projectile}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> MOB_PROJECTILE = create(key("mob_projectile"));

    /**
     * {@code minecraft:on_fire}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> ON_FIRE = create(key("on_fire"));

    /**
     * {@code minecraft:out_of_world}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> OUT_OF_WORLD = create(key("out_of_world"));

    /**
     * {@code minecraft:outside_border}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> OUTSIDE_BORDER = create(key("outside_border"));

    /**
     * {@code minecraft:player_attack}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> PLAYER_ATTACK = create(key("player_attack"));

    /**
     * {@code minecraft:player_explosion}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> PLAYER_EXPLOSION = create(key("player_explosion"));

    /**
     * {@code minecraft:sonic_boom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> SONIC_BOOM = create(key("sonic_boom"));

    /**
     * {@code minecraft:spit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> SPIT = create(key("spit"));

    /**
     * {@code minecraft:stalagmite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> STALAGMITE = create(key("stalagmite"));

    /**
     * {@code minecraft:starve}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> STARVE = create(key("starve"));

    /**
     * {@code minecraft:sting}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> STING = create(key("sting"));

    /**
     * {@code minecraft:sweet_berry_bush}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> SWEET_BERRY_BUSH = create(key("sweet_berry_bush"));

    /**
     * {@code minecraft:thorns}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> THORNS = create(key("thorns"));

    /**
     * {@code minecraft:thrown}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> THROWN = create(key("thrown"));

    /**
     * {@code minecraft:trident}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> TRIDENT = create(key("trident"));

    /**
     * {@code minecraft:unattributed_fireball}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> UNATTRIBUTED_FIREBALL = create(key("unattributed_fireball"));

    /**
     * {@code minecraft:wind_charge}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> WIND_CHARGE = create(key("wind_charge"));

    /**
     * {@code minecraft:wither}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> WITHER = create(key("wither"));

    /**
     * {@code minecraft:wither_skull}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<DamageType> WITHER_SKULL = create(key("wither_skull"));

    private DamageTypeKeys() {
    }

    /**
     * Creates a typed key for {@link DamageType} in the registry {@code minecraft:damage_type}.
     *
     * @param key the value's key in the registry
     * @return a new typed key
     */
    public static TypedKey<DamageType> create(final Key key) {
        return TypedKey.create(RegistryKey.DAMAGE_TYPE, key);
    }
}
