/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.dialog.action;

import io.papermc.paper.registry.data.dialog.DialogInstancesProvider;
import io.papermc.paper.registry.data.dialog.action.DialogActionCallback;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.event.ClickEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public sealed interface DialogAction {
    @Contract(pure=true, value="_ -> new")
    public static CommandTemplateAction commandTemplate(String template) {
        return DialogInstancesProvider.instance().commandTemplate(template);
    }

    @Contract(pure=true, value="_ -> new")
    public static StaticAction staticAction(ClickEvent value) {
        return DialogInstancesProvider.instance().staticAction(value);
    }

    @Contract(pure=true, value="_, _ -> new")
    public static CustomClickAction customClick(Key id, @Nullable BinaryTagHolder additions) {
        return DialogInstancesProvider.instance().customClick(id, additions);
    }

    @Contract(pure=true, value="_, _ -> new")
    public static CustomClickAction customClick(DialogActionCallback callback, ClickCallback.Options options) {
        return DialogInstancesProvider.instance().register(callback, options);
    }

    @ApiStatus.NonExtendable
    public static non-sealed interface CommandTemplateAction
    extends DialogAction {
        @Contract(pure=true)
        public String template();
    }

    @ApiStatus.NonExtendable
    public static non-sealed interface StaticAction
    extends DialogAction {
        @Contract(pure=true)
        public ClickEvent value();
    }

    @ApiStatus.NonExtendable
    public static non-sealed interface CustomClickAction
    extends DialogAction {
        @Contract(pure=true)
        public Key id();

        @Contract(pure=true)
        public @Nullable BinaryTagHolder additions();
    }
}

