/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.dialog.type;

import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogInstancesProvider;
import io.papermc.paper.registry.data.dialog.type.ConfirmationType;
import io.papermc.paper.registry.data.dialog.type.DialogListType;
import io.papermc.paper.registry.data.dialog.type.MultiActionType;
import io.papermc.paper.registry.data.dialog.type.NoticeType;
import io.papermc.paper.registry.data.dialog.type.ServerLinksType;
import io.papermc.paper.registry.set.RegistrySet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.Nullable;

public sealed interface DialogType
permits ConfirmationType, DialogListType, MultiActionType, NoticeType, ServerLinksType {
    @Contract(value="_, _ -> new", pure=true)
    public static ConfirmationType confirmation(ActionButton yesButton, ActionButton noButton) {
        return DialogInstancesProvider.instance().confirmation(yesButton, noButton);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static DialogListType dialogList(RegistrySet<Dialog> dialogs, @Nullable ActionButton exitAction, @Range(from=1L, to=0x7FFFFFFFL) int columns, @Range(from=1L, to=1024L) int buttonWidth) {
        return DialogType.dialogList(dialogs).exitAction(exitAction).columns(columns).buttonWidth(buttonWidth).build();
    }

    @Contract(value="_ -> new", pure=true)
    public static DialogListType.Builder dialogList(RegistrySet<Dialog> dialogs) {
        return DialogInstancesProvider.instance().dialogList(dialogs);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static MultiActionType multiAction(List<ActionButton> actions, @Nullable ActionButton exitAction, @Range(from=1L, to=0x7FFFFFFFL) int columns) {
        return DialogType.multiAction(actions).exitAction(exitAction).columns(columns).build();
    }

    @Contract(value="_ -> new", pure=true)
    public static MultiActionType.Builder multiAction(List<ActionButton> actions) {
        return DialogInstancesProvider.instance().multiAction(actions);
    }

    @Contract(value="-> new", pure=true)
    public static NoticeType notice() {
        return DialogInstancesProvider.instance().notice();
    }

    @Contract(value="_ -> new", pure=true)
    public static NoticeType notice(ActionButton action) {
        return DialogInstancesProvider.instance().notice(action);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static ServerLinksType serverLinks(@Nullable ActionButton exitAction, @Range(from=1L, to=0x7FFFFFFFL) int columns, @Range(from=1L, to=1024L) int buttonWidth) {
        return DialogInstancesProvider.instance().serverLinks(exitAction, columns, buttonWidth);
    }
}

