/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.dialog.input;

import io.papermc.paper.registry.data.dialog.DialogInstancesProvider;
import io.papermc.paper.registry.data.dialog.input.BooleanDialogInput;
import io.papermc.paper.registry.data.dialog.input.NumberRangeDialogInput;
import io.papermc.paper.registry.data.dialog.input.SingleOptionDialogInput;
import io.papermc.paper.registry.data.dialog.input.TextDialogInput;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public sealed interface DialogInput
permits BooleanDialogInput, NumberRangeDialogInput, SingleOptionDialogInput, TextDialogInput {
    @Contract(pure=true, value="_, _, _, _, _ -> new")
    public static BooleanDialogInput bool(String key, Component label, boolean initial, String onTrue, String onFalse) {
        return DialogInput.bool(key, label).initial(initial).onTrue(onTrue).onFalse(onFalse).build();
    }

    @Contract(pure=true, value="_, _ -> new")
    public static BooleanDialogInput.Builder bool(String key, Component label) {
        return DialogInstancesProvider.instance().booleanBuilder(key, label);
    }

    @Contract(pure=true, value="_, _, _, _, _, _, _, _ -> new")
    public static NumberRangeDialogInput numberRange(String key, int width, Component label, String labelFormat, float start, float end, @Nullable Float initial, @Nullable Float step) {
        return DialogInput.numberRange(key, label, start, end).width(width).labelFormat(labelFormat).initial(initial).step(step).build();
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static NumberRangeDialogInput.Builder numberRange(String key, Component label, float start, float end) {
        return DialogInstancesProvider.instance().numberRangeBuilder(key, label, start, end);
    }

    @Contract(pure=true, value="_, _, _, _, _ -> new")
    public static SingleOptionDialogInput singleOption(String key, int width, List<SingleOptionDialogInput.OptionEntry> entries, Component label, boolean labelVisible) {
        return DialogInput.singleOption(key, label, entries).width(width).labelVisible(labelVisible).build();
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static SingleOptionDialogInput.Builder singleOption(String key, Component label, List<SingleOptionDialogInput.OptionEntry> entries) {
        return DialogInstancesProvider.instance().singleOptionBuilder(key, label, entries);
    }

    @Contract(pure=true, value="_, _, _, _, _, _, _ -> new")
    public static TextDialogInput text(String key, int width, Component label, boolean labelVisible, String initial, int maxLength, @Nullable TextDialogInput.MultilineOptions multilineOptions) {
        return DialogInput.text(key, label).width(width).labelVisible(labelVisible).initial(initial).maxLength(maxLength).multiline(multilineOptions).build();
    }

    @Contract(value="_, _ -> new", pure=true)
    public static TextDialogInput.Builder text(String key, Component label) {
        return DialogInstancesProvider.instance().textBuilder(key, label);
    }

    @Contract(pure=true, value=" -> new")
    public String key();
}

