/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.dialog.body;

import io.papermc.paper.registry.data.dialog.DialogInstancesProvider;
import io.papermc.paper.registry.data.dialog.body.ItemDialogBody;
import io.papermc.paper.registry.data.dialog.body.PlainMessageDialogBody;
import net.kyori.adventure.text.Component;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.Nullable;

public sealed interface DialogBody
permits ItemDialogBody, PlainMessageDialogBody {
    @Contract(pure=true, value="_, _, _, _, _, _ -> new")
    public static ItemDialogBody item(ItemStack item, @Nullable PlainMessageDialogBody description, boolean showDecorations, boolean showTooltip, int width, int height) {
        return DialogBody.item(item).description(description).showDecorations(showDecorations).showTooltip(showTooltip).width(width).height(height).build();
    }

    @Contract(pure=true, value="_ -> new")
    public static ItemDialogBody.Builder item(ItemStack item) {
        return DialogInstancesProvider.instance().itemDialogBodyBuilder(item);
    }

    @Contract(pure=true, value="_, -> new")
    public static PlainMessageDialogBody plainMessage(Component contents) {
        return DialogInstancesProvider.instance().plainMessageDialogBody(contents);
    }

    @Contract(pure=true, value="_, _ -> new")
    public static PlainMessageDialogBody plainMessage(Component contents, @Range(from=1L, to=1024L) int width) {
        return DialogInstancesProvider.instance().plainMessageDialogBody(contents, width);
    }
}

