package io.papermc.paper.registry.keys;

import static net.kyori.adventure.key.Key.key;

import io.papermc.paper.generated.GeneratedFrom;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import net.kyori.adventure.key.Key;
import org.bukkit.inventory.ItemType;
import org.jspecify.annotations.NullMarked;

/**
 * Vanilla keys for {@link RegistryKey#ITEM}.
 *
 * @apiNote The fields provided here are a direct representation of
 * what is available from the vanilla game source. They may be
 * changed (including removals) on any Minecraft version
 * bump, so cross-version compatibility is not provided on the
 * same level as it is on most of the other API.
 */
@SuppressWarnings({
        "unused",
        "SpellCheckingInspection"
})
@NullMarked
@GeneratedFrom("1.21.7")
public final class ItemTypeKeys {
    /**
     * {@code minecraft:acacia_boat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ACACIA_BOAT = create(key("acacia_boat"));

    /**
     * {@code minecraft:acacia_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ACACIA_BUTTON = create(key("acacia_button"));

    /**
     * {@code minecraft:acacia_chest_boat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ACACIA_CHEST_BOAT = create(key("acacia_chest_boat"));

    /**
     * {@code minecraft:acacia_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ACACIA_DOOR = create(key("acacia_door"));

    /**
     * {@code minecraft:acacia_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ACACIA_FENCE = create(key("acacia_fence"));

    /**
     * {@code minecraft:acacia_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ACACIA_FENCE_GATE = create(key("acacia_fence_gate"));

    /**
     * {@code minecraft:acacia_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ACACIA_HANGING_SIGN = create(key("acacia_hanging_sign"));

    /**
     * {@code minecraft:acacia_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ACACIA_LEAVES = create(key("acacia_leaves"));

    /**
     * {@code minecraft:acacia_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ACACIA_LOG = create(key("acacia_log"));

    /**
     * {@code minecraft:acacia_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ACACIA_PLANKS = create(key("acacia_planks"));

    /**
     * {@code minecraft:acacia_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ACACIA_PRESSURE_PLATE = create(key("acacia_pressure_plate"));

    /**
     * {@code minecraft:acacia_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ACACIA_SAPLING = create(key("acacia_sapling"));

    /**
     * {@code minecraft:acacia_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ACACIA_SIGN = create(key("acacia_sign"));

    /**
     * {@code minecraft:acacia_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ACACIA_SLAB = create(key("acacia_slab"));

    /**
     * {@code minecraft:acacia_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ACACIA_STAIRS = create(key("acacia_stairs"));

    /**
     * {@code minecraft:acacia_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ACACIA_TRAPDOOR = create(key("acacia_trapdoor"));

    /**
     * {@code minecraft:acacia_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ACACIA_WOOD = create(key("acacia_wood"));

    /**
     * {@code minecraft:activator_rail}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ACTIVATOR_RAIL = create(key("activator_rail"));

    /**
     * {@code minecraft:air}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> AIR = create(key("air"));

    /**
     * {@code minecraft:allay_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ALLAY_SPAWN_EGG = create(key("allay_spawn_egg"));

    /**
     * {@code minecraft:allium}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ALLIUM = create(key("allium"));

    /**
     * {@code minecraft:amethyst_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> AMETHYST_BLOCK = create(key("amethyst_block"));

    /**
     * {@code minecraft:amethyst_cluster}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> AMETHYST_CLUSTER = create(key("amethyst_cluster"));

    /**
     * {@code minecraft:amethyst_shard}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> AMETHYST_SHARD = create(key("amethyst_shard"));

    /**
     * {@code minecraft:ancient_debris}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ANCIENT_DEBRIS = create(key("ancient_debris"));

    /**
     * {@code minecraft:andesite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ANDESITE = create(key("andesite"));

    /**
     * {@code minecraft:andesite_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ANDESITE_SLAB = create(key("andesite_slab"));

    /**
     * {@code minecraft:andesite_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ANDESITE_STAIRS = create(key("andesite_stairs"));

    /**
     * {@code minecraft:andesite_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ANDESITE_WALL = create(key("andesite_wall"));

    /**
     * {@code minecraft:angler_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ANGLER_POTTERY_SHERD = create(key("angler_pottery_sherd"));

    /**
     * {@code minecraft:anvil}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ANVIL = create(key("anvil"));

    /**
     * {@code minecraft:apple}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> APPLE = create(key("apple"));

    /**
     * {@code minecraft:archer_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ARCHER_POTTERY_SHERD = create(key("archer_pottery_sherd"));

    /**
     * {@code minecraft:armadillo_scute}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ARMADILLO_SCUTE = create(key("armadillo_scute"));

    /**
     * {@code minecraft:armadillo_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ARMADILLO_SPAWN_EGG = create(key("armadillo_spawn_egg"));

    /**
     * {@code minecraft:armor_stand}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ARMOR_STAND = create(key("armor_stand"));

    /**
     * {@code minecraft:arms_up_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ARMS_UP_POTTERY_SHERD = create(key("arms_up_pottery_sherd"));

    /**
     * {@code minecraft:arrow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ARROW = create(key("arrow"));

    /**
     * {@code minecraft:axolotl_bucket}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> AXOLOTL_BUCKET = create(key("axolotl_bucket"));

    /**
     * {@code minecraft:axolotl_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> AXOLOTL_SPAWN_EGG = create(key("axolotl_spawn_egg"));

    /**
     * {@code minecraft:azalea}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> AZALEA = create(key("azalea"));

    /**
     * {@code minecraft:azalea_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> AZALEA_LEAVES = create(key("azalea_leaves"));

    /**
     * {@code minecraft:azure_bluet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> AZURE_BLUET = create(key("azure_bluet"));

    /**
     * {@code minecraft:baked_potato}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAKED_POTATO = create(key("baked_potato"));

    /**
     * {@code minecraft:bamboo}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAMBOO = create(key("bamboo"));

    /**
     * {@code minecraft:bamboo_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAMBOO_BLOCK = create(key("bamboo_block"));

    /**
     * {@code minecraft:bamboo_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAMBOO_BUTTON = create(key("bamboo_button"));

    /**
     * {@code minecraft:bamboo_chest_raft}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAMBOO_CHEST_RAFT = create(key("bamboo_chest_raft"));

    /**
     * {@code minecraft:bamboo_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAMBOO_DOOR = create(key("bamboo_door"));

    /**
     * {@code minecraft:bamboo_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAMBOO_FENCE = create(key("bamboo_fence"));

    /**
     * {@code minecraft:bamboo_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAMBOO_FENCE_GATE = create(key("bamboo_fence_gate"));

    /**
     * {@code minecraft:bamboo_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAMBOO_HANGING_SIGN = create(key("bamboo_hanging_sign"));

    /**
     * {@code minecraft:bamboo_mosaic}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAMBOO_MOSAIC = create(key("bamboo_mosaic"));

    /**
     * {@code minecraft:bamboo_mosaic_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAMBOO_MOSAIC_SLAB = create(key("bamboo_mosaic_slab"));

    /**
     * {@code minecraft:bamboo_mosaic_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAMBOO_MOSAIC_STAIRS = create(key("bamboo_mosaic_stairs"));

    /**
     * {@code minecraft:bamboo_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAMBOO_PLANKS = create(key("bamboo_planks"));

    /**
     * {@code minecraft:bamboo_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAMBOO_PRESSURE_PLATE = create(key("bamboo_pressure_plate"));

    /**
     * {@code minecraft:bamboo_raft}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAMBOO_RAFT = create(key("bamboo_raft"));

    /**
     * {@code minecraft:bamboo_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAMBOO_SIGN = create(key("bamboo_sign"));

    /**
     * {@code minecraft:bamboo_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAMBOO_SLAB = create(key("bamboo_slab"));

    /**
     * {@code minecraft:bamboo_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAMBOO_STAIRS = create(key("bamboo_stairs"));

    /**
     * {@code minecraft:bamboo_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAMBOO_TRAPDOOR = create(key("bamboo_trapdoor"));

    /**
     * {@code minecraft:barrel}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BARREL = create(key("barrel"));

    /**
     * {@code minecraft:barrier}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BARRIER = create(key("barrier"));

    /**
     * {@code minecraft:basalt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BASALT = create(key("basalt"));

    /**
     * {@code minecraft:bat_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BAT_SPAWN_EGG = create(key("bat_spawn_egg"));

    /**
     * {@code minecraft:beacon}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BEACON = create(key("beacon"));

    /**
     * {@code minecraft:bedrock}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BEDROCK = create(key("bedrock"));

    /**
     * {@code minecraft:bee_nest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BEE_NEST = create(key("bee_nest"));

    /**
     * {@code minecraft:bee_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BEE_SPAWN_EGG = create(key("bee_spawn_egg"));

    /**
     * {@code minecraft:beef}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BEEF = create(key("beef"));

    /**
     * {@code minecraft:beehive}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BEEHIVE = create(key("beehive"));

    /**
     * {@code minecraft:beetroot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BEETROOT = create(key("beetroot"));

    /**
     * {@code minecraft:beetroot_seeds}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BEETROOT_SEEDS = create(key("beetroot_seeds"));

    /**
     * {@code minecraft:beetroot_soup}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BEETROOT_SOUP = create(key("beetroot_soup"));

    /**
     * {@code minecraft:bell}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BELL = create(key("bell"));

    /**
     * {@code minecraft:big_dripleaf}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BIG_DRIPLEAF = create(key("big_dripleaf"));

    /**
     * {@code minecraft:birch_boat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BIRCH_BOAT = create(key("birch_boat"));

    /**
     * {@code minecraft:birch_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BIRCH_BUTTON = create(key("birch_button"));

    /**
     * {@code minecraft:birch_chest_boat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BIRCH_CHEST_BOAT = create(key("birch_chest_boat"));

    /**
     * {@code minecraft:birch_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BIRCH_DOOR = create(key("birch_door"));

    /**
     * {@code minecraft:birch_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BIRCH_FENCE = create(key("birch_fence"));

    /**
     * {@code minecraft:birch_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BIRCH_FENCE_GATE = create(key("birch_fence_gate"));

    /**
     * {@code minecraft:birch_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BIRCH_HANGING_SIGN = create(key("birch_hanging_sign"));

    /**
     * {@code minecraft:birch_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BIRCH_LEAVES = create(key("birch_leaves"));

    /**
     * {@code minecraft:birch_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BIRCH_LOG = create(key("birch_log"));

    /**
     * {@code minecraft:birch_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BIRCH_PLANKS = create(key("birch_planks"));

    /**
     * {@code minecraft:birch_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BIRCH_PRESSURE_PLATE = create(key("birch_pressure_plate"));

    /**
     * {@code minecraft:birch_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BIRCH_SAPLING = create(key("birch_sapling"));

    /**
     * {@code minecraft:birch_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BIRCH_SIGN = create(key("birch_sign"));

    /**
     * {@code minecraft:birch_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BIRCH_SLAB = create(key("birch_slab"));

    /**
     * {@code minecraft:birch_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BIRCH_STAIRS = create(key("birch_stairs"));

    /**
     * {@code minecraft:birch_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BIRCH_TRAPDOOR = create(key("birch_trapdoor"));

    /**
     * {@code minecraft:birch_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BIRCH_WOOD = create(key("birch_wood"));

    /**
     * {@code minecraft:black_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLACK_BANNER = create(key("black_banner"));

    /**
     * {@code minecraft:black_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLACK_BED = create(key("black_bed"));

    /**
     * {@code minecraft:black_bundle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLACK_BUNDLE = create(key("black_bundle"));

    /**
     * {@code minecraft:black_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLACK_CANDLE = create(key("black_candle"));

    /**
     * {@code minecraft:black_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLACK_CARPET = create(key("black_carpet"));

    /**
     * {@code minecraft:black_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLACK_CONCRETE = create(key("black_concrete"));

    /**
     * {@code minecraft:black_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLACK_CONCRETE_POWDER = create(key("black_concrete_powder"));

    /**
     * {@code minecraft:black_dye}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLACK_DYE = create(key("black_dye"));

    /**
     * {@code minecraft:black_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLACK_GLAZED_TERRACOTTA = create(key("black_glazed_terracotta"));

    /**
     * {@code minecraft:black_harness}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLACK_HARNESS = create(key("black_harness"));

    /**
     * {@code minecraft:black_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLACK_SHULKER_BOX = create(key("black_shulker_box"));

    /**
     * {@code minecraft:black_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLACK_STAINED_GLASS = create(key("black_stained_glass"));

    /**
     * {@code minecraft:black_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLACK_STAINED_GLASS_PANE = create(key("black_stained_glass_pane"));

    /**
     * {@code minecraft:black_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLACK_TERRACOTTA = create(key("black_terracotta"));

    /**
     * {@code minecraft:black_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLACK_WOOL = create(key("black_wool"));

    /**
     * {@code minecraft:blackstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLACKSTONE = create(key("blackstone"));

    /**
     * {@code minecraft:blackstone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLACKSTONE_SLAB = create(key("blackstone_slab"));

    /**
     * {@code minecraft:blackstone_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLACKSTONE_STAIRS = create(key("blackstone_stairs"));

    /**
     * {@code minecraft:blackstone_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLACKSTONE_WALL = create(key("blackstone_wall"));

    /**
     * {@code minecraft:blade_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLADE_POTTERY_SHERD = create(key("blade_pottery_sherd"));

    /**
     * {@code minecraft:blast_furnace}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLAST_FURNACE = create(key("blast_furnace"));

    /**
     * {@code minecraft:blaze_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLAZE_POWDER = create(key("blaze_powder"));

    /**
     * {@code minecraft:blaze_rod}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLAZE_ROD = create(key("blaze_rod"));

    /**
     * {@code minecraft:blaze_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLAZE_SPAWN_EGG = create(key("blaze_spawn_egg"));

    /**
     * {@code minecraft:blue_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLUE_BANNER = create(key("blue_banner"));

    /**
     * {@code minecraft:blue_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLUE_BED = create(key("blue_bed"));

    /**
     * {@code minecraft:blue_bundle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLUE_BUNDLE = create(key("blue_bundle"));

    /**
     * {@code minecraft:blue_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLUE_CANDLE = create(key("blue_candle"));

    /**
     * {@code minecraft:blue_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLUE_CARPET = create(key("blue_carpet"));

    /**
     * {@code minecraft:blue_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLUE_CONCRETE = create(key("blue_concrete"));

    /**
     * {@code minecraft:blue_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLUE_CONCRETE_POWDER = create(key("blue_concrete_powder"));

    /**
     * {@code minecraft:blue_dye}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLUE_DYE = create(key("blue_dye"));

    /**
     * {@code minecraft:blue_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLUE_EGG = create(key("blue_egg"));

    /**
     * {@code minecraft:blue_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLUE_GLAZED_TERRACOTTA = create(key("blue_glazed_terracotta"));

    /**
     * {@code minecraft:blue_harness}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLUE_HARNESS = create(key("blue_harness"));

    /**
     * {@code minecraft:blue_ice}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLUE_ICE = create(key("blue_ice"));

    /**
     * {@code minecraft:blue_orchid}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLUE_ORCHID = create(key("blue_orchid"));

    /**
     * {@code minecraft:blue_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLUE_SHULKER_BOX = create(key("blue_shulker_box"));

    /**
     * {@code minecraft:blue_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLUE_STAINED_GLASS = create(key("blue_stained_glass"));

    /**
     * {@code minecraft:blue_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLUE_STAINED_GLASS_PANE = create(key("blue_stained_glass_pane"));

    /**
     * {@code minecraft:blue_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLUE_TERRACOTTA = create(key("blue_terracotta"));

    /**
     * {@code minecraft:blue_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BLUE_WOOL = create(key("blue_wool"));

    /**
     * {@code minecraft:bogged_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BOGGED_SPAWN_EGG = create(key("bogged_spawn_egg"));

    /**
     * {@code minecraft:bolt_armor_trim_smithing_template}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BOLT_ARMOR_TRIM_SMITHING_TEMPLATE = create(key("bolt_armor_trim_smithing_template"));

    /**
     * {@code minecraft:bone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BONE = create(key("bone"));

    /**
     * {@code minecraft:bone_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BONE_BLOCK = create(key("bone_block"));

    /**
     * {@code minecraft:bone_meal}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BONE_MEAL = create(key("bone_meal"));

    /**
     * {@code minecraft:book}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BOOK = create(key("book"));

    /**
     * {@code minecraft:bookshelf}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BOOKSHELF = create(key("bookshelf"));

    /**
     * {@code minecraft:bordure_indented_banner_pattern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BORDURE_INDENTED_BANNER_PATTERN = create(key("bordure_indented_banner_pattern"));

    /**
     * {@code minecraft:bow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BOW = create(key("bow"));

    /**
     * {@code minecraft:bowl}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BOWL = create(key("bowl"));

    /**
     * {@code minecraft:brain_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BRAIN_CORAL = create(key("brain_coral"));

    /**
     * {@code minecraft:brain_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BRAIN_CORAL_BLOCK = create(key("brain_coral_block"));

    /**
     * {@code minecraft:brain_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BRAIN_CORAL_FAN = create(key("brain_coral_fan"));

    /**
     * {@code minecraft:bread}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BREAD = create(key("bread"));

    /**
     * {@code minecraft:breeze_rod}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BREEZE_ROD = create(key("breeze_rod"));

    /**
     * {@code minecraft:breeze_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BREEZE_SPAWN_EGG = create(key("breeze_spawn_egg"));

    /**
     * {@code minecraft:brewer_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BREWER_POTTERY_SHERD = create(key("brewer_pottery_sherd"));

    /**
     * {@code minecraft:brewing_stand}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BREWING_STAND = create(key("brewing_stand"));

    /**
     * {@code minecraft:brick}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BRICK = create(key("brick"));

    /**
     * {@code minecraft:brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BRICK_SLAB = create(key("brick_slab"));

    /**
     * {@code minecraft:brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BRICK_STAIRS = create(key("brick_stairs"));

    /**
     * {@code minecraft:brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BRICK_WALL = create(key("brick_wall"));

    /**
     * {@code minecraft:bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BRICKS = create(key("bricks"));

    /**
     * {@code minecraft:brown_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BROWN_BANNER = create(key("brown_banner"));

    /**
     * {@code minecraft:brown_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BROWN_BED = create(key("brown_bed"));

    /**
     * {@code minecraft:brown_bundle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BROWN_BUNDLE = create(key("brown_bundle"));

    /**
     * {@code minecraft:brown_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BROWN_CANDLE = create(key("brown_candle"));

    /**
     * {@code minecraft:brown_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BROWN_CARPET = create(key("brown_carpet"));

    /**
     * {@code minecraft:brown_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BROWN_CONCRETE = create(key("brown_concrete"));

    /**
     * {@code minecraft:brown_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BROWN_CONCRETE_POWDER = create(key("brown_concrete_powder"));

    /**
     * {@code minecraft:brown_dye}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BROWN_DYE = create(key("brown_dye"));

    /**
     * {@code minecraft:brown_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BROWN_EGG = create(key("brown_egg"));

    /**
     * {@code minecraft:brown_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BROWN_GLAZED_TERRACOTTA = create(key("brown_glazed_terracotta"));

    /**
     * {@code minecraft:brown_harness}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BROWN_HARNESS = create(key("brown_harness"));

    /**
     * {@code minecraft:brown_mushroom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BROWN_MUSHROOM = create(key("brown_mushroom"));

    /**
     * {@code minecraft:brown_mushroom_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BROWN_MUSHROOM_BLOCK = create(key("brown_mushroom_block"));

    /**
     * {@code minecraft:brown_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BROWN_SHULKER_BOX = create(key("brown_shulker_box"));

    /**
     * {@code minecraft:brown_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BROWN_STAINED_GLASS = create(key("brown_stained_glass"));

    /**
     * {@code minecraft:brown_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BROWN_STAINED_GLASS_PANE = create(key("brown_stained_glass_pane"));

    /**
     * {@code minecraft:brown_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BROWN_TERRACOTTA = create(key("brown_terracotta"));

    /**
     * {@code minecraft:brown_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BROWN_WOOL = create(key("brown_wool"));

    /**
     * {@code minecraft:brush}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BRUSH = create(key("brush"));

    /**
     * {@code minecraft:bubble_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BUBBLE_CORAL = create(key("bubble_coral"));

    /**
     * {@code minecraft:bubble_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BUBBLE_CORAL_BLOCK = create(key("bubble_coral_block"));

    /**
     * {@code minecraft:bubble_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BUBBLE_CORAL_FAN = create(key("bubble_coral_fan"));

    /**
     * {@code minecraft:bucket}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BUCKET = create(key("bucket"));

    /**
     * {@code minecraft:budding_amethyst}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BUDDING_AMETHYST = create(key("budding_amethyst"));

    /**
     * {@code minecraft:bundle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BUNDLE = create(key("bundle"));

    /**
     * {@code minecraft:burn_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BURN_POTTERY_SHERD = create(key("burn_pottery_sherd"));

    /**
     * {@code minecraft:bush}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> BUSH = create(key("bush"));

    /**
     * {@code minecraft:cactus}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CACTUS = create(key("cactus"));

    /**
     * {@code minecraft:cactus_flower}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CACTUS_FLOWER = create(key("cactus_flower"));

    /**
     * {@code minecraft:cake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CAKE = create(key("cake"));

    /**
     * {@code minecraft:calcite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CALCITE = create(key("calcite"));

    /**
     * {@code minecraft:calibrated_sculk_sensor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CALIBRATED_SCULK_SENSOR = create(key("calibrated_sculk_sensor"));

    /**
     * {@code minecraft:camel_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CAMEL_SPAWN_EGG = create(key("camel_spawn_egg"));

    /**
     * {@code minecraft:campfire}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CAMPFIRE = create(key("campfire"));

    /**
     * {@code minecraft:candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CANDLE = create(key("candle"));

    /**
     * {@code minecraft:carrot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CARROT = create(key("carrot"));

    /**
     * {@code minecraft:carrot_on_a_stick}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CARROT_ON_A_STICK = create(key("carrot_on_a_stick"));

    /**
     * {@code minecraft:cartography_table}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CARTOGRAPHY_TABLE = create(key("cartography_table"));

    /**
     * {@code minecraft:carved_pumpkin}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CARVED_PUMPKIN = create(key("carved_pumpkin"));

    /**
     * {@code minecraft:cat_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CAT_SPAWN_EGG = create(key("cat_spawn_egg"));

    /**
     * {@code minecraft:cauldron}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CAULDRON = create(key("cauldron"));

    /**
     * {@code minecraft:cave_spider_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CAVE_SPIDER_SPAWN_EGG = create(key("cave_spider_spawn_egg"));

    /**
     * {@code minecraft:chain}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHAIN = create(key("chain"));

    /**
     * {@code minecraft:chain_command_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHAIN_COMMAND_BLOCK = create(key("chain_command_block"));

    /**
     * {@code minecraft:chainmail_boots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHAINMAIL_BOOTS = create(key("chainmail_boots"));

    /**
     * {@code minecraft:chainmail_chestplate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHAINMAIL_CHESTPLATE = create(key("chainmail_chestplate"));

    /**
     * {@code minecraft:chainmail_helmet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHAINMAIL_HELMET = create(key("chainmail_helmet"));

    /**
     * {@code minecraft:chainmail_leggings}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHAINMAIL_LEGGINGS = create(key("chainmail_leggings"));

    /**
     * {@code minecraft:charcoal}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHARCOAL = create(key("charcoal"));

    /**
     * {@code minecraft:cherry_boat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHERRY_BOAT = create(key("cherry_boat"));

    /**
     * {@code minecraft:cherry_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHERRY_BUTTON = create(key("cherry_button"));

    /**
     * {@code minecraft:cherry_chest_boat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHERRY_CHEST_BOAT = create(key("cherry_chest_boat"));

    /**
     * {@code minecraft:cherry_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHERRY_DOOR = create(key("cherry_door"));

    /**
     * {@code minecraft:cherry_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHERRY_FENCE = create(key("cherry_fence"));

    /**
     * {@code minecraft:cherry_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHERRY_FENCE_GATE = create(key("cherry_fence_gate"));

    /**
     * {@code minecraft:cherry_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHERRY_HANGING_SIGN = create(key("cherry_hanging_sign"));

    /**
     * {@code minecraft:cherry_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHERRY_LEAVES = create(key("cherry_leaves"));

    /**
     * {@code minecraft:cherry_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHERRY_LOG = create(key("cherry_log"));

    /**
     * {@code minecraft:cherry_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHERRY_PLANKS = create(key("cherry_planks"));

    /**
     * {@code minecraft:cherry_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHERRY_PRESSURE_PLATE = create(key("cherry_pressure_plate"));

    /**
     * {@code minecraft:cherry_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHERRY_SAPLING = create(key("cherry_sapling"));

    /**
     * {@code minecraft:cherry_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHERRY_SIGN = create(key("cherry_sign"));

    /**
     * {@code minecraft:cherry_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHERRY_SLAB = create(key("cherry_slab"));

    /**
     * {@code minecraft:cherry_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHERRY_STAIRS = create(key("cherry_stairs"));

    /**
     * {@code minecraft:cherry_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHERRY_TRAPDOOR = create(key("cherry_trapdoor"));

    /**
     * {@code minecraft:cherry_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHERRY_WOOD = create(key("cherry_wood"));

    /**
     * {@code minecraft:chest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHEST = create(key("chest"));

    /**
     * {@code minecraft:chest_minecart}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHEST_MINECART = create(key("chest_minecart"));

    /**
     * {@code minecraft:chicken}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHICKEN = create(key("chicken"));

    /**
     * {@code minecraft:chicken_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHICKEN_SPAWN_EGG = create(key("chicken_spawn_egg"));

    /**
     * {@code minecraft:chipped_anvil}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHIPPED_ANVIL = create(key("chipped_anvil"));

    /**
     * {@code minecraft:chiseled_bookshelf}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHISELED_BOOKSHELF = create(key("chiseled_bookshelf"));

    /**
     * {@code minecraft:chiseled_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHISELED_COPPER = create(key("chiseled_copper"));

    /**
     * {@code minecraft:chiseled_deepslate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHISELED_DEEPSLATE = create(key("chiseled_deepslate"));

    /**
     * {@code minecraft:chiseled_nether_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHISELED_NETHER_BRICKS = create(key("chiseled_nether_bricks"));

    /**
     * {@code minecraft:chiseled_polished_blackstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHISELED_POLISHED_BLACKSTONE = create(key("chiseled_polished_blackstone"));

    /**
     * {@code minecraft:chiseled_quartz_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHISELED_QUARTZ_BLOCK = create(key("chiseled_quartz_block"));

    /**
     * {@code minecraft:chiseled_red_sandstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHISELED_RED_SANDSTONE = create(key("chiseled_red_sandstone"));

    /**
     * {@code minecraft:chiseled_resin_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHISELED_RESIN_BRICKS = create(key("chiseled_resin_bricks"));

    /**
     * {@code minecraft:chiseled_sandstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHISELED_SANDSTONE = create(key("chiseled_sandstone"));

    /**
     * {@code minecraft:chiseled_stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHISELED_STONE_BRICKS = create(key("chiseled_stone_bricks"));

    /**
     * {@code minecraft:chiseled_tuff}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHISELED_TUFF = create(key("chiseled_tuff"));

    /**
     * {@code minecraft:chiseled_tuff_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHISELED_TUFF_BRICKS = create(key("chiseled_tuff_bricks"));

    /**
     * {@code minecraft:chorus_flower}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHORUS_FLOWER = create(key("chorus_flower"));

    /**
     * {@code minecraft:chorus_fruit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHORUS_FRUIT = create(key("chorus_fruit"));

    /**
     * {@code minecraft:chorus_plant}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CHORUS_PLANT = create(key("chorus_plant"));

    /**
     * {@code minecraft:clay}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CLAY = create(key("clay"));

    /**
     * {@code minecraft:clay_ball}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CLAY_BALL = create(key("clay_ball"));

    /**
     * {@code minecraft:clock}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CLOCK = create(key("clock"));

    /**
     * {@code minecraft:closed_eyeblossom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CLOSED_EYEBLOSSOM = create(key("closed_eyeblossom"));

    /**
     * {@code minecraft:coal}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COAL = create(key("coal"));

    /**
     * {@code minecraft:coal_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COAL_BLOCK = create(key("coal_block"));

    /**
     * {@code minecraft:coal_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COAL_ORE = create(key("coal_ore"));

    /**
     * {@code minecraft:coarse_dirt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COARSE_DIRT = create(key("coarse_dirt"));

    /**
     * {@code minecraft:coast_armor_trim_smithing_template}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COAST_ARMOR_TRIM_SMITHING_TEMPLATE = create(key("coast_armor_trim_smithing_template"));

    /**
     * {@code minecraft:cobbled_deepslate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COBBLED_DEEPSLATE = create(key("cobbled_deepslate"));

    /**
     * {@code minecraft:cobbled_deepslate_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COBBLED_DEEPSLATE_SLAB = create(key("cobbled_deepslate_slab"));

    /**
     * {@code minecraft:cobbled_deepslate_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COBBLED_DEEPSLATE_STAIRS = create(key("cobbled_deepslate_stairs"));

    /**
     * {@code minecraft:cobbled_deepslate_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COBBLED_DEEPSLATE_WALL = create(key("cobbled_deepslate_wall"));

    /**
     * {@code minecraft:cobblestone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COBBLESTONE = create(key("cobblestone"));

    /**
     * {@code minecraft:cobblestone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COBBLESTONE_SLAB = create(key("cobblestone_slab"));

    /**
     * {@code minecraft:cobblestone_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COBBLESTONE_STAIRS = create(key("cobblestone_stairs"));

    /**
     * {@code minecraft:cobblestone_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COBBLESTONE_WALL = create(key("cobblestone_wall"));

    /**
     * {@code minecraft:cobweb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COBWEB = create(key("cobweb"));

    /**
     * {@code minecraft:cocoa_beans}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COCOA_BEANS = create(key("cocoa_beans"));

    /**
     * {@code minecraft:cod}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COD = create(key("cod"));

    /**
     * {@code minecraft:cod_bucket}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COD_BUCKET = create(key("cod_bucket"));

    /**
     * {@code minecraft:cod_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COD_SPAWN_EGG = create(key("cod_spawn_egg"));

    /**
     * {@code minecraft:command_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COMMAND_BLOCK = create(key("command_block"));

    /**
     * {@code minecraft:command_block_minecart}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COMMAND_BLOCK_MINECART = create(key("command_block_minecart"));

    /**
     * {@code minecraft:comparator}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COMPARATOR = create(key("comparator"));

    /**
     * {@code minecraft:compass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COMPASS = create(key("compass"));

    /**
     * {@code minecraft:composter}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COMPOSTER = create(key("composter"));

    /**
     * {@code minecraft:conduit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CONDUIT = create(key("conduit"));

    /**
     * {@code minecraft:cooked_beef}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COOKED_BEEF = create(key("cooked_beef"));

    /**
     * {@code minecraft:cooked_chicken}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COOKED_CHICKEN = create(key("cooked_chicken"));

    /**
     * {@code minecraft:cooked_cod}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COOKED_COD = create(key("cooked_cod"));

    /**
     * {@code minecraft:cooked_mutton}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COOKED_MUTTON = create(key("cooked_mutton"));

    /**
     * {@code minecraft:cooked_porkchop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COOKED_PORKCHOP = create(key("cooked_porkchop"));

    /**
     * {@code minecraft:cooked_rabbit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COOKED_RABBIT = create(key("cooked_rabbit"));

    /**
     * {@code minecraft:cooked_salmon}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COOKED_SALMON = create(key("cooked_salmon"));

    /**
     * {@code minecraft:cookie}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COOKIE = create(key("cookie"));

    /**
     * {@code minecraft:copper_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COPPER_BLOCK = create(key("copper_block"));

    /**
     * {@code minecraft:copper_bulb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COPPER_BULB = create(key("copper_bulb"));

    /**
     * {@code minecraft:copper_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COPPER_DOOR = create(key("copper_door"));

    /**
     * {@code minecraft:copper_grate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COPPER_GRATE = create(key("copper_grate"));

    /**
     * {@code minecraft:copper_ingot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COPPER_INGOT = create(key("copper_ingot"));

    /**
     * {@code minecraft:copper_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COPPER_ORE = create(key("copper_ore"));

    /**
     * {@code minecraft:copper_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COPPER_TRAPDOOR = create(key("copper_trapdoor"));

    /**
     * {@code minecraft:cornflower}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CORNFLOWER = create(key("cornflower"));

    /**
     * {@code minecraft:cow_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> COW_SPAWN_EGG = create(key("cow_spawn_egg"));

    /**
     * {@code minecraft:cracked_deepslate_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRACKED_DEEPSLATE_BRICKS = create(key("cracked_deepslate_bricks"));

    /**
     * {@code minecraft:cracked_deepslate_tiles}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRACKED_DEEPSLATE_TILES = create(key("cracked_deepslate_tiles"));

    /**
     * {@code minecraft:cracked_nether_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRACKED_NETHER_BRICKS = create(key("cracked_nether_bricks"));

    /**
     * {@code minecraft:cracked_polished_blackstone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRACKED_POLISHED_BLACKSTONE_BRICKS = create(key("cracked_polished_blackstone_bricks"));

    /**
     * {@code minecraft:cracked_stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRACKED_STONE_BRICKS = create(key("cracked_stone_bricks"));

    /**
     * {@code minecraft:crafter}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRAFTER = create(key("crafter"));

    /**
     * {@code minecraft:crafting_table}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRAFTING_TABLE = create(key("crafting_table"));

    /**
     * {@code minecraft:creaking_heart}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CREAKING_HEART = create(key("creaking_heart"));

    /**
     * {@code minecraft:creaking_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CREAKING_SPAWN_EGG = create(key("creaking_spawn_egg"));

    /**
     * {@code minecraft:creeper_banner_pattern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CREEPER_BANNER_PATTERN = create(key("creeper_banner_pattern"));

    /**
     * {@code minecraft:creeper_head}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CREEPER_HEAD = create(key("creeper_head"));

    /**
     * {@code minecraft:creeper_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CREEPER_SPAWN_EGG = create(key("creeper_spawn_egg"));

    /**
     * {@code minecraft:crimson_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRIMSON_BUTTON = create(key("crimson_button"));

    /**
     * {@code minecraft:crimson_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRIMSON_DOOR = create(key("crimson_door"));

    /**
     * {@code minecraft:crimson_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRIMSON_FENCE = create(key("crimson_fence"));

    /**
     * {@code minecraft:crimson_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRIMSON_FENCE_GATE = create(key("crimson_fence_gate"));

    /**
     * {@code minecraft:crimson_fungus}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRIMSON_FUNGUS = create(key("crimson_fungus"));

    /**
     * {@code minecraft:crimson_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRIMSON_HANGING_SIGN = create(key("crimson_hanging_sign"));

    /**
     * {@code minecraft:crimson_hyphae}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRIMSON_HYPHAE = create(key("crimson_hyphae"));

    /**
     * {@code minecraft:crimson_nylium}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRIMSON_NYLIUM = create(key("crimson_nylium"));

    /**
     * {@code minecraft:crimson_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRIMSON_PLANKS = create(key("crimson_planks"));

    /**
     * {@code minecraft:crimson_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRIMSON_PRESSURE_PLATE = create(key("crimson_pressure_plate"));

    /**
     * {@code minecraft:crimson_roots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRIMSON_ROOTS = create(key("crimson_roots"));

    /**
     * {@code minecraft:crimson_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRIMSON_SIGN = create(key("crimson_sign"));

    /**
     * {@code minecraft:crimson_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRIMSON_SLAB = create(key("crimson_slab"));

    /**
     * {@code minecraft:crimson_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRIMSON_STAIRS = create(key("crimson_stairs"));

    /**
     * {@code minecraft:crimson_stem}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRIMSON_STEM = create(key("crimson_stem"));

    /**
     * {@code minecraft:crimson_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRIMSON_TRAPDOOR = create(key("crimson_trapdoor"));

    /**
     * {@code minecraft:crossbow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CROSSBOW = create(key("crossbow"));

    /**
     * {@code minecraft:crying_obsidian}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CRYING_OBSIDIAN = create(key("crying_obsidian"));

    /**
     * {@code minecraft:cut_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CUT_COPPER = create(key("cut_copper"));

    /**
     * {@code minecraft:cut_copper_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CUT_COPPER_SLAB = create(key("cut_copper_slab"));

    /**
     * {@code minecraft:cut_copper_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CUT_COPPER_STAIRS = create(key("cut_copper_stairs"));

    /**
     * {@code minecraft:cut_red_sandstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CUT_RED_SANDSTONE = create(key("cut_red_sandstone"));

    /**
     * {@code minecraft:cut_red_sandstone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CUT_RED_SANDSTONE_SLAB = create(key("cut_red_sandstone_slab"));

    /**
     * {@code minecraft:cut_sandstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CUT_SANDSTONE = create(key("cut_sandstone"));

    /**
     * {@code minecraft:cut_sandstone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CUT_SANDSTONE_SLAB = create(key("cut_sandstone_slab"));

    /**
     * {@code minecraft:cyan_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CYAN_BANNER = create(key("cyan_banner"));

    /**
     * {@code minecraft:cyan_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CYAN_BED = create(key("cyan_bed"));

    /**
     * {@code minecraft:cyan_bundle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CYAN_BUNDLE = create(key("cyan_bundle"));

    /**
     * {@code minecraft:cyan_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CYAN_CANDLE = create(key("cyan_candle"));

    /**
     * {@code minecraft:cyan_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CYAN_CARPET = create(key("cyan_carpet"));

    /**
     * {@code minecraft:cyan_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CYAN_CONCRETE = create(key("cyan_concrete"));

    /**
     * {@code minecraft:cyan_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CYAN_CONCRETE_POWDER = create(key("cyan_concrete_powder"));

    /**
     * {@code minecraft:cyan_dye}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CYAN_DYE = create(key("cyan_dye"));

    /**
     * {@code minecraft:cyan_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CYAN_GLAZED_TERRACOTTA = create(key("cyan_glazed_terracotta"));

    /**
     * {@code minecraft:cyan_harness}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CYAN_HARNESS = create(key("cyan_harness"));

    /**
     * {@code minecraft:cyan_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CYAN_SHULKER_BOX = create(key("cyan_shulker_box"));

    /**
     * {@code minecraft:cyan_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CYAN_STAINED_GLASS = create(key("cyan_stained_glass"));

    /**
     * {@code minecraft:cyan_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CYAN_STAINED_GLASS_PANE = create(key("cyan_stained_glass_pane"));

    /**
     * {@code minecraft:cyan_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CYAN_TERRACOTTA = create(key("cyan_terracotta"));

    /**
     * {@code minecraft:cyan_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> CYAN_WOOL = create(key("cyan_wool"));

    /**
     * {@code minecraft:damaged_anvil}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DAMAGED_ANVIL = create(key("damaged_anvil"));

    /**
     * {@code minecraft:dandelion}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DANDELION = create(key("dandelion"));

    /**
     * {@code minecraft:danger_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DANGER_POTTERY_SHERD = create(key("danger_pottery_sherd"));

    /**
     * {@code minecraft:dark_oak_boat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_OAK_BOAT = create(key("dark_oak_boat"));

    /**
     * {@code minecraft:dark_oak_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_OAK_BUTTON = create(key("dark_oak_button"));

    /**
     * {@code minecraft:dark_oak_chest_boat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_OAK_CHEST_BOAT = create(key("dark_oak_chest_boat"));

    /**
     * {@code minecraft:dark_oak_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_OAK_DOOR = create(key("dark_oak_door"));

    /**
     * {@code minecraft:dark_oak_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_OAK_FENCE = create(key("dark_oak_fence"));

    /**
     * {@code minecraft:dark_oak_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_OAK_FENCE_GATE = create(key("dark_oak_fence_gate"));

    /**
     * {@code minecraft:dark_oak_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_OAK_HANGING_SIGN = create(key("dark_oak_hanging_sign"));

    /**
     * {@code minecraft:dark_oak_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_OAK_LEAVES = create(key("dark_oak_leaves"));

    /**
     * {@code minecraft:dark_oak_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_OAK_LOG = create(key("dark_oak_log"));

    /**
     * {@code minecraft:dark_oak_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_OAK_PLANKS = create(key("dark_oak_planks"));

    /**
     * {@code minecraft:dark_oak_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_OAK_PRESSURE_PLATE = create(key("dark_oak_pressure_plate"));

    /**
     * {@code minecraft:dark_oak_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_OAK_SAPLING = create(key("dark_oak_sapling"));

    /**
     * {@code minecraft:dark_oak_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_OAK_SIGN = create(key("dark_oak_sign"));

    /**
     * {@code minecraft:dark_oak_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_OAK_SLAB = create(key("dark_oak_slab"));

    /**
     * {@code minecraft:dark_oak_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_OAK_STAIRS = create(key("dark_oak_stairs"));

    /**
     * {@code minecraft:dark_oak_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_OAK_TRAPDOOR = create(key("dark_oak_trapdoor"));

    /**
     * {@code minecraft:dark_oak_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_OAK_WOOD = create(key("dark_oak_wood"));

    /**
     * {@code minecraft:dark_prismarine}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_PRISMARINE = create(key("dark_prismarine"));

    /**
     * {@code minecraft:dark_prismarine_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_PRISMARINE_SLAB = create(key("dark_prismarine_slab"));

    /**
     * {@code minecraft:dark_prismarine_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DARK_PRISMARINE_STAIRS = create(key("dark_prismarine_stairs"));

    /**
     * {@code minecraft:daylight_detector}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DAYLIGHT_DETECTOR = create(key("daylight_detector"));

    /**
     * {@code minecraft:dead_brain_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEAD_BRAIN_CORAL = create(key("dead_brain_coral"));

    /**
     * {@code minecraft:dead_brain_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEAD_BRAIN_CORAL_BLOCK = create(key("dead_brain_coral_block"));

    /**
     * {@code minecraft:dead_brain_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEAD_BRAIN_CORAL_FAN = create(key("dead_brain_coral_fan"));

    /**
     * {@code minecraft:dead_bubble_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEAD_BUBBLE_CORAL = create(key("dead_bubble_coral"));

    /**
     * {@code minecraft:dead_bubble_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEAD_BUBBLE_CORAL_BLOCK = create(key("dead_bubble_coral_block"));

    /**
     * {@code minecraft:dead_bubble_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEAD_BUBBLE_CORAL_FAN = create(key("dead_bubble_coral_fan"));

    /**
     * {@code minecraft:dead_bush}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEAD_BUSH = create(key("dead_bush"));

    /**
     * {@code minecraft:dead_fire_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEAD_FIRE_CORAL = create(key("dead_fire_coral"));

    /**
     * {@code minecraft:dead_fire_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEAD_FIRE_CORAL_BLOCK = create(key("dead_fire_coral_block"));

    /**
     * {@code minecraft:dead_fire_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEAD_FIRE_CORAL_FAN = create(key("dead_fire_coral_fan"));

    /**
     * {@code minecraft:dead_horn_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEAD_HORN_CORAL = create(key("dead_horn_coral"));

    /**
     * {@code minecraft:dead_horn_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEAD_HORN_CORAL_BLOCK = create(key("dead_horn_coral_block"));

    /**
     * {@code minecraft:dead_horn_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEAD_HORN_CORAL_FAN = create(key("dead_horn_coral_fan"));

    /**
     * {@code minecraft:dead_tube_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEAD_TUBE_CORAL = create(key("dead_tube_coral"));

    /**
     * {@code minecraft:dead_tube_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEAD_TUBE_CORAL_BLOCK = create(key("dead_tube_coral_block"));

    /**
     * {@code minecraft:dead_tube_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEAD_TUBE_CORAL_FAN = create(key("dead_tube_coral_fan"));

    /**
     * {@code minecraft:debug_stick}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEBUG_STICK = create(key("debug_stick"));

    /**
     * {@code minecraft:decorated_pot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DECORATED_POT = create(key("decorated_pot"));

    /**
     * {@code minecraft:deepslate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEEPSLATE = create(key("deepslate"));

    /**
     * {@code minecraft:deepslate_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEEPSLATE_BRICK_SLAB = create(key("deepslate_brick_slab"));

    /**
     * {@code minecraft:deepslate_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEEPSLATE_BRICK_STAIRS = create(key("deepslate_brick_stairs"));

    /**
     * {@code minecraft:deepslate_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEEPSLATE_BRICK_WALL = create(key("deepslate_brick_wall"));

    /**
     * {@code minecraft:deepslate_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEEPSLATE_BRICKS = create(key("deepslate_bricks"));

    /**
     * {@code minecraft:deepslate_coal_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEEPSLATE_COAL_ORE = create(key("deepslate_coal_ore"));

    /**
     * {@code minecraft:deepslate_copper_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEEPSLATE_COPPER_ORE = create(key("deepslate_copper_ore"));

    /**
     * {@code minecraft:deepslate_diamond_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEEPSLATE_DIAMOND_ORE = create(key("deepslate_diamond_ore"));

    /**
     * {@code minecraft:deepslate_emerald_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEEPSLATE_EMERALD_ORE = create(key("deepslate_emerald_ore"));

    /**
     * {@code minecraft:deepslate_gold_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEEPSLATE_GOLD_ORE = create(key("deepslate_gold_ore"));

    /**
     * {@code minecraft:deepslate_iron_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEEPSLATE_IRON_ORE = create(key("deepslate_iron_ore"));

    /**
     * {@code minecraft:deepslate_lapis_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEEPSLATE_LAPIS_ORE = create(key("deepslate_lapis_ore"));

    /**
     * {@code minecraft:deepslate_redstone_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEEPSLATE_REDSTONE_ORE = create(key("deepslate_redstone_ore"));

    /**
     * {@code minecraft:deepslate_tile_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEEPSLATE_TILE_SLAB = create(key("deepslate_tile_slab"));

    /**
     * {@code minecraft:deepslate_tile_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEEPSLATE_TILE_STAIRS = create(key("deepslate_tile_stairs"));

    /**
     * {@code minecraft:deepslate_tile_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEEPSLATE_TILE_WALL = create(key("deepslate_tile_wall"));

    /**
     * {@code minecraft:deepslate_tiles}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DEEPSLATE_TILES = create(key("deepslate_tiles"));

    /**
     * {@code minecraft:detector_rail}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DETECTOR_RAIL = create(key("detector_rail"));

    /**
     * {@code minecraft:diamond}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DIAMOND = create(key("diamond"));

    /**
     * {@code minecraft:diamond_axe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DIAMOND_AXE = create(key("diamond_axe"));

    /**
     * {@code minecraft:diamond_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DIAMOND_BLOCK = create(key("diamond_block"));

    /**
     * {@code minecraft:diamond_boots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DIAMOND_BOOTS = create(key("diamond_boots"));

    /**
     * {@code minecraft:diamond_chestplate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DIAMOND_CHESTPLATE = create(key("diamond_chestplate"));

    /**
     * {@code minecraft:diamond_helmet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DIAMOND_HELMET = create(key("diamond_helmet"));

    /**
     * {@code minecraft:diamond_hoe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DIAMOND_HOE = create(key("diamond_hoe"));

    /**
     * {@code minecraft:diamond_horse_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DIAMOND_HORSE_ARMOR = create(key("diamond_horse_armor"));

    /**
     * {@code minecraft:diamond_leggings}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DIAMOND_LEGGINGS = create(key("diamond_leggings"));

    /**
     * {@code minecraft:diamond_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DIAMOND_ORE = create(key("diamond_ore"));

    /**
     * {@code minecraft:diamond_pickaxe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DIAMOND_PICKAXE = create(key("diamond_pickaxe"));

    /**
     * {@code minecraft:diamond_shovel}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DIAMOND_SHOVEL = create(key("diamond_shovel"));

    /**
     * {@code minecraft:diamond_sword}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DIAMOND_SWORD = create(key("diamond_sword"));

    /**
     * {@code minecraft:diorite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DIORITE = create(key("diorite"));

    /**
     * {@code minecraft:diorite_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DIORITE_SLAB = create(key("diorite_slab"));

    /**
     * {@code minecraft:diorite_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DIORITE_STAIRS = create(key("diorite_stairs"));

    /**
     * {@code minecraft:diorite_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DIORITE_WALL = create(key("diorite_wall"));

    /**
     * {@code minecraft:dirt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DIRT = create(key("dirt"));

    /**
     * {@code minecraft:dirt_path}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DIRT_PATH = create(key("dirt_path"));

    /**
     * {@code minecraft:disc_fragment_5}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DISC_FRAGMENT_5 = create(key("disc_fragment_5"));

    /**
     * {@code minecraft:dispenser}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DISPENSER = create(key("dispenser"));

    /**
     * {@code minecraft:dolphin_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DOLPHIN_SPAWN_EGG = create(key("dolphin_spawn_egg"));

    /**
     * {@code minecraft:donkey_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DONKEY_SPAWN_EGG = create(key("donkey_spawn_egg"));

    /**
     * {@code minecraft:dragon_breath}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DRAGON_BREATH = create(key("dragon_breath"));

    /**
     * {@code minecraft:dragon_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DRAGON_EGG = create(key("dragon_egg"));

    /**
     * {@code minecraft:dragon_head}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DRAGON_HEAD = create(key("dragon_head"));

    /**
     * {@code minecraft:dried_ghast}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DRIED_GHAST = create(key("dried_ghast"));

    /**
     * {@code minecraft:dried_kelp}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DRIED_KELP = create(key("dried_kelp"));

    /**
     * {@code minecraft:dried_kelp_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DRIED_KELP_BLOCK = create(key("dried_kelp_block"));

    /**
     * {@code minecraft:dripstone_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DRIPSTONE_BLOCK = create(key("dripstone_block"));

    /**
     * {@code minecraft:dropper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DROPPER = create(key("dropper"));

    /**
     * {@code minecraft:drowned_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DROWNED_SPAWN_EGG = create(key("drowned_spawn_egg"));

    /**
     * {@code minecraft:dune_armor_trim_smithing_template}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> DUNE_ARMOR_TRIM_SMITHING_TEMPLATE = create(key("dune_armor_trim_smithing_template"));

    /**
     * {@code minecraft:echo_shard}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ECHO_SHARD = create(key("echo_shard"));

    /**
     * {@code minecraft:egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> EGG = create(key("egg"));

    /**
     * {@code minecraft:elder_guardian_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ELDER_GUARDIAN_SPAWN_EGG = create(key("elder_guardian_spawn_egg"));

    /**
     * {@code minecraft:elytra}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ELYTRA = create(key("elytra"));

    /**
     * {@code minecraft:emerald}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> EMERALD = create(key("emerald"));

    /**
     * {@code minecraft:emerald_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> EMERALD_BLOCK = create(key("emerald_block"));

    /**
     * {@code minecraft:emerald_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> EMERALD_ORE = create(key("emerald_ore"));

    /**
     * {@code minecraft:enchanted_book}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ENCHANTED_BOOK = create(key("enchanted_book"));

    /**
     * {@code minecraft:enchanted_golden_apple}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ENCHANTED_GOLDEN_APPLE = create(key("enchanted_golden_apple"));

    /**
     * {@code minecraft:enchanting_table}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ENCHANTING_TABLE = create(key("enchanting_table"));

    /**
     * {@code minecraft:end_crystal}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> END_CRYSTAL = create(key("end_crystal"));

    /**
     * {@code minecraft:end_portal_frame}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> END_PORTAL_FRAME = create(key("end_portal_frame"));

    /**
     * {@code minecraft:end_rod}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> END_ROD = create(key("end_rod"));

    /**
     * {@code minecraft:end_stone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> END_STONE = create(key("end_stone"));

    /**
     * {@code minecraft:end_stone_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> END_STONE_BRICK_SLAB = create(key("end_stone_brick_slab"));

    /**
     * {@code minecraft:end_stone_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> END_STONE_BRICK_STAIRS = create(key("end_stone_brick_stairs"));

    /**
     * {@code minecraft:end_stone_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> END_STONE_BRICK_WALL = create(key("end_stone_brick_wall"));

    /**
     * {@code minecraft:end_stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> END_STONE_BRICKS = create(key("end_stone_bricks"));

    /**
     * {@code minecraft:ender_chest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ENDER_CHEST = create(key("ender_chest"));

    /**
     * {@code minecraft:ender_dragon_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ENDER_DRAGON_SPAWN_EGG = create(key("ender_dragon_spawn_egg"));

    /**
     * {@code minecraft:ender_eye}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ENDER_EYE = create(key("ender_eye"));

    /**
     * {@code minecraft:ender_pearl}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ENDER_PEARL = create(key("ender_pearl"));

    /**
     * {@code minecraft:enderman_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ENDERMAN_SPAWN_EGG = create(key("enderman_spawn_egg"));

    /**
     * {@code minecraft:endermite_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ENDERMITE_SPAWN_EGG = create(key("endermite_spawn_egg"));

    /**
     * {@code minecraft:evoker_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> EVOKER_SPAWN_EGG = create(key("evoker_spawn_egg"));

    /**
     * {@code minecraft:experience_bottle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> EXPERIENCE_BOTTLE = create(key("experience_bottle"));

    /**
     * {@code minecraft:explorer_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> EXPLORER_POTTERY_SHERD = create(key("explorer_pottery_sherd"));

    /**
     * {@code minecraft:exposed_chiseled_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> EXPOSED_CHISELED_COPPER = create(key("exposed_chiseled_copper"));

    /**
     * {@code minecraft:exposed_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> EXPOSED_COPPER = create(key("exposed_copper"));

    /**
     * {@code minecraft:exposed_copper_bulb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> EXPOSED_COPPER_BULB = create(key("exposed_copper_bulb"));

    /**
     * {@code minecraft:exposed_copper_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> EXPOSED_COPPER_DOOR = create(key("exposed_copper_door"));

    /**
     * {@code minecraft:exposed_copper_grate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> EXPOSED_COPPER_GRATE = create(key("exposed_copper_grate"));

    /**
     * {@code minecraft:exposed_copper_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> EXPOSED_COPPER_TRAPDOOR = create(key("exposed_copper_trapdoor"));

    /**
     * {@code minecraft:exposed_cut_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> EXPOSED_CUT_COPPER = create(key("exposed_cut_copper"));

    /**
     * {@code minecraft:exposed_cut_copper_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> EXPOSED_CUT_COPPER_SLAB = create(key("exposed_cut_copper_slab"));

    /**
     * {@code minecraft:exposed_cut_copper_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> EXPOSED_CUT_COPPER_STAIRS = create(key("exposed_cut_copper_stairs"));

    /**
     * {@code minecraft:eye_armor_trim_smithing_template}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> EYE_ARMOR_TRIM_SMITHING_TEMPLATE = create(key("eye_armor_trim_smithing_template"));

    /**
     * {@code minecraft:farmland}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FARMLAND = create(key("farmland"));

    /**
     * {@code minecraft:feather}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FEATHER = create(key("feather"));

    /**
     * {@code minecraft:fermented_spider_eye}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FERMENTED_SPIDER_EYE = create(key("fermented_spider_eye"));

    /**
     * {@code minecraft:fern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FERN = create(key("fern"));

    /**
     * {@code minecraft:field_masoned_banner_pattern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FIELD_MASONED_BANNER_PATTERN = create(key("field_masoned_banner_pattern"));

    /**
     * {@code minecraft:filled_map}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FILLED_MAP = create(key("filled_map"));

    /**
     * {@code minecraft:fire_charge}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FIRE_CHARGE = create(key("fire_charge"));

    /**
     * {@code minecraft:fire_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FIRE_CORAL = create(key("fire_coral"));

    /**
     * {@code minecraft:fire_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FIRE_CORAL_BLOCK = create(key("fire_coral_block"));

    /**
     * {@code minecraft:fire_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FIRE_CORAL_FAN = create(key("fire_coral_fan"));

    /**
     * {@code minecraft:firefly_bush}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FIREFLY_BUSH = create(key("firefly_bush"));

    /**
     * {@code minecraft:firework_rocket}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FIREWORK_ROCKET = create(key("firework_rocket"));

    /**
     * {@code minecraft:firework_star}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FIREWORK_STAR = create(key("firework_star"));

    /**
     * {@code minecraft:fishing_rod}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FISHING_ROD = create(key("fishing_rod"));

    /**
     * {@code minecraft:fletching_table}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FLETCHING_TABLE = create(key("fletching_table"));

    /**
     * {@code minecraft:flint}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FLINT = create(key("flint"));

    /**
     * {@code minecraft:flint_and_steel}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FLINT_AND_STEEL = create(key("flint_and_steel"));

    /**
     * {@code minecraft:flow_armor_trim_smithing_template}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FLOW_ARMOR_TRIM_SMITHING_TEMPLATE = create(key("flow_armor_trim_smithing_template"));

    /**
     * {@code minecraft:flow_banner_pattern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FLOW_BANNER_PATTERN = create(key("flow_banner_pattern"));

    /**
     * {@code minecraft:flow_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FLOW_POTTERY_SHERD = create(key("flow_pottery_sherd"));

    /**
     * {@code minecraft:flower_banner_pattern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FLOWER_BANNER_PATTERN = create(key("flower_banner_pattern"));

    /**
     * {@code minecraft:flower_pot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FLOWER_POT = create(key("flower_pot"));

    /**
     * {@code minecraft:flowering_azalea}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FLOWERING_AZALEA = create(key("flowering_azalea"));

    /**
     * {@code minecraft:flowering_azalea_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FLOWERING_AZALEA_LEAVES = create(key("flowering_azalea_leaves"));

    /**
     * {@code minecraft:fox_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FOX_SPAWN_EGG = create(key("fox_spawn_egg"));

    /**
     * {@code minecraft:friend_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FRIEND_POTTERY_SHERD = create(key("friend_pottery_sherd"));

    /**
     * {@code minecraft:frog_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FROG_SPAWN_EGG = create(key("frog_spawn_egg"));

    /**
     * {@code minecraft:frogspawn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FROGSPAWN = create(key("frogspawn"));

    /**
     * {@code minecraft:furnace}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FURNACE = create(key("furnace"));

    /**
     * {@code minecraft:furnace_minecart}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> FURNACE_MINECART = create(key("furnace_minecart"));

    /**
     * {@code minecraft:ghast_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GHAST_SPAWN_EGG = create(key("ghast_spawn_egg"));

    /**
     * {@code minecraft:ghast_tear}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GHAST_TEAR = create(key("ghast_tear"));

    /**
     * {@code minecraft:gilded_blackstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GILDED_BLACKSTONE = create(key("gilded_blackstone"));

    /**
     * {@code minecraft:glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GLASS = create(key("glass"));

    /**
     * {@code minecraft:glass_bottle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GLASS_BOTTLE = create(key("glass_bottle"));

    /**
     * {@code minecraft:glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GLASS_PANE = create(key("glass_pane"));

    /**
     * {@code minecraft:glistering_melon_slice}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GLISTERING_MELON_SLICE = create(key("glistering_melon_slice"));

    /**
     * {@code minecraft:globe_banner_pattern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GLOBE_BANNER_PATTERN = create(key("globe_banner_pattern"));

    /**
     * {@code minecraft:glow_berries}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GLOW_BERRIES = create(key("glow_berries"));

    /**
     * {@code minecraft:glow_ink_sac}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GLOW_INK_SAC = create(key("glow_ink_sac"));

    /**
     * {@code minecraft:glow_item_frame}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GLOW_ITEM_FRAME = create(key("glow_item_frame"));

    /**
     * {@code minecraft:glow_lichen}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GLOW_LICHEN = create(key("glow_lichen"));

    /**
     * {@code minecraft:glow_squid_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GLOW_SQUID_SPAWN_EGG = create(key("glow_squid_spawn_egg"));

    /**
     * {@code minecraft:glowstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GLOWSTONE = create(key("glowstone"));

    /**
     * {@code minecraft:glowstone_dust}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GLOWSTONE_DUST = create(key("glowstone_dust"));

    /**
     * {@code minecraft:goat_horn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GOAT_HORN = create(key("goat_horn"));

    /**
     * {@code minecraft:goat_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GOAT_SPAWN_EGG = create(key("goat_spawn_egg"));

    /**
     * {@code minecraft:gold_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GOLD_BLOCK = create(key("gold_block"));

    /**
     * {@code minecraft:gold_ingot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GOLD_INGOT = create(key("gold_ingot"));

    /**
     * {@code minecraft:gold_nugget}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GOLD_NUGGET = create(key("gold_nugget"));

    /**
     * {@code minecraft:gold_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GOLD_ORE = create(key("gold_ore"));

    /**
     * {@code minecraft:golden_apple}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GOLDEN_APPLE = create(key("golden_apple"));

    /**
     * {@code minecraft:golden_axe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GOLDEN_AXE = create(key("golden_axe"));

    /**
     * {@code minecraft:golden_boots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GOLDEN_BOOTS = create(key("golden_boots"));

    /**
     * {@code minecraft:golden_carrot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GOLDEN_CARROT = create(key("golden_carrot"));

    /**
     * {@code minecraft:golden_chestplate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GOLDEN_CHESTPLATE = create(key("golden_chestplate"));

    /**
     * {@code minecraft:golden_helmet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GOLDEN_HELMET = create(key("golden_helmet"));

    /**
     * {@code minecraft:golden_hoe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GOLDEN_HOE = create(key("golden_hoe"));

    /**
     * {@code minecraft:golden_horse_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GOLDEN_HORSE_ARMOR = create(key("golden_horse_armor"));

    /**
     * {@code minecraft:golden_leggings}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GOLDEN_LEGGINGS = create(key("golden_leggings"));

    /**
     * {@code minecraft:golden_pickaxe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GOLDEN_PICKAXE = create(key("golden_pickaxe"));

    /**
     * {@code minecraft:golden_shovel}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GOLDEN_SHOVEL = create(key("golden_shovel"));

    /**
     * {@code minecraft:golden_sword}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GOLDEN_SWORD = create(key("golden_sword"));

    /**
     * {@code minecraft:granite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRANITE = create(key("granite"));

    /**
     * {@code minecraft:granite_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRANITE_SLAB = create(key("granite_slab"));

    /**
     * {@code minecraft:granite_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRANITE_STAIRS = create(key("granite_stairs"));

    /**
     * {@code minecraft:granite_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRANITE_WALL = create(key("granite_wall"));

    /**
     * {@code minecraft:grass_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRASS_BLOCK = create(key("grass_block"));

    /**
     * {@code minecraft:gravel}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRAVEL = create(key("gravel"));

    /**
     * {@code minecraft:gray_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRAY_BANNER = create(key("gray_banner"));

    /**
     * {@code minecraft:gray_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRAY_BED = create(key("gray_bed"));

    /**
     * {@code minecraft:gray_bundle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRAY_BUNDLE = create(key("gray_bundle"));

    /**
     * {@code minecraft:gray_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRAY_CANDLE = create(key("gray_candle"));

    /**
     * {@code minecraft:gray_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRAY_CARPET = create(key("gray_carpet"));

    /**
     * {@code minecraft:gray_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRAY_CONCRETE = create(key("gray_concrete"));

    /**
     * {@code minecraft:gray_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRAY_CONCRETE_POWDER = create(key("gray_concrete_powder"));

    /**
     * {@code minecraft:gray_dye}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRAY_DYE = create(key("gray_dye"));

    /**
     * {@code minecraft:gray_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRAY_GLAZED_TERRACOTTA = create(key("gray_glazed_terracotta"));

    /**
     * {@code minecraft:gray_harness}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRAY_HARNESS = create(key("gray_harness"));

    /**
     * {@code minecraft:gray_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRAY_SHULKER_BOX = create(key("gray_shulker_box"));

    /**
     * {@code minecraft:gray_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRAY_STAINED_GLASS = create(key("gray_stained_glass"));

    /**
     * {@code minecraft:gray_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRAY_STAINED_GLASS_PANE = create(key("gray_stained_glass_pane"));

    /**
     * {@code minecraft:gray_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRAY_TERRACOTTA = create(key("gray_terracotta"));

    /**
     * {@code minecraft:gray_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRAY_WOOL = create(key("gray_wool"));

    /**
     * {@code minecraft:green_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GREEN_BANNER = create(key("green_banner"));

    /**
     * {@code minecraft:green_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GREEN_BED = create(key("green_bed"));

    /**
     * {@code minecraft:green_bundle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GREEN_BUNDLE = create(key("green_bundle"));

    /**
     * {@code minecraft:green_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GREEN_CANDLE = create(key("green_candle"));

    /**
     * {@code minecraft:green_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GREEN_CARPET = create(key("green_carpet"));

    /**
     * {@code minecraft:green_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GREEN_CONCRETE = create(key("green_concrete"));

    /**
     * {@code minecraft:green_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GREEN_CONCRETE_POWDER = create(key("green_concrete_powder"));

    /**
     * {@code minecraft:green_dye}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GREEN_DYE = create(key("green_dye"));

    /**
     * {@code minecraft:green_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GREEN_GLAZED_TERRACOTTA = create(key("green_glazed_terracotta"));

    /**
     * {@code minecraft:green_harness}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GREEN_HARNESS = create(key("green_harness"));

    /**
     * {@code minecraft:green_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GREEN_SHULKER_BOX = create(key("green_shulker_box"));

    /**
     * {@code minecraft:green_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GREEN_STAINED_GLASS = create(key("green_stained_glass"));

    /**
     * {@code minecraft:green_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GREEN_STAINED_GLASS_PANE = create(key("green_stained_glass_pane"));

    /**
     * {@code minecraft:green_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GREEN_TERRACOTTA = create(key("green_terracotta"));

    /**
     * {@code minecraft:green_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GREEN_WOOL = create(key("green_wool"));

    /**
     * {@code minecraft:grindstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GRINDSTONE = create(key("grindstone"));

    /**
     * {@code minecraft:guardian_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GUARDIAN_SPAWN_EGG = create(key("guardian_spawn_egg"));

    /**
     * {@code minecraft:gunpowder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GUNPOWDER = create(key("gunpowder"));

    /**
     * {@code minecraft:guster_banner_pattern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GUSTER_BANNER_PATTERN = create(key("guster_banner_pattern"));

    /**
     * {@code minecraft:guster_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> GUSTER_POTTERY_SHERD = create(key("guster_pottery_sherd"));

    /**
     * {@code minecraft:hanging_roots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HANGING_ROOTS = create(key("hanging_roots"));

    /**
     * {@code minecraft:happy_ghast_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HAPPY_GHAST_SPAWN_EGG = create(key("happy_ghast_spawn_egg"));

    /**
     * {@code minecraft:hay_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HAY_BLOCK = create(key("hay_block"));

    /**
     * {@code minecraft:heart_of_the_sea}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HEART_OF_THE_SEA = create(key("heart_of_the_sea"));

    /**
     * {@code minecraft:heart_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HEART_POTTERY_SHERD = create(key("heart_pottery_sherd"));

    /**
     * {@code minecraft:heartbreak_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HEARTBREAK_POTTERY_SHERD = create(key("heartbreak_pottery_sherd"));

    /**
     * {@code minecraft:heavy_core}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HEAVY_CORE = create(key("heavy_core"));

    /**
     * {@code minecraft:heavy_weighted_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HEAVY_WEIGHTED_PRESSURE_PLATE = create(key("heavy_weighted_pressure_plate"));

    /**
     * {@code minecraft:hoglin_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HOGLIN_SPAWN_EGG = create(key("hoglin_spawn_egg"));

    /**
     * {@code minecraft:honey_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HONEY_BLOCK = create(key("honey_block"));

    /**
     * {@code minecraft:honey_bottle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HONEY_BOTTLE = create(key("honey_bottle"));

    /**
     * {@code minecraft:honeycomb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HONEYCOMB = create(key("honeycomb"));

    /**
     * {@code minecraft:honeycomb_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HONEYCOMB_BLOCK = create(key("honeycomb_block"));

    /**
     * {@code minecraft:hopper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HOPPER = create(key("hopper"));

    /**
     * {@code minecraft:hopper_minecart}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HOPPER_MINECART = create(key("hopper_minecart"));

    /**
     * {@code minecraft:horn_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HORN_CORAL = create(key("horn_coral"));

    /**
     * {@code minecraft:horn_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HORN_CORAL_BLOCK = create(key("horn_coral_block"));

    /**
     * {@code minecraft:horn_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HORN_CORAL_FAN = create(key("horn_coral_fan"));

    /**
     * {@code minecraft:horse_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HORSE_SPAWN_EGG = create(key("horse_spawn_egg"));

    /**
     * {@code minecraft:host_armor_trim_smithing_template}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HOST_ARMOR_TRIM_SMITHING_TEMPLATE = create(key("host_armor_trim_smithing_template"));

    /**
     * {@code minecraft:howl_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HOWL_POTTERY_SHERD = create(key("howl_pottery_sherd"));

    /**
     * {@code minecraft:husk_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> HUSK_SPAWN_EGG = create(key("husk_spawn_egg"));

    /**
     * {@code minecraft:ice}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ICE = create(key("ice"));

    /**
     * {@code minecraft:infested_chiseled_stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> INFESTED_CHISELED_STONE_BRICKS = create(key("infested_chiseled_stone_bricks"));

    /**
     * {@code minecraft:infested_cobblestone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> INFESTED_COBBLESTONE = create(key("infested_cobblestone"));

    /**
     * {@code minecraft:infested_cracked_stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> INFESTED_CRACKED_STONE_BRICKS = create(key("infested_cracked_stone_bricks"));

    /**
     * {@code minecraft:infested_deepslate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> INFESTED_DEEPSLATE = create(key("infested_deepslate"));

    /**
     * {@code minecraft:infested_mossy_stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> INFESTED_MOSSY_STONE_BRICKS = create(key("infested_mossy_stone_bricks"));

    /**
     * {@code minecraft:infested_stone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> INFESTED_STONE = create(key("infested_stone"));

    /**
     * {@code minecraft:infested_stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> INFESTED_STONE_BRICKS = create(key("infested_stone_bricks"));

    /**
     * {@code minecraft:ink_sac}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> INK_SAC = create(key("ink_sac"));

    /**
     * {@code minecraft:iron_axe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> IRON_AXE = create(key("iron_axe"));

    /**
     * {@code minecraft:iron_bars}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> IRON_BARS = create(key("iron_bars"));

    /**
     * {@code minecraft:iron_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> IRON_BLOCK = create(key("iron_block"));

    /**
     * {@code minecraft:iron_boots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> IRON_BOOTS = create(key("iron_boots"));

    /**
     * {@code minecraft:iron_chestplate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> IRON_CHESTPLATE = create(key("iron_chestplate"));

    /**
     * {@code minecraft:iron_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> IRON_DOOR = create(key("iron_door"));

    /**
     * {@code minecraft:iron_golem_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> IRON_GOLEM_SPAWN_EGG = create(key("iron_golem_spawn_egg"));

    /**
     * {@code minecraft:iron_helmet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> IRON_HELMET = create(key("iron_helmet"));

    /**
     * {@code minecraft:iron_hoe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> IRON_HOE = create(key("iron_hoe"));

    /**
     * {@code minecraft:iron_horse_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> IRON_HORSE_ARMOR = create(key("iron_horse_armor"));

    /**
     * {@code minecraft:iron_ingot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> IRON_INGOT = create(key("iron_ingot"));

    /**
     * {@code minecraft:iron_leggings}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> IRON_LEGGINGS = create(key("iron_leggings"));

    /**
     * {@code minecraft:iron_nugget}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> IRON_NUGGET = create(key("iron_nugget"));

    /**
     * {@code minecraft:iron_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> IRON_ORE = create(key("iron_ore"));

    /**
     * {@code minecraft:iron_pickaxe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> IRON_PICKAXE = create(key("iron_pickaxe"));

    /**
     * {@code minecraft:iron_shovel}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> IRON_SHOVEL = create(key("iron_shovel"));

    /**
     * {@code minecraft:iron_sword}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> IRON_SWORD = create(key("iron_sword"));

    /**
     * {@code minecraft:iron_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> IRON_TRAPDOOR = create(key("iron_trapdoor"));

    /**
     * {@code minecraft:item_frame}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ITEM_FRAME = create(key("item_frame"));

    /**
     * {@code minecraft:jack_o_lantern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JACK_O_LANTERN = create(key("jack_o_lantern"));

    /**
     * {@code minecraft:jigsaw}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JIGSAW = create(key("jigsaw"));

    /**
     * {@code minecraft:jukebox}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JUKEBOX = create(key("jukebox"));

    /**
     * {@code minecraft:jungle_boat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JUNGLE_BOAT = create(key("jungle_boat"));

    /**
     * {@code minecraft:jungle_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JUNGLE_BUTTON = create(key("jungle_button"));

    /**
     * {@code minecraft:jungle_chest_boat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JUNGLE_CHEST_BOAT = create(key("jungle_chest_boat"));

    /**
     * {@code minecraft:jungle_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JUNGLE_DOOR = create(key("jungle_door"));

    /**
     * {@code minecraft:jungle_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JUNGLE_FENCE = create(key("jungle_fence"));

    /**
     * {@code minecraft:jungle_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JUNGLE_FENCE_GATE = create(key("jungle_fence_gate"));

    /**
     * {@code minecraft:jungle_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JUNGLE_HANGING_SIGN = create(key("jungle_hanging_sign"));

    /**
     * {@code minecraft:jungle_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JUNGLE_LEAVES = create(key("jungle_leaves"));

    /**
     * {@code minecraft:jungle_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JUNGLE_LOG = create(key("jungle_log"));

    /**
     * {@code minecraft:jungle_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JUNGLE_PLANKS = create(key("jungle_planks"));

    /**
     * {@code minecraft:jungle_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JUNGLE_PRESSURE_PLATE = create(key("jungle_pressure_plate"));

    /**
     * {@code minecraft:jungle_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JUNGLE_SAPLING = create(key("jungle_sapling"));

    /**
     * {@code minecraft:jungle_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JUNGLE_SIGN = create(key("jungle_sign"));

    /**
     * {@code minecraft:jungle_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JUNGLE_SLAB = create(key("jungle_slab"));

    /**
     * {@code minecraft:jungle_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JUNGLE_STAIRS = create(key("jungle_stairs"));

    /**
     * {@code minecraft:jungle_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JUNGLE_TRAPDOOR = create(key("jungle_trapdoor"));

    /**
     * {@code minecraft:jungle_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> JUNGLE_WOOD = create(key("jungle_wood"));

    /**
     * {@code minecraft:kelp}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> KELP = create(key("kelp"));

    /**
     * {@code minecraft:knowledge_book}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> KNOWLEDGE_BOOK = create(key("knowledge_book"));

    /**
     * {@code minecraft:ladder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LADDER = create(key("ladder"));

    /**
     * {@code minecraft:lantern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LANTERN = create(key("lantern"));

    /**
     * {@code minecraft:lapis_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LAPIS_BLOCK = create(key("lapis_block"));

    /**
     * {@code minecraft:lapis_lazuli}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LAPIS_LAZULI = create(key("lapis_lazuli"));

    /**
     * {@code minecraft:lapis_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LAPIS_ORE = create(key("lapis_ore"));

    /**
     * {@code minecraft:large_amethyst_bud}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LARGE_AMETHYST_BUD = create(key("large_amethyst_bud"));

    /**
     * {@code minecraft:large_fern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LARGE_FERN = create(key("large_fern"));

    /**
     * {@code minecraft:lava_bucket}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LAVA_BUCKET = create(key("lava_bucket"));

    /**
     * {@code minecraft:lead}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LEAD = create(key("lead"));

    /**
     * {@code minecraft:leaf_litter}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LEAF_LITTER = create(key("leaf_litter"));

    /**
     * {@code minecraft:leather}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LEATHER = create(key("leather"));

    /**
     * {@code minecraft:leather_boots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LEATHER_BOOTS = create(key("leather_boots"));

    /**
     * {@code minecraft:leather_chestplate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LEATHER_CHESTPLATE = create(key("leather_chestplate"));

    /**
     * {@code minecraft:leather_helmet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LEATHER_HELMET = create(key("leather_helmet"));

    /**
     * {@code minecraft:leather_horse_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LEATHER_HORSE_ARMOR = create(key("leather_horse_armor"));

    /**
     * {@code minecraft:leather_leggings}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LEATHER_LEGGINGS = create(key("leather_leggings"));

    /**
     * {@code minecraft:lectern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LECTERN = create(key("lectern"));

    /**
     * {@code minecraft:lever}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LEVER = create(key("lever"));

    /**
     * {@code minecraft:light}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT = create(key("light"));

    /**
     * {@code minecraft:light_blue_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_BLUE_BANNER = create(key("light_blue_banner"));

    /**
     * {@code minecraft:light_blue_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_BLUE_BED = create(key("light_blue_bed"));

    /**
     * {@code minecraft:light_blue_bundle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_BLUE_BUNDLE = create(key("light_blue_bundle"));

    /**
     * {@code minecraft:light_blue_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_BLUE_CANDLE = create(key("light_blue_candle"));

    /**
     * {@code minecraft:light_blue_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_BLUE_CARPET = create(key("light_blue_carpet"));

    /**
     * {@code minecraft:light_blue_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_BLUE_CONCRETE = create(key("light_blue_concrete"));

    /**
     * {@code minecraft:light_blue_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_BLUE_CONCRETE_POWDER = create(key("light_blue_concrete_powder"));

    /**
     * {@code minecraft:light_blue_dye}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_BLUE_DYE = create(key("light_blue_dye"));

    /**
     * {@code minecraft:light_blue_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_BLUE_GLAZED_TERRACOTTA = create(key("light_blue_glazed_terracotta"));

    /**
     * {@code minecraft:light_blue_harness}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_BLUE_HARNESS = create(key("light_blue_harness"));

    /**
     * {@code minecraft:light_blue_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_BLUE_SHULKER_BOX = create(key("light_blue_shulker_box"));

    /**
     * {@code minecraft:light_blue_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_BLUE_STAINED_GLASS = create(key("light_blue_stained_glass"));

    /**
     * {@code minecraft:light_blue_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_BLUE_STAINED_GLASS_PANE = create(key("light_blue_stained_glass_pane"));

    /**
     * {@code minecraft:light_blue_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_BLUE_TERRACOTTA = create(key("light_blue_terracotta"));

    /**
     * {@code minecraft:light_blue_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_BLUE_WOOL = create(key("light_blue_wool"));

    /**
     * {@code minecraft:light_gray_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_GRAY_BANNER = create(key("light_gray_banner"));

    /**
     * {@code minecraft:light_gray_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_GRAY_BED = create(key("light_gray_bed"));

    /**
     * {@code minecraft:light_gray_bundle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_GRAY_BUNDLE = create(key("light_gray_bundle"));

    /**
     * {@code minecraft:light_gray_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_GRAY_CANDLE = create(key("light_gray_candle"));

    /**
     * {@code minecraft:light_gray_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_GRAY_CARPET = create(key("light_gray_carpet"));

    /**
     * {@code minecraft:light_gray_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_GRAY_CONCRETE = create(key("light_gray_concrete"));

    /**
     * {@code minecraft:light_gray_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_GRAY_CONCRETE_POWDER = create(key("light_gray_concrete_powder"));

    /**
     * {@code minecraft:light_gray_dye}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_GRAY_DYE = create(key("light_gray_dye"));

    /**
     * {@code minecraft:light_gray_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_GRAY_GLAZED_TERRACOTTA = create(key("light_gray_glazed_terracotta"));

    /**
     * {@code minecraft:light_gray_harness}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_GRAY_HARNESS = create(key("light_gray_harness"));

    /**
     * {@code minecraft:light_gray_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_GRAY_SHULKER_BOX = create(key("light_gray_shulker_box"));

    /**
     * {@code minecraft:light_gray_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_GRAY_STAINED_GLASS = create(key("light_gray_stained_glass"));

    /**
     * {@code minecraft:light_gray_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_GRAY_STAINED_GLASS_PANE = create(key("light_gray_stained_glass_pane"));

    /**
     * {@code minecraft:light_gray_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_GRAY_TERRACOTTA = create(key("light_gray_terracotta"));

    /**
     * {@code minecraft:light_gray_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_GRAY_WOOL = create(key("light_gray_wool"));

    /**
     * {@code minecraft:light_weighted_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHT_WEIGHTED_PRESSURE_PLATE = create(key("light_weighted_pressure_plate"));

    /**
     * {@code minecraft:lightning_rod}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIGHTNING_ROD = create(key("lightning_rod"));

    /**
     * {@code minecraft:lilac}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LILAC = create(key("lilac"));

    /**
     * {@code minecraft:lily_of_the_valley}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LILY_OF_THE_VALLEY = create(key("lily_of_the_valley"));

    /**
     * {@code minecraft:lily_pad}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LILY_PAD = create(key("lily_pad"));

    /**
     * {@code minecraft:lime_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIME_BANNER = create(key("lime_banner"));

    /**
     * {@code minecraft:lime_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIME_BED = create(key("lime_bed"));

    /**
     * {@code minecraft:lime_bundle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIME_BUNDLE = create(key("lime_bundle"));

    /**
     * {@code minecraft:lime_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIME_CANDLE = create(key("lime_candle"));

    /**
     * {@code minecraft:lime_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIME_CARPET = create(key("lime_carpet"));

    /**
     * {@code minecraft:lime_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIME_CONCRETE = create(key("lime_concrete"));

    /**
     * {@code minecraft:lime_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIME_CONCRETE_POWDER = create(key("lime_concrete_powder"));

    /**
     * {@code minecraft:lime_dye}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIME_DYE = create(key("lime_dye"));

    /**
     * {@code minecraft:lime_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIME_GLAZED_TERRACOTTA = create(key("lime_glazed_terracotta"));

    /**
     * {@code minecraft:lime_harness}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIME_HARNESS = create(key("lime_harness"));

    /**
     * {@code minecraft:lime_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIME_SHULKER_BOX = create(key("lime_shulker_box"));

    /**
     * {@code minecraft:lime_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIME_STAINED_GLASS = create(key("lime_stained_glass"));

    /**
     * {@code minecraft:lime_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIME_STAINED_GLASS_PANE = create(key("lime_stained_glass_pane"));

    /**
     * {@code minecraft:lime_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIME_TERRACOTTA = create(key("lime_terracotta"));

    /**
     * {@code minecraft:lime_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LIME_WOOL = create(key("lime_wool"));

    /**
     * {@code minecraft:lingering_potion}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LINGERING_POTION = create(key("lingering_potion"));

    /**
     * {@code minecraft:llama_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LLAMA_SPAWN_EGG = create(key("llama_spawn_egg"));

    /**
     * {@code minecraft:lodestone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LODESTONE = create(key("lodestone"));

    /**
     * {@code minecraft:loom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> LOOM = create(key("loom"));

    /**
     * {@code minecraft:mace}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MACE = create(key("mace"));

    /**
     * {@code minecraft:magenta_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MAGENTA_BANNER = create(key("magenta_banner"));

    /**
     * {@code minecraft:magenta_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MAGENTA_BED = create(key("magenta_bed"));

    /**
     * {@code minecraft:magenta_bundle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MAGENTA_BUNDLE = create(key("magenta_bundle"));

    /**
     * {@code minecraft:magenta_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MAGENTA_CANDLE = create(key("magenta_candle"));

    /**
     * {@code minecraft:magenta_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MAGENTA_CARPET = create(key("magenta_carpet"));

    /**
     * {@code minecraft:magenta_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MAGENTA_CONCRETE = create(key("magenta_concrete"));

    /**
     * {@code minecraft:magenta_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MAGENTA_CONCRETE_POWDER = create(key("magenta_concrete_powder"));

    /**
     * {@code minecraft:magenta_dye}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MAGENTA_DYE = create(key("magenta_dye"));

    /**
     * {@code minecraft:magenta_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MAGENTA_GLAZED_TERRACOTTA = create(key("magenta_glazed_terracotta"));

    /**
     * {@code minecraft:magenta_harness}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MAGENTA_HARNESS = create(key("magenta_harness"));

    /**
     * {@code minecraft:magenta_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MAGENTA_SHULKER_BOX = create(key("magenta_shulker_box"));

    /**
     * {@code minecraft:magenta_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MAGENTA_STAINED_GLASS = create(key("magenta_stained_glass"));

    /**
     * {@code minecraft:magenta_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MAGENTA_STAINED_GLASS_PANE = create(key("magenta_stained_glass_pane"));

    /**
     * {@code minecraft:magenta_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MAGENTA_TERRACOTTA = create(key("magenta_terracotta"));

    /**
     * {@code minecraft:magenta_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MAGENTA_WOOL = create(key("magenta_wool"));

    /**
     * {@code minecraft:magma_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MAGMA_BLOCK = create(key("magma_block"));

    /**
     * {@code minecraft:magma_cream}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MAGMA_CREAM = create(key("magma_cream"));

    /**
     * {@code minecraft:magma_cube_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MAGMA_CUBE_SPAWN_EGG = create(key("magma_cube_spawn_egg"));

    /**
     * {@code minecraft:mangrove_boat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MANGROVE_BOAT = create(key("mangrove_boat"));

    /**
     * {@code minecraft:mangrove_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MANGROVE_BUTTON = create(key("mangrove_button"));

    /**
     * {@code minecraft:mangrove_chest_boat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MANGROVE_CHEST_BOAT = create(key("mangrove_chest_boat"));

    /**
     * {@code minecraft:mangrove_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MANGROVE_DOOR = create(key("mangrove_door"));

    /**
     * {@code minecraft:mangrove_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MANGROVE_FENCE = create(key("mangrove_fence"));

    /**
     * {@code minecraft:mangrove_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MANGROVE_FENCE_GATE = create(key("mangrove_fence_gate"));

    /**
     * {@code minecraft:mangrove_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MANGROVE_HANGING_SIGN = create(key("mangrove_hanging_sign"));

    /**
     * {@code minecraft:mangrove_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MANGROVE_LEAVES = create(key("mangrove_leaves"));

    /**
     * {@code minecraft:mangrove_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MANGROVE_LOG = create(key("mangrove_log"));

    /**
     * {@code minecraft:mangrove_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MANGROVE_PLANKS = create(key("mangrove_planks"));

    /**
     * {@code minecraft:mangrove_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MANGROVE_PRESSURE_PLATE = create(key("mangrove_pressure_plate"));

    /**
     * {@code minecraft:mangrove_propagule}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MANGROVE_PROPAGULE = create(key("mangrove_propagule"));

    /**
     * {@code minecraft:mangrove_roots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MANGROVE_ROOTS = create(key("mangrove_roots"));

    /**
     * {@code minecraft:mangrove_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MANGROVE_SIGN = create(key("mangrove_sign"));

    /**
     * {@code minecraft:mangrove_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MANGROVE_SLAB = create(key("mangrove_slab"));

    /**
     * {@code minecraft:mangrove_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MANGROVE_STAIRS = create(key("mangrove_stairs"));

    /**
     * {@code minecraft:mangrove_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MANGROVE_TRAPDOOR = create(key("mangrove_trapdoor"));

    /**
     * {@code minecraft:mangrove_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MANGROVE_WOOD = create(key("mangrove_wood"));

    /**
     * {@code minecraft:map}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MAP = create(key("map"));

    /**
     * {@code minecraft:medium_amethyst_bud}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MEDIUM_AMETHYST_BUD = create(key("medium_amethyst_bud"));

    /**
     * {@code minecraft:melon}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MELON = create(key("melon"));

    /**
     * {@code minecraft:melon_seeds}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MELON_SEEDS = create(key("melon_seeds"));

    /**
     * {@code minecraft:melon_slice}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MELON_SLICE = create(key("melon_slice"));

    /**
     * {@code minecraft:milk_bucket}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MILK_BUCKET = create(key("milk_bucket"));

    /**
     * {@code minecraft:minecart}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MINECART = create(key("minecart"));

    /**
     * {@code minecraft:miner_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MINER_POTTERY_SHERD = create(key("miner_pottery_sherd"));

    /**
     * {@code minecraft:mojang_banner_pattern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MOJANG_BANNER_PATTERN = create(key("mojang_banner_pattern"));

    /**
     * {@code minecraft:mooshroom_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MOOSHROOM_SPAWN_EGG = create(key("mooshroom_spawn_egg"));

    /**
     * {@code minecraft:moss_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MOSS_BLOCK = create(key("moss_block"));

    /**
     * {@code minecraft:moss_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MOSS_CARPET = create(key("moss_carpet"));

    /**
     * {@code minecraft:mossy_cobblestone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MOSSY_COBBLESTONE = create(key("mossy_cobblestone"));

    /**
     * {@code minecraft:mossy_cobblestone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MOSSY_COBBLESTONE_SLAB = create(key("mossy_cobblestone_slab"));

    /**
     * {@code minecraft:mossy_cobblestone_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MOSSY_COBBLESTONE_STAIRS = create(key("mossy_cobblestone_stairs"));

    /**
     * {@code minecraft:mossy_cobblestone_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MOSSY_COBBLESTONE_WALL = create(key("mossy_cobblestone_wall"));

    /**
     * {@code minecraft:mossy_stone_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MOSSY_STONE_BRICK_SLAB = create(key("mossy_stone_brick_slab"));

    /**
     * {@code minecraft:mossy_stone_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MOSSY_STONE_BRICK_STAIRS = create(key("mossy_stone_brick_stairs"));

    /**
     * {@code minecraft:mossy_stone_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MOSSY_STONE_BRICK_WALL = create(key("mossy_stone_brick_wall"));

    /**
     * {@code minecraft:mossy_stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MOSSY_STONE_BRICKS = create(key("mossy_stone_bricks"));

    /**
     * {@code minecraft:mourner_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MOURNER_POTTERY_SHERD = create(key("mourner_pottery_sherd"));

    /**
     * {@code minecraft:mud}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUD = create(key("mud"));

    /**
     * {@code minecraft:mud_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUD_BRICK_SLAB = create(key("mud_brick_slab"));

    /**
     * {@code minecraft:mud_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUD_BRICK_STAIRS = create(key("mud_brick_stairs"));

    /**
     * {@code minecraft:mud_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUD_BRICK_WALL = create(key("mud_brick_wall"));

    /**
     * {@code minecraft:mud_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUD_BRICKS = create(key("mud_bricks"));

    /**
     * {@code minecraft:muddy_mangrove_roots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUDDY_MANGROVE_ROOTS = create(key("muddy_mangrove_roots"));

    /**
     * {@code minecraft:mule_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MULE_SPAWN_EGG = create(key("mule_spawn_egg"));

    /**
     * {@code minecraft:mushroom_stem}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSHROOM_STEM = create(key("mushroom_stem"));

    /**
     * {@code minecraft:mushroom_stew}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSHROOM_STEW = create(key("mushroom_stew"));

    /**
     * {@code minecraft:music_disc_5}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_5 = create(key("music_disc_5"));

    /**
     * {@code minecraft:music_disc_11}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_11 = create(key("music_disc_11"));

    /**
     * {@code minecraft:music_disc_13}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_13 = create(key("music_disc_13"));

    /**
     * {@code minecraft:music_disc_blocks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_BLOCKS = create(key("music_disc_blocks"));

    /**
     * {@code minecraft:music_disc_cat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_CAT = create(key("music_disc_cat"));

    /**
     * {@code minecraft:music_disc_chirp}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_CHIRP = create(key("music_disc_chirp"));

    /**
     * {@code minecraft:music_disc_creator}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_CREATOR = create(key("music_disc_creator"));

    /**
     * {@code minecraft:music_disc_creator_music_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_CREATOR_MUSIC_BOX = create(key("music_disc_creator_music_box"));

    /**
     * {@code minecraft:music_disc_far}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_FAR = create(key("music_disc_far"));

    /**
     * {@code minecraft:music_disc_lava_chicken}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_LAVA_CHICKEN = create(key("music_disc_lava_chicken"));

    /**
     * {@code minecraft:music_disc_mall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_MALL = create(key("music_disc_mall"));

    /**
     * {@code minecraft:music_disc_mellohi}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_MELLOHI = create(key("music_disc_mellohi"));

    /**
     * {@code minecraft:music_disc_otherside}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_OTHERSIDE = create(key("music_disc_otherside"));

    /**
     * {@code minecraft:music_disc_pigstep}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_PIGSTEP = create(key("music_disc_pigstep"));

    /**
     * {@code minecraft:music_disc_precipice}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_PRECIPICE = create(key("music_disc_precipice"));

    /**
     * {@code minecraft:music_disc_relic}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_RELIC = create(key("music_disc_relic"));

    /**
     * {@code minecraft:music_disc_stal}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_STAL = create(key("music_disc_stal"));

    /**
     * {@code minecraft:music_disc_strad}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_STRAD = create(key("music_disc_strad"));

    /**
     * {@code minecraft:music_disc_tears}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_TEARS = create(key("music_disc_tears"));

    /**
     * {@code minecraft:music_disc_wait}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_WAIT = create(key("music_disc_wait"));

    /**
     * {@code minecraft:music_disc_ward}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUSIC_DISC_WARD = create(key("music_disc_ward"));

    /**
     * {@code minecraft:mutton}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MUTTON = create(key("mutton"));

    /**
     * {@code minecraft:mycelium}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> MYCELIUM = create(key("mycelium"));

    /**
     * {@code minecraft:name_tag}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NAME_TAG = create(key("name_tag"));

    /**
     * {@code minecraft:nautilus_shell}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NAUTILUS_SHELL = create(key("nautilus_shell"));

    /**
     * {@code minecraft:nether_brick}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHER_BRICK = create(key("nether_brick"));

    /**
     * {@code minecraft:nether_brick_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHER_BRICK_FENCE = create(key("nether_brick_fence"));

    /**
     * {@code minecraft:nether_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHER_BRICK_SLAB = create(key("nether_brick_slab"));

    /**
     * {@code minecraft:nether_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHER_BRICK_STAIRS = create(key("nether_brick_stairs"));

    /**
     * {@code minecraft:nether_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHER_BRICK_WALL = create(key("nether_brick_wall"));

    /**
     * {@code minecraft:nether_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHER_BRICKS = create(key("nether_bricks"));

    /**
     * {@code minecraft:nether_gold_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHER_GOLD_ORE = create(key("nether_gold_ore"));

    /**
     * {@code minecraft:nether_quartz_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHER_QUARTZ_ORE = create(key("nether_quartz_ore"));

    /**
     * {@code minecraft:nether_sprouts}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHER_SPROUTS = create(key("nether_sprouts"));

    /**
     * {@code minecraft:nether_star}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHER_STAR = create(key("nether_star"));

    /**
     * {@code minecraft:nether_wart}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHER_WART = create(key("nether_wart"));

    /**
     * {@code minecraft:nether_wart_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHER_WART_BLOCK = create(key("nether_wart_block"));

    /**
     * {@code minecraft:netherite_axe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHERITE_AXE = create(key("netherite_axe"));

    /**
     * {@code minecraft:netherite_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHERITE_BLOCK = create(key("netherite_block"));

    /**
     * {@code minecraft:netherite_boots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHERITE_BOOTS = create(key("netherite_boots"));

    /**
     * {@code minecraft:netherite_chestplate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHERITE_CHESTPLATE = create(key("netherite_chestplate"));

    /**
     * {@code minecraft:netherite_helmet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHERITE_HELMET = create(key("netherite_helmet"));

    /**
     * {@code minecraft:netherite_hoe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHERITE_HOE = create(key("netherite_hoe"));

    /**
     * {@code minecraft:netherite_ingot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHERITE_INGOT = create(key("netherite_ingot"));

    /**
     * {@code minecraft:netherite_leggings}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHERITE_LEGGINGS = create(key("netherite_leggings"));

    /**
     * {@code minecraft:netherite_pickaxe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHERITE_PICKAXE = create(key("netherite_pickaxe"));

    /**
     * {@code minecraft:netherite_scrap}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHERITE_SCRAP = create(key("netherite_scrap"));

    /**
     * {@code minecraft:netherite_shovel}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHERITE_SHOVEL = create(key("netherite_shovel"));

    /**
     * {@code minecraft:netherite_sword}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHERITE_SWORD = create(key("netherite_sword"));

    /**
     * {@code minecraft:netherite_upgrade_smithing_template}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHERITE_UPGRADE_SMITHING_TEMPLATE = create(key("netherite_upgrade_smithing_template"));

    /**
     * {@code minecraft:netherrack}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NETHERRACK = create(key("netherrack"));

    /**
     * {@code minecraft:note_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> NOTE_BLOCK = create(key("note_block"));

    /**
     * {@code minecraft:oak_boat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OAK_BOAT = create(key("oak_boat"));

    /**
     * {@code minecraft:oak_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OAK_BUTTON = create(key("oak_button"));

    /**
     * {@code minecraft:oak_chest_boat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OAK_CHEST_BOAT = create(key("oak_chest_boat"));

    /**
     * {@code minecraft:oak_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OAK_DOOR = create(key("oak_door"));

    /**
     * {@code minecraft:oak_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OAK_FENCE = create(key("oak_fence"));

    /**
     * {@code minecraft:oak_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OAK_FENCE_GATE = create(key("oak_fence_gate"));

    /**
     * {@code minecraft:oak_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OAK_HANGING_SIGN = create(key("oak_hanging_sign"));

    /**
     * {@code minecraft:oak_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OAK_LEAVES = create(key("oak_leaves"));

    /**
     * {@code minecraft:oak_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OAK_LOG = create(key("oak_log"));

    /**
     * {@code minecraft:oak_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OAK_PLANKS = create(key("oak_planks"));

    /**
     * {@code minecraft:oak_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OAK_PRESSURE_PLATE = create(key("oak_pressure_plate"));

    /**
     * {@code minecraft:oak_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OAK_SAPLING = create(key("oak_sapling"));

    /**
     * {@code minecraft:oak_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OAK_SIGN = create(key("oak_sign"));

    /**
     * {@code minecraft:oak_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OAK_SLAB = create(key("oak_slab"));

    /**
     * {@code minecraft:oak_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OAK_STAIRS = create(key("oak_stairs"));

    /**
     * {@code minecraft:oak_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OAK_TRAPDOOR = create(key("oak_trapdoor"));

    /**
     * {@code minecraft:oak_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OAK_WOOD = create(key("oak_wood"));

    /**
     * {@code minecraft:observer}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OBSERVER = create(key("observer"));

    /**
     * {@code minecraft:obsidian}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OBSIDIAN = create(key("obsidian"));

    /**
     * {@code minecraft:ocelot_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OCELOT_SPAWN_EGG = create(key("ocelot_spawn_egg"));

    /**
     * {@code minecraft:ochre_froglight}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OCHRE_FROGLIGHT = create(key("ochre_froglight"));

    /**
     * {@code minecraft:ominous_bottle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OMINOUS_BOTTLE = create(key("ominous_bottle"));

    /**
     * {@code minecraft:ominous_trial_key}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OMINOUS_TRIAL_KEY = create(key("ominous_trial_key"));

    /**
     * {@code minecraft:open_eyeblossom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OPEN_EYEBLOSSOM = create(key("open_eyeblossom"));

    /**
     * {@code minecraft:orange_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ORANGE_BANNER = create(key("orange_banner"));

    /**
     * {@code minecraft:orange_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ORANGE_BED = create(key("orange_bed"));

    /**
     * {@code minecraft:orange_bundle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ORANGE_BUNDLE = create(key("orange_bundle"));

    /**
     * {@code minecraft:orange_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ORANGE_CANDLE = create(key("orange_candle"));

    /**
     * {@code minecraft:orange_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ORANGE_CARPET = create(key("orange_carpet"));

    /**
     * {@code minecraft:orange_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ORANGE_CONCRETE = create(key("orange_concrete"));

    /**
     * {@code minecraft:orange_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ORANGE_CONCRETE_POWDER = create(key("orange_concrete_powder"));

    /**
     * {@code minecraft:orange_dye}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ORANGE_DYE = create(key("orange_dye"));

    /**
     * {@code minecraft:orange_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ORANGE_GLAZED_TERRACOTTA = create(key("orange_glazed_terracotta"));

    /**
     * {@code minecraft:orange_harness}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ORANGE_HARNESS = create(key("orange_harness"));

    /**
     * {@code minecraft:orange_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ORANGE_SHULKER_BOX = create(key("orange_shulker_box"));

    /**
     * {@code minecraft:orange_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ORANGE_STAINED_GLASS = create(key("orange_stained_glass"));

    /**
     * {@code minecraft:orange_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ORANGE_STAINED_GLASS_PANE = create(key("orange_stained_glass_pane"));

    /**
     * {@code minecraft:orange_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ORANGE_TERRACOTTA = create(key("orange_terracotta"));

    /**
     * {@code minecraft:orange_tulip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ORANGE_TULIP = create(key("orange_tulip"));

    /**
     * {@code minecraft:orange_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ORANGE_WOOL = create(key("orange_wool"));

    /**
     * {@code minecraft:oxeye_daisy}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OXEYE_DAISY = create(key("oxeye_daisy"));

    /**
     * {@code minecraft:oxidized_chiseled_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OXIDIZED_CHISELED_COPPER = create(key("oxidized_chiseled_copper"));

    /**
     * {@code minecraft:oxidized_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OXIDIZED_COPPER = create(key("oxidized_copper"));

    /**
     * {@code minecraft:oxidized_copper_bulb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OXIDIZED_COPPER_BULB = create(key("oxidized_copper_bulb"));

    /**
     * {@code minecraft:oxidized_copper_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OXIDIZED_COPPER_DOOR = create(key("oxidized_copper_door"));

    /**
     * {@code minecraft:oxidized_copper_grate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OXIDIZED_COPPER_GRATE = create(key("oxidized_copper_grate"));

    /**
     * {@code minecraft:oxidized_copper_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OXIDIZED_COPPER_TRAPDOOR = create(key("oxidized_copper_trapdoor"));

    /**
     * {@code minecraft:oxidized_cut_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OXIDIZED_CUT_COPPER = create(key("oxidized_cut_copper"));

    /**
     * {@code minecraft:oxidized_cut_copper_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OXIDIZED_CUT_COPPER_SLAB = create(key("oxidized_cut_copper_slab"));

    /**
     * {@code minecraft:oxidized_cut_copper_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> OXIDIZED_CUT_COPPER_STAIRS = create(key("oxidized_cut_copper_stairs"));

    /**
     * {@code minecraft:packed_ice}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PACKED_ICE = create(key("packed_ice"));

    /**
     * {@code minecraft:packed_mud}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PACKED_MUD = create(key("packed_mud"));

    /**
     * {@code minecraft:painting}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PAINTING = create(key("painting"));

    /**
     * {@code minecraft:pale_hanging_moss}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_HANGING_MOSS = create(key("pale_hanging_moss"));

    /**
     * {@code minecraft:pale_moss_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_MOSS_BLOCK = create(key("pale_moss_block"));

    /**
     * {@code minecraft:pale_moss_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_MOSS_CARPET = create(key("pale_moss_carpet"));

    /**
     * {@code minecraft:pale_oak_boat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_OAK_BOAT = create(key("pale_oak_boat"));

    /**
     * {@code minecraft:pale_oak_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_OAK_BUTTON = create(key("pale_oak_button"));

    /**
     * {@code minecraft:pale_oak_chest_boat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_OAK_CHEST_BOAT = create(key("pale_oak_chest_boat"));

    /**
     * {@code minecraft:pale_oak_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_OAK_DOOR = create(key("pale_oak_door"));

    /**
     * {@code minecraft:pale_oak_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_OAK_FENCE = create(key("pale_oak_fence"));

    /**
     * {@code minecraft:pale_oak_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_OAK_FENCE_GATE = create(key("pale_oak_fence_gate"));

    /**
     * {@code minecraft:pale_oak_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_OAK_HANGING_SIGN = create(key("pale_oak_hanging_sign"));

    /**
     * {@code minecraft:pale_oak_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_OAK_LEAVES = create(key("pale_oak_leaves"));

    /**
     * {@code minecraft:pale_oak_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_OAK_LOG = create(key("pale_oak_log"));

    /**
     * {@code minecraft:pale_oak_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_OAK_PLANKS = create(key("pale_oak_planks"));

    /**
     * {@code minecraft:pale_oak_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_OAK_PRESSURE_PLATE = create(key("pale_oak_pressure_plate"));

    /**
     * {@code minecraft:pale_oak_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_OAK_SAPLING = create(key("pale_oak_sapling"));

    /**
     * {@code minecraft:pale_oak_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_OAK_SIGN = create(key("pale_oak_sign"));

    /**
     * {@code minecraft:pale_oak_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_OAK_SLAB = create(key("pale_oak_slab"));

    /**
     * {@code minecraft:pale_oak_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_OAK_STAIRS = create(key("pale_oak_stairs"));

    /**
     * {@code minecraft:pale_oak_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_OAK_TRAPDOOR = create(key("pale_oak_trapdoor"));

    /**
     * {@code minecraft:pale_oak_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PALE_OAK_WOOD = create(key("pale_oak_wood"));

    /**
     * {@code minecraft:panda_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PANDA_SPAWN_EGG = create(key("panda_spawn_egg"));

    /**
     * {@code minecraft:paper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PAPER = create(key("paper"));

    /**
     * {@code minecraft:parrot_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PARROT_SPAWN_EGG = create(key("parrot_spawn_egg"));

    /**
     * {@code minecraft:pearlescent_froglight}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PEARLESCENT_FROGLIGHT = create(key("pearlescent_froglight"));

    /**
     * {@code minecraft:peony}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PEONY = create(key("peony"));

    /**
     * {@code minecraft:petrified_oak_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PETRIFIED_OAK_SLAB = create(key("petrified_oak_slab"));

    /**
     * {@code minecraft:phantom_membrane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PHANTOM_MEMBRANE = create(key("phantom_membrane"));

    /**
     * {@code minecraft:phantom_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PHANTOM_SPAWN_EGG = create(key("phantom_spawn_egg"));

    /**
     * {@code minecraft:pig_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PIG_SPAWN_EGG = create(key("pig_spawn_egg"));

    /**
     * {@code minecraft:piglin_banner_pattern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PIGLIN_BANNER_PATTERN = create(key("piglin_banner_pattern"));

    /**
     * {@code minecraft:piglin_brute_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PIGLIN_BRUTE_SPAWN_EGG = create(key("piglin_brute_spawn_egg"));

    /**
     * {@code minecraft:piglin_head}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PIGLIN_HEAD = create(key("piglin_head"));

    /**
     * {@code minecraft:piglin_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PIGLIN_SPAWN_EGG = create(key("piglin_spawn_egg"));

    /**
     * {@code minecraft:pillager_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PILLAGER_SPAWN_EGG = create(key("pillager_spawn_egg"));

    /**
     * {@code minecraft:pink_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PINK_BANNER = create(key("pink_banner"));

    /**
     * {@code minecraft:pink_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PINK_BED = create(key("pink_bed"));

    /**
     * {@code minecraft:pink_bundle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PINK_BUNDLE = create(key("pink_bundle"));

    /**
     * {@code minecraft:pink_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PINK_CANDLE = create(key("pink_candle"));

    /**
     * {@code minecraft:pink_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PINK_CARPET = create(key("pink_carpet"));

    /**
     * {@code minecraft:pink_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PINK_CONCRETE = create(key("pink_concrete"));

    /**
     * {@code minecraft:pink_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PINK_CONCRETE_POWDER = create(key("pink_concrete_powder"));

    /**
     * {@code minecraft:pink_dye}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PINK_DYE = create(key("pink_dye"));

    /**
     * {@code minecraft:pink_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PINK_GLAZED_TERRACOTTA = create(key("pink_glazed_terracotta"));

    /**
     * {@code minecraft:pink_harness}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PINK_HARNESS = create(key("pink_harness"));

    /**
     * {@code minecraft:pink_petals}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PINK_PETALS = create(key("pink_petals"));

    /**
     * {@code minecraft:pink_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PINK_SHULKER_BOX = create(key("pink_shulker_box"));

    /**
     * {@code minecraft:pink_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PINK_STAINED_GLASS = create(key("pink_stained_glass"));

    /**
     * {@code minecraft:pink_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PINK_STAINED_GLASS_PANE = create(key("pink_stained_glass_pane"));

    /**
     * {@code minecraft:pink_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PINK_TERRACOTTA = create(key("pink_terracotta"));

    /**
     * {@code minecraft:pink_tulip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PINK_TULIP = create(key("pink_tulip"));

    /**
     * {@code minecraft:pink_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PINK_WOOL = create(key("pink_wool"));

    /**
     * {@code minecraft:piston}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PISTON = create(key("piston"));

    /**
     * {@code minecraft:pitcher_plant}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PITCHER_PLANT = create(key("pitcher_plant"));

    /**
     * {@code minecraft:pitcher_pod}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PITCHER_POD = create(key("pitcher_pod"));

    /**
     * {@code minecraft:player_head}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PLAYER_HEAD = create(key("player_head"));

    /**
     * {@code minecraft:plenty_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PLENTY_POTTERY_SHERD = create(key("plenty_pottery_sherd"));

    /**
     * {@code minecraft:podzol}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PODZOL = create(key("podzol"));

    /**
     * {@code minecraft:pointed_dripstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POINTED_DRIPSTONE = create(key("pointed_dripstone"));

    /**
     * {@code minecraft:poisonous_potato}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POISONOUS_POTATO = create(key("poisonous_potato"));

    /**
     * {@code minecraft:polar_bear_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLAR_BEAR_SPAWN_EGG = create(key("polar_bear_spawn_egg"));

    /**
     * {@code minecraft:polished_andesite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_ANDESITE = create(key("polished_andesite"));

    /**
     * {@code minecraft:polished_andesite_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_ANDESITE_SLAB = create(key("polished_andesite_slab"));

    /**
     * {@code minecraft:polished_andesite_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_ANDESITE_STAIRS = create(key("polished_andesite_stairs"));

    /**
     * {@code minecraft:polished_basalt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_BASALT = create(key("polished_basalt"));

    /**
     * {@code minecraft:polished_blackstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_BLACKSTONE = create(key("polished_blackstone"));

    /**
     * {@code minecraft:polished_blackstone_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_BLACKSTONE_BRICK_SLAB = create(key("polished_blackstone_brick_slab"));

    /**
     * {@code minecraft:polished_blackstone_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_BLACKSTONE_BRICK_STAIRS = create(key("polished_blackstone_brick_stairs"));

    /**
     * {@code minecraft:polished_blackstone_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_BLACKSTONE_BRICK_WALL = create(key("polished_blackstone_brick_wall"));

    /**
     * {@code minecraft:polished_blackstone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_BLACKSTONE_BRICKS = create(key("polished_blackstone_bricks"));

    /**
     * {@code minecraft:polished_blackstone_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_BLACKSTONE_BUTTON = create(key("polished_blackstone_button"));

    /**
     * {@code minecraft:polished_blackstone_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_BLACKSTONE_PRESSURE_PLATE = create(key("polished_blackstone_pressure_plate"));

    /**
     * {@code minecraft:polished_blackstone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_BLACKSTONE_SLAB = create(key("polished_blackstone_slab"));

    /**
     * {@code minecraft:polished_blackstone_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_BLACKSTONE_STAIRS = create(key("polished_blackstone_stairs"));

    /**
     * {@code minecraft:polished_blackstone_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_BLACKSTONE_WALL = create(key("polished_blackstone_wall"));

    /**
     * {@code minecraft:polished_deepslate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_DEEPSLATE = create(key("polished_deepslate"));

    /**
     * {@code minecraft:polished_deepslate_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_DEEPSLATE_SLAB = create(key("polished_deepslate_slab"));

    /**
     * {@code minecraft:polished_deepslate_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_DEEPSLATE_STAIRS = create(key("polished_deepslate_stairs"));

    /**
     * {@code minecraft:polished_deepslate_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_DEEPSLATE_WALL = create(key("polished_deepslate_wall"));

    /**
     * {@code minecraft:polished_diorite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_DIORITE = create(key("polished_diorite"));

    /**
     * {@code minecraft:polished_diorite_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_DIORITE_SLAB = create(key("polished_diorite_slab"));

    /**
     * {@code minecraft:polished_diorite_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_DIORITE_STAIRS = create(key("polished_diorite_stairs"));

    /**
     * {@code minecraft:polished_granite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_GRANITE = create(key("polished_granite"));

    /**
     * {@code minecraft:polished_granite_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_GRANITE_SLAB = create(key("polished_granite_slab"));

    /**
     * {@code minecraft:polished_granite_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_GRANITE_STAIRS = create(key("polished_granite_stairs"));

    /**
     * {@code minecraft:polished_tuff}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_TUFF = create(key("polished_tuff"));

    /**
     * {@code minecraft:polished_tuff_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_TUFF_SLAB = create(key("polished_tuff_slab"));

    /**
     * {@code minecraft:polished_tuff_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_TUFF_STAIRS = create(key("polished_tuff_stairs"));

    /**
     * {@code minecraft:polished_tuff_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POLISHED_TUFF_WALL = create(key("polished_tuff_wall"));

    /**
     * {@code minecraft:popped_chorus_fruit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POPPED_CHORUS_FRUIT = create(key("popped_chorus_fruit"));

    /**
     * {@code minecraft:poppy}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POPPY = create(key("poppy"));

    /**
     * {@code minecraft:porkchop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PORKCHOP = create(key("porkchop"));

    /**
     * {@code minecraft:potato}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POTATO = create(key("potato"));

    /**
     * {@code minecraft:potion}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POTION = create(key("potion"));

    /**
     * {@code minecraft:powder_snow_bucket}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POWDER_SNOW_BUCKET = create(key("powder_snow_bucket"));

    /**
     * {@code minecraft:powered_rail}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> POWERED_RAIL = create(key("powered_rail"));

    /**
     * {@code minecraft:prismarine}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PRISMARINE = create(key("prismarine"));

    /**
     * {@code minecraft:prismarine_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PRISMARINE_BRICK_SLAB = create(key("prismarine_brick_slab"));

    /**
     * {@code minecraft:prismarine_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PRISMARINE_BRICK_STAIRS = create(key("prismarine_brick_stairs"));

    /**
     * {@code minecraft:prismarine_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PRISMARINE_BRICKS = create(key("prismarine_bricks"));

    /**
     * {@code minecraft:prismarine_crystals}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PRISMARINE_CRYSTALS = create(key("prismarine_crystals"));

    /**
     * {@code minecraft:prismarine_shard}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PRISMARINE_SHARD = create(key("prismarine_shard"));

    /**
     * {@code minecraft:prismarine_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PRISMARINE_SLAB = create(key("prismarine_slab"));

    /**
     * {@code minecraft:prismarine_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PRISMARINE_STAIRS = create(key("prismarine_stairs"));

    /**
     * {@code minecraft:prismarine_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PRISMARINE_WALL = create(key("prismarine_wall"));

    /**
     * {@code minecraft:prize_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PRIZE_POTTERY_SHERD = create(key("prize_pottery_sherd"));

    /**
     * {@code minecraft:pufferfish}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PUFFERFISH = create(key("pufferfish"));

    /**
     * {@code minecraft:pufferfish_bucket}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PUFFERFISH_BUCKET = create(key("pufferfish_bucket"));

    /**
     * {@code minecraft:pufferfish_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PUFFERFISH_SPAWN_EGG = create(key("pufferfish_spawn_egg"));

    /**
     * {@code minecraft:pumpkin}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PUMPKIN = create(key("pumpkin"));

    /**
     * {@code minecraft:pumpkin_pie}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PUMPKIN_PIE = create(key("pumpkin_pie"));

    /**
     * {@code minecraft:pumpkin_seeds}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PUMPKIN_SEEDS = create(key("pumpkin_seeds"));

    /**
     * {@code minecraft:purple_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PURPLE_BANNER = create(key("purple_banner"));

    /**
     * {@code minecraft:purple_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PURPLE_BED = create(key("purple_bed"));

    /**
     * {@code minecraft:purple_bundle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PURPLE_BUNDLE = create(key("purple_bundle"));

    /**
     * {@code minecraft:purple_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PURPLE_CANDLE = create(key("purple_candle"));

    /**
     * {@code minecraft:purple_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PURPLE_CARPET = create(key("purple_carpet"));

    /**
     * {@code minecraft:purple_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PURPLE_CONCRETE = create(key("purple_concrete"));

    /**
     * {@code minecraft:purple_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PURPLE_CONCRETE_POWDER = create(key("purple_concrete_powder"));

    /**
     * {@code minecraft:purple_dye}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PURPLE_DYE = create(key("purple_dye"));

    /**
     * {@code minecraft:purple_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PURPLE_GLAZED_TERRACOTTA = create(key("purple_glazed_terracotta"));

    /**
     * {@code minecraft:purple_harness}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PURPLE_HARNESS = create(key("purple_harness"));

    /**
     * {@code minecraft:purple_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PURPLE_SHULKER_BOX = create(key("purple_shulker_box"));

    /**
     * {@code minecraft:purple_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PURPLE_STAINED_GLASS = create(key("purple_stained_glass"));

    /**
     * {@code minecraft:purple_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PURPLE_STAINED_GLASS_PANE = create(key("purple_stained_glass_pane"));

    /**
     * {@code minecraft:purple_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PURPLE_TERRACOTTA = create(key("purple_terracotta"));

    /**
     * {@code minecraft:purple_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PURPLE_WOOL = create(key("purple_wool"));

    /**
     * {@code minecraft:purpur_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PURPUR_BLOCK = create(key("purpur_block"));

    /**
     * {@code minecraft:purpur_pillar}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PURPUR_PILLAR = create(key("purpur_pillar"));

    /**
     * {@code minecraft:purpur_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PURPUR_SLAB = create(key("purpur_slab"));

    /**
     * {@code minecraft:purpur_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> PURPUR_STAIRS = create(key("purpur_stairs"));

    /**
     * {@code minecraft:quartz}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> QUARTZ = create(key("quartz"));

    /**
     * {@code minecraft:quartz_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> QUARTZ_BLOCK = create(key("quartz_block"));

    /**
     * {@code minecraft:quartz_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> QUARTZ_BRICKS = create(key("quartz_bricks"));

    /**
     * {@code minecraft:quartz_pillar}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> QUARTZ_PILLAR = create(key("quartz_pillar"));

    /**
     * {@code minecraft:quartz_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> QUARTZ_SLAB = create(key("quartz_slab"));

    /**
     * {@code minecraft:quartz_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> QUARTZ_STAIRS = create(key("quartz_stairs"));

    /**
     * {@code minecraft:rabbit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RABBIT = create(key("rabbit"));

    /**
     * {@code minecraft:rabbit_foot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RABBIT_FOOT = create(key("rabbit_foot"));

    /**
     * {@code minecraft:rabbit_hide}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RABBIT_HIDE = create(key("rabbit_hide"));

    /**
     * {@code minecraft:rabbit_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RABBIT_SPAWN_EGG = create(key("rabbit_spawn_egg"));

    /**
     * {@code minecraft:rabbit_stew}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RABBIT_STEW = create(key("rabbit_stew"));

    /**
     * {@code minecraft:rail}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RAIL = create(key("rail"));

    /**
     * {@code minecraft:raiser_armor_trim_smithing_template}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RAISER_ARMOR_TRIM_SMITHING_TEMPLATE = create(key("raiser_armor_trim_smithing_template"));

    /**
     * {@code minecraft:ravager_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RAVAGER_SPAWN_EGG = create(key("ravager_spawn_egg"));

    /**
     * {@code minecraft:raw_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RAW_COPPER = create(key("raw_copper"));

    /**
     * {@code minecraft:raw_copper_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RAW_COPPER_BLOCK = create(key("raw_copper_block"));

    /**
     * {@code minecraft:raw_gold}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RAW_GOLD = create(key("raw_gold"));

    /**
     * {@code minecraft:raw_gold_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RAW_GOLD_BLOCK = create(key("raw_gold_block"));

    /**
     * {@code minecraft:raw_iron}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RAW_IRON = create(key("raw_iron"));

    /**
     * {@code minecraft:raw_iron_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RAW_IRON_BLOCK = create(key("raw_iron_block"));

    /**
     * {@code minecraft:recovery_compass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RECOVERY_COMPASS = create(key("recovery_compass"));

    /**
     * {@code minecraft:red_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_BANNER = create(key("red_banner"));

    /**
     * {@code minecraft:red_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_BED = create(key("red_bed"));

    /**
     * {@code minecraft:red_bundle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_BUNDLE = create(key("red_bundle"));

    /**
     * {@code minecraft:red_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_CANDLE = create(key("red_candle"));

    /**
     * {@code minecraft:red_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_CARPET = create(key("red_carpet"));

    /**
     * {@code minecraft:red_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_CONCRETE = create(key("red_concrete"));

    /**
     * {@code minecraft:red_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_CONCRETE_POWDER = create(key("red_concrete_powder"));

    /**
     * {@code minecraft:red_dye}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_DYE = create(key("red_dye"));

    /**
     * {@code minecraft:red_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_GLAZED_TERRACOTTA = create(key("red_glazed_terracotta"));

    /**
     * {@code minecraft:red_harness}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_HARNESS = create(key("red_harness"));

    /**
     * {@code minecraft:red_mushroom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_MUSHROOM = create(key("red_mushroom"));

    /**
     * {@code minecraft:red_mushroom_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_MUSHROOM_BLOCK = create(key("red_mushroom_block"));

    /**
     * {@code minecraft:red_nether_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_NETHER_BRICK_SLAB = create(key("red_nether_brick_slab"));

    /**
     * {@code minecraft:red_nether_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_NETHER_BRICK_STAIRS = create(key("red_nether_brick_stairs"));

    /**
     * {@code minecraft:red_nether_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_NETHER_BRICK_WALL = create(key("red_nether_brick_wall"));

    /**
     * {@code minecraft:red_nether_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_NETHER_BRICKS = create(key("red_nether_bricks"));

    /**
     * {@code minecraft:red_sand}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_SAND = create(key("red_sand"));

    /**
     * {@code minecraft:red_sandstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_SANDSTONE = create(key("red_sandstone"));

    /**
     * {@code minecraft:red_sandstone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_SANDSTONE_SLAB = create(key("red_sandstone_slab"));

    /**
     * {@code minecraft:red_sandstone_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_SANDSTONE_STAIRS = create(key("red_sandstone_stairs"));

    /**
     * {@code minecraft:red_sandstone_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_SANDSTONE_WALL = create(key("red_sandstone_wall"));

    /**
     * {@code minecraft:red_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_SHULKER_BOX = create(key("red_shulker_box"));

    /**
     * {@code minecraft:red_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_STAINED_GLASS = create(key("red_stained_glass"));

    /**
     * {@code minecraft:red_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_STAINED_GLASS_PANE = create(key("red_stained_glass_pane"));

    /**
     * {@code minecraft:red_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_TERRACOTTA = create(key("red_terracotta"));

    /**
     * {@code minecraft:red_tulip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_TULIP = create(key("red_tulip"));

    /**
     * {@code minecraft:red_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RED_WOOL = create(key("red_wool"));

    /**
     * {@code minecraft:redstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> REDSTONE = create(key("redstone"));

    /**
     * {@code minecraft:redstone_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> REDSTONE_BLOCK = create(key("redstone_block"));

    /**
     * {@code minecraft:redstone_lamp}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> REDSTONE_LAMP = create(key("redstone_lamp"));

    /**
     * {@code minecraft:redstone_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> REDSTONE_ORE = create(key("redstone_ore"));

    /**
     * {@code minecraft:redstone_torch}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> REDSTONE_TORCH = create(key("redstone_torch"));

    /**
     * {@code minecraft:reinforced_deepslate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> REINFORCED_DEEPSLATE = create(key("reinforced_deepslate"));

    /**
     * {@code minecraft:repeater}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> REPEATER = create(key("repeater"));

    /**
     * {@code minecraft:repeating_command_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> REPEATING_COMMAND_BLOCK = create(key("repeating_command_block"));

    /**
     * {@code minecraft:resin_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RESIN_BLOCK = create(key("resin_block"));

    /**
     * {@code minecraft:resin_brick}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RESIN_BRICK = create(key("resin_brick"));

    /**
     * {@code minecraft:resin_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RESIN_BRICK_SLAB = create(key("resin_brick_slab"));

    /**
     * {@code minecraft:resin_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RESIN_BRICK_STAIRS = create(key("resin_brick_stairs"));

    /**
     * {@code minecraft:resin_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RESIN_BRICK_WALL = create(key("resin_brick_wall"));

    /**
     * {@code minecraft:resin_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RESIN_BRICKS = create(key("resin_bricks"));

    /**
     * {@code minecraft:resin_clump}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RESIN_CLUMP = create(key("resin_clump"));

    /**
     * {@code minecraft:respawn_anchor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RESPAWN_ANCHOR = create(key("respawn_anchor"));

    /**
     * {@code minecraft:rib_armor_trim_smithing_template}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> RIB_ARMOR_TRIM_SMITHING_TEMPLATE = create(key("rib_armor_trim_smithing_template"));

    /**
     * {@code minecraft:rooted_dirt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ROOTED_DIRT = create(key("rooted_dirt"));

    /**
     * {@code minecraft:rose_bush}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ROSE_BUSH = create(key("rose_bush"));

    /**
     * {@code minecraft:rotten_flesh}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ROTTEN_FLESH = create(key("rotten_flesh"));

    /**
     * {@code minecraft:saddle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SADDLE = create(key("saddle"));

    /**
     * {@code minecraft:salmon}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SALMON = create(key("salmon"));

    /**
     * {@code minecraft:salmon_bucket}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SALMON_BUCKET = create(key("salmon_bucket"));

    /**
     * {@code minecraft:salmon_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SALMON_SPAWN_EGG = create(key("salmon_spawn_egg"));

    /**
     * {@code minecraft:sand}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SAND = create(key("sand"));

    /**
     * {@code minecraft:sandstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SANDSTONE = create(key("sandstone"));

    /**
     * {@code minecraft:sandstone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SANDSTONE_SLAB = create(key("sandstone_slab"));

    /**
     * {@code minecraft:sandstone_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SANDSTONE_STAIRS = create(key("sandstone_stairs"));

    /**
     * {@code minecraft:sandstone_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SANDSTONE_WALL = create(key("sandstone_wall"));

    /**
     * {@code minecraft:scaffolding}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SCAFFOLDING = create(key("scaffolding"));

    /**
     * {@code minecraft:scrape_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SCRAPE_POTTERY_SHERD = create(key("scrape_pottery_sherd"));

    /**
     * {@code minecraft:sculk}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SCULK = create(key("sculk"));

    /**
     * {@code minecraft:sculk_catalyst}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SCULK_CATALYST = create(key("sculk_catalyst"));

    /**
     * {@code minecraft:sculk_sensor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SCULK_SENSOR = create(key("sculk_sensor"));

    /**
     * {@code minecraft:sculk_shrieker}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SCULK_SHRIEKER = create(key("sculk_shrieker"));

    /**
     * {@code minecraft:sculk_vein}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SCULK_VEIN = create(key("sculk_vein"));

    /**
     * {@code minecraft:sea_lantern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SEA_LANTERN = create(key("sea_lantern"));

    /**
     * {@code minecraft:sea_pickle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SEA_PICKLE = create(key("sea_pickle"));

    /**
     * {@code minecraft:seagrass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SEAGRASS = create(key("seagrass"));

    /**
     * {@code minecraft:sentry_armor_trim_smithing_template}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE = create(key("sentry_armor_trim_smithing_template"));

    /**
     * {@code minecraft:shaper_armor_trim_smithing_template}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE = create(key("shaper_armor_trim_smithing_template"));

    /**
     * {@code minecraft:sheaf_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SHEAF_POTTERY_SHERD = create(key("sheaf_pottery_sherd"));

    /**
     * {@code minecraft:shears}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SHEARS = create(key("shears"));

    /**
     * {@code minecraft:sheep_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SHEEP_SPAWN_EGG = create(key("sheep_spawn_egg"));

    /**
     * {@code minecraft:shelter_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SHELTER_POTTERY_SHERD = create(key("shelter_pottery_sherd"));

    /**
     * {@code minecraft:shield}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SHIELD = create(key("shield"));

    /**
     * {@code minecraft:short_dry_grass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SHORT_DRY_GRASS = create(key("short_dry_grass"));

    /**
     * {@code minecraft:short_grass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SHORT_GRASS = create(key("short_grass"));

    /**
     * {@code minecraft:shroomlight}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SHROOMLIGHT = create(key("shroomlight"));

    /**
     * {@code minecraft:shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SHULKER_BOX = create(key("shulker_box"));

    /**
     * {@code minecraft:shulker_shell}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SHULKER_SHELL = create(key("shulker_shell"));

    /**
     * {@code minecraft:shulker_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SHULKER_SPAWN_EGG = create(key("shulker_spawn_egg"));

    /**
     * {@code minecraft:silence_armor_trim_smithing_template}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE = create(key("silence_armor_trim_smithing_template"));

    /**
     * {@code minecraft:silverfish_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SILVERFISH_SPAWN_EGG = create(key("silverfish_spawn_egg"));

    /**
     * {@code minecraft:skeleton_horse_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SKELETON_HORSE_SPAWN_EGG = create(key("skeleton_horse_spawn_egg"));

    /**
     * {@code minecraft:skeleton_skull}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SKELETON_SKULL = create(key("skeleton_skull"));

    /**
     * {@code minecraft:skeleton_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SKELETON_SPAWN_EGG = create(key("skeleton_spawn_egg"));

    /**
     * {@code minecraft:skull_banner_pattern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SKULL_BANNER_PATTERN = create(key("skull_banner_pattern"));

    /**
     * {@code minecraft:skull_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SKULL_POTTERY_SHERD = create(key("skull_pottery_sherd"));

    /**
     * {@code minecraft:slime_ball}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SLIME_BALL = create(key("slime_ball"));

    /**
     * {@code minecraft:slime_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SLIME_BLOCK = create(key("slime_block"));

    /**
     * {@code minecraft:slime_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SLIME_SPAWN_EGG = create(key("slime_spawn_egg"));

    /**
     * {@code minecraft:small_amethyst_bud}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SMALL_AMETHYST_BUD = create(key("small_amethyst_bud"));

    /**
     * {@code minecraft:small_dripleaf}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SMALL_DRIPLEAF = create(key("small_dripleaf"));

    /**
     * {@code minecraft:smithing_table}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SMITHING_TABLE = create(key("smithing_table"));

    /**
     * {@code minecraft:smoker}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SMOKER = create(key("smoker"));

    /**
     * {@code minecraft:smooth_basalt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SMOOTH_BASALT = create(key("smooth_basalt"));

    /**
     * {@code minecraft:smooth_quartz}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SMOOTH_QUARTZ = create(key("smooth_quartz"));

    /**
     * {@code minecraft:smooth_quartz_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SMOOTH_QUARTZ_SLAB = create(key("smooth_quartz_slab"));

    /**
     * {@code minecraft:smooth_quartz_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SMOOTH_QUARTZ_STAIRS = create(key("smooth_quartz_stairs"));

    /**
     * {@code minecraft:smooth_red_sandstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SMOOTH_RED_SANDSTONE = create(key("smooth_red_sandstone"));

    /**
     * {@code minecraft:smooth_red_sandstone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SMOOTH_RED_SANDSTONE_SLAB = create(key("smooth_red_sandstone_slab"));

    /**
     * {@code minecraft:smooth_red_sandstone_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SMOOTH_RED_SANDSTONE_STAIRS = create(key("smooth_red_sandstone_stairs"));

    /**
     * {@code minecraft:smooth_sandstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SMOOTH_SANDSTONE = create(key("smooth_sandstone"));

    /**
     * {@code minecraft:smooth_sandstone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SMOOTH_SANDSTONE_SLAB = create(key("smooth_sandstone_slab"));

    /**
     * {@code minecraft:smooth_sandstone_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SMOOTH_SANDSTONE_STAIRS = create(key("smooth_sandstone_stairs"));

    /**
     * {@code minecraft:smooth_stone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SMOOTH_STONE = create(key("smooth_stone"));

    /**
     * {@code minecraft:smooth_stone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SMOOTH_STONE_SLAB = create(key("smooth_stone_slab"));

    /**
     * {@code minecraft:sniffer_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SNIFFER_EGG = create(key("sniffer_egg"));

    /**
     * {@code minecraft:sniffer_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SNIFFER_SPAWN_EGG = create(key("sniffer_spawn_egg"));

    /**
     * {@code minecraft:snort_pottery_sherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SNORT_POTTERY_SHERD = create(key("snort_pottery_sherd"));

    /**
     * {@code minecraft:snout_armor_trim_smithing_template}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE = create(key("snout_armor_trim_smithing_template"));

    /**
     * {@code minecraft:snow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SNOW = create(key("snow"));

    /**
     * {@code minecraft:snow_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SNOW_BLOCK = create(key("snow_block"));

    /**
     * {@code minecraft:snow_golem_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SNOW_GOLEM_SPAWN_EGG = create(key("snow_golem_spawn_egg"));

    /**
     * {@code minecraft:snowball}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SNOWBALL = create(key("snowball"));

    /**
     * {@code minecraft:soul_campfire}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SOUL_CAMPFIRE = create(key("soul_campfire"));

    /**
     * {@code minecraft:soul_lantern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SOUL_LANTERN = create(key("soul_lantern"));

    /**
     * {@code minecraft:soul_sand}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SOUL_SAND = create(key("soul_sand"));

    /**
     * {@code minecraft:soul_soil}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SOUL_SOIL = create(key("soul_soil"));

    /**
     * {@code minecraft:soul_torch}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SOUL_TORCH = create(key("soul_torch"));

    /**
     * {@code minecraft:spawner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPAWNER = create(key("spawner"));

    /**
     * {@code minecraft:spectral_arrow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPECTRAL_ARROW = create(key("spectral_arrow"));

    /**
     * {@code minecraft:spider_eye}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPIDER_EYE = create(key("spider_eye"));

    /**
     * {@code minecraft:spider_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPIDER_SPAWN_EGG = create(key("spider_spawn_egg"));

    /**
     * {@code minecraft:spire_armor_trim_smithing_template}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE = create(key("spire_armor_trim_smithing_template"));

    /**
     * {@code minecraft:splash_potion}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPLASH_POTION = create(key("splash_potion"));

    /**
     * {@code minecraft:sponge}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPONGE = create(key("sponge"));

    /**
     * {@code minecraft:spore_blossom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPORE_BLOSSOM = create(key("spore_blossom"));

    /**
     * {@code minecraft:spruce_boat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPRUCE_BOAT = create(key("spruce_boat"));

    /**
     * {@code minecraft:spruce_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPRUCE_BUTTON = create(key("spruce_button"));

    /**
     * {@code minecraft:spruce_chest_boat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPRUCE_CHEST_BOAT = create(key("spruce_chest_boat"));

    /**
     * {@code minecraft:spruce_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPRUCE_DOOR = create(key("spruce_door"));

    /**
     * {@code minecraft:spruce_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPRUCE_FENCE = create(key("spruce_fence"));

    /**
     * {@code minecraft:spruce_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPRUCE_FENCE_GATE = create(key("spruce_fence_gate"));

    /**
     * {@code minecraft:spruce_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPRUCE_HANGING_SIGN = create(key("spruce_hanging_sign"));

    /**
     * {@code minecraft:spruce_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPRUCE_LEAVES = create(key("spruce_leaves"));

    /**
     * {@code minecraft:spruce_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPRUCE_LOG = create(key("spruce_log"));

    /**
     * {@code minecraft:spruce_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPRUCE_PLANKS = create(key("spruce_planks"));

    /**
     * {@code minecraft:spruce_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPRUCE_PRESSURE_PLATE = create(key("spruce_pressure_plate"));

    /**
     * {@code minecraft:spruce_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPRUCE_SAPLING = create(key("spruce_sapling"));

    /**
     * {@code minecraft:spruce_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPRUCE_SIGN = create(key("spruce_sign"));

    /**
     * {@code minecraft:spruce_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPRUCE_SLAB = create(key("spruce_slab"));

    /**
     * {@code minecraft:spruce_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPRUCE_STAIRS = create(key("spruce_stairs"));

    /**
     * {@code minecraft:spruce_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPRUCE_TRAPDOOR = create(key("spruce_trapdoor"));

    /**
     * {@code minecraft:spruce_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPRUCE_WOOD = create(key("spruce_wood"));

    /**
     * {@code minecraft:spyglass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SPYGLASS = create(key("spyglass"));

    /**
     * {@code minecraft:squid_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SQUID_SPAWN_EGG = create(key("squid_spawn_egg"));

    /**
     * {@code minecraft:stick}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STICK = create(key("stick"));

    /**
     * {@code minecraft:sticky_piston}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STICKY_PISTON = create(key("sticky_piston"));

    /**
     * {@code minecraft:stone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STONE = create(key("stone"));

    /**
     * {@code minecraft:stone_axe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STONE_AXE = create(key("stone_axe"));

    /**
     * {@code minecraft:stone_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STONE_BRICK_SLAB = create(key("stone_brick_slab"));

    /**
     * {@code minecraft:stone_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STONE_BRICK_STAIRS = create(key("stone_brick_stairs"));

    /**
     * {@code minecraft:stone_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STONE_BRICK_WALL = create(key("stone_brick_wall"));

    /**
     * {@code minecraft:stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STONE_BRICKS = create(key("stone_bricks"));

    /**
     * {@code minecraft:stone_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STONE_BUTTON = create(key("stone_button"));

    /**
     * {@code minecraft:stone_hoe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STONE_HOE = create(key("stone_hoe"));

    /**
     * {@code minecraft:stone_pickaxe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STONE_PICKAXE = create(key("stone_pickaxe"));

    /**
     * {@code minecraft:stone_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STONE_PRESSURE_PLATE = create(key("stone_pressure_plate"));

    /**
     * {@code minecraft:stone_shovel}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STONE_SHOVEL = create(key("stone_shovel"));

    /**
     * {@code minecraft:stone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STONE_SLAB = create(key("stone_slab"));

    /**
     * {@code minecraft:stone_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STONE_STAIRS = create(key("stone_stairs"));

    /**
     * {@code minecraft:stone_sword}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STONE_SWORD = create(key("stone_sword"));

    /**
     * {@code minecraft:stonecutter}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STONECUTTER = create(key("stonecutter"));

    /**
     * {@code minecraft:stray_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRAY_SPAWN_EGG = create(key("stray_spawn_egg"));

    /**
     * {@code minecraft:strider_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIDER_SPAWN_EGG = create(key("strider_spawn_egg"));

    /**
     * {@code minecraft:string}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRING = create(key("string"));

    /**
     * {@code minecraft:stripped_acacia_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_ACACIA_LOG = create(key("stripped_acacia_log"));

    /**
     * {@code minecraft:stripped_acacia_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_ACACIA_WOOD = create(key("stripped_acacia_wood"));

    /**
     * {@code minecraft:stripped_bamboo_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_BAMBOO_BLOCK = create(key("stripped_bamboo_block"));

    /**
     * {@code minecraft:stripped_birch_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_BIRCH_LOG = create(key("stripped_birch_log"));

    /**
     * {@code minecraft:stripped_birch_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_BIRCH_WOOD = create(key("stripped_birch_wood"));

    /**
     * {@code minecraft:stripped_cherry_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_CHERRY_LOG = create(key("stripped_cherry_log"));

    /**
     * {@code minecraft:stripped_cherry_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_CHERRY_WOOD = create(key("stripped_cherry_wood"));

    /**
     * {@code minecraft:stripped_crimson_hyphae}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_CRIMSON_HYPHAE = create(key("stripped_crimson_hyphae"));

    /**
     * {@code minecraft:stripped_crimson_stem}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_CRIMSON_STEM = create(key("stripped_crimson_stem"));

    /**
     * {@code minecraft:stripped_dark_oak_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_DARK_OAK_LOG = create(key("stripped_dark_oak_log"));

    /**
     * {@code minecraft:stripped_dark_oak_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_DARK_OAK_WOOD = create(key("stripped_dark_oak_wood"));

    /**
     * {@code minecraft:stripped_jungle_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_JUNGLE_LOG = create(key("stripped_jungle_log"));

    /**
     * {@code minecraft:stripped_jungle_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_JUNGLE_WOOD = create(key("stripped_jungle_wood"));

    /**
     * {@code minecraft:stripped_mangrove_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_MANGROVE_LOG = create(key("stripped_mangrove_log"));

    /**
     * {@code minecraft:stripped_mangrove_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_MANGROVE_WOOD = create(key("stripped_mangrove_wood"));

    /**
     * {@code minecraft:stripped_oak_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_OAK_LOG = create(key("stripped_oak_log"));

    /**
     * {@code minecraft:stripped_oak_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_OAK_WOOD = create(key("stripped_oak_wood"));

    /**
     * {@code minecraft:stripped_pale_oak_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_PALE_OAK_LOG = create(key("stripped_pale_oak_log"));

    /**
     * {@code minecraft:stripped_pale_oak_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_PALE_OAK_WOOD = create(key("stripped_pale_oak_wood"));

    /**
     * {@code minecraft:stripped_spruce_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_SPRUCE_LOG = create(key("stripped_spruce_log"));

    /**
     * {@code minecraft:stripped_spruce_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_SPRUCE_WOOD = create(key("stripped_spruce_wood"));

    /**
     * {@code minecraft:stripped_warped_hyphae}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_WARPED_HYPHAE = create(key("stripped_warped_hyphae"));

    /**
     * {@code minecraft:stripped_warped_stem}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRIPPED_WARPED_STEM = create(key("stripped_warped_stem"));

    /**
     * {@code minecraft:structure_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRUCTURE_BLOCK = create(key("structure_block"));

    /**
     * {@code minecraft:structure_void}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> STRUCTURE_VOID = create(key("structure_void"));

    /**
     * {@code minecraft:sugar}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SUGAR = create(key("sugar"));

    /**
     * {@code minecraft:sugar_cane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SUGAR_CANE = create(key("sugar_cane"));

    /**
     * {@code minecraft:sunflower}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SUNFLOWER = create(key("sunflower"));

    /**
     * {@code minecraft:suspicious_gravel}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SUSPICIOUS_GRAVEL = create(key("suspicious_gravel"));

    /**
     * {@code minecraft:suspicious_sand}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SUSPICIOUS_SAND = create(key("suspicious_sand"));

    /**
     * {@code minecraft:suspicious_stew}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SUSPICIOUS_STEW = create(key("suspicious_stew"));

    /**
     * {@code minecraft:sweet_berries}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> SWEET_BERRIES = create(key("sweet_berries"));

    /**
     * {@code minecraft:tadpole_bucket}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TADPOLE_BUCKET = create(key("tadpole_bucket"));

    /**
     * {@code minecraft:tadpole_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TADPOLE_SPAWN_EGG = create(key("tadpole_spawn_egg"));

    /**
     * {@code minecraft:tall_dry_grass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TALL_DRY_GRASS = create(key("tall_dry_grass"));

    /**
     * {@code minecraft:tall_grass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TALL_GRASS = create(key("tall_grass"));

    /**
     * {@code minecraft:target}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TARGET = create(key("target"));

    /**
     * {@code minecraft:terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TERRACOTTA = create(key("terracotta"));

    /**
     * {@code minecraft:test_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TEST_BLOCK = create(key("test_block"));

    /**
     * {@code minecraft:test_instance_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TEST_INSTANCE_BLOCK = create(key("test_instance_block"));

    /**
     * {@code minecraft:tide_armor_trim_smithing_template}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TIDE_ARMOR_TRIM_SMITHING_TEMPLATE = create(key("tide_armor_trim_smithing_template"));

    /**
     * {@code minecraft:tinted_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TINTED_GLASS = create(key("tinted_glass"));

    /**
     * {@code minecraft:tipped_arrow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TIPPED_ARROW = create(key("tipped_arrow"));

    /**
     * {@code minecraft:tnt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TNT = create(key("tnt"));

    /**
     * {@code minecraft:tnt_minecart}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TNT_MINECART = create(key("tnt_minecart"));

    /**
     * {@code minecraft:torch}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TORCH = create(key("torch"));

    /**
     * {@code minecraft:torchflower}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TORCHFLOWER = create(key("torchflower"));

    /**
     * {@code minecraft:torchflower_seeds}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TORCHFLOWER_SEEDS = create(key("torchflower_seeds"));

    /**
     * {@code minecraft:totem_of_undying}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TOTEM_OF_UNDYING = create(key("totem_of_undying"));

    /**
     * {@code minecraft:trader_llama_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TRADER_LLAMA_SPAWN_EGG = create(key("trader_llama_spawn_egg"));

    /**
     * {@code minecraft:trapped_chest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TRAPPED_CHEST = create(key("trapped_chest"));

    /**
     * {@code minecraft:trial_key}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TRIAL_KEY = create(key("trial_key"));

    /**
     * {@code minecraft:trial_spawner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TRIAL_SPAWNER = create(key("trial_spawner"));

    /**
     * {@code minecraft:trident}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TRIDENT = create(key("trident"));

    /**
     * {@code minecraft:tripwire_hook}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TRIPWIRE_HOOK = create(key("tripwire_hook"));

    /**
     * {@code minecraft:tropical_fish}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TROPICAL_FISH = create(key("tropical_fish"));

    /**
     * {@code minecraft:tropical_fish_bucket}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TROPICAL_FISH_BUCKET = create(key("tropical_fish_bucket"));

    /**
     * {@code minecraft:tropical_fish_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TROPICAL_FISH_SPAWN_EGG = create(key("tropical_fish_spawn_egg"));

    /**
     * {@code minecraft:tube_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TUBE_CORAL = create(key("tube_coral"));

    /**
     * {@code minecraft:tube_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TUBE_CORAL_BLOCK = create(key("tube_coral_block"));

    /**
     * {@code minecraft:tube_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TUBE_CORAL_FAN = create(key("tube_coral_fan"));

    /**
     * {@code minecraft:tuff}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TUFF = create(key("tuff"));

    /**
     * {@code minecraft:tuff_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TUFF_BRICK_SLAB = create(key("tuff_brick_slab"));

    /**
     * {@code minecraft:tuff_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TUFF_BRICK_STAIRS = create(key("tuff_brick_stairs"));

    /**
     * {@code minecraft:tuff_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TUFF_BRICK_WALL = create(key("tuff_brick_wall"));

    /**
     * {@code minecraft:tuff_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TUFF_BRICKS = create(key("tuff_bricks"));

    /**
     * {@code minecraft:tuff_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TUFF_SLAB = create(key("tuff_slab"));

    /**
     * {@code minecraft:tuff_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TUFF_STAIRS = create(key("tuff_stairs"));

    /**
     * {@code minecraft:tuff_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TUFF_WALL = create(key("tuff_wall"));

    /**
     * {@code minecraft:turtle_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TURTLE_EGG = create(key("turtle_egg"));

    /**
     * {@code minecraft:turtle_helmet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TURTLE_HELMET = create(key("turtle_helmet"));

    /**
     * {@code minecraft:turtle_scute}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TURTLE_SCUTE = create(key("turtle_scute"));

    /**
     * {@code minecraft:turtle_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TURTLE_SPAWN_EGG = create(key("turtle_spawn_egg"));

    /**
     * {@code minecraft:twisting_vines}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> TWISTING_VINES = create(key("twisting_vines"));

    /**
     * {@code minecraft:vault}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> VAULT = create(key("vault"));

    /**
     * {@code minecraft:verdant_froglight}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> VERDANT_FROGLIGHT = create(key("verdant_froglight"));

    /**
     * {@code minecraft:vex_armor_trim_smithing_template}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> VEX_ARMOR_TRIM_SMITHING_TEMPLATE = create(key("vex_armor_trim_smithing_template"));

    /**
     * {@code minecraft:vex_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> VEX_SPAWN_EGG = create(key("vex_spawn_egg"));

    /**
     * {@code minecraft:villager_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> VILLAGER_SPAWN_EGG = create(key("villager_spawn_egg"));

    /**
     * {@code minecraft:vindicator_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> VINDICATOR_SPAWN_EGG = create(key("vindicator_spawn_egg"));

    /**
     * {@code minecraft:vine}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> VINE = create(key("vine"));

    /**
     * {@code minecraft:wandering_trader_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WANDERING_TRADER_SPAWN_EGG = create(key("wandering_trader_spawn_egg"));

    /**
     * {@code minecraft:ward_armor_trim_smithing_template}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARD_ARMOR_TRIM_SMITHING_TEMPLATE = create(key("ward_armor_trim_smithing_template"));

    /**
     * {@code minecraft:warden_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARDEN_SPAWN_EGG = create(key("warden_spawn_egg"));

    /**
     * {@code minecraft:warped_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARPED_BUTTON = create(key("warped_button"));

    /**
     * {@code minecraft:warped_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARPED_DOOR = create(key("warped_door"));

    /**
     * {@code minecraft:warped_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARPED_FENCE = create(key("warped_fence"));

    /**
     * {@code minecraft:warped_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARPED_FENCE_GATE = create(key("warped_fence_gate"));

    /**
     * {@code minecraft:warped_fungus}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARPED_FUNGUS = create(key("warped_fungus"));

    /**
     * {@code minecraft:warped_fungus_on_a_stick}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARPED_FUNGUS_ON_A_STICK = create(key("warped_fungus_on_a_stick"));

    /**
     * {@code minecraft:warped_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARPED_HANGING_SIGN = create(key("warped_hanging_sign"));

    /**
     * {@code minecraft:warped_hyphae}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARPED_HYPHAE = create(key("warped_hyphae"));

    /**
     * {@code minecraft:warped_nylium}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARPED_NYLIUM = create(key("warped_nylium"));

    /**
     * {@code minecraft:warped_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARPED_PLANKS = create(key("warped_planks"));

    /**
     * {@code minecraft:warped_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARPED_PRESSURE_PLATE = create(key("warped_pressure_plate"));

    /**
     * {@code minecraft:warped_roots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARPED_ROOTS = create(key("warped_roots"));

    /**
     * {@code minecraft:warped_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARPED_SIGN = create(key("warped_sign"));

    /**
     * {@code minecraft:warped_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARPED_SLAB = create(key("warped_slab"));

    /**
     * {@code minecraft:warped_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARPED_STAIRS = create(key("warped_stairs"));

    /**
     * {@code minecraft:warped_stem}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARPED_STEM = create(key("warped_stem"));

    /**
     * {@code minecraft:warped_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARPED_TRAPDOOR = create(key("warped_trapdoor"));

    /**
     * {@code minecraft:warped_wart_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WARPED_WART_BLOCK = create(key("warped_wart_block"));

    /**
     * {@code minecraft:water_bucket}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WATER_BUCKET = create(key("water_bucket"));

    /**
     * {@code minecraft:waxed_chiseled_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_CHISELED_COPPER = create(key("waxed_chiseled_copper"));

    /**
     * {@code minecraft:waxed_copper_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_COPPER_BLOCK = create(key("waxed_copper_block"));

    /**
     * {@code minecraft:waxed_copper_bulb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_COPPER_BULB = create(key("waxed_copper_bulb"));

    /**
     * {@code minecraft:waxed_copper_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_COPPER_DOOR = create(key("waxed_copper_door"));

    /**
     * {@code minecraft:waxed_copper_grate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_COPPER_GRATE = create(key("waxed_copper_grate"));

    /**
     * {@code minecraft:waxed_copper_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_COPPER_TRAPDOOR = create(key("waxed_copper_trapdoor"));

    /**
     * {@code minecraft:waxed_cut_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_CUT_COPPER = create(key("waxed_cut_copper"));

    /**
     * {@code minecraft:waxed_cut_copper_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_CUT_COPPER_SLAB = create(key("waxed_cut_copper_slab"));

    /**
     * {@code minecraft:waxed_cut_copper_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_CUT_COPPER_STAIRS = create(key("waxed_cut_copper_stairs"));

    /**
     * {@code minecraft:waxed_exposed_chiseled_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_EXPOSED_CHISELED_COPPER = create(key("waxed_exposed_chiseled_copper"));

    /**
     * {@code minecraft:waxed_exposed_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_EXPOSED_COPPER = create(key("waxed_exposed_copper"));

    /**
     * {@code minecraft:waxed_exposed_copper_bulb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_EXPOSED_COPPER_BULB = create(key("waxed_exposed_copper_bulb"));

    /**
     * {@code minecraft:waxed_exposed_copper_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_EXPOSED_COPPER_DOOR = create(key("waxed_exposed_copper_door"));

    /**
     * {@code minecraft:waxed_exposed_copper_grate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_EXPOSED_COPPER_GRATE = create(key("waxed_exposed_copper_grate"));

    /**
     * {@code minecraft:waxed_exposed_copper_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_EXPOSED_COPPER_TRAPDOOR = create(key("waxed_exposed_copper_trapdoor"));

    /**
     * {@code minecraft:waxed_exposed_cut_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_EXPOSED_CUT_COPPER = create(key("waxed_exposed_cut_copper"));

    /**
     * {@code minecraft:waxed_exposed_cut_copper_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_EXPOSED_CUT_COPPER_SLAB = create(key("waxed_exposed_cut_copper_slab"));

    /**
     * {@code minecraft:waxed_exposed_cut_copper_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_EXPOSED_CUT_COPPER_STAIRS = create(key("waxed_exposed_cut_copper_stairs"));

    /**
     * {@code minecraft:waxed_oxidized_chiseled_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_OXIDIZED_CHISELED_COPPER = create(key("waxed_oxidized_chiseled_copper"));

    /**
     * {@code minecraft:waxed_oxidized_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_OXIDIZED_COPPER = create(key("waxed_oxidized_copper"));

    /**
     * {@code minecraft:waxed_oxidized_copper_bulb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_OXIDIZED_COPPER_BULB = create(key("waxed_oxidized_copper_bulb"));

    /**
     * {@code minecraft:waxed_oxidized_copper_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_OXIDIZED_COPPER_DOOR = create(key("waxed_oxidized_copper_door"));

    /**
     * {@code minecraft:waxed_oxidized_copper_grate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_OXIDIZED_COPPER_GRATE = create(key("waxed_oxidized_copper_grate"));

    /**
     * {@code minecraft:waxed_oxidized_copper_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_OXIDIZED_COPPER_TRAPDOOR = create(key("waxed_oxidized_copper_trapdoor"));

    /**
     * {@code minecraft:waxed_oxidized_cut_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_OXIDIZED_CUT_COPPER = create(key("waxed_oxidized_cut_copper"));

    /**
     * {@code minecraft:waxed_oxidized_cut_copper_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_OXIDIZED_CUT_COPPER_SLAB = create(key("waxed_oxidized_cut_copper_slab"));

    /**
     * {@code minecraft:waxed_oxidized_cut_copper_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_OXIDIZED_CUT_COPPER_STAIRS = create(key("waxed_oxidized_cut_copper_stairs"));

    /**
     * {@code minecraft:waxed_weathered_chiseled_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_WEATHERED_CHISELED_COPPER = create(key("waxed_weathered_chiseled_copper"));

    /**
     * {@code minecraft:waxed_weathered_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_WEATHERED_COPPER = create(key("waxed_weathered_copper"));

    /**
     * {@code minecraft:waxed_weathered_copper_bulb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_WEATHERED_COPPER_BULB = create(key("waxed_weathered_copper_bulb"));

    /**
     * {@code minecraft:waxed_weathered_copper_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_WEATHERED_COPPER_DOOR = create(key("waxed_weathered_copper_door"));

    /**
     * {@code minecraft:waxed_weathered_copper_grate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_WEATHERED_COPPER_GRATE = create(key("waxed_weathered_copper_grate"));

    /**
     * {@code minecraft:waxed_weathered_copper_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_WEATHERED_COPPER_TRAPDOOR = create(key("waxed_weathered_copper_trapdoor"));

    /**
     * {@code minecraft:waxed_weathered_cut_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_WEATHERED_CUT_COPPER = create(key("waxed_weathered_cut_copper"));

    /**
     * {@code minecraft:waxed_weathered_cut_copper_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_WEATHERED_CUT_COPPER_SLAB = create(key("waxed_weathered_cut_copper_slab"));

    /**
     * {@code minecraft:waxed_weathered_cut_copper_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAXED_WEATHERED_CUT_COPPER_STAIRS = create(key("waxed_weathered_cut_copper_stairs"));

    /**
     * {@code minecraft:wayfinder_armor_trim_smithing_template}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE = create(key("wayfinder_armor_trim_smithing_template"));

    /**
     * {@code minecraft:weathered_chiseled_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WEATHERED_CHISELED_COPPER = create(key("weathered_chiseled_copper"));

    /**
     * {@code minecraft:weathered_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WEATHERED_COPPER = create(key("weathered_copper"));

    /**
     * {@code minecraft:weathered_copper_bulb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WEATHERED_COPPER_BULB = create(key("weathered_copper_bulb"));

    /**
     * {@code minecraft:weathered_copper_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WEATHERED_COPPER_DOOR = create(key("weathered_copper_door"));

    /**
     * {@code minecraft:weathered_copper_grate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WEATHERED_COPPER_GRATE = create(key("weathered_copper_grate"));

    /**
     * {@code minecraft:weathered_copper_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WEATHERED_COPPER_TRAPDOOR = create(key("weathered_copper_trapdoor"));

    /**
     * {@code minecraft:weathered_cut_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WEATHERED_CUT_COPPER = create(key("weathered_cut_copper"));

    /**
     * {@code minecraft:weathered_cut_copper_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WEATHERED_CUT_COPPER_SLAB = create(key("weathered_cut_copper_slab"));

    /**
     * {@code minecraft:weathered_cut_copper_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WEATHERED_CUT_COPPER_STAIRS = create(key("weathered_cut_copper_stairs"));

    /**
     * {@code minecraft:weeping_vines}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WEEPING_VINES = create(key("weeping_vines"));

    /**
     * {@code minecraft:wet_sponge}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WET_SPONGE = create(key("wet_sponge"));

    /**
     * {@code minecraft:wheat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WHEAT = create(key("wheat"));

    /**
     * {@code minecraft:wheat_seeds}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WHEAT_SEEDS = create(key("wheat_seeds"));

    /**
     * {@code minecraft:white_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WHITE_BANNER = create(key("white_banner"));

    /**
     * {@code minecraft:white_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WHITE_BED = create(key("white_bed"));

    /**
     * {@code minecraft:white_bundle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WHITE_BUNDLE = create(key("white_bundle"));

    /**
     * {@code minecraft:white_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WHITE_CANDLE = create(key("white_candle"));

    /**
     * {@code minecraft:white_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WHITE_CARPET = create(key("white_carpet"));

    /**
     * {@code minecraft:white_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WHITE_CONCRETE = create(key("white_concrete"));

    /**
     * {@code minecraft:white_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WHITE_CONCRETE_POWDER = create(key("white_concrete_powder"));

    /**
     * {@code minecraft:white_dye}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WHITE_DYE = create(key("white_dye"));

    /**
     * {@code minecraft:white_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WHITE_GLAZED_TERRACOTTA = create(key("white_glazed_terracotta"));

    /**
     * {@code minecraft:white_harness}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WHITE_HARNESS = create(key("white_harness"));

    /**
     * {@code minecraft:white_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WHITE_SHULKER_BOX = create(key("white_shulker_box"));

    /**
     * {@code minecraft:white_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WHITE_STAINED_GLASS = create(key("white_stained_glass"));

    /**
     * {@code minecraft:white_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WHITE_STAINED_GLASS_PANE = create(key("white_stained_glass_pane"));

    /**
     * {@code minecraft:white_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WHITE_TERRACOTTA = create(key("white_terracotta"));

    /**
     * {@code minecraft:white_tulip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WHITE_TULIP = create(key("white_tulip"));

    /**
     * {@code minecraft:white_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WHITE_WOOL = create(key("white_wool"));

    /**
     * {@code minecraft:wild_armor_trim_smithing_template}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WILD_ARMOR_TRIM_SMITHING_TEMPLATE = create(key("wild_armor_trim_smithing_template"));

    /**
     * {@code minecraft:wildflowers}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WILDFLOWERS = create(key("wildflowers"));

    /**
     * {@code minecraft:wind_charge}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WIND_CHARGE = create(key("wind_charge"));

    /**
     * {@code minecraft:witch_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WITCH_SPAWN_EGG = create(key("witch_spawn_egg"));

    /**
     * {@code minecraft:wither_rose}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WITHER_ROSE = create(key("wither_rose"));

    /**
     * {@code minecraft:wither_skeleton_skull}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WITHER_SKELETON_SKULL = create(key("wither_skeleton_skull"));

    /**
     * {@code minecraft:wither_skeleton_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WITHER_SKELETON_SPAWN_EGG = create(key("wither_skeleton_spawn_egg"));

    /**
     * {@code minecraft:wither_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WITHER_SPAWN_EGG = create(key("wither_spawn_egg"));

    /**
     * {@code minecraft:wolf_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WOLF_ARMOR = create(key("wolf_armor"));

    /**
     * {@code minecraft:wolf_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WOLF_SPAWN_EGG = create(key("wolf_spawn_egg"));

    /**
     * {@code minecraft:wooden_axe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WOODEN_AXE = create(key("wooden_axe"));

    /**
     * {@code minecraft:wooden_hoe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WOODEN_HOE = create(key("wooden_hoe"));

    /**
     * {@code minecraft:wooden_pickaxe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WOODEN_PICKAXE = create(key("wooden_pickaxe"));

    /**
     * {@code minecraft:wooden_shovel}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WOODEN_SHOVEL = create(key("wooden_shovel"));

    /**
     * {@code minecraft:wooden_sword}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WOODEN_SWORD = create(key("wooden_sword"));

    /**
     * {@code minecraft:writable_book}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WRITABLE_BOOK = create(key("writable_book"));

    /**
     * {@code minecraft:written_book}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> WRITTEN_BOOK = create(key("written_book"));

    /**
     * {@code minecraft:yellow_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> YELLOW_BANNER = create(key("yellow_banner"));

    /**
     * {@code minecraft:yellow_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> YELLOW_BED = create(key("yellow_bed"));

    /**
     * {@code minecraft:yellow_bundle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> YELLOW_BUNDLE = create(key("yellow_bundle"));

    /**
     * {@code minecraft:yellow_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> YELLOW_CANDLE = create(key("yellow_candle"));

    /**
     * {@code minecraft:yellow_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> YELLOW_CARPET = create(key("yellow_carpet"));

    /**
     * {@code minecraft:yellow_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> YELLOW_CONCRETE = create(key("yellow_concrete"));

    /**
     * {@code minecraft:yellow_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> YELLOW_CONCRETE_POWDER = create(key("yellow_concrete_powder"));

    /**
     * {@code minecraft:yellow_dye}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> YELLOW_DYE = create(key("yellow_dye"));

    /**
     * {@code minecraft:yellow_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> YELLOW_GLAZED_TERRACOTTA = create(key("yellow_glazed_terracotta"));

    /**
     * {@code minecraft:yellow_harness}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> YELLOW_HARNESS = create(key("yellow_harness"));

    /**
     * {@code minecraft:yellow_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> YELLOW_SHULKER_BOX = create(key("yellow_shulker_box"));

    /**
     * {@code minecraft:yellow_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> YELLOW_STAINED_GLASS = create(key("yellow_stained_glass"));

    /**
     * {@code minecraft:yellow_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> YELLOW_STAINED_GLASS_PANE = create(key("yellow_stained_glass_pane"));

    /**
     * {@code minecraft:yellow_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> YELLOW_TERRACOTTA = create(key("yellow_terracotta"));

    /**
     * {@code minecraft:yellow_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> YELLOW_WOOL = create(key("yellow_wool"));

    /**
     * {@code minecraft:zoglin_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ZOGLIN_SPAWN_EGG = create(key("zoglin_spawn_egg"));

    /**
     * {@code minecraft:zombie_head}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ZOMBIE_HEAD = create(key("zombie_head"));

    /**
     * {@code minecraft:zombie_horse_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ZOMBIE_HORSE_SPAWN_EGG = create(key("zombie_horse_spawn_egg"));

    /**
     * {@code minecraft:zombie_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ZOMBIE_SPAWN_EGG = create(key("zombie_spawn_egg"));

    /**
     * {@code minecraft:zombie_villager_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ZOMBIE_VILLAGER_SPAWN_EGG = create(key("zombie_villager_spawn_egg"));

    /**
     * {@code minecraft:zombified_piglin_spawn_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<ItemType> ZOMBIFIED_PIGLIN_SPAWN_EGG = create(key("zombified_piglin_spawn_egg"));

    private ItemTypeKeys() {
    }

    private static TypedKey<ItemType> create(final Key key) {
        return TypedKey.create(RegistryKey.ITEM, key);
    }
}
