package io.papermc.paper.registry.keys;

import static net.kyori.adventure.key.Key.key;

import io.papermc.paper.generated.GeneratedFrom;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import net.kyori.adventure.key.Key;
import org.bukkit.Sound;
import org.jspecify.annotations.NullMarked;

/**
 * Vanilla keys for {@link RegistryKey#SOUND_EVENT}.
 *
 * @apiNote The fields provided here are a direct representation of
 * what is available from the vanilla game source. They may be
 * changed (including removals) on any Minecraft version
 * bump, so cross-version compatibility is not provided on the
 * same level as it is on most of the other API.
 */
@SuppressWarnings({
        "unused",
        "SpellCheckingInspection"
})
@NullMarked
@GeneratedFrom("1.21.7")
public final class SoundEventKeys {
    /**
     * {@code minecraft:ambient.basalt_deltas.additions}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_BASALT_DELTAS_ADDITIONS = create(key("ambient.basalt_deltas.additions"));

    /**
     * {@code minecraft:ambient.basalt_deltas.loop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_BASALT_DELTAS_LOOP = create(key("ambient.basalt_deltas.loop"));

    /**
     * {@code minecraft:ambient.basalt_deltas.mood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_BASALT_DELTAS_MOOD = create(key("ambient.basalt_deltas.mood"));

    /**
     * {@code minecraft:ambient.cave}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_CAVE = create(key("ambient.cave"));

    /**
     * {@code minecraft:ambient.crimson_forest.additions}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_CRIMSON_FOREST_ADDITIONS = create(key("ambient.crimson_forest.additions"));

    /**
     * {@code minecraft:ambient.crimson_forest.loop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_CRIMSON_FOREST_LOOP = create(key("ambient.crimson_forest.loop"));

    /**
     * {@code minecraft:ambient.crimson_forest.mood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_CRIMSON_FOREST_MOOD = create(key("ambient.crimson_forest.mood"));

    /**
     * {@code minecraft:ambient.nether_wastes.additions}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_NETHER_WASTES_ADDITIONS = create(key("ambient.nether_wastes.additions"));

    /**
     * {@code minecraft:ambient.nether_wastes.loop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_NETHER_WASTES_LOOP = create(key("ambient.nether_wastes.loop"));

    /**
     * {@code minecraft:ambient.nether_wastes.mood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_NETHER_WASTES_MOOD = create(key("ambient.nether_wastes.mood"));

    /**
     * {@code minecraft:ambient.soul_sand_valley.additions}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_SOUL_SAND_VALLEY_ADDITIONS = create(key("ambient.soul_sand_valley.additions"));

    /**
     * {@code minecraft:ambient.soul_sand_valley.loop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_SOUL_SAND_VALLEY_LOOP = create(key("ambient.soul_sand_valley.loop"));

    /**
     * {@code minecraft:ambient.soul_sand_valley.mood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_SOUL_SAND_VALLEY_MOOD = create(key("ambient.soul_sand_valley.mood"));

    /**
     * {@code minecraft:ambient.underwater.enter}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_UNDERWATER_ENTER = create(key("ambient.underwater.enter"));

    /**
     * {@code minecraft:ambient.underwater.exit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_UNDERWATER_EXIT = create(key("ambient.underwater.exit"));

    /**
     * {@code minecraft:ambient.underwater.loop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_UNDERWATER_LOOP = create(key("ambient.underwater.loop"));

    /**
     * {@code minecraft:ambient.underwater.loop.additions}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_UNDERWATER_LOOP_ADDITIONS = create(key("ambient.underwater.loop.additions"));

    /**
     * {@code minecraft:ambient.underwater.loop.additions.rare}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_UNDERWATER_LOOP_ADDITIONS_RARE = create(key("ambient.underwater.loop.additions.rare"));

    /**
     * {@code minecraft:ambient.underwater.loop.additions.ultra_rare}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_UNDERWATER_LOOP_ADDITIONS_ULTRA_RARE = create(key("ambient.underwater.loop.additions.ultra_rare"));

    /**
     * {@code minecraft:ambient.warped_forest.additions}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_WARPED_FOREST_ADDITIONS = create(key("ambient.warped_forest.additions"));

    /**
     * {@code minecraft:ambient.warped_forest.loop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_WARPED_FOREST_LOOP = create(key("ambient.warped_forest.loop"));

    /**
     * {@code minecraft:ambient.warped_forest.mood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> AMBIENT_WARPED_FOREST_MOOD = create(key("ambient.warped_forest.mood"));

    /**
     * {@code minecraft:block.amethyst_block.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AMETHYST_BLOCK_BREAK = create(key("block.amethyst_block.break"));

    /**
     * {@code minecraft:block.amethyst_block.chime}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AMETHYST_BLOCK_CHIME = create(key("block.amethyst_block.chime"));

    /**
     * {@code minecraft:block.amethyst_block.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AMETHYST_BLOCK_FALL = create(key("block.amethyst_block.fall"));

    /**
     * {@code minecraft:block.amethyst_block.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AMETHYST_BLOCK_HIT = create(key("block.amethyst_block.hit"));

    /**
     * {@code minecraft:block.amethyst_block.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AMETHYST_BLOCK_PLACE = create(key("block.amethyst_block.place"));

    /**
     * {@code minecraft:block.amethyst_block.resonate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AMETHYST_BLOCK_RESONATE = create(key("block.amethyst_block.resonate"));

    /**
     * {@code minecraft:block.amethyst_block.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AMETHYST_BLOCK_STEP = create(key("block.amethyst_block.step"));

    /**
     * {@code minecraft:block.amethyst_cluster.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AMETHYST_CLUSTER_BREAK = create(key("block.amethyst_cluster.break"));

    /**
     * {@code minecraft:block.amethyst_cluster.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AMETHYST_CLUSTER_FALL = create(key("block.amethyst_cluster.fall"));

    /**
     * {@code minecraft:block.amethyst_cluster.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AMETHYST_CLUSTER_HIT = create(key("block.amethyst_cluster.hit"));

    /**
     * {@code minecraft:block.amethyst_cluster.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AMETHYST_CLUSTER_PLACE = create(key("block.amethyst_cluster.place"));

    /**
     * {@code minecraft:block.amethyst_cluster.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AMETHYST_CLUSTER_STEP = create(key("block.amethyst_cluster.step"));

    /**
     * {@code minecraft:block.ancient_debris.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ANCIENT_DEBRIS_BREAK = create(key("block.ancient_debris.break"));

    /**
     * {@code minecraft:block.ancient_debris.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ANCIENT_DEBRIS_FALL = create(key("block.ancient_debris.fall"));

    /**
     * {@code minecraft:block.ancient_debris.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ANCIENT_DEBRIS_HIT = create(key("block.ancient_debris.hit"));

    /**
     * {@code minecraft:block.ancient_debris.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ANCIENT_DEBRIS_PLACE = create(key("block.ancient_debris.place"));

    /**
     * {@code minecraft:block.ancient_debris.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ANCIENT_DEBRIS_STEP = create(key("block.ancient_debris.step"));

    /**
     * {@code minecraft:block.anvil.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ANVIL_BREAK = create(key("block.anvil.break"));

    /**
     * {@code minecraft:block.anvil.destroy}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ANVIL_DESTROY = create(key("block.anvil.destroy"));

    /**
     * {@code minecraft:block.anvil.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ANVIL_FALL = create(key("block.anvil.fall"));

    /**
     * {@code minecraft:block.anvil.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ANVIL_HIT = create(key("block.anvil.hit"));

    /**
     * {@code minecraft:block.anvil.land}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ANVIL_LAND = create(key("block.anvil.land"));

    /**
     * {@code minecraft:block.anvil.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ANVIL_PLACE = create(key("block.anvil.place"));

    /**
     * {@code minecraft:block.anvil.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ANVIL_STEP = create(key("block.anvil.step"));

    /**
     * {@code minecraft:block.anvil.use}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ANVIL_USE = create(key("block.anvil.use"));

    /**
     * {@code minecraft:block.azalea.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AZALEA_BREAK = create(key("block.azalea.break"));

    /**
     * {@code minecraft:block.azalea.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AZALEA_FALL = create(key("block.azalea.fall"));

    /**
     * {@code minecraft:block.azalea.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AZALEA_HIT = create(key("block.azalea.hit"));

    /**
     * {@code minecraft:block.azalea.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AZALEA_PLACE = create(key("block.azalea.place"));

    /**
     * {@code minecraft:block.azalea.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AZALEA_STEP = create(key("block.azalea.step"));

    /**
     * {@code minecraft:block.azalea_leaves.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AZALEA_LEAVES_BREAK = create(key("block.azalea_leaves.break"));

    /**
     * {@code minecraft:block.azalea_leaves.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AZALEA_LEAVES_FALL = create(key("block.azalea_leaves.fall"));

    /**
     * {@code minecraft:block.azalea_leaves.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AZALEA_LEAVES_HIT = create(key("block.azalea_leaves.hit"));

    /**
     * {@code minecraft:block.azalea_leaves.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AZALEA_LEAVES_PLACE = create(key("block.azalea_leaves.place"));

    /**
     * {@code minecraft:block.azalea_leaves.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_AZALEA_LEAVES_STEP = create(key("block.azalea_leaves.step"));

    /**
     * {@code minecraft:block.bamboo.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_BREAK = create(key("block.bamboo.break"));

    /**
     * {@code minecraft:block.bamboo.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_FALL = create(key("block.bamboo.fall"));

    /**
     * {@code minecraft:block.bamboo.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_HIT = create(key("block.bamboo.hit"));

    /**
     * {@code minecraft:block.bamboo.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_PLACE = create(key("block.bamboo.place"));

    /**
     * {@code minecraft:block.bamboo.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_STEP = create(key("block.bamboo.step"));

    /**
     * {@code minecraft:block.bamboo_sapling.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_SAPLING_BREAK = create(key("block.bamboo_sapling.break"));

    /**
     * {@code minecraft:block.bamboo_sapling.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_SAPLING_HIT = create(key("block.bamboo_sapling.hit"));

    /**
     * {@code minecraft:block.bamboo_sapling.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_SAPLING_PLACE = create(key("block.bamboo_sapling.place"));

    /**
     * {@code minecraft:block.bamboo_wood.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_BREAK = create(key("block.bamboo_wood.break"));

    /**
     * {@code minecraft:block.bamboo_wood.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_FALL = create(key("block.bamboo_wood.fall"));

    /**
     * {@code minecraft:block.bamboo_wood.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_HIT = create(key("block.bamboo_wood.hit"));

    /**
     * {@code minecraft:block.bamboo_wood.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_PLACE = create(key("block.bamboo_wood.place"));

    /**
     * {@code minecraft:block.bamboo_wood.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_STEP = create(key("block.bamboo_wood.step"));

    /**
     * {@code minecraft:block.bamboo_wood_button.click_off}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_BUTTON_CLICK_OFF = create(key("block.bamboo_wood_button.click_off"));

    /**
     * {@code minecraft:block.bamboo_wood_button.click_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_BUTTON_CLICK_ON = create(key("block.bamboo_wood_button.click_on"));

    /**
     * {@code minecraft:block.bamboo_wood_door.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_DOOR_CLOSE = create(key("block.bamboo_wood_door.close"));

    /**
     * {@code minecraft:block.bamboo_wood_door.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_DOOR_OPEN = create(key("block.bamboo_wood_door.open"));

    /**
     * {@code minecraft:block.bamboo_wood_fence_gate.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_FENCE_GATE_CLOSE = create(key("block.bamboo_wood_fence_gate.close"));

    /**
     * {@code minecraft:block.bamboo_wood_fence_gate.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_FENCE_GATE_OPEN = create(key("block.bamboo_wood_fence_gate.open"));

    /**
     * {@code minecraft:block.bamboo_wood_hanging_sign.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_HANGING_SIGN_BREAK = create(key("block.bamboo_wood_hanging_sign.break"));

    /**
     * {@code minecraft:block.bamboo_wood_hanging_sign.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_HANGING_SIGN_FALL = create(key("block.bamboo_wood_hanging_sign.fall"));

    /**
     * {@code minecraft:block.bamboo_wood_hanging_sign.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_HANGING_SIGN_HIT = create(key("block.bamboo_wood_hanging_sign.hit"));

    /**
     * {@code minecraft:block.bamboo_wood_hanging_sign.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_HANGING_SIGN_PLACE = create(key("block.bamboo_wood_hanging_sign.place"));

    /**
     * {@code minecraft:block.bamboo_wood_hanging_sign.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_HANGING_SIGN_STEP = create(key("block.bamboo_wood_hanging_sign.step"));

    /**
     * {@code minecraft:block.bamboo_wood_pressure_plate.click_off}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_PRESSURE_PLATE_CLICK_OFF = create(key("block.bamboo_wood_pressure_plate.click_off"));

    /**
     * {@code minecraft:block.bamboo_wood_pressure_plate.click_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_PRESSURE_PLATE_CLICK_ON = create(key("block.bamboo_wood_pressure_plate.click_on"));

    /**
     * {@code minecraft:block.bamboo_wood_trapdoor.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_TRAPDOOR_CLOSE = create(key("block.bamboo_wood_trapdoor.close"));

    /**
     * {@code minecraft:block.bamboo_wood_trapdoor.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BAMBOO_WOOD_TRAPDOOR_OPEN = create(key("block.bamboo_wood_trapdoor.open"));

    /**
     * {@code minecraft:block.barrel.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BARREL_CLOSE = create(key("block.barrel.close"));

    /**
     * {@code minecraft:block.barrel.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BARREL_OPEN = create(key("block.barrel.open"));

    /**
     * {@code minecraft:block.basalt.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BASALT_BREAK = create(key("block.basalt.break"));

    /**
     * {@code minecraft:block.basalt.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BASALT_FALL = create(key("block.basalt.fall"));

    /**
     * {@code minecraft:block.basalt.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BASALT_HIT = create(key("block.basalt.hit"));

    /**
     * {@code minecraft:block.basalt.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BASALT_PLACE = create(key("block.basalt.place"));

    /**
     * {@code minecraft:block.basalt.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BASALT_STEP = create(key("block.basalt.step"));

    /**
     * {@code minecraft:block.beacon.activate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BEACON_ACTIVATE = create(key("block.beacon.activate"));

    /**
     * {@code minecraft:block.beacon.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BEACON_AMBIENT = create(key("block.beacon.ambient"));

    /**
     * {@code minecraft:block.beacon.deactivate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BEACON_DEACTIVATE = create(key("block.beacon.deactivate"));

    /**
     * {@code minecraft:block.beacon.power_select}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BEACON_POWER_SELECT = create(key("block.beacon.power_select"));

    /**
     * {@code minecraft:block.beehive.drip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BEEHIVE_DRIP = create(key("block.beehive.drip"));

    /**
     * {@code minecraft:block.beehive.enter}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BEEHIVE_ENTER = create(key("block.beehive.enter"));

    /**
     * {@code minecraft:block.beehive.exit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BEEHIVE_EXIT = create(key("block.beehive.exit"));

    /**
     * {@code minecraft:block.beehive.shear}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BEEHIVE_SHEAR = create(key("block.beehive.shear"));

    /**
     * {@code minecraft:block.beehive.work}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BEEHIVE_WORK = create(key("block.beehive.work"));

    /**
     * {@code minecraft:block.bell.resonate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BELL_RESONATE = create(key("block.bell.resonate"));

    /**
     * {@code minecraft:block.bell.use}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BELL_USE = create(key("block.bell.use"));

    /**
     * {@code minecraft:block.big_dripleaf.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BIG_DRIPLEAF_BREAK = create(key("block.big_dripleaf.break"));

    /**
     * {@code minecraft:block.big_dripleaf.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BIG_DRIPLEAF_FALL = create(key("block.big_dripleaf.fall"));

    /**
     * {@code minecraft:block.big_dripleaf.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BIG_DRIPLEAF_HIT = create(key("block.big_dripleaf.hit"));

    /**
     * {@code minecraft:block.big_dripleaf.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BIG_DRIPLEAF_PLACE = create(key("block.big_dripleaf.place"));

    /**
     * {@code minecraft:block.big_dripleaf.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BIG_DRIPLEAF_STEP = create(key("block.big_dripleaf.step"));

    /**
     * {@code minecraft:block.big_dripleaf.tilt_down}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BIG_DRIPLEAF_TILT_DOWN = create(key("block.big_dripleaf.tilt_down"));

    /**
     * {@code minecraft:block.big_dripleaf.tilt_up}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BIG_DRIPLEAF_TILT_UP = create(key("block.big_dripleaf.tilt_up"));

    /**
     * {@code minecraft:block.blastfurnace.fire_crackle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BLASTFURNACE_FIRE_CRACKLE = create(key("block.blastfurnace.fire_crackle"));

    /**
     * {@code minecraft:block.bone_block.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BONE_BLOCK_BREAK = create(key("block.bone_block.break"));

    /**
     * {@code minecraft:block.bone_block.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BONE_BLOCK_FALL = create(key("block.bone_block.fall"));

    /**
     * {@code minecraft:block.bone_block.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BONE_BLOCK_HIT = create(key("block.bone_block.hit"));

    /**
     * {@code minecraft:block.bone_block.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BONE_BLOCK_PLACE = create(key("block.bone_block.place"));

    /**
     * {@code minecraft:block.bone_block.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BONE_BLOCK_STEP = create(key("block.bone_block.step"));

    /**
     * {@code minecraft:block.brewing_stand.brew}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BREWING_STAND_BREW = create(key("block.brewing_stand.brew"));

    /**
     * {@code minecraft:block.bubble_column.bubble_pop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BUBBLE_COLUMN_BUBBLE_POP = create(key("block.bubble_column.bubble_pop"));

    /**
     * {@code minecraft:block.bubble_column.upwards_ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BUBBLE_COLUMN_UPWARDS_AMBIENT = create(key("block.bubble_column.upwards_ambient"));

    /**
     * {@code minecraft:block.bubble_column.upwards_inside}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BUBBLE_COLUMN_UPWARDS_INSIDE = create(key("block.bubble_column.upwards_inside"));

    /**
     * {@code minecraft:block.bubble_column.whirlpool_ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BUBBLE_COLUMN_WHIRLPOOL_AMBIENT = create(key("block.bubble_column.whirlpool_ambient"));

    /**
     * {@code minecraft:block.bubble_column.whirlpool_inside}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_BUBBLE_COLUMN_WHIRLPOOL_INSIDE = create(key("block.bubble_column.whirlpool_inside"));

    /**
     * {@code minecraft:block.cactus_flower.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CACTUS_FLOWER_BREAK = create(key("block.cactus_flower.break"));

    /**
     * {@code minecraft:block.cactus_flower.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CACTUS_FLOWER_PLACE = create(key("block.cactus_flower.place"));

    /**
     * {@code minecraft:block.cake.add_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CAKE_ADD_CANDLE = create(key("block.cake.add_candle"));

    /**
     * {@code minecraft:block.calcite.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CALCITE_BREAK = create(key("block.calcite.break"));

    /**
     * {@code minecraft:block.calcite.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CALCITE_FALL = create(key("block.calcite.fall"));

    /**
     * {@code minecraft:block.calcite.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CALCITE_HIT = create(key("block.calcite.hit"));

    /**
     * {@code minecraft:block.calcite.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CALCITE_PLACE = create(key("block.calcite.place"));

    /**
     * {@code minecraft:block.calcite.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CALCITE_STEP = create(key("block.calcite.step"));

    /**
     * {@code minecraft:block.campfire.crackle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CAMPFIRE_CRACKLE = create(key("block.campfire.crackle"));

    /**
     * {@code minecraft:block.candle.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CANDLE_AMBIENT = create(key("block.candle.ambient"));

    /**
     * {@code minecraft:block.candle.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CANDLE_BREAK = create(key("block.candle.break"));

    /**
     * {@code minecraft:block.candle.extinguish}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CANDLE_EXTINGUISH = create(key("block.candle.extinguish"));

    /**
     * {@code minecraft:block.candle.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CANDLE_FALL = create(key("block.candle.fall"));

    /**
     * {@code minecraft:block.candle.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CANDLE_HIT = create(key("block.candle.hit"));

    /**
     * {@code minecraft:block.candle.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CANDLE_PLACE = create(key("block.candle.place"));

    /**
     * {@code minecraft:block.candle.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CANDLE_STEP = create(key("block.candle.step"));

    /**
     * {@code minecraft:block.cave_vines.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CAVE_VINES_BREAK = create(key("block.cave_vines.break"));

    /**
     * {@code minecraft:block.cave_vines.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CAVE_VINES_FALL = create(key("block.cave_vines.fall"));

    /**
     * {@code minecraft:block.cave_vines.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CAVE_VINES_HIT = create(key("block.cave_vines.hit"));

    /**
     * {@code minecraft:block.cave_vines.pick_berries}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CAVE_VINES_PICK_BERRIES = create(key("block.cave_vines.pick_berries"));

    /**
     * {@code minecraft:block.cave_vines.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CAVE_VINES_PLACE = create(key("block.cave_vines.place"));

    /**
     * {@code minecraft:block.cave_vines.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CAVE_VINES_STEP = create(key("block.cave_vines.step"));

    /**
     * {@code minecraft:block.chain.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHAIN_BREAK = create(key("block.chain.break"));

    /**
     * {@code minecraft:block.chain.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHAIN_FALL = create(key("block.chain.fall"));

    /**
     * {@code minecraft:block.chain.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHAIN_HIT = create(key("block.chain.hit"));

    /**
     * {@code minecraft:block.chain.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHAIN_PLACE = create(key("block.chain.place"));

    /**
     * {@code minecraft:block.chain.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHAIN_STEP = create(key("block.chain.step"));

    /**
     * {@code minecraft:block.cherry_leaves.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_LEAVES_BREAK = create(key("block.cherry_leaves.break"));

    /**
     * {@code minecraft:block.cherry_leaves.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_LEAVES_FALL = create(key("block.cherry_leaves.fall"));

    /**
     * {@code minecraft:block.cherry_leaves.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_LEAVES_HIT = create(key("block.cherry_leaves.hit"));

    /**
     * {@code minecraft:block.cherry_leaves.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_LEAVES_PLACE = create(key("block.cherry_leaves.place"));

    /**
     * {@code minecraft:block.cherry_leaves.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_LEAVES_STEP = create(key("block.cherry_leaves.step"));

    /**
     * {@code minecraft:block.cherry_sapling.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_SAPLING_BREAK = create(key("block.cherry_sapling.break"));

    /**
     * {@code minecraft:block.cherry_sapling.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_SAPLING_FALL = create(key("block.cherry_sapling.fall"));

    /**
     * {@code minecraft:block.cherry_sapling.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_SAPLING_HIT = create(key("block.cherry_sapling.hit"));

    /**
     * {@code minecraft:block.cherry_sapling.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_SAPLING_PLACE = create(key("block.cherry_sapling.place"));

    /**
     * {@code minecraft:block.cherry_sapling.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_SAPLING_STEP = create(key("block.cherry_sapling.step"));

    /**
     * {@code minecraft:block.cherry_wood.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_BREAK = create(key("block.cherry_wood.break"));

    /**
     * {@code minecraft:block.cherry_wood.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_FALL = create(key("block.cherry_wood.fall"));

    /**
     * {@code minecraft:block.cherry_wood.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_HIT = create(key("block.cherry_wood.hit"));

    /**
     * {@code minecraft:block.cherry_wood.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_PLACE = create(key("block.cherry_wood.place"));

    /**
     * {@code minecraft:block.cherry_wood.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_STEP = create(key("block.cherry_wood.step"));

    /**
     * {@code minecraft:block.cherry_wood_button.click_off}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_BUTTON_CLICK_OFF = create(key("block.cherry_wood_button.click_off"));

    /**
     * {@code minecraft:block.cherry_wood_button.click_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_BUTTON_CLICK_ON = create(key("block.cherry_wood_button.click_on"));

    /**
     * {@code minecraft:block.cherry_wood_door.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_DOOR_CLOSE = create(key("block.cherry_wood_door.close"));

    /**
     * {@code minecraft:block.cherry_wood_door.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_DOOR_OPEN = create(key("block.cherry_wood_door.open"));

    /**
     * {@code minecraft:block.cherry_wood_fence_gate.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_FENCE_GATE_CLOSE = create(key("block.cherry_wood_fence_gate.close"));

    /**
     * {@code minecraft:block.cherry_wood_fence_gate.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_FENCE_GATE_OPEN = create(key("block.cherry_wood_fence_gate.open"));

    /**
     * {@code minecraft:block.cherry_wood_hanging_sign.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_HANGING_SIGN_BREAK = create(key("block.cherry_wood_hanging_sign.break"));

    /**
     * {@code minecraft:block.cherry_wood_hanging_sign.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_HANGING_SIGN_FALL = create(key("block.cherry_wood_hanging_sign.fall"));

    /**
     * {@code minecraft:block.cherry_wood_hanging_sign.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_HANGING_SIGN_HIT = create(key("block.cherry_wood_hanging_sign.hit"));

    /**
     * {@code minecraft:block.cherry_wood_hanging_sign.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_HANGING_SIGN_PLACE = create(key("block.cherry_wood_hanging_sign.place"));

    /**
     * {@code minecraft:block.cherry_wood_hanging_sign.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_HANGING_SIGN_STEP = create(key("block.cherry_wood_hanging_sign.step"));

    /**
     * {@code minecraft:block.cherry_wood_pressure_plate.click_off}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_PRESSURE_PLATE_CLICK_OFF = create(key("block.cherry_wood_pressure_plate.click_off"));

    /**
     * {@code minecraft:block.cherry_wood_pressure_plate.click_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_PRESSURE_PLATE_CLICK_ON = create(key("block.cherry_wood_pressure_plate.click_on"));

    /**
     * {@code minecraft:block.cherry_wood_trapdoor.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_TRAPDOOR_CLOSE = create(key("block.cherry_wood_trapdoor.close"));

    /**
     * {@code minecraft:block.cherry_wood_trapdoor.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHERRY_WOOD_TRAPDOOR_OPEN = create(key("block.cherry_wood_trapdoor.open"));

    /**
     * {@code minecraft:block.chest.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHEST_CLOSE = create(key("block.chest.close"));

    /**
     * {@code minecraft:block.chest.locked}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHEST_LOCKED = create(key("block.chest.locked"));

    /**
     * {@code minecraft:block.chest.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHEST_OPEN = create(key("block.chest.open"));

    /**
     * {@code minecraft:block.chiseled_bookshelf.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHISELED_BOOKSHELF_BREAK = create(key("block.chiseled_bookshelf.break"));

    /**
     * {@code minecraft:block.chiseled_bookshelf.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHISELED_BOOKSHELF_FALL = create(key("block.chiseled_bookshelf.fall"));

    /**
     * {@code minecraft:block.chiseled_bookshelf.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHISELED_BOOKSHELF_HIT = create(key("block.chiseled_bookshelf.hit"));

    /**
     * {@code minecraft:block.chiseled_bookshelf.insert}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHISELED_BOOKSHELF_INSERT = create(key("block.chiseled_bookshelf.insert"));

    /**
     * {@code minecraft:block.chiseled_bookshelf.insert.enchanted}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHISELED_BOOKSHELF_INSERT_ENCHANTED = create(key("block.chiseled_bookshelf.insert.enchanted"));

    /**
     * {@code minecraft:block.chiseled_bookshelf.pickup}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHISELED_BOOKSHELF_PICKUP = create(key("block.chiseled_bookshelf.pickup"));

    /**
     * {@code minecraft:block.chiseled_bookshelf.pickup.enchanted}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHISELED_BOOKSHELF_PICKUP_ENCHANTED = create(key("block.chiseled_bookshelf.pickup.enchanted"));

    /**
     * {@code minecraft:block.chiseled_bookshelf.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHISELED_BOOKSHELF_PLACE = create(key("block.chiseled_bookshelf.place"));

    /**
     * {@code minecraft:block.chiseled_bookshelf.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHISELED_BOOKSHELF_STEP = create(key("block.chiseled_bookshelf.step"));

    /**
     * {@code minecraft:block.chorus_flower.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHORUS_FLOWER_DEATH = create(key("block.chorus_flower.death"));

    /**
     * {@code minecraft:block.chorus_flower.grow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CHORUS_FLOWER_GROW = create(key("block.chorus_flower.grow"));

    /**
     * {@code minecraft:block.cobweb.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COBWEB_BREAK = create(key("block.cobweb.break"));

    /**
     * {@code minecraft:block.cobweb.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COBWEB_FALL = create(key("block.cobweb.fall"));

    /**
     * {@code minecraft:block.cobweb.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COBWEB_HIT = create(key("block.cobweb.hit"));

    /**
     * {@code minecraft:block.cobweb.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COBWEB_PLACE = create(key("block.cobweb.place"));

    /**
     * {@code minecraft:block.cobweb.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COBWEB_STEP = create(key("block.cobweb.step"));

    /**
     * {@code minecraft:block.comparator.click}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COMPARATOR_CLICK = create(key("block.comparator.click"));

    /**
     * {@code minecraft:block.composter.empty}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COMPOSTER_EMPTY = create(key("block.composter.empty"));

    /**
     * {@code minecraft:block.composter.fill}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COMPOSTER_FILL = create(key("block.composter.fill"));

    /**
     * {@code minecraft:block.composter.fill_success}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COMPOSTER_FILL_SUCCESS = create(key("block.composter.fill_success"));

    /**
     * {@code minecraft:block.composter.ready}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COMPOSTER_READY = create(key("block.composter.ready"));

    /**
     * {@code minecraft:block.conduit.activate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CONDUIT_ACTIVATE = create(key("block.conduit.activate"));

    /**
     * {@code minecraft:block.conduit.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CONDUIT_AMBIENT = create(key("block.conduit.ambient"));

    /**
     * {@code minecraft:block.conduit.ambient.short}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CONDUIT_AMBIENT_SHORT = create(key("block.conduit.ambient.short"));

    /**
     * {@code minecraft:block.conduit.attack.target}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CONDUIT_ATTACK_TARGET = create(key("block.conduit.attack.target"));

    /**
     * {@code minecraft:block.conduit.deactivate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CONDUIT_DEACTIVATE = create(key("block.conduit.deactivate"));

    /**
     * {@code minecraft:block.copper.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_BREAK = create(key("block.copper.break"));

    /**
     * {@code minecraft:block.copper.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_FALL = create(key("block.copper.fall"));

    /**
     * {@code minecraft:block.copper.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_HIT = create(key("block.copper.hit"));

    /**
     * {@code minecraft:block.copper.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_PLACE = create(key("block.copper.place"));

    /**
     * {@code minecraft:block.copper.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_STEP = create(key("block.copper.step"));

    /**
     * {@code minecraft:block.copper_bulb.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_BULB_BREAK = create(key("block.copper_bulb.break"));

    /**
     * {@code minecraft:block.copper_bulb.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_BULB_FALL = create(key("block.copper_bulb.fall"));

    /**
     * {@code minecraft:block.copper_bulb.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_BULB_HIT = create(key("block.copper_bulb.hit"));

    /**
     * {@code minecraft:block.copper_bulb.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_BULB_PLACE = create(key("block.copper_bulb.place"));

    /**
     * {@code minecraft:block.copper_bulb.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_BULB_STEP = create(key("block.copper_bulb.step"));

    /**
     * {@code minecraft:block.copper_bulb.turn_off}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_BULB_TURN_OFF = create(key("block.copper_bulb.turn_off"));

    /**
     * {@code minecraft:block.copper_bulb.turn_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_BULB_TURN_ON = create(key("block.copper_bulb.turn_on"));

    /**
     * {@code minecraft:block.copper_door.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_DOOR_CLOSE = create(key("block.copper_door.close"));

    /**
     * {@code minecraft:block.copper_door.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_DOOR_OPEN = create(key("block.copper_door.open"));

    /**
     * {@code minecraft:block.copper_grate.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_GRATE_BREAK = create(key("block.copper_grate.break"));

    /**
     * {@code minecraft:block.copper_grate.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_GRATE_FALL = create(key("block.copper_grate.fall"));

    /**
     * {@code minecraft:block.copper_grate.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_GRATE_HIT = create(key("block.copper_grate.hit"));

    /**
     * {@code minecraft:block.copper_grate.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_GRATE_PLACE = create(key("block.copper_grate.place"));

    /**
     * {@code minecraft:block.copper_grate.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_GRATE_STEP = create(key("block.copper_grate.step"));

    /**
     * {@code minecraft:block.copper_trapdoor.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_TRAPDOOR_CLOSE = create(key("block.copper_trapdoor.close"));

    /**
     * {@code minecraft:block.copper_trapdoor.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_COPPER_TRAPDOOR_OPEN = create(key("block.copper_trapdoor.open"));

    /**
     * {@code minecraft:block.coral_block.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CORAL_BLOCK_BREAK = create(key("block.coral_block.break"));

    /**
     * {@code minecraft:block.coral_block.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CORAL_BLOCK_FALL = create(key("block.coral_block.fall"));

    /**
     * {@code minecraft:block.coral_block.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CORAL_BLOCK_HIT = create(key("block.coral_block.hit"));

    /**
     * {@code minecraft:block.coral_block.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CORAL_BLOCK_PLACE = create(key("block.coral_block.place"));

    /**
     * {@code minecraft:block.coral_block.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CORAL_BLOCK_STEP = create(key("block.coral_block.step"));

    /**
     * {@code minecraft:block.crafter.craft}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CRAFTER_CRAFT = create(key("block.crafter.craft"));

    /**
     * {@code minecraft:block.crafter.fail}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CRAFTER_FAIL = create(key("block.crafter.fail"));

    /**
     * {@code minecraft:block.creaking_heart.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CREAKING_HEART_BREAK = create(key("block.creaking_heart.break"));

    /**
     * {@code minecraft:block.creaking_heart.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CREAKING_HEART_FALL = create(key("block.creaking_heart.fall"));

    /**
     * {@code minecraft:block.creaking_heart.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CREAKING_HEART_HIT = create(key("block.creaking_heart.hit"));

    /**
     * {@code minecraft:block.creaking_heart.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CREAKING_HEART_HURT = create(key("block.creaking_heart.hurt"));

    /**
     * {@code minecraft:block.creaking_heart.idle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CREAKING_HEART_IDLE = create(key("block.creaking_heart.idle"));

    /**
     * {@code minecraft:block.creaking_heart.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CREAKING_HEART_PLACE = create(key("block.creaking_heart.place"));

    /**
     * {@code minecraft:block.creaking_heart.spawn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CREAKING_HEART_SPAWN = create(key("block.creaking_heart.spawn"));

    /**
     * {@code minecraft:block.creaking_heart.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CREAKING_HEART_STEP = create(key("block.creaking_heart.step"));

    /**
     * {@code minecraft:block.crop.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_CROP_BREAK = create(key("block.crop.break"));

    /**
     * {@code minecraft:block.deadbush.idle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DEADBUSH_IDLE = create(key("block.deadbush.idle"));

    /**
     * {@code minecraft:block.decorated_pot.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DECORATED_POT_BREAK = create(key("block.decorated_pot.break"));

    /**
     * {@code minecraft:block.decorated_pot.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DECORATED_POT_FALL = create(key("block.decorated_pot.fall"));

    /**
     * {@code minecraft:block.decorated_pot.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DECORATED_POT_HIT = create(key("block.decorated_pot.hit"));

    /**
     * {@code minecraft:block.decorated_pot.insert}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DECORATED_POT_INSERT = create(key("block.decorated_pot.insert"));

    /**
     * {@code minecraft:block.decorated_pot.insert_fail}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DECORATED_POT_INSERT_FAIL = create(key("block.decorated_pot.insert_fail"));

    /**
     * {@code minecraft:block.decorated_pot.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DECORATED_POT_PLACE = create(key("block.decorated_pot.place"));

    /**
     * {@code minecraft:block.decorated_pot.shatter}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DECORATED_POT_SHATTER = create(key("block.decorated_pot.shatter"));

    /**
     * {@code minecraft:block.decorated_pot.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DECORATED_POT_STEP = create(key("block.decorated_pot.step"));

    /**
     * {@code minecraft:block.deepslate.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DEEPSLATE_BREAK = create(key("block.deepslate.break"));

    /**
     * {@code minecraft:block.deepslate.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DEEPSLATE_FALL = create(key("block.deepslate.fall"));

    /**
     * {@code minecraft:block.deepslate.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DEEPSLATE_HIT = create(key("block.deepslate.hit"));

    /**
     * {@code minecraft:block.deepslate.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DEEPSLATE_PLACE = create(key("block.deepslate.place"));

    /**
     * {@code minecraft:block.deepslate.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DEEPSLATE_STEP = create(key("block.deepslate.step"));

    /**
     * {@code minecraft:block.deepslate_bricks.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DEEPSLATE_BRICKS_BREAK = create(key("block.deepslate_bricks.break"));

    /**
     * {@code minecraft:block.deepslate_bricks.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DEEPSLATE_BRICKS_FALL = create(key("block.deepslate_bricks.fall"));

    /**
     * {@code minecraft:block.deepslate_bricks.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DEEPSLATE_BRICKS_HIT = create(key("block.deepslate_bricks.hit"));

    /**
     * {@code minecraft:block.deepslate_bricks.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DEEPSLATE_BRICKS_PLACE = create(key("block.deepslate_bricks.place"));

    /**
     * {@code minecraft:block.deepslate_bricks.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DEEPSLATE_BRICKS_STEP = create(key("block.deepslate_bricks.step"));

    /**
     * {@code minecraft:block.deepslate_tiles.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DEEPSLATE_TILES_BREAK = create(key("block.deepslate_tiles.break"));

    /**
     * {@code minecraft:block.deepslate_tiles.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DEEPSLATE_TILES_FALL = create(key("block.deepslate_tiles.fall"));

    /**
     * {@code minecraft:block.deepslate_tiles.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DEEPSLATE_TILES_HIT = create(key("block.deepslate_tiles.hit"));

    /**
     * {@code minecraft:block.deepslate_tiles.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DEEPSLATE_TILES_PLACE = create(key("block.deepslate_tiles.place"));

    /**
     * {@code minecraft:block.deepslate_tiles.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DEEPSLATE_TILES_STEP = create(key("block.deepslate_tiles.step"));

    /**
     * {@code minecraft:block.dispenser.dispense}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DISPENSER_DISPENSE = create(key("block.dispenser.dispense"));

    /**
     * {@code minecraft:block.dispenser.fail}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DISPENSER_FAIL = create(key("block.dispenser.fail"));

    /**
     * {@code minecraft:block.dispenser.launch}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DISPENSER_LAUNCH = create(key("block.dispenser.launch"));

    /**
     * {@code minecraft:block.dried_ghast.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DRIED_GHAST_AMBIENT = create(key("block.dried_ghast.ambient"));

    /**
     * {@code minecraft:block.dried_ghast.ambient_water}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DRIED_GHAST_AMBIENT_WATER = create(key("block.dried_ghast.ambient_water"));

    /**
     * {@code minecraft:block.dried_ghast.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DRIED_GHAST_BREAK = create(key("block.dried_ghast.break"));

    /**
     * {@code minecraft:block.dried_ghast.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DRIED_GHAST_FALL = create(key("block.dried_ghast.fall"));

    /**
     * {@code minecraft:block.dried_ghast.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DRIED_GHAST_PLACE = create(key("block.dried_ghast.place"));

    /**
     * {@code minecraft:block.dried_ghast.place_in_water}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DRIED_GHAST_PLACE_IN_WATER = create(key("block.dried_ghast.place_in_water"));

    /**
     * {@code minecraft:block.dried_ghast.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DRIED_GHAST_STEP = create(key("block.dried_ghast.step"));

    /**
     * {@code minecraft:block.dried_ghast.transition}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DRIED_GHAST_TRANSITION = create(key("block.dried_ghast.transition"));

    /**
     * {@code minecraft:block.dripstone_block.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DRIPSTONE_BLOCK_BREAK = create(key("block.dripstone_block.break"));

    /**
     * {@code minecraft:block.dripstone_block.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DRIPSTONE_BLOCK_FALL = create(key("block.dripstone_block.fall"));

    /**
     * {@code minecraft:block.dripstone_block.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DRIPSTONE_BLOCK_HIT = create(key("block.dripstone_block.hit"));

    /**
     * {@code minecraft:block.dripstone_block.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DRIPSTONE_BLOCK_PLACE = create(key("block.dripstone_block.place"));

    /**
     * {@code minecraft:block.dripstone_block.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DRIPSTONE_BLOCK_STEP = create(key("block.dripstone_block.step"));

    /**
     * {@code minecraft:block.dry_grass.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_DRY_GRASS_AMBIENT = create(key("block.dry_grass.ambient"));

    /**
     * {@code minecraft:block.enchantment_table.use}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ENCHANTMENT_TABLE_USE = create(key("block.enchantment_table.use"));

    /**
     * {@code minecraft:block.end_gateway.spawn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_END_GATEWAY_SPAWN = create(key("block.end_gateway.spawn"));

    /**
     * {@code minecraft:block.end_portal.spawn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_END_PORTAL_SPAWN = create(key("block.end_portal.spawn"));

    /**
     * {@code minecraft:block.end_portal_frame.fill}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_END_PORTAL_FRAME_FILL = create(key("block.end_portal_frame.fill"));

    /**
     * {@code minecraft:block.ender_chest.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ENDER_CHEST_CLOSE = create(key("block.ender_chest.close"));

    /**
     * {@code minecraft:block.ender_chest.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ENDER_CHEST_OPEN = create(key("block.ender_chest.open"));

    /**
     * {@code minecraft:block.eyeblossom.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_EYEBLOSSOM_CLOSE = create(key("block.eyeblossom.close"));

    /**
     * {@code minecraft:block.eyeblossom.close_long}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_EYEBLOSSOM_CLOSE_LONG = create(key("block.eyeblossom.close_long"));

    /**
     * {@code minecraft:block.eyeblossom.idle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_EYEBLOSSOM_IDLE = create(key("block.eyeblossom.idle"));

    /**
     * {@code minecraft:block.eyeblossom.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_EYEBLOSSOM_OPEN = create(key("block.eyeblossom.open"));

    /**
     * {@code minecraft:block.eyeblossom.open_long}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_EYEBLOSSOM_OPEN_LONG = create(key("block.eyeblossom.open_long"));

    /**
     * {@code minecraft:block.fence_gate.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FENCE_GATE_CLOSE = create(key("block.fence_gate.close"));

    /**
     * {@code minecraft:block.fence_gate.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FENCE_GATE_OPEN = create(key("block.fence_gate.open"));

    /**
     * {@code minecraft:block.fire.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FIRE_AMBIENT = create(key("block.fire.ambient"));

    /**
     * {@code minecraft:block.fire.extinguish}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FIRE_EXTINGUISH = create(key("block.fire.extinguish"));

    /**
     * {@code minecraft:block.firefly_bush.idle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FIREFLY_BUSH_IDLE = create(key("block.firefly_bush.idle"));

    /**
     * {@code minecraft:block.flowering_azalea.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FLOWERING_AZALEA_BREAK = create(key("block.flowering_azalea.break"));

    /**
     * {@code minecraft:block.flowering_azalea.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FLOWERING_AZALEA_FALL = create(key("block.flowering_azalea.fall"));

    /**
     * {@code minecraft:block.flowering_azalea.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FLOWERING_AZALEA_HIT = create(key("block.flowering_azalea.hit"));

    /**
     * {@code minecraft:block.flowering_azalea.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FLOWERING_AZALEA_PLACE = create(key("block.flowering_azalea.place"));

    /**
     * {@code minecraft:block.flowering_azalea.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FLOWERING_AZALEA_STEP = create(key("block.flowering_azalea.step"));

    /**
     * {@code minecraft:block.froglight.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FROGLIGHT_BREAK = create(key("block.froglight.break"));

    /**
     * {@code minecraft:block.froglight.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FROGLIGHT_FALL = create(key("block.froglight.fall"));

    /**
     * {@code minecraft:block.froglight.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FROGLIGHT_HIT = create(key("block.froglight.hit"));

    /**
     * {@code minecraft:block.froglight.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FROGLIGHT_PLACE = create(key("block.froglight.place"));

    /**
     * {@code minecraft:block.froglight.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FROGLIGHT_STEP = create(key("block.froglight.step"));

    /**
     * {@code minecraft:block.frogspawn.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FROGSPAWN_BREAK = create(key("block.frogspawn.break"));

    /**
     * {@code minecraft:block.frogspawn.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FROGSPAWN_FALL = create(key("block.frogspawn.fall"));

    /**
     * {@code minecraft:block.frogspawn.hatch}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FROGSPAWN_HATCH = create(key("block.frogspawn.hatch"));

    /**
     * {@code minecraft:block.frogspawn.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FROGSPAWN_HIT = create(key("block.frogspawn.hit"));

    /**
     * {@code minecraft:block.frogspawn.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FROGSPAWN_PLACE = create(key("block.frogspawn.place"));

    /**
     * {@code minecraft:block.frogspawn.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FROGSPAWN_STEP = create(key("block.frogspawn.step"));

    /**
     * {@code minecraft:block.fungus.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FUNGUS_BREAK = create(key("block.fungus.break"));

    /**
     * {@code minecraft:block.fungus.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FUNGUS_FALL = create(key("block.fungus.fall"));

    /**
     * {@code minecraft:block.fungus.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FUNGUS_HIT = create(key("block.fungus.hit"));

    /**
     * {@code minecraft:block.fungus.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FUNGUS_PLACE = create(key("block.fungus.place"));

    /**
     * {@code minecraft:block.fungus.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FUNGUS_STEP = create(key("block.fungus.step"));

    /**
     * {@code minecraft:block.furnace.fire_crackle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_FURNACE_FIRE_CRACKLE = create(key("block.furnace.fire_crackle"));

    /**
     * {@code minecraft:block.gilded_blackstone.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GILDED_BLACKSTONE_BREAK = create(key("block.gilded_blackstone.break"));

    /**
     * {@code minecraft:block.gilded_blackstone.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GILDED_BLACKSTONE_FALL = create(key("block.gilded_blackstone.fall"));

    /**
     * {@code minecraft:block.gilded_blackstone.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GILDED_BLACKSTONE_HIT = create(key("block.gilded_blackstone.hit"));

    /**
     * {@code minecraft:block.gilded_blackstone.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GILDED_BLACKSTONE_PLACE = create(key("block.gilded_blackstone.place"));

    /**
     * {@code minecraft:block.gilded_blackstone.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GILDED_BLACKSTONE_STEP = create(key("block.gilded_blackstone.step"));

    /**
     * {@code minecraft:block.glass.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GLASS_BREAK = create(key("block.glass.break"));

    /**
     * {@code minecraft:block.glass.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GLASS_FALL = create(key("block.glass.fall"));

    /**
     * {@code minecraft:block.glass.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GLASS_HIT = create(key("block.glass.hit"));

    /**
     * {@code minecraft:block.glass.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GLASS_PLACE = create(key("block.glass.place"));

    /**
     * {@code minecraft:block.glass.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GLASS_STEP = create(key("block.glass.step"));

    /**
     * {@code minecraft:block.grass.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GRASS_BREAK = create(key("block.grass.break"));

    /**
     * {@code minecraft:block.grass.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GRASS_FALL = create(key("block.grass.fall"));

    /**
     * {@code minecraft:block.grass.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GRASS_HIT = create(key("block.grass.hit"));

    /**
     * {@code minecraft:block.grass.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GRASS_PLACE = create(key("block.grass.place"));

    /**
     * {@code minecraft:block.grass.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GRASS_STEP = create(key("block.grass.step"));

    /**
     * {@code minecraft:block.gravel.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GRAVEL_BREAK = create(key("block.gravel.break"));

    /**
     * {@code minecraft:block.gravel.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GRAVEL_FALL = create(key("block.gravel.fall"));

    /**
     * {@code minecraft:block.gravel.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GRAVEL_HIT = create(key("block.gravel.hit"));

    /**
     * {@code minecraft:block.gravel.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GRAVEL_PLACE = create(key("block.gravel.place"));

    /**
     * {@code minecraft:block.gravel.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GRAVEL_STEP = create(key("block.gravel.step"));

    /**
     * {@code minecraft:block.grindstone.use}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GRINDSTONE_USE = create(key("block.grindstone.use"));

    /**
     * {@code minecraft:block.growing_plant.crop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_GROWING_PLANT_CROP = create(key("block.growing_plant.crop"));

    /**
     * {@code minecraft:block.hanging_roots.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HANGING_ROOTS_BREAK = create(key("block.hanging_roots.break"));

    /**
     * {@code minecraft:block.hanging_roots.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HANGING_ROOTS_FALL = create(key("block.hanging_roots.fall"));

    /**
     * {@code minecraft:block.hanging_roots.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HANGING_ROOTS_HIT = create(key("block.hanging_roots.hit"));

    /**
     * {@code minecraft:block.hanging_roots.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HANGING_ROOTS_PLACE = create(key("block.hanging_roots.place"));

    /**
     * {@code minecraft:block.hanging_roots.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HANGING_ROOTS_STEP = create(key("block.hanging_roots.step"));

    /**
     * {@code minecraft:block.hanging_sign.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HANGING_SIGN_BREAK = create(key("block.hanging_sign.break"));

    /**
     * {@code minecraft:block.hanging_sign.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HANGING_SIGN_FALL = create(key("block.hanging_sign.fall"));

    /**
     * {@code minecraft:block.hanging_sign.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HANGING_SIGN_HIT = create(key("block.hanging_sign.hit"));

    /**
     * {@code minecraft:block.hanging_sign.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HANGING_SIGN_PLACE = create(key("block.hanging_sign.place"));

    /**
     * {@code minecraft:block.hanging_sign.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HANGING_SIGN_STEP = create(key("block.hanging_sign.step"));

    /**
     * {@code minecraft:block.hanging_sign.waxed_interact_fail}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HANGING_SIGN_WAXED_INTERACT_FAIL = create(key("block.hanging_sign.waxed_interact_fail"));

    /**
     * {@code minecraft:block.heavy_core.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HEAVY_CORE_BREAK = create(key("block.heavy_core.break"));

    /**
     * {@code minecraft:block.heavy_core.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HEAVY_CORE_FALL = create(key("block.heavy_core.fall"));

    /**
     * {@code minecraft:block.heavy_core.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HEAVY_CORE_HIT = create(key("block.heavy_core.hit"));

    /**
     * {@code minecraft:block.heavy_core.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HEAVY_CORE_PLACE = create(key("block.heavy_core.place"));

    /**
     * {@code minecraft:block.heavy_core.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HEAVY_CORE_STEP = create(key("block.heavy_core.step"));

    /**
     * {@code minecraft:block.honey_block.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HONEY_BLOCK_BREAK = create(key("block.honey_block.break"));

    /**
     * {@code minecraft:block.honey_block.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HONEY_BLOCK_FALL = create(key("block.honey_block.fall"));

    /**
     * {@code minecraft:block.honey_block.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HONEY_BLOCK_HIT = create(key("block.honey_block.hit"));

    /**
     * {@code minecraft:block.honey_block.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HONEY_BLOCK_PLACE = create(key("block.honey_block.place"));

    /**
     * {@code minecraft:block.honey_block.slide}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HONEY_BLOCK_SLIDE = create(key("block.honey_block.slide"));

    /**
     * {@code minecraft:block.honey_block.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_HONEY_BLOCK_STEP = create(key("block.honey_block.step"));

    /**
     * {@code minecraft:block.iron.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_IRON_BREAK = create(key("block.iron.break"));

    /**
     * {@code minecraft:block.iron.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_IRON_FALL = create(key("block.iron.fall"));

    /**
     * {@code minecraft:block.iron.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_IRON_HIT = create(key("block.iron.hit"));

    /**
     * {@code minecraft:block.iron.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_IRON_PLACE = create(key("block.iron.place"));

    /**
     * {@code minecraft:block.iron.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_IRON_STEP = create(key("block.iron.step"));

    /**
     * {@code minecraft:block.iron_door.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_IRON_DOOR_CLOSE = create(key("block.iron_door.close"));

    /**
     * {@code minecraft:block.iron_door.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_IRON_DOOR_OPEN = create(key("block.iron_door.open"));

    /**
     * {@code minecraft:block.iron_trapdoor.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_IRON_TRAPDOOR_CLOSE = create(key("block.iron_trapdoor.close"));

    /**
     * {@code minecraft:block.iron_trapdoor.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_IRON_TRAPDOOR_OPEN = create(key("block.iron_trapdoor.open"));

    /**
     * {@code minecraft:block.ladder.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LADDER_BREAK = create(key("block.ladder.break"));

    /**
     * {@code minecraft:block.ladder.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LADDER_FALL = create(key("block.ladder.fall"));

    /**
     * {@code minecraft:block.ladder.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LADDER_HIT = create(key("block.ladder.hit"));

    /**
     * {@code minecraft:block.ladder.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LADDER_PLACE = create(key("block.ladder.place"));

    /**
     * {@code minecraft:block.ladder.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LADDER_STEP = create(key("block.ladder.step"));

    /**
     * {@code minecraft:block.lantern.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LANTERN_BREAK = create(key("block.lantern.break"));

    /**
     * {@code minecraft:block.lantern.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LANTERN_FALL = create(key("block.lantern.fall"));

    /**
     * {@code minecraft:block.lantern.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LANTERN_HIT = create(key("block.lantern.hit"));

    /**
     * {@code minecraft:block.lantern.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LANTERN_PLACE = create(key("block.lantern.place"));

    /**
     * {@code minecraft:block.lantern.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LANTERN_STEP = create(key("block.lantern.step"));

    /**
     * {@code minecraft:block.large_amethyst_bud.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LARGE_AMETHYST_BUD_BREAK = create(key("block.large_amethyst_bud.break"));

    /**
     * {@code minecraft:block.large_amethyst_bud.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LARGE_AMETHYST_BUD_PLACE = create(key("block.large_amethyst_bud.place"));

    /**
     * {@code minecraft:block.lava.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LAVA_AMBIENT = create(key("block.lava.ambient"));

    /**
     * {@code minecraft:block.lava.extinguish}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LAVA_EXTINGUISH = create(key("block.lava.extinguish"));

    /**
     * {@code minecraft:block.lava.pop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LAVA_POP = create(key("block.lava.pop"));

    /**
     * {@code minecraft:block.leaf_litter.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LEAF_LITTER_BREAK = create(key("block.leaf_litter.break"));

    /**
     * {@code minecraft:block.leaf_litter.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LEAF_LITTER_FALL = create(key("block.leaf_litter.fall"));

    /**
     * {@code minecraft:block.leaf_litter.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LEAF_LITTER_HIT = create(key("block.leaf_litter.hit"));

    /**
     * {@code minecraft:block.leaf_litter.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LEAF_LITTER_PLACE = create(key("block.leaf_litter.place"));

    /**
     * {@code minecraft:block.leaf_litter.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LEAF_LITTER_STEP = create(key("block.leaf_litter.step"));

    /**
     * {@code minecraft:block.lever.click}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LEVER_CLICK = create(key("block.lever.click"));

    /**
     * {@code minecraft:block.lily_pad.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LILY_PAD_PLACE = create(key("block.lily_pad.place"));

    /**
     * {@code minecraft:block.lodestone.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LODESTONE_BREAK = create(key("block.lodestone.break"));

    /**
     * {@code minecraft:block.lodestone.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LODESTONE_FALL = create(key("block.lodestone.fall"));

    /**
     * {@code minecraft:block.lodestone.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LODESTONE_HIT = create(key("block.lodestone.hit"));

    /**
     * {@code minecraft:block.lodestone.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LODESTONE_PLACE = create(key("block.lodestone.place"));

    /**
     * {@code minecraft:block.lodestone.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_LODESTONE_STEP = create(key("block.lodestone.step"));

    /**
     * {@code minecraft:block.mangrove_roots.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MANGROVE_ROOTS_BREAK = create(key("block.mangrove_roots.break"));

    /**
     * {@code minecraft:block.mangrove_roots.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MANGROVE_ROOTS_FALL = create(key("block.mangrove_roots.fall"));

    /**
     * {@code minecraft:block.mangrove_roots.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MANGROVE_ROOTS_HIT = create(key("block.mangrove_roots.hit"));

    /**
     * {@code minecraft:block.mangrove_roots.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MANGROVE_ROOTS_PLACE = create(key("block.mangrove_roots.place"));

    /**
     * {@code minecraft:block.mangrove_roots.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MANGROVE_ROOTS_STEP = create(key("block.mangrove_roots.step"));

    /**
     * {@code minecraft:block.medium_amethyst_bud.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MEDIUM_AMETHYST_BUD_BREAK = create(key("block.medium_amethyst_bud.break"));

    /**
     * {@code minecraft:block.medium_amethyst_bud.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MEDIUM_AMETHYST_BUD_PLACE = create(key("block.medium_amethyst_bud.place"));

    /**
     * {@code minecraft:block.metal.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_METAL_BREAK = create(key("block.metal.break"));

    /**
     * {@code minecraft:block.metal.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_METAL_FALL = create(key("block.metal.fall"));

    /**
     * {@code minecraft:block.metal.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_METAL_HIT = create(key("block.metal.hit"));

    /**
     * {@code minecraft:block.metal.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_METAL_PLACE = create(key("block.metal.place"));

    /**
     * {@code minecraft:block.metal.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_METAL_STEP = create(key("block.metal.step"));

    /**
     * {@code minecraft:block.metal_pressure_plate.click_off}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_METAL_PRESSURE_PLATE_CLICK_OFF = create(key("block.metal_pressure_plate.click_off"));

    /**
     * {@code minecraft:block.metal_pressure_plate.click_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_METAL_PRESSURE_PLATE_CLICK_ON = create(key("block.metal_pressure_plate.click_on"));

    /**
     * {@code minecraft:block.moss.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MOSS_BREAK = create(key("block.moss.break"));

    /**
     * {@code minecraft:block.moss.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MOSS_FALL = create(key("block.moss.fall"));

    /**
     * {@code minecraft:block.moss.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MOSS_HIT = create(key("block.moss.hit"));

    /**
     * {@code minecraft:block.moss.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MOSS_PLACE = create(key("block.moss.place"));

    /**
     * {@code minecraft:block.moss.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MOSS_STEP = create(key("block.moss.step"));

    /**
     * {@code minecraft:block.moss_carpet.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MOSS_CARPET_BREAK = create(key("block.moss_carpet.break"));

    /**
     * {@code minecraft:block.moss_carpet.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MOSS_CARPET_FALL = create(key("block.moss_carpet.fall"));

    /**
     * {@code minecraft:block.moss_carpet.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MOSS_CARPET_HIT = create(key("block.moss_carpet.hit"));

    /**
     * {@code minecraft:block.moss_carpet.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MOSS_CARPET_PLACE = create(key("block.moss_carpet.place"));

    /**
     * {@code minecraft:block.moss_carpet.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MOSS_CARPET_STEP = create(key("block.moss_carpet.step"));

    /**
     * {@code minecraft:block.mud.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MUD_BREAK = create(key("block.mud.break"));

    /**
     * {@code minecraft:block.mud.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MUD_FALL = create(key("block.mud.fall"));

    /**
     * {@code minecraft:block.mud.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MUD_HIT = create(key("block.mud.hit"));

    /**
     * {@code minecraft:block.mud.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MUD_PLACE = create(key("block.mud.place"));

    /**
     * {@code minecraft:block.mud.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MUD_STEP = create(key("block.mud.step"));

    /**
     * {@code minecraft:block.mud_bricks.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MUD_BRICKS_BREAK = create(key("block.mud_bricks.break"));

    /**
     * {@code minecraft:block.mud_bricks.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MUD_BRICKS_FALL = create(key("block.mud_bricks.fall"));

    /**
     * {@code minecraft:block.mud_bricks.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MUD_BRICKS_HIT = create(key("block.mud_bricks.hit"));

    /**
     * {@code minecraft:block.mud_bricks.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MUD_BRICKS_PLACE = create(key("block.mud_bricks.place"));

    /**
     * {@code minecraft:block.mud_bricks.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MUD_BRICKS_STEP = create(key("block.mud_bricks.step"));

    /**
     * {@code minecraft:block.muddy_mangrove_roots.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MUDDY_MANGROVE_ROOTS_BREAK = create(key("block.muddy_mangrove_roots.break"));

    /**
     * {@code minecraft:block.muddy_mangrove_roots.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MUDDY_MANGROVE_ROOTS_FALL = create(key("block.muddy_mangrove_roots.fall"));

    /**
     * {@code minecraft:block.muddy_mangrove_roots.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MUDDY_MANGROVE_ROOTS_HIT = create(key("block.muddy_mangrove_roots.hit"));

    /**
     * {@code minecraft:block.muddy_mangrove_roots.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MUDDY_MANGROVE_ROOTS_PLACE = create(key("block.muddy_mangrove_roots.place"));

    /**
     * {@code minecraft:block.muddy_mangrove_roots.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_MUDDY_MANGROVE_ROOTS_STEP = create(key("block.muddy_mangrove_roots.step"));

    /**
     * {@code minecraft:block.nether_bricks.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_BRICKS_BREAK = create(key("block.nether_bricks.break"));

    /**
     * {@code minecraft:block.nether_bricks.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_BRICKS_FALL = create(key("block.nether_bricks.fall"));

    /**
     * {@code minecraft:block.nether_bricks.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_BRICKS_HIT = create(key("block.nether_bricks.hit"));

    /**
     * {@code minecraft:block.nether_bricks.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_BRICKS_PLACE = create(key("block.nether_bricks.place"));

    /**
     * {@code minecraft:block.nether_bricks.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_BRICKS_STEP = create(key("block.nether_bricks.step"));

    /**
     * {@code minecraft:block.nether_gold_ore.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_GOLD_ORE_BREAK = create(key("block.nether_gold_ore.break"));

    /**
     * {@code minecraft:block.nether_gold_ore.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_GOLD_ORE_FALL = create(key("block.nether_gold_ore.fall"));

    /**
     * {@code minecraft:block.nether_gold_ore.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_GOLD_ORE_HIT = create(key("block.nether_gold_ore.hit"));

    /**
     * {@code minecraft:block.nether_gold_ore.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_GOLD_ORE_PLACE = create(key("block.nether_gold_ore.place"));

    /**
     * {@code minecraft:block.nether_gold_ore.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_GOLD_ORE_STEP = create(key("block.nether_gold_ore.step"));

    /**
     * {@code minecraft:block.nether_ore.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_ORE_BREAK = create(key("block.nether_ore.break"));

    /**
     * {@code minecraft:block.nether_ore.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_ORE_FALL = create(key("block.nether_ore.fall"));

    /**
     * {@code minecraft:block.nether_ore.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_ORE_HIT = create(key("block.nether_ore.hit"));

    /**
     * {@code minecraft:block.nether_ore.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_ORE_PLACE = create(key("block.nether_ore.place"));

    /**
     * {@code minecraft:block.nether_ore.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_ORE_STEP = create(key("block.nether_ore.step"));

    /**
     * {@code minecraft:block.nether_sprouts.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_SPROUTS_BREAK = create(key("block.nether_sprouts.break"));

    /**
     * {@code minecraft:block.nether_sprouts.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_SPROUTS_FALL = create(key("block.nether_sprouts.fall"));

    /**
     * {@code minecraft:block.nether_sprouts.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_SPROUTS_HIT = create(key("block.nether_sprouts.hit"));

    /**
     * {@code minecraft:block.nether_sprouts.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_SPROUTS_PLACE = create(key("block.nether_sprouts.place"));

    /**
     * {@code minecraft:block.nether_sprouts.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_SPROUTS_STEP = create(key("block.nether_sprouts.step"));

    /**
     * {@code minecraft:block.nether_wart.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WART_BREAK = create(key("block.nether_wart.break"));

    /**
     * {@code minecraft:block.nether_wood.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_BREAK = create(key("block.nether_wood.break"));

    /**
     * {@code minecraft:block.nether_wood.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_FALL = create(key("block.nether_wood.fall"));

    /**
     * {@code minecraft:block.nether_wood.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_HIT = create(key("block.nether_wood.hit"));

    /**
     * {@code minecraft:block.nether_wood.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_PLACE = create(key("block.nether_wood.place"));

    /**
     * {@code minecraft:block.nether_wood.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_STEP = create(key("block.nether_wood.step"));

    /**
     * {@code minecraft:block.nether_wood_button.click_off}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_BUTTON_CLICK_OFF = create(key("block.nether_wood_button.click_off"));

    /**
     * {@code minecraft:block.nether_wood_button.click_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_BUTTON_CLICK_ON = create(key("block.nether_wood_button.click_on"));

    /**
     * {@code minecraft:block.nether_wood_door.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_DOOR_CLOSE = create(key("block.nether_wood_door.close"));

    /**
     * {@code minecraft:block.nether_wood_door.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_DOOR_OPEN = create(key("block.nether_wood_door.open"));

    /**
     * {@code minecraft:block.nether_wood_fence_gate.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_FENCE_GATE_CLOSE = create(key("block.nether_wood_fence_gate.close"));

    /**
     * {@code minecraft:block.nether_wood_fence_gate.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_FENCE_GATE_OPEN = create(key("block.nether_wood_fence_gate.open"));

    /**
     * {@code minecraft:block.nether_wood_hanging_sign.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_HANGING_SIGN_BREAK = create(key("block.nether_wood_hanging_sign.break"));

    /**
     * {@code minecraft:block.nether_wood_hanging_sign.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_HANGING_SIGN_FALL = create(key("block.nether_wood_hanging_sign.fall"));

    /**
     * {@code minecraft:block.nether_wood_hanging_sign.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_HANGING_SIGN_HIT = create(key("block.nether_wood_hanging_sign.hit"));

    /**
     * {@code minecraft:block.nether_wood_hanging_sign.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_HANGING_SIGN_PLACE = create(key("block.nether_wood_hanging_sign.place"));

    /**
     * {@code minecraft:block.nether_wood_hanging_sign.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_HANGING_SIGN_STEP = create(key("block.nether_wood_hanging_sign.step"));

    /**
     * {@code minecraft:block.nether_wood_pressure_plate.click_off}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_PRESSURE_PLATE_CLICK_OFF = create(key("block.nether_wood_pressure_plate.click_off"));

    /**
     * {@code minecraft:block.nether_wood_pressure_plate.click_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_PRESSURE_PLATE_CLICK_ON = create(key("block.nether_wood_pressure_plate.click_on"));

    /**
     * {@code minecraft:block.nether_wood_trapdoor.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_TRAPDOOR_CLOSE = create(key("block.nether_wood_trapdoor.close"));

    /**
     * {@code minecraft:block.nether_wood_trapdoor.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHER_WOOD_TRAPDOOR_OPEN = create(key("block.nether_wood_trapdoor.open"));

    /**
     * {@code minecraft:block.netherite_block.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHERITE_BLOCK_BREAK = create(key("block.netherite_block.break"));

    /**
     * {@code minecraft:block.netherite_block.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHERITE_BLOCK_FALL = create(key("block.netherite_block.fall"));

    /**
     * {@code minecraft:block.netherite_block.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHERITE_BLOCK_HIT = create(key("block.netherite_block.hit"));

    /**
     * {@code minecraft:block.netherite_block.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHERITE_BLOCK_PLACE = create(key("block.netherite_block.place"));

    /**
     * {@code minecraft:block.netherite_block.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHERITE_BLOCK_STEP = create(key("block.netherite_block.step"));

    /**
     * {@code minecraft:block.netherrack.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHERRACK_BREAK = create(key("block.netherrack.break"));

    /**
     * {@code minecraft:block.netherrack.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHERRACK_FALL = create(key("block.netherrack.fall"));

    /**
     * {@code minecraft:block.netherrack.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHERRACK_HIT = create(key("block.netherrack.hit"));

    /**
     * {@code minecraft:block.netherrack.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHERRACK_PLACE = create(key("block.netherrack.place"));

    /**
     * {@code minecraft:block.netherrack.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NETHERRACK_STEP = create(key("block.netherrack.step"));

    /**
     * {@code minecraft:block.note_block.banjo}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_BANJO = create(key("block.note_block.banjo"));

    /**
     * {@code minecraft:block.note_block.basedrum}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_BASEDRUM = create(key("block.note_block.basedrum"));

    /**
     * {@code minecraft:block.note_block.bass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_BASS = create(key("block.note_block.bass"));

    /**
     * {@code minecraft:block.note_block.bell}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_BELL = create(key("block.note_block.bell"));

    /**
     * {@code minecraft:block.note_block.bit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_BIT = create(key("block.note_block.bit"));

    /**
     * {@code minecraft:block.note_block.chime}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_CHIME = create(key("block.note_block.chime"));

    /**
     * {@code minecraft:block.note_block.cow_bell}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_COW_BELL = create(key("block.note_block.cow_bell"));

    /**
     * {@code minecraft:block.note_block.didgeridoo}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_DIDGERIDOO = create(key("block.note_block.didgeridoo"));

    /**
     * {@code minecraft:block.note_block.flute}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_FLUTE = create(key("block.note_block.flute"));

    /**
     * {@code minecraft:block.note_block.guitar}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_GUITAR = create(key("block.note_block.guitar"));

    /**
     * {@code minecraft:block.note_block.harp}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_HARP = create(key("block.note_block.harp"));

    /**
     * {@code minecraft:block.note_block.hat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_HAT = create(key("block.note_block.hat"));

    /**
     * {@code minecraft:block.note_block.imitate.creeper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_IMITATE_CREEPER = create(key("block.note_block.imitate.creeper"));

    /**
     * {@code minecraft:block.note_block.imitate.ender_dragon}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_IMITATE_ENDER_DRAGON = create(key("block.note_block.imitate.ender_dragon"));

    /**
     * {@code minecraft:block.note_block.imitate.piglin}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_IMITATE_PIGLIN = create(key("block.note_block.imitate.piglin"));

    /**
     * {@code minecraft:block.note_block.imitate.skeleton}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_IMITATE_SKELETON = create(key("block.note_block.imitate.skeleton"));

    /**
     * {@code minecraft:block.note_block.imitate.wither_skeleton}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_IMITATE_WITHER_SKELETON = create(key("block.note_block.imitate.wither_skeleton"));

    /**
     * {@code minecraft:block.note_block.imitate.zombie}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_IMITATE_ZOMBIE = create(key("block.note_block.imitate.zombie"));

    /**
     * {@code minecraft:block.note_block.iron_xylophone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_IRON_XYLOPHONE = create(key("block.note_block.iron_xylophone"));

    /**
     * {@code minecraft:block.note_block.pling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_PLING = create(key("block.note_block.pling"));

    /**
     * {@code minecraft:block.note_block.snare}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_SNARE = create(key("block.note_block.snare"));

    /**
     * {@code minecraft:block.note_block.xylophone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NOTE_BLOCK_XYLOPHONE = create(key("block.note_block.xylophone"));

    /**
     * {@code minecraft:block.nylium.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NYLIUM_BREAK = create(key("block.nylium.break"));

    /**
     * {@code minecraft:block.nylium.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NYLIUM_FALL = create(key("block.nylium.fall"));

    /**
     * {@code minecraft:block.nylium.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NYLIUM_HIT = create(key("block.nylium.hit"));

    /**
     * {@code minecraft:block.nylium.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NYLIUM_PLACE = create(key("block.nylium.place"));

    /**
     * {@code minecraft:block.nylium.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_NYLIUM_STEP = create(key("block.nylium.step"));

    /**
     * {@code minecraft:block.packed_mud.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_PACKED_MUD_BREAK = create(key("block.packed_mud.break"));

    /**
     * {@code minecraft:block.packed_mud.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_PACKED_MUD_FALL = create(key("block.packed_mud.fall"));

    /**
     * {@code minecraft:block.packed_mud.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_PACKED_MUD_HIT = create(key("block.packed_mud.hit"));

    /**
     * {@code minecraft:block.packed_mud.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_PACKED_MUD_PLACE = create(key("block.packed_mud.place"));

    /**
     * {@code minecraft:block.packed_mud.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_PACKED_MUD_STEP = create(key("block.packed_mud.step"));

    /**
     * {@code minecraft:block.pale_hanging_moss.idle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_PALE_HANGING_MOSS_IDLE = create(key("block.pale_hanging_moss.idle"));

    /**
     * {@code minecraft:block.pink_petals.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_PINK_PETALS_BREAK = create(key("block.pink_petals.break"));

    /**
     * {@code minecraft:block.pink_petals.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_PINK_PETALS_FALL = create(key("block.pink_petals.fall"));

    /**
     * {@code minecraft:block.pink_petals.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_PINK_PETALS_HIT = create(key("block.pink_petals.hit"));

    /**
     * {@code minecraft:block.pink_petals.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_PINK_PETALS_PLACE = create(key("block.pink_petals.place"));

    /**
     * {@code minecraft:block.pink_petals.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_PINK_PETALS_STEP = create(key("block.pink_petals.step"));

    /**
     * {@code minecraft:block.piston.contract}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_PISTON_CONTRACT = create(key("block.piston.contract"));

    /**
     * {@code minecraft:block.piston.extend}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_PISTON_EXTEND = create(key("block.piston.extend"));

    /**
     * {@code minecraft:block.pointed_dripstone.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POINTED_DRIPSTONE_BREAK = create(key("block.pointed_dripstone.break"));

    /**
     * {@code minecraft:block.pointed_dripstone.drip_lava}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POINTED_DRIPSTONE_DRIP_LAVA = create(key("block.pointed_dripstone.drip_lava"));

    /**
     * {@code minecraft:block.pointed_dripstone.drip_lava_into_cauldron}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POINTED_DRIPSTONE_DRIP_LAVA_INTO_CAULDRON = create(key("block.pointed_dripstone.drip_lava_into_cauldron"));

    /**
     * {@code minecraft:block.pointed_dripstone.drip_water}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POINTED_DRIPSTONE_DRIP_WATER = create(key("block.pointed_dripstone.drip_water"));

    /**
     * {@code minecraft:block.pointed_dripstone.drip_water_into_cauldron}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POINTED_DRIPSTONE_DRIP_WATER_INTO_CAULDRON = create(key("block.pointed_dripstone.drip_water_into_cauldron"));

    /**
     * {@code minecraft:block.pointed_dripstone.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POINTED_DRIPSTONE_FALL = create(key("block.pointed_dripstone.fall"));

    /**
     * {@code minecraft:block.pointed_dripstone.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POINTED_DRIPSTONE_HIT = create(key("block.pointed_dripstone.hit"));

    /**
     * {@code minecraft:block.pointed_dripstone.land}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POINTED_DRIPSTONE_LAND = create(key("block.pointed_dripstone.land"));

    /**
     * {@code minecraft:block.pointed_dripstone.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POINTED_DRIPSTONE_PLACE = create(key("block.pointed_dripstone.place"));

    /**
     * {@code minecraft:block.pointed_dripstone.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POINTED_DRIPSTONE_STEP = create(key("block.pointed_dripstone.step"));

    /**
     * {@code minecraft:block.polished_deepslate.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POLISHED_DEEPSLATE_BREAK = create(key("block.polished_deepslate.break"));

    /**
     * {@code minecraft:block.polished_deepslate.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POLISHED_DEEPSLATE_FALL = create(key("block.polished_deepslate.fall"));

    /**
     * {@code minecraft:block.polished_deepslate.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POLISHED_DEEPSLATE_HIT = create(key("block.polished_deepslate.hit"));

    /**
     * {@code minecraft:block.polished_deepslate.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POLISHED_DEEPSLATE_PLACE = create(key("block.polished_deepslate.place"));

    /**
     * {@code minecraft:block.polished_deepslate.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POLISHED_DEEPSLATE_STEP = create(key("block.polished_deepslate.step"));

    /**
     * {@code minecraft:block.polished_tuff.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POLISHED_TUFF_BREAK = create(key("block.polished_tuff.break"));

    /**
     * {@code minecraft:block.polished_tuff.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POLISHED_TUFF_FALL = create(key("block.polished_tuff.fall"));

    /**
     * {@code minecraft:block.polished_tuff.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POLISHED_TUFF_HIT = create(key("block.polished_tuff.hit"));

    /**
     * {@code minecraft:block.polished_tuff.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POLISHED_TUFF_PLACE = create(key("block.polished_tuff.place"));

    /**
     * {@code minecraft:block.polished_tuff.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POLISHED_TUFF_STEP = create(key("block.polished_tuff.step"));

    /**
     * {@code minecraft:block.portal.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_PORTAL_AMBIENT = create(key("block.portal.ambient"));

    /**
     * {@code minecraft:block.portal.travel}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_PORTAL_TRAVEL = create(key("block.portal.travel"));

    /**
     * {@code minecraft:block.portal.trigger}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_PORTAL_TRIGGER = create(key("block.portal.trigger"));

    /**
     * {@code minecraft:block.powder_snow.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POWDER_SNOW_BREAK = create(key("block.powder_snow.break"));

    /**
     * {@code minecraft:block.powder_snow.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POWDER_SNOW_FALL = create(key("block.powder_snow.fall"));

    /**
     * {@code minecraft:block.powder_snow.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POWDER_SNOW_HIT = create(key("block.powder_snow.hit"));

    /**
     * {@code minecraft:block.powder_snow.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POWDER_SNOW_PLACE = create(key("block.powder_snow.place"));

    /**
     * {@code minecraft:block.powder_snow.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_POWDER_SNOW_STEP = create(key("block.powder_snow.step"));

    /**
     * {@code minecraft:block.pumpkin.carve}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_PUMPKIN_CARVE = create(key("block.pumpkin.carve"));

    /**
     * {@code minecraft:block.redstone_torch.burnout}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_REDSTONE_TORCH_BURNOUT = create(key("block.redstone_torch.burnout"));

    /**
     * {@code minecraft:block.resin.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_RESIN_BREAK = create(key("block.resin.break"));

    /**
     * {@code minecraft:block.resin.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_RESIN_FALL = create(key("block.resin.fall"));

    /**
     * {@code minecraft:block.resin.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_RESIN_PLACE = create(key("block.resin.place"));

    /**
     * {@code minecraft:block.resin.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_RESIN_STEP = create(key("block.resin.step"));

    /**
     * {@code minecraft:block.resin_bricks.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_RESIN_BRICKS_BREAK = create(key("block.resin_bricks.break"));

    /**
     * {@code minecraft:block.resin_bricks.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_RESIN_BRICKS_FALL = create(key("block.resin_bricks.fall"));

    /**
     * {@code minecraft:block.resin_bricks.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_RESIN_BRICKS_HIT = create(key("block.resin_bricks.hit"));

    /**
     * {@code minecraft:block.resin_bricks.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_RESIN_BRICKS_PLACE = create(key("block.resin_bricks.place"));

    /**
     * {@code minecraft:block.resin_bricks.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_RESIN_BRICKS_STEP = create(key("block.resin_bricks.step"));

    /**
     * {@code minecraft:block.respawn_anchor.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_RESPAWN_ANCHOR_AMBIENT = create(key("block.respawn_anchor.ambient"));

    /**
     * {@code minecraft:block.respawn_anchor.charge}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_RESPAWN_ANCHOR_CHARGE = create(key("block.respawn_anchor.charge"));

    /**
     * {@code minecraft:block.respawn_anchor.deplete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_RESPAWN_ANCHOR_DEPLETE = create(key("block.respawn_anchor.deplete"));

    /**
     * {@code minecraft:block.respawn_anchor.set_spawn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_RESPAWN_ANCHOR_SET_SPAWN = create(key("block.respawn_anchor.set_spawn"));

    /**
     * {@code minecraft:block.rooted_dirt.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ROOTED_DIRT_BREAK = create(key("block.rooted_dirt.break"));

    /**
     * {@code minecraft:block.rooted_dirt.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ROOTED_DIRT_FALL = create(key("block.rooted_dirt.fall"));

    /**
     * {@code minecraft:block.rooted_dirt.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ROOTED_DIRT_HIT = create(key("block.rooted_dirt.hit"));

    /**
     * {@code minecraft:block.rooted_dirt.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ROOTED_DIRT_PLACE = create(key("block.rooted_dirt.place"));

    /**
     * {@code minecraft:block.rooted_dirt.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ROOTED_DIRT_STEP = create(key("block.rooted_dirt.step"));

    /**
     * {@code minecraft:block.roots.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ROOTS_BREAK = create(key("block.roots.break"));

    /**
     * {@code minecraft:block.roots.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ROOTS_FALL = create(key("block.roots.fall"));

    /**
     * {@code minecraft:block.roots.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ROOTS_HIT = create(key("block.roots.hit"));

    /**
     * {@code minecraft:block.roots.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ROOTS_PLACE = create(key("block.roots.place"));

    /**
     * {@code minecraft:block.roots.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_ROOTS_STEP = create(key("block.roots.step"));

    /**
     * {@code minecraft:block.sand.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SAND_BREAK = create(key("block.sand.break"));

    /**
     * {@code minecraft:block.sand.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SAND_FALL = create(key("block.sand.fall"));

    /**
     * {@code minecraft:block.sand.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SAND_HIT = create(key("block.sand.hit"));

    /**
     * {@code minecraft:block.sand.idle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SAND_IDLE = create(key("block.sand.idle"));

    /**
     * {@code minecraft:block.sand.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SAND_PLACE = create(key("block.sand.place"));

    /**
     * {@code minecraft:block.sand.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SAND_STEP = create(key("block.sand.step"));

    /**
     * {@code minecraft:block.scaffolding.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCAFFOLDING_BREAK = create(key("block.scaffolding.break"));

    /**
     * {@code minecraft:block.scaffolding.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCAFFOLDING_FALL = create(key("block.scaffolding.fall"));

    /**
     * {@code minecraft:block.scaffolding.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCAFFOLDING_HIT = create(key("block.scaffolding.hit"));

    /**
     * {@code minecraft:block.scaffolding.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCAFFOLDING_PLACE = create(key("block.scaffolding.place"));

    /**
     * {@code minecraft:block.scaffolding.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCAFFOLDING_STEP = create(key("block.scaffolding.step"));

    /**
     * {@code minecraft:block.sculk.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_BREAK = create(key("block.sculk.break"));

    /**
     * {@code minecraft:block.sculk.charge}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_CHARGE = create(key("block.sculk.charge"));

    /**
     * {@code minecraft:block.sculk.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_FALL = create(key("block.sculk.fall"));

    /**
     * {@code minecraft:block.sculk.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_HIT = create(key("block.sculk.hit"));

    /**
     * {@code minecraft:block.sculk.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_PLACE = create(key("block.sculk.place"));

    /**
     * {@code minecraft:block.sculk.spread}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_SPREAD = create(key("block.sculk.spread"));

    /**
     * {@code minecraft:block.sculk.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_STEP = create(key("block.sculk.step"));

    /**
     * {@code minecraft:block.sculk_catalyst.bloom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_CATALYST_BLOOM = create(key("block.sculk_catalyst.bloom"));

    /**
     * {@code minecraft:block.sculk_catalyst.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_CATALYST_BREAK = create(key("block.sculk_catalyst.break"));

    /**
     * {@code minecraft:block.sculk_catalyst.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_CATALYST_FALL = create(key("block.sculk_catalyst.fall"));

    /**
     * {@code minecraft:block.sculk_catalyst.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_CATALYST_HIT = create(key("block.sculk_catalyst.hit"));

    /**
     * {@code minecraft:block.sculk_catalyst.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_CATALYST_PLACE = create(key("block.sculk_catalyst.place"));

    /**
     * {@code minecraft:block.sculk_catalyst.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_CATALYST_STEP = create(key("block.sculk_catalyst.step"));

    /**
     * {@code minecraft:block.sculk_sensor.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_SENSOR_BREAK = create(key("block.sculk_sensor.break"));

    /**
     * {@code minecraft:block.sculk_sensor.clicking}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_SENSOR_CLICKING = create(key("block.sculk_sensor.clicking"));

    /**
     * {@code minecraft:block.sculk_sensor.clicking_stop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_SENSOR_CLICKING_STOP = create(key("block.sculk_sensor.clicking_stop"));

    /**
     * {@code minecraft:block.sculk_sensor.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_SENSOR_FALL = create(key("block.sculk_sensor.fall"));

    /**
     * {@code minecraft:block.sculk_sensor.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_SENSOR_HIT = create(key("block.sculk_sensor.hit"));

    /**
     * {@code minecraft:block.sculk_sensor.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_SENSOR_PLACE = create(key("block.sculk_sensor.place"));

    /**
     * {@code minecraft:block.sculk_sensor.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_SENSOR_STEP = create(key("block.sculk_sensor.step"));

    /**
     * {@code minecraft:block.sculk_shrieker.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_SHRIEKER_BREAK = create(key("block.sculk_shrieker.break"));

    /**
     * {@code minecraft:block.sculk_shrieker.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_SHRIEKER_FALL = create(key("block.sculk_shrieker.fall"));

    /**
     * {@code minecraft:block.sculk_shrieker.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_SHRIEKER_HIT = create(key("block.sculk_shrieker.hit"));

    /**
     * {@code minecraft:block.sculk_shrieker.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_SHRIEKER_PLACE = create(key("block.sculk_shrieker.place"));

    /**
     * {@code minecraft:block.sculk_shrieker.shriek}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_SHRIEKER_SHRIEK = create(key("block.sculk_shrieker.shriek"));

    /**
     * {@code minecraft:block.sculk_shrieker.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_SHRIEKER_STEP = create(key("block.sculk_shrieker.step"));

    /**
     * {@code minecraft:block.sculk_vein.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_VEIN_BREAK = create(key("block.sculk_vein.break"));

    /**
     * {@code minecraft:block.sculk_vein.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_VEIN_FALL = create(key("block.sculk_vein.fall"));

    /**
     * {@code minecraft:block.sculk_vein.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_VEIN_HIT = create(key("block.sculk_vein.hit"));

    /**
     * {@code minecraft:block.sculk_vein.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_VEIN_PLACE = create(key("block.sculk_vein.place"));

    /**
     * {@code minecraft:block.sculk_vein.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SCULK_VEIN_STEP = create(key("block.sculk_vein.step"));

    /**
     * {@code minecraft:block.shroomlight.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SHROOMLIGHT_BREAK = create(key("block.shroomlight.break"));

    /**
     * {@code minecraft:block.shroomlight.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SHROOMLIGHT_FALL = create(key("block.shroomlight.fall"));

    /**
     * {@code minecraft:block.shroomlight.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SHROOMLIGHT_HIT = create(key("block.shroomlight.hit"));

    /**
     * {@code minecraft:block.shroomlight.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SHROOMLIGHT_PLACE = create(key("block.shroomlight.place"));

    /**
     * {@code minecraft:block.shroomlight.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SHROOMLIGHT_STEP = create(key("block.shroomlight.step"));

    /**
     * {@code minecraft:block.shulker_box.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SHULKER_BOX_CLOSE = create(key("block.shulker_box.close"));

    /**
     * {@code minecraft:block.shulker_box.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SHULKER_BOX_OPEN = create(key("block.shulker_box.open"));

    /**
     * {@code minecraft:block.sign.waxed_interact_fail}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SIGN_WAXED_INTERACT_FAIL = create(key("block.sign.waxed_interact_fail"));

    /**
     * {@code minecraft:block.slime_block.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SLIME_BLOCK_BREAK = create(key("block.slime_block.break"));

    /**
     * {@code minecraft:block.slime_block.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SLIME_BLOCK_FALL = create(key("block.slime_block.fall"));

    /**
     * {@code minecraft:block.slime_block.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SLIME_BLOCK_HIT = create(key("block.slime_block.hit"));

    /**
     * {@code minecraft:block.slime_block.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SLIME_BLOCK_PLACE = create(key("block.slime_block.place"));

    /**
     * {@code minecraft:block.slime_block.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SLIME_BLOCK_STEP = create(key("block.slime_block.step"));

    /**
     * {@code minecraft:block.small_amethyst_bud.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SMALL_AMETHYST_BUD_BREAK = create(key("block.small_amethyst_bud.break"));

    /**
     * {@code minecraft:block.small_amethyst_bud.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SMALL_AMETHYST_BUD_PLACE = create(key("block.small_amethyst_bud.place"));

    /**
     * {@code minecraft:block.small_dripleaf.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SMALL_DRIPLEAF_BREAK = create(key("block.small_dripleaf.break"));

    /**
     * {@code minecraft:block.small_dripleaf.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SMALL_DRIPLEAF_FALL = create(key("block.small_dripleaf.fall"));

    /**
     * {@code minecraft:block.small_dripleaf.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SMALL_DRIPLEAF_HIT = create(key("block.small_dripleaf.hit"));

    /**
     * {@code minecraft:block.small_dripleaf.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SMALL_DRIPLEAF_PLACE = create(key("block.small_dripleaf.place"));

    /**
     * {@code minecraft:block.small_dripleaf.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SMALL_DRIPLEAF_STEP = create(key("block.small_dripleaf.step"));

    /**
     * {@code minecraft:block.smithing_table.use}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SMITHING_TABLE_USE = create(key("block.smithing_table.use"));

    /**
     * {@code minecraft:block.smoker.smoke}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SMOKER_SMOKE = create(key("block.smoker.smoke"));

    /**
     * {@code minecraft:block.sniffer_egg.crack}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SNIFFER_EGG_CRACK = create(key("block.sniffer_egg.crack"));

    /**
     * {@code minecraft:block.sniffer_egg.hatch}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SNIFFER_EGG_HATCH = create(key("block.sniffer_egg.hatch"));

    /**
     * {@code minecraft:block.sniffer_egg.plop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SNIFFER_EGG_PLOP = create(key("block.sniffer_egg.plop"));

    /**
     * {@code minecraft:block.snow.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SNOW_BREAK = create(key("block.snow.break"));

    /**
     * {@code minecraft:block.snow.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SNOW_FALL = create(key("block.snow.fall"));

    /**
     * {@code minecraft:block.snow.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SNOW_HIT = create(key("block.snow.hit"));

    /**
     * {@code minecraft:block.snow.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SNOW_PLACE = create(key("block.snow.place"));

    /**
     * {@code minecraft:block.snow.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SNOW_STEP = create(key("block.snow.step"));

    /**
     * {@code minecraft:block.soul_sand.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SOUL_SAND_BREAK = create(key("block.soul_sand.break"));

    /**
     * {@code minecraft:block.soul_sand.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SOUL_SAND_FALL = create(key("block.soul_sand.fall"));

    /**
     * {@code minecraft:block.soul_sand.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SOUL_SAND_HIT = create(key("block.soul_sand.hit"));

    /**
     * {@code minecraft:block.soul_sand.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SOUL_SAND_PLACE = create(key("block.soul_sand.place"));

    /**
     * {@code minecraft:block.soul_sand.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SOUL_SAND_STEP = create(key("block.soul_sand.step"));

    /**
     * {@code minecraft:block.soul_soil.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SOUL_SOIL_BREAK = create(key("block.soul_soil.break"));

    /**
     * {@code minecraft:block.soul_soil.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SOUL_SOIL_FALL = create(key("block.soul_soil.fall"));

    /**
     * {@code minecraft:block.soul_soil.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SOUL_SOIL_HIT = create(key("block.soul_soil.hit"));

    /**
     * {@code minecraft:block.soul_soil.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SOUL_SOIL_PLACE = create(key("block.soul_soil.place"));

    /**
     * {@code minecraft:block.soul_soil.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SOUL_SOIL_STEP = create(key("block.soul_soil.step"));

    /**
     * {@code minecraft:block.spawner.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SPAWNER_BREAK = create(key("block.spawner.break"));

    /**
     * {@code minecraft:block.spawner.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SPAWNER_FALL = create(key("block.spawner.fall"));

    /**
     * {@code minecraft:block.spawner.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SPAWNER_HIT = create(key("block.spawner.hit"));

    /**
     * {@code minecraft:block.spawner.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SPAWNER_PLACE = create(key("block.spawner.place"));

    /**
     * {@code minecraft:block.spawner.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SPAWNER_STEP = create(key("block.spawner.step"));

    /**
     * {@code minecraft:block.sponge.absorb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SPONGE_ABSORB = create(key("block.sponge.absorb"));

    /**
     * {@code minecraft:block.sponge.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SPONGE_BREAK = create(key("block.sponge.break"));

    /**
     * {@code minecraft:block.sponge.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SPONGE_FALL = create(key("block.sponge.fall"));

    /**
     * {@code minecraft:block.sponge.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SPONGE_HIT = create(key("block.sponge.hit"));

    /**
     * {@code minecraft:block.sponge.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SPONGE_PLACE = create(key("block.sponge.place"));

    /**
     * {@code minecraft:block.sponge.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SPONGE_STEP = create(key("block.sponge.step"));

    /**
     * {@code minecraft:block.spore_blossom.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SPORE_BLOSSOM_BREAK = create(key("block.spore_blossom.break"));

    /**
     * {@code minecraft:block.spore_blossom.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SPORE_BLOSSOM_FALL = create(key("block.spore_blossom.fall"));

    /**
     * {@code minecraft:block.spore_blossom.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SPORE_BLOSSOM_HIT = create(key("block.spore_blossom.hit"));

    /**
     * {@code minecraft:block.spore_blossom.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SPORE_BLOSSOM_PLACE = create(key("block.spore_blossom.place"));

    /**
     * {@code minecraft:block.spore_blossom.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SPORE_BLOSSOM_STEP = create(key("block.spore_blossom.step"));

    /**
     * {@code minecraft:block.stem.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_STEM_BREAK = create(key("block.stem.break"));

    /**
     * {@code minecraft:block.stem.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_STEM_FALL = create(key("block.stem.fall"));

    /**
     * {@code minecraft:block.stem.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_STEM_HIT = create(key("block.stem.hit"));

    /**
     * {@code minecraft:block.stem.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_STEM_PLACE = create(key("block.stem.place"));

    /**
     * {@code minecraft:block.stem.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_STEM_STEP = create(key("block.stem.step"));

    /**
     * {@code minecraft:block.stone.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_STONE_BREAK = create(key("block.stone.break"));

    /**
     * {@code minecraft:block.stone.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_STONE_FALL = create(key("block.stone.fall"));

    /**
     * {@code minecraft:block.stone.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_STONE_HIT = create(key("block.stone.hit"));

    /**
     * {@code minecraft:block.stone.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_STONE_PLACE = create(key("block.stone.place"));

    /**
     * {@code minecraft:block.stone.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_STONE_STEP = create(key("block.stone.step"));

    /**
     * {@code minecraft:block.stone_button.click_off}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_STONE_BUTTON_CLICK_OFF = create(key("block.stone_button.click_off"));

    /**
     * {@code minecraft:block.stone_button.click_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_STONE_BUTTON_CLICK_ON = create(key("block.stone_button.click_on"));

    /**
     * {@code minecraft:block.stone_pressure_plate.click_off}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_STONE_PRESSURE_PLATE_CLICK_OFF = create(key("block.stone_pressure_plate.click_off"));

    /**
     * {@code minecraft:block.stone_pressure_plate.click_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_STONE_PRESSURE_PLATE_CLICK_ON = create(key("block.stone_pressure_plate.click_on"));

    /**
     * {@code minecraft:block.suspicious_gravel.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SUSPICIOUS_GRAVEL_BREAK = create(key("block.suspicious_gravel.break"));

    /**
     * {@code minecraft:block.suspicious_gravel.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SUSPICIOUS_GRAVEL_FALL = create(key("block.suspicious_gravel.fall"));

    /**
     * {@code minecraft:block.suspicious_gravel.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SUSPICIOUS_GRAVEL_HIT = create(key("block.suspicious_gravel.hit"));

    /**
     * {@code minecraft:block.suspicious_gravel.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SUSPICIOUS_GRAVEL_PLACE = create(key("block.suspicious_gravel.place"));

    /**
     * {@code minecraft:block.suspicious_gravel.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SUSPICIOUS_GRAVEL_STEP = create(key("block.suspicious_gravel.step"));

    /**
     * {@code minecraft:block.suspicious_sand.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SUSPICIOUS_SAND_BREAK = create(key("block.suspicious_sand.break"));

    /**
     * {@code minecraft:block.suspicious_sand.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SUSPICIOUS_SAND_FALL = create(key("block.suspicious_sand.fall"));

    /**
     * {@code minecraft:block.suspicious_sand.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SUSPICIOUS_SAND_HIT = create(key("block.suspicious_sand.hit"));

    /**
     * {@code minecraft:block.suspicious_sand.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SUSPICIOUS_SAND_PLACE = create(key("block.suspicious_sand.place"));

    /**
     * {@code minecraft:block.suspicious_sand.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SUSPICIOUS_SAND_STEP = create(key("block.suspicious_sand.step"));

    /**
     * {@code minecraft:block.sweet_berry_bush.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SWEET_BERRY_BUSH_BREAK = create(key("block.sweet_berry_bush.break"));

    /**
     * {@code minecraft:block.sweet_berry_bush.pick_berries}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SWEET_BERRY_BUSH_PICK_BERRIES = create(key("block.sweet_berry_bush.pick_berries"));

    /**
     * {@code minecraft:block.sweet_berry_bush.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_SWEET_BERRY_BUSH_PLACE = create(key("block.sweet_berry_bush.place"));

    /**
     * {@code minecraft:block.trial_spawner.about_to_spawn_item}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIAL_SPAWNER_ABOUT_TO_SPAWN_ITEM = create(key("block.trial_spawner.about_to_spawn_item"));

    /**
     * {@code minecraft:block.trial_spawner.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIAL_SPAWNER_AMBIENT = create(key("block.trial_spawner.ambient"));

    /**
     * {@code minecraft:block.trial_spawner.ambient_ominous}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIAL_SPAWNER_AMBIENT_OMINOUS = create(key("block.trial_spawner.ambient_ominous"));

    /**
     * {@code minecraft:block.trial_spawner.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIAL_SPAWNER_BREAK = create(key("block.trial_spawner.break"));

    /**
     * {@code minecraft:block.trial_spawner.close_shutter}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIAL_SPAWNER_CLOSE_SHUTTER = create(key("block.trial_spawner.close_shutter"));

    /**
     * {@code minecraft:block.trial_spawner.detect_player}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIAL_SPAWNER_DETECT_PLAYER = create(key("block.trial_spawner.detect_player"));

    /**
     * {@code minecraft:block.trial_spawner.eject_item}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIAL_SPAWNER_EJECT_ITEM = create(key("block.trial_spawner.eject_item"));

    /**
     * {@code minecraft:block.trial_spawner.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIAL_SPAWNER_FALL = create(key("block.trial_spawner.fall"));

    /**
     * {@code minecraft:block.trial_spawner.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIAL_SPAWNER_HIT = create(key("block.trial_spawner.hit"));

    /**
     * {@code minecraft:block.trial_spawner.ominous_activate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIAL_SPAWNER_OMINOUS_ACTIVATE = create(key("block.trial_spawner.ominous_activate"));

    /**
     * {@code minecraft:block.trial_spawner.open_shutter}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIAL_SPAWNER_OPEN_SHUTTER = create(key("block.trial_spawner.open_shutter"));

    /**
     * {@code minecraft:block.trial_spawner.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIAL_SPAWNER_PLACE = create(key("block.trial_spawner.place"));

    /**
     * {@code minecraft:block.trial_spawner.spawn_item}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIAL_SPAWNER_SPAWN_ITEM = create(key("block.trial_spawner.spawn_item"));

    /**
     * {@code minecraft:block.trial_spawner.spawn_item_begin}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIAL_SPAWNER_SPAWN_ITEM_BEGIN = create(key("block.trial_spawner.spawn_item_begin"));

    /**
     * {@code minecraft:block.trial_spawner.spawn_mob}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIAL_SPAWNER_SPAWN_MOB = create(key("block.trial_spawner.spawn_mob"));

    /**
     * {@code minecraft:block.trial_spawner.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIAL_SPAWNER_STEP = create(key("block.trial_spawner.step"));

    /**
     * {@code minecraft:block.tripwire.attach}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIPWIRE_ATTACH = create(key("block.tripwire.attach"));

    /**
     * {@code minecraft:block.tripwire.click_off}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIPWIRE_CLICK_OFF = create(key("block.tripwire.click_off"));

    /**
     * {@code minecraft:block.tripwire.click_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIPWIRE_CLICK_ON = create(key("block.tripwire.click_on"));

    /**
     * {@code minecraft:block.tripwire.detach}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TRIPWIRE_DETACH = create(key("block.tripwire.detach"));

    /**
     * {@code minecraft:block.tuff.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TUFF_BREAK = create(key("block.tuff.break"));

    /**
     * {@code minecraft:block.tuff.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TUFF_FALL = create(key("block.tuff.fall"));

    /**
     * {@code minecraft:block.tuff.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TUFF_HIT = create(key("block.tuff.hit"));

    /**
     * {@code minecraft:block.tuff.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TUFF_PLACE = create(key("block.tuff.place"));

    /**
     * {@code minecraft:block.tuff.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TUFF_STEP = create(key("block.tuff.step"));

    /**
     * {@code minecraft:block.tuff_bricks.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TUFF_BRICKS_BREAK = create(key("block.tuff_bricks.break"));

    /**
     * {@code minecraft:block.tuff_bricks.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TUFF_BRICKS_FALL = create(key("block.tuff_bricks.fall"));

    /**
     * {@code minecraft:block.tuff_bricks.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TUFF_BRICKS_HIT = create(key("block.tuff_bricks.hit"));

    /**
     * {@code minecraft:block.tuff_bricks.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TUFF_BRICKS_PLACE = create(key("block.tuff_bricks.place"));

    /**
     * {@code minecraft:block.tuff_bricks.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_TUFF_BRICKS_STEP = create(key("block.tuff_bricks.step"));

    /**
     * {@code minecraft:block.vault.activate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_VAULT_ACTIVATE = create(key("block.vault.activate"));

    /**
     * {@code minecraft:block.vault.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_VAULT_AMBIENT = create(key("block.vault.ambient"));

    /**
     * {@code minecraft:block.vault.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_VAULT_BREAK = create(key("block.vault.break"));

    /**
     * {@code minecraft:block.vault.close_shutter}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_VAULT_CLOSE_SHUTTER = create(key("block.vault.close_shutter"));

    /**
     * {@code minecraft:block.vault.deactivate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_VAULT_DEACTIVATE = create(key("block.vault.deactivate"));

    /**
     * {@code minecraft:block.vault.eject_item}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_VAULT_EJECT_ITEM = create(key("block.vault.eject_item"));

    /**
     * {@code minecraft:block.vault.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_VAULT_FALL = create(key("block.vault.fall"));

    /**
     * {@code minecraft:block.vault.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_VAULT_HIT = create(key("block.vault.hit"));

    /**
     * {@code minecraft:block.vault.insert_item}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_VAULT_INSERT_ITEM = create(key("block.vault.insert_item"));

    /**
     * {@code minecraft:block.vault.insert_item_fail}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_VAULT_INSERT_ITEM_FAIL = create(key("block.vault.insert_item_fail"));

    /**
     * {@code minecraft:block.vault.open_shutter}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_VAULT_OPEN_SHUTTER = create(key("block.vault.open_shutter"));

    /**
     * {@code minecraft:block.vault.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_VAULT_PLACE = create(key("block.vault.place"));

    /**
     * {@code minecraft:block.vault.reject_rewarded_player}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_VAULT_REJECT_REWARDED_PLAYER = create(key("block.vault.reject_rewarded_player"));

    /**
     * {@code minecraft:block.vault.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_VAULT_STEP = create(key("block.vault.step"));

    /**
     * {@code minecraft:block.vine.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_VINE_BREAK = create(key("block.vine.break"));

    /**
     * {@code minecraft:block.vine.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_VINE_FALL = create(key("block.vine.fall"));

    /**
     * {@code minecraft:block.vine.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_VINE_HIT = create(key("block.vine.hit"));

    /**
     * {@code minecraft:block.vine.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_VINE_PLACE = create(key("block.vine.place"));

    /**
     * {@code minecraft:block.vine.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_VINE_STEP = create(key("block.vine.step"));

    /**
     * {@code minecraft:block.wart_block.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WART_BLOCK_BREAK = create(key("block.wart_block.break"));

    /**
     * {@code minecraft:block.wart_block.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WART_BLOCK_FALL = create(key("block.wart_block.fall"));

    /**
     * {@code minecraft:block.wart_block.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WART_BLOCK_HIT = create(key("block.wart_block.hit"));

    /**
     * {@code minecraft:block.wart_block.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WART_BLOCK_PLACE = create(key("block.wart_block.place"));

    /**
     * {@code minecraft:block.wart_block.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WART_BLOCK_STEP = create(key("block.wart_block.step"));

    /**
     * {@code minecraft:block.water.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WATER_AMBIENT = create(key("block.water.ambient"));

    /**
     * {@code minecraft:block.weeping_vines.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WEEPING_VINES_BREAK = create(key("block.weeping_vines.break"));

    /**
     * {@code minecraft:block.weeping_vines.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WEEPING_VINES_FALL = create(key("block.weeping_vines.fall"));

    /**
     * {@code minecraft:block.weeping_vines.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WEEPING_VINES_HIT = create(key("block.weeping_vines.hit"));

    /**
     * {@code minecraft:block.weeping_vines.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WEEPING_VINES_PLACE = create(key("block.weeping_vines.place"));

    /**
     * {@code minecraft:block.weeping_vines.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WEEPING_VINES_STEP = create(key("block.weeping_vines.step"));

    /**
     * {@code minecraft:block.wet_grass.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WET_GRASS_BREAK = create(key("block.wet_grass.break"));

    /**
     * {@code minecraft:block.wet_grass.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WET_GRASS_FALL = create(key("block.wet_grass.fall"));

    /**
     * {@code minecraft:block.wet_grass.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WET_GRASS_HIT = create(key("block.wet_grass.hit"));

    /**
     * {@code minecraft:block.wet_grass.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WET_GRASS_PLACE = create(key("block.wet_grass.place"));

    /**
     * {@code minecraft:block.wet_grass.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WET_GRASS_STEP = create(key("block.wet_grass.step"));

    /**
     * {@code minecraft:block.wet_sponge.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WET_SPONGE_BREAK = create(key("block.wet_sponge.break"));

    /**
     * {@code minecraft:block.wet_sponge.dries}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WET_SPONGE_DRIES = create(key("block.wet_sponge.dries"));

    /**
     * {@code minecraft:block.wet_sponge.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WET_SPONGE_FALL = create(key("block.wet_sponge.fall"));

    /**
     * {@code minecraft:block.wet_sponge.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WET_SPONGE_HIT = create(key("block.wet_sponge.hit"));

    /**
     * {@code minecraft:block.wet_sponge.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WET_SPONGE_PLACE = create(key("block.wet_sponge.place"));

    /**
     * {@code minecraft:block.wet_sponge.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WET_SPONGE_STEP = create(key("block.wet_sponge.step"));

    /**
     * {@code minecraft:block.wood.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WOOD_BREAK = create(key("block.wood.break"));

    /**
     * {@code minecraft:block.wood.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WOOD_FALL = create(key("block.wood.fall"));

    /**
     * {@code minecraft:block.wood.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WOOD_HIT = create(key("block.wood.hit"));

    /**
     * {@code minecraft:block.wood.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WOOD_PLACE = create(key("block.wood.place"));

    /**
     * {@code minecraft:block.wood.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WOOD_STEP = create(key("block.wood.step"));

    /**
     * {@code minecraft:block.wooden_button.click_off}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WOODEN_BUTTON_CLICK_OFF = create(key("block.wooden_button.click_off"));

    /**
     * {@code minecraft:block.wooden_button.click_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WOODEN_BUTTON_CLICK_ON = create(key("block.wooden_button.click_on"));

    /**
     * {@code minecraft:block.wooden_door.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WOODEN_DOOR_CLOSE = create(key("block.wooden_door.close"));

    /**
     * {@code minecraft:block.wooden_door.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WOODEN_DOOR_OPEN = create(key("block.wooden_door.open"));

    /**
     * {@code minecraft:block.wooden_pressure_plate.click_off}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WOODEN_PRESSURE_PLATE_CLICK_OFF = create(key("block.wooden_pressure_plate.click_off"));

    /**
     * {@code minecraft:block.wooden_pressure_plate.click_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WOODEN_PRESSURE_PLATE_CLICK_ON = create(key("block.wooden_pressure_plate.click_on"));

    /**
     * {@code minecraft:block.wooden_trapdoor.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WOODEN_TRAPDOOR_CLOSE = create(key("block.wooden_trapdoor.close"));

    /**
     * {@code minecraft:block.wooden_trapdoor.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WOODEN_TRAPDOOR_OPEN = create(key("block.wooden_trapdoor.open"));

    /**
     * {@code minecraft:block.wool.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WOOL_BREAK = create(key("block.wool.break"));

    /**
     * {@code minecraft:block.wool.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WOOL_FALL = create(key("block.wool.fall"));

    /**
     * {@code minecraft:block.wool.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WOOL_HIT = create(key("block.wool.hit"));

    /**
     * {@code minecraft:block.wool.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WOOL_PLACE = create(key("block.wool.place"));

    /**
     * {@code minecraft:block.wool.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> BLOCK_WOOL_STEP = create(key("block.wool.step"));

    /**
     * {@code minecraft:enchant.thorns.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENCHANT_THORNS_HIT = create(key("enchant.thorns.hit"));

    /**
     * {@code minecraft:entity.allay.ambient_with_item}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ALLAY_AMBIENT_WITH_ITEM = create(key("entity.allay.ambient_with_item"));

    /**
     * {@code minecraft:entity.allay.ambient_without_item}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ALLAY_AMBIENT_WITHOUT_ITEM = create(key("entity.allay.ambient_without_item"));

    /**
     * {@code minecraft:entity.allay.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ALLAY_DEATH = create(key("entity.allay.death"));

    /**
     * {@code minecraft:entity.allay.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ALLAY_HURT = create(key("entity.allay.hurt"));

    /**
     * {@code minecraft:entity.allay.item_given}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ALLAY_ITEM_GIVEN = create(key("entity.allay.item_given"));

    /**
     * {@code minecraft:entity.allay.item_taken}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ALLAY_ITEM_TAKEN = create(key("entity.allay.item_taken"));

    /**
     * {@code minecraft:entity.allay.item_thrown}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ALLAY_ITEM_THROWN = create(key("entity.allay.item_thrown"));

    /**
     * {@code minecraft:entity.armadillo.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARMADILLO_AMBIENT = create(key("entity.armadillo.ambient"));

    /**
     * {@code minecraft:entity.armadillo.brush}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARMADILLO_BRUSH = create(key("entity.armadillo.brush"));

    /**
     * {@code minecraft:entity.armadillo.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARMADILLO_DEATH = create(key("entity.armadillo.death"));

    /**
     * {@code minecraft:entity.armadillo.eat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARMADILLO_EAT = create(key("entity.armadillo.eat"));

    /**
     * {@code minecraft:entity.armadillo.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARMADILLO_HURT = create(key("entity.armadillo.hurt"));

    /**
     * {@code minecraft:entity.armadillo.hurt_reduced}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARMADILLO_HURT_REDUCED = create(key("entity.armadillo.hurt_reduced"));

    /**
     * {@code minecraft:entity.armadillo.land}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARMADILLO_LAND = create(key("entity.armadillo.land"));

    /**
     * {@code minecraft:entity.armadillo.peek}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARMADILLO_PEEK = create(key("entity.armadillo.peek"));

    /**
     * {@code minecraft:entity.armadillo.roll}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARMADILLO_ROLL = create(key("entity.armadillo.roll"));

    /**
     * {@code minecraft:entity.armadillo.scute_drop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARMADILLO_SCUTE_DROP = create(key("entity.armadillo.scute_drop"));

    /**
     * {@code minecraft:entity.armadillo.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARMADILLO_STEP = create(key("entity.armadillo.step"));

    /**
     * {@code minecraft:entity.armadillo.unroll_finish}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARMADILLO_UNROLL_FINISH = create(key("entity.armadillo.unroll_finish"));

    /**
     * {@code minecraft:entity.armadillo.unroll_start}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARMADILLO_UNROLL_START = create(key("entity.armadillo.unroll_start"));

    /**
     * {@code minecraft:entity.armor_stand.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARMOR_STAND_BREAK = create(key("entity.armor_stand.break"));

    /**
     * {@code minecraft:entity.armor_stand.fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARMOR_STAND_FALL = create(key("entity.armor_stand.fall"));

    /**
     * {@code minecraft:entity.armor_stand.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARMOR_STAND_HIT = create(key("entity.armor_stand.hit"));

    /**
     * {@code minecraft:entity.armor_stand.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARMOR_STAND_PLACE = create(key("entity.armor_stand.place"));

    /**
     * {@code minecraft:entity.arrow.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARROW_HIT = create(key("entity.arrow.hit"));

    /**
     * {@code minecraft:entity.arrow.hit_player}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARROW_HIT_PLAYER = create(key("entity.arrow.hit_player"));

    /**
     * {@code minecraft:entity.arrow.shoot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ARROW_SHOOT = create(key("entity.arrow.shoot"));

    /**
     * {@code minecraft:entity.axolotl.attack}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_AXOLOTL_ATTACK = create(key("entity.axolotl.attack"));

    /**
     * {@code minecraft:entity.axolotl.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_AXOLOTL_DEATH = create(key("entity.axolotl.death"));

    /**
     * {@code minecraft:entity.axolotl.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_AXOLOTL_HURT = create(key("entity.axolotl.hurt"));

    /**
     * {@code minecraft:entity.axolotl.idle_air}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_AXOLOTL_IDLE_AIR = create(key("entity.axolotl.idle_air"));

    /**
     * {@code minecraft:entity.axolotl.idle_water}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_AXOLOTL_IDLE_WATER = create(key("entity.axolotl.idle_water"));

    /**
     * {@code minecraft:entity.axolotl.splash}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_AXOLOTL_SPLASH = create(key("entity.axolotl.splash"));

    /**
     * {@code minecraft:entity.axolotl.swim}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_AXOLOTL_SWIM = create(key("entity.axolotl.swim"));

    /**
     * {@code minecraft:entity.bat.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BAT_AMBIENT = create(key("entity.bat.ambient"));

    /**
     * {@code minecraft:entity.bat.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BAT_DEATH = create(key("entity.bat.death"));

    /**
     * {@code minecraft:entity.bat.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BAT_HURT = create(key("entity.bat.hurt"));

    /**
     * {@code minecraft:entity.bat.loop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BAT_LOOP = create(key("entity.bat.loop"));

    /**
     * {@code minecraft:entity.bat.takeoff}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BAT_TAKEOFF = create(key("entity.bat.takeoff"));

    /**
     * {@code minecraft:entity.bee.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BEE_DEATH = create(key("entity.bee.death"));

    /**
     * {@code minecraft:entity.bee.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BEE_HURT = create(key("entity.bee.hurt"));

    /**
     * {@code minecraft:entity.bee.loop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BEE_LOOP = create(key("entity.bee.loop"));

    /**
     * {@code minecraft:entity.bee.loop_aggressive}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BEE_LOOP_AGGRESSIVE = create(key("entity.bee.loop_aggressive"));

    /**
     * {@code minecraft:entity.bee.pollinate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BEE_POLLINATE = create(key("entity.bee.pollinate"));

    /**
     * {@code minecraft:entity.bee.sting}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BEE_STING = create(key("entity.bee.sting"));

    /**
     * {@code minecraft:entity.blaze.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BLAZE_AMBIENT = create(key("entity.blaze.ambient"));

    /**
     * {@code minecraft:entity.blaze.burn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BLAZE_BURN = create(key("entity.blaze.burn"));

    /**
     * {@code minecraft:entity.blaze.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BLAZE_DEATH = create(key("entity.blaze.death"));

    /**
     * {@code minecraft:entity.blaze.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BLAZE_HURT = create(key("entity.blaze.hurt"));

    /**
     * {@code minecraft:entity.blaze.shoot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BLAZE_SHOOT = create(key("entity.blaze.shoot"));

    /**
     * {@code minecraft:entity.boat.paddle_land}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BOAT_PADDLE_LAND = create(key("entity.boat.paddle_land"));

    /**
     * {@code minecraft:entity.boat.paddle_water}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BOAT_PADDLE_WATER = create(key("entity.boat.paddle_water"));

    /**
     * {@code minecraft:entity.bogged.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BOGGED_AMBIENT = create(key("entity.bogged.ambient"));

    /**
     * {@code minecraft:entity.bogged.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BOGGED_DEATH = create(key("entity.bogged.death"));

    /**
     * {@code minecraft:entity.bogged.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BOGGED_HURT = create(key("entity.bogged.hurt"));

    /**
     * {@code minecraft:entity.bogged.shear}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BOGGED_SHEAR = create(key("entity.bogged.shear"));

    /**
     * {@code minecraft:entity.bogged.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BOGGED_STEP = create(key("entity.bogged.step"));

    /**
     * {@code minecraft:entity.breeze.charge}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BREEZE_CHARGE = create(key("entity.breeze.charge"));

    /**
     * {@code minecraft:entity.breeze.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BREEZE_DEATH = create(key("entity.breeze.death"));

    /**
     * {@code minecraft:entity.breeze.deflect}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BREEZE_DEFLECT = create(key("entity.breeze.deflect"));

    /**
     * {@code minecraft:entity.breeze.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BREEZE_HURT = create(key("entity.breeze.hurt"));

    /**
     * {@code minecraft:entity.breeze.idle_air}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BREEZE_IDLE_AIR = create(key("entity.breeze.idle_air"));

    /**
     * {@code minecraft:entity.breeze.idle_ground}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BREEZE_IDLE_GROUND = create(key("entity.breeze.idle_ground"));

    /**
     * {@code minecraft:entity.breeze.inhale}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BREEZE_INHALE = create(key("entity.breeze.inhale"));

    /**
     * {@code minecraft:entity.breeze.jump}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BREEZE_JUMP = create(key("entity.breeze.jump"));

    /**
     * {@code minecraft:entity.breeze.land}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BREEZE_LAND = create(key("entity.breeze.land"));

    /**
     * {@code minecraft:entity.breeze.shoot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BREEZE_SHOOT = create(key("entity.breeze.shoot"));

    /**
     * {@code minecraft:entity.breeze.slide}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BREEZE_SLIDE = create(key("entity.breeze.slide"));

    /**
     * {@code minecraft:entity.breeze.whirl}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BREEZE_WHIRL = create(key("entity.breeze.whirl"));

    /**
     * {@code minecraft:entity.breeze.wind_burst}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_BREEZE_WIND_BURST = create(key("entity.breeze.wind_burst"));

    /**
     * {@code minecraft:entity.camel.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAMEL_AMBIENT = create(key("entity.camel.ambient"));

    /**
     * {@code minecraft:entity.camel.dash}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAMEL_DASH = create(key("entity.camel.dash"));

    /**
     * {@code minecraft:entity.camel.dash_ready}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAMEL_DASH_READY = create(key("entity.camel.dash_ready"));

    /**
     * {@code minecraft:entity.camel.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAMEL_DEATH = create(key("entity.camel.death"));

    /**
     * {@code minecraft:entity.camel.eat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAMEL_EAT = create(key("entity.camel.eat"));

    /**
     * {@code minecraft:entity.camel.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAMEL_HURT = create(key("entity.camel.hurt"));

    /**
     * {@code minecraft:entity.camel.saddle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAMEL_SADDLE = create(key("entity.camel.saddle"));

    /**
     * {@code minecraft:entity.camel.sit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAMEL_SIT = create(key("entity.camel.sit"));

    /**
     * {@code minecraft:entity.camel.stand}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAMEL_STAND = create(key("entity.camel.stand"));

    /**
     * {@code minecraft:entity.camel.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAMEL_STEP = create(key("entity.camel.step"));

    /**
     * {@code minecraft:entity.camel.step_sand}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAMEL_STEP_SAND = create(key("entity.camel.step_sand"));

    /**
     * {@code minecraft:entity.cat.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAT_AMBIENT = create(key("entity.cat.ambient"));

    /**
     * {@code minecraft:entity.cat.beg_for_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAT_BEG_FOR_FOOD = create(key("entity.cat.beg_for_food"));

    /**
     * {@code minecraft:entity.cat.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAT_DEATH = create(key("entity.cat.death"));

    /**
     * {@code minecraft:entity.cat.eat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAT_EAT = create(key("entity.cat.eat"));

    /**
     * {@code minecraft:entity.cat.hiss}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAT_HISS = create(key("entity.cat.hiss"));

    /**
     * {@code minecraft:entity.cat.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAT_HURT = create(key("entity.cat.hurt"));

    /**
     * {@code minecraft:entity.cat.purr}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAT_PURR = create(key("entity.cat.purr"));

    /**
     * {@code minecraft:entity.cat.purreow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAT_PURREOW = create(key("entity.cat.purreow"));

    /**
     * {@code minecraft:entity.cat.stray_ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CAT_STRAY_AMBIENT = create(key("entity.cat.stray_ambient"));

    /**
     * {@code minecraft:entity.chicken.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CHICKEN_AMBIENT = create(key("entity.chicken.ambient"));

    /**
     * {@code minecraft:entity.chicken.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CHICKEN_DEATH = create(key("entity.chicken.death"));

    /**
     * {@code minecraft:entity.chicken.egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CHICKEN_EGG = create(key("entity.chicken.egg"));

    /**
     * {@code minecraft:entity.chicken.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CHICKEN_HURT = create(key("entity.chicken.hurt"));

    /**
     * {@code minecraft:entity.chicken.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CHICKEN_STEP = create(key("entity.chicken.step"));

    /**
     * {@code minecraft:entity.cod.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_COD_AMBIENT = create(key("entity.cod.ambient"));

    /**
     * {@code minecraft:entity.cod.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_COD_DEATH = create(key("entity.cod.death"));

    /**
     * {@code minecraft:entity.cod.flop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_COD_FLOP = create(key("entity.cod.flop"));

    /**
     * {@code minecraft:entity.cod.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_COD_HURT = create(key("entity.cod.hurt"));

    /**
     * {@code minecraft:entity.cow.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_COW_AMBIENT = create(key("entity.cow.ambient"));

    /**
     * {@code minecraft:entity.cow.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_COW_DEATH = create(key("entity.cow.death"));

    /**
     * {@code minecraft:entity.cow.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_COW_HURT = create(key("entity.cow.hurt"));

    /**
     * {@code minecraft:entity.cow.milk}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_COW_MILK = create(key("entity.cow.milk"));

    /**
     * {@code minecraft:entity.cow.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_COW_STEP = create(key("entity.cow.step"));

    /**
     * {@code minecraft:entity.creaking.activate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CREAKING_ACTIVATE = create(key("entity.creaking.activate"));

    /**
     * {@code minecraft:entity.creaking.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CREAKING_AMBIENT = create(key("entity.creaking.ambient"));

    /**
     * {@code minecraft:entity.creaking.attack}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CREAKING_ATTACK = create(key("entity.creaking.attack"));

    /**
     * {@code minecraft:entity.creaking.deactivate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CREAKING_DEACTIVATE = create(key("entity.creaking.deactivate"));

    /**
     * {@code minecraft:entity.creaking.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CREAKING_DEATH = create(key("entity.creaking.death"));

    /**
     * {@code minecraft:entity.creaking.freeze}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CREAKING_FREEZE = create(key("entity.creaking.freeze"));

    /**
     * {@code minecraft:entity.creaking.spawn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CREAKING_SPAWN = create(key("entity.creaking.spawn"));

    /**
     * {@code minecraft:entity.creaking.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CREAKING_STEP = create(key("entity.creaking.step"));

    /**
     * {@code minecraft:entity.creaking.sway}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CREAKING_SWAY = create(key("entity.creaking.sway"));

    /**
     * {@code minecraft:entity.creaking.twitch}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CREAKING_TWITCH = create(key("entity.creaking.twitch"));

    /**
     * {@code minecraft:entity.creaking.unfreeze}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CREAKING_UNFREEZE = create(key("entity.creaking.unfreeze"));

    /**
     * {@code minecraft:entity.creeper.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CREEPER_DEATH = create(key("entity.creeper.death"));

    /**
     * {@code minecraft:entity.creeper.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CREEPER_HURT = create(key("entity.creeper.hurt"));

    /**
     * {@code minecraft:entity.creeper.primed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_CREEPER_PRIMED = create(key("entity.creeper.primed"));

    /**
     * {@code minecraft:entity.dolphin.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DOLPHIN_AMBIENT = create(key("entity.dolphin.ambient"));

    /**
     * {@code minecraft:entity.dolphin.ambient_water}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DOLPHIN_AMBIENT_WATER = create(key("entity.dolphin.ambient_water"));

    /**
     * {@code minecraft:entity.dolphin.attack}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DOLPHIN_ATTACK = create(key("entity.dolphin.attack"));

    /**
     * {@code minecraft:entity.dolphin.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DOLPHIN_DEATH = create(key("entity.dolphin.death"));

    /**
     * {@code minecraft:entity.dolphin.eat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DOLPHIN_EAT = create(key("entity.dolphin.eat"));

    /**
     * {@code minecraft:entity.dolphin.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DOLPHIN_HURT = create(key("entity.dolphin.hurt"));

    /**
     * {@code minecraft:entity.dolphin.jump}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DOLPHIN_JUMP = create(key("entity.dolphin.jump"));

    /**
     * {@code minecraft:entity.dolphin.play}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DOLPHIN_PLAY = create(key("entity.dolphin.play"));

    /**
     * {@code minecraft:entity.dolphin.splash}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DOLPHIN_SPLASH = create(key("entity.dolphin.splash"));

    /**
     * {@code minecraft:entity.dolphin.swim}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DOLPHIN_SWIM = create(key("entity.dolphin.swim"));

    /**
     * {@code minecraft:entity.donkey.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DONKEY_AMBIENT = create(key("entity.donkey.ambient"));

    /**
     * {@code minecraft:entity.donkey.angry}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DONKEY_ANGRY = create(key("entity.donkey.angry"));

    /**
     * {@code minecraft:entity.donkey.chest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DONKEY_CHEST = create(key("entity.donkey.chest"));

    /**
     * {@code minecraft:entity.donkey.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DONKEY_DEATH = create(key("entity.donkey.death"));

    /**
     * {@code minecraft:entity.donkey.eat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DONKEY_EAT = create(key("entity.donkey.eat"));

    /**
     * {@code minecraft:entity.donkey.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DONKEY_HURT = create(key("entity.donkey.hurt"));

    /**
     * {@code minecraft:entity.donkey.jump}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DONKEY_JUMP = create(key("entity.donkey.jump"));

    /**
     * {@code minecraft:entity.dragon_fireball.explode}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DRAGON_FIREBALL_EXPLODE = create(key("entity.dragon_fireball.explode"));

    /**
     * {@code minecraft:entity.drowned.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DROWNED_AMBIENT = create(key("entity.drowned.ambient"));

    /**
     * {@code minecraft:entity.drowned.ambient_water}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DROWNED_AMBIENT_WATER = create(key("entity.drowned.ambient_water"));

    /**
     * {@code minecraft:entity.drowned.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DROWNED_DEATH = create(key("entity.drowned.death"));

    /**
     * {@code minecraft:entity.drowned.death_water}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DROWNED_DEATH_WATER = create(key("entity.drowned.death_water"));

    /**
     * {@code minecraft:entity.drowned.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DROWNED_HURT = create(key("entity.drowned.hurt"));

    /**
     * {@code minecraft:entity.drowned.hurt_water}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DROWNED_HURT_WATER = create(key("entity.drowned.hurt_water"));

    /**
     * {@code minecraft:entity.drowned.shoot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DROWNED_SHOOT = create(key("entity.drowned.shoot"));

    /**
     * {@code minecraft:entity.drowned.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DROWNED_STEP = create(key("entity.drowned.step"));

    /**
     * {@code minecraft:entity.drowned.swim}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_DROWNED_SWIM = create(key("entity.drowned.swim"));

    /**
     * {@code minecraft:entity.egg.throw}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_EGG_THROW = create(key("entity.egg.throw"));

    /**
     * {@code minecraft:entity.elder_guardian.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ELDER_GUARDIAN_AMBIENT = create(key("entity.elder_guardian.ambient"));

    /**
     * {@code minecraft:entity.elder_guardian.ambient_land}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ELDER_GUARDIAN_AMBIENT_LAND = create(key("entity.elder_guardian.ambient_land"));

    /**
     * {@code minecraft:entity.elder_guardian.curse}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ELDER_GUARDIAN_CURSE = create(key("entity.elder_guardian.curse"));

    /**
     * {@code minecraft:entity.elder_guardian.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ELDER_GUARDIAN_DEATH = create(key("entity.elder_guardian.death"));

    /**
     * {@code minecraft:entity.elder_guardian.death_land}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ELDER_GUARDIAN_DEATH_LAND = create(key("entity.elder_guardian.death_land"));

    /**
     * {@code minecraft:entity.elder_guardian.flop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ELDER_GUARDIAN_FLOP = create(key("entity.elder_guardian.flop"));

    /**
     * {@code minecraft:entity.elder_guardian.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ELDER_GUARDIAN_HURT = create(key("entity.elder_guardian.hurt"));

    /**
     * {@code minecraft:entity.elder_guardian.hurt_land}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ELDER_GUARDIAN_HURT_LAND = create(key("entity.elder_guardian.hurt_land"));

    /**
     * {@code minecraft:entity.ender_dragon.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ENDER_DRAGON_AMBIENT = create(key("entity.ender_dragon.ambient"));

    /**
     * {@code minecraft:entity.ender_dragon.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ENDER_DRAGON_DEATH = create(key("entity.ender_dragon.death"));

    /**
     * {@code minecraft:entity.ender_dragon.flap}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ENDER_DRAGON_FLAP = create(key("entity.ender_dragon.flap"));

    /**
     * {@code minecraft:entity.ender_dragon.growl}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ENDER_DRAGON_GROWL = create(key("entity.ender_dragon.growl"));

    /**
     * {@code minecraft:entity.ender_dragon.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ENDER_DRAGON_HURT = create(key("entity.ender_dragon.hurt"));

    /**
     * {@code minecraft:entity.ender_dragon.shoot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ENDER_DRAGON_SHOOT = create(key("entity.ender_dragon.shoot"));

    /**
     * {@code minecraft:entity.ender_eye.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ENDER_EYE_DEATH = create(key("entity.ender_eye.death"));

    /**
     * {@code minecraft:entity.ender_eye.launch}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ENDER_EYE_LAUNCH = create(key("entity.ender_eye.launch"));

    /**
     * {@code minecraft:entity.ender_pearl.throw}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ENDER_PEARL_THROW = create(key("entity.ender_pearl.throw"));

    /**
     * {@code minecraft:entity.enderman.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ENDERMAN_AMBIENT = create(key("entity.enderman.ambient"));

    /**
     * {@code minecraft:entity.enderman.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ENDERMAN_DEATH = create(key("entity.enderman.death"));

    /**
     * {@code minecraft:entity.enderman.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ENDERMAN_HURT = create(key("entity.enderman.hurt"));

    /**
     * {@code minecraft:entity.enderman.scream}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ENDERMAN_SCREAM = create(key("entity.enderman.scream"));

    /**
     * {@code minecraft:entity.enderman.stare}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ENDERMAN_STARE = create(key("entity.enderman.stare"));

    /**
     * {@code minecraft:entity.enderman.teleport}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ENDERMAN_TELEPORT = create(key("entity.enderman.teleport"));

    /**
     * {@code minecraft:entity.endermite.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ENDERMITE_AMBIENT = create(key("entity.endermite.ambient"));

    /**
     * {@code minecraft:entity.endermite.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ENDERMITE_DEATH = create(key("entity.endermite.death"));

    /**
     * {@code minecraft:entity.endermite.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ENDERMITE_HURT = create(key("entity.endermite.hurt"));

    /**
     * {@code minecraft:entity.endermite.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ENDERMITE_STEP = create(key("entity.endermite.step"));

    /**
     * {@code minecraft:entity.evoker.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_EVOKER_AMBIENT = create(key("entity.evoker.ambient"));

    /**
     * {@code minecraft:entity.evoker.cast_spell}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_EVOKER_CAST_SPELL = create(key("entity.evoker.cast_spell"));

    /**
     * {@code minecraft:entity.evoker.celebrate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_EVOKER_CELEBRATE = create(key("entity.evoker.celebrate"));

    /**
     * {@code minecraft:entity.evoker.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_EVOKER_DEATH = create(key("entity.evoker.death"));

    /**
     * {@code minecraft:entity.evoker.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_EVOKER_HURT = create(key("entity.evoker.hurt"));

    /**
     * {@code minecraft:entity.evoker.prepare_attack}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_EVOKER_PREPARE_ATTACK = create(key("entity.evoker.prepare_attack"));

    /**
     * {@code minecraft:entity.evoker.prepare_summon}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_EVOKER_PREPARE_SUMMON = create(key("entity.evoker.prepare_summon"));

    /**
     * {@code minecraft:entity.evoker.prepare_wololo}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_EVOKER_PREPARE_WOLOLO = create(key("entity.evoker.prepare_wololo"));

    /**
     * {@code minecraft:entity.evoker_fangs.attack}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_EVOKER_FANGS_ATTACK = create(key("entity.evoker_fangs.attack"));

    /**
     * {@code minecraft:entity.experience_bottle.throw}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_EXPERIENCE_BOTTLE_THROW = create(key("entity.experience_bottle.throw"));

    /**
     * {@code minecraft:entity.experience_orb.pickup}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_EXPERIENCE_ORB_PICKUP = create(key("entity.experience_orb.pickup"));

    /**
     * {@code minecraft:entity.firework_rocket.blast}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FIREWORK_ROCKET_BLAST = create(key("entity.firework_rocket.blast"));

    /**
     * {@code minecraft:entity.firework_rocket.blast_far}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FIREWORK_ROCKET_BLAST_FAR = create(key("entity.firework_rocket.blast_far"));

    /**
     * {@code minecraft:entity.firework_rocket.large_blast}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FIREWORK_ROCKET_LARGE_BLAST = create(key("entity.firework_rocket.large_blast"));

    /**
     * {@code minecraft:entity.firework_rocket.large_blast_far}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FIREWORK_ROCKET_LARGE_BLAST_FAR = create(key("entity.firework_rocket.large_blast_far"));

    /**
     * {@code minecraft:entity.firework_rocket.launch}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FIREWORK_ROCKET_LAUNCH = create(key("entity.firework_rocket.launch"));

    /**
     * {@code minecraft:entity.firework_rocket.shoot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FIREWORK_ROCKET_SHOOT = create(key("entity.firework_rocket.shoot"));

    /**
     * {@code minecraft:entity.firework_rocket.twinkle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FIREWORK_ROCKET_TWINKLE = create(key("entity.firework_rocket.twinkle"));

    /**
     * {@code minecraft:entity.firework_rocket.twinkle_far}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FIREWORK_ROCKET_TWINKLE_FAR = create(key("entity.firework_rocket.twinkle_far"));

    /**
     * {@code minecraft:entity.fish.swim}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FISH_SWIM = create(key("entity.fish.swim"));

    /**
     * {@code minecraft:entity.fishing_bobber.retrieve}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FISHING_BOBBER_RETRIEVE = create(key("entity.fishing_bobber.retrieve"));

    /**
     * {@code minecraft:entity.fishing_bobber.splash}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FISHING_BOBBER_SPLASH = create(key("entity.fishing_bobber.splash"));

    /**
     * {@code minecraft:entity.fishing_bobber.throw}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FISHING_BOBBER_THROW = create(key("entity.fishing_bobber.throw"));

    /**
     * {@code minecraft:entity.fox.aggro}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FOX_AGGRO = create(key("entity.fox.aggro"));

    /**
     * {@code minecraft:entity.fox.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FOX_AMBIENT = create(key("entity.fox.ambient"));

    /**
     * {@code minecraft:entity.fox.bite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FOX_BITE = create(key("entity.fox.bite"));

    /**
     * {@code minecraft:entity.fox.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FOX_DEATH = create(key("entity.fox.death"));

    /**
     * {@code minecraft:entity.fox.eat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FOX_EAT = create(key("entity.fox.eat"));

    /**
     * {@code minecraft:entity.fox.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FOX_HURT = create(key("entity.fox.hurt"));

    /**
     * {@code minecraft:entity.fox.screech}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FOX_SCREECH = create(key("entity.fox.screech"));

    /**
     * {@code minecraft:entity.fox.sleep}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FOX_SLEEP = create(key("entity.fox.sleep"));

    /**
     * {@code minecraft:entity.fox.sniff}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FOX_SNIFF = create(key("entity.fox.sniff"));

    /**
     * {@code minecraft:entity.fox.spit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FOX_SPIT = create(key("entity.fox.spit"));

    /**
     * {@code minecraft:entity.fox.teleport}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FOX_TELEPORT = create(key("entity.fox.teleport"));

    /**
     * {@code minecraft:entity.frog.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FROG_AMBIENT = create(key("entity.frog.ambient"));

    /**
     * {@code minecraft:entity.frog.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FROG_DEATH = create(key("entity.frog.death"));

    /**
     * {@code minecraft:entity.frog.eat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FROG_EAT = create(key("entity.frog.eat"));

    /**
     * {@code minecraft:entity.frog.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FROG_HURT = create(key("entity.frog.hurt"));

    /**
     * {@code minecraft:entity.frog.lay_spawn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FROG_LAY_SPAWN = create(key("entity.frog.lay_spawn"));

    /**
     * {@code minecraft:entity.frog.long_jump}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FROG_LONG_JUMP = create(key("entity.frog.long_jump"));

    /**
     * {@code minecraft:entity.frog.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FROG_STEP = create(key("entity.frog.step"));

    /**
     * {@code minecraft:entity.frog.tongue}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_FROG_TONGUE = create(key("entity.frog.tongue"));

    /**
     * {@code minecraft:entity.generic.big_fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GENERIC_BIG_FALL = create(key("entity.generic.big_fall"));

    /**
     * {@code minecraft:entity.generic.burn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GENERIC_BURN = create(key("entity.generic.burn"));

    /**
     * {@code minecraft:entity.generic.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GENERIC_DEATH = create(key("entity.generic.death"));

    /**
     * {@code minecraft:entity.generic.drink}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GENERIC_DRINK = create(key("entity.generic.drink"));

    /**
     * {@code minecraft:entity.generic.eat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GENERIC_EAT = create(key("entity.generic.eat"));

    /**
     * {@code minecraft:entity.generic.explode}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GENERIC_EXPLODE = create(key("entity.generic.explode"));

    /**
     * {@code minecraft:entity.generic.extinguish_fire}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GENERIC_EXTINGUISH_FIRE = create(key("entity.generic.extinguish_fire"));

    /**
     * {@code minecraft:entity.generic.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GENERIC_HURT = create(key("entity.generic.hurt"));

    /**
     * {@code minecraft:entity.generic.small_fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GENERIC_SMALL_FALL = create(key("entity.generic.small_fall"));

    /**
     * {@code minecraft:entity.generic.splash}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GENERIC_SPLASH = create(key("entity.generic.splash"));

    /**
     * {@code minecraft:entity.generic.swim}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GENERIC_SWIM = create(key("entity.generic.swim"));

    /**
     * {@code minecraft:entity.ghast.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GHAST_AMBIENT = create(key("entity.ghast.ambient"));

    /**
     * {@code minecraft:entity.ghast.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GHAST_DEATH = create(key("entity.ghast.death"));

    /**
     * {@code minecraft:entity.ghast.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GHAST_HURT = create(key("entity.ghast.hurt"));

    /**
     * {@code minecraft:entity.ghast.scream}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GHAST_SCREAM = create(key("entity.ghast.scream"));

    /**
     * {@code minecraft:entity.ghast.shoot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GHAST_SHOOT = create(key("entity.ghast.shoot"));

    /**
     * {@code minecraft:entity.ghast.warn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GHAST_WARN = create(key("entity.ghast.warn"));

    /**
     * {@code minecraft:entity.ghastling.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GHASTLING_AMBIENT = create(key("entity.ghastling.ambient"));

    /**
     * {@code minecraft:entity.ghastling.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GHASTLING_DEATH = create(key("entity.ghastling.death"));

    /**
     * {@code minecraft:entity.ghastling.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GHASTLING_HURT = create(key("entity.ghastling.hurt"));

    /**
     * {@code minecraft:entity.ghastling.spawn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GHASTLING_SPAWN = create(key("entity.ghastling.spawn"));

    /**
     * {@code minecraft:entity.glow_item_frame.add_item}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GLOW_ITEM_FRAME_ADD_ITEM = create(key("entity.glow_item_frame.add_item"));

    /**
     * {@code minecraft:entity.glow_item_frame.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GLOW_ITEM_FRAME_BREAK = create(key("entity.glow_item_frame.break"));

    /**
     * {@code minecraft:entity.glow_item_frame.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GLOW_ITEM_FRAME_PLACE = create(key("entity.glow_item_frame.place"));

    /**
     * {@code minecraft:entity.glow_item_frame.remove_item}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GLOW_ITEM_FRAME_REMOVE_ITEM = create(key("entity.glow_item_frame.remove_item"));

    /**
     * {@code minecraft:entity.glow_item_frame.rotate_item}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GLOW_ITEM_FRAME_ROTATE_ITEM = create(key("entity.glow_item_frame.rotate_item"));

    /**
     * {@code minecraft:entity.glow_squid.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GLOW_SQUID_AMBIENT = create(key("entity.glow_squid.ambient"));

    /**
     * {@code minecraft:entity.glow_squid.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GLOW_SQUID_DEATH = create(key("entity.glow_squid.death"));

    /**
     * {@code minecraft:entity.glow_squid.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GLOW_SQUID_HURT = create(key("entity.glow_squid.hurt"));

    /**
     * {@code minecraft:entity.glow_squid.squirt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GLOW_SQUID_SQUIRT = create(key("entity.glow_squid.squirt"));

    /**
     * {@code minecraft:entity.goat.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GOAT_AMBIENT = create(key("entity.goat.ambient"));

    /**
     * {@code minecraft:entity.goat.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GOAT_DEATH = create(key("entity.goat.death"));

    /**
     * {@code minecraft:entity.goat.eat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GOAT_EAT = create(key("entity.goat.eat"));

    /**
     * {@code minecraft:entity.goat.horn_break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GOAT_HORN_BREAK = create(key("entity.goat.horn_break"));

    /**
     * {@code minecraft:entity.goat.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GOAT_HURT = create(key("entity.goat.hurt"));

    /**
     * {@code minecraft:entity.goat.long_jump}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GOAT_LONG_JUMP = create(key("entity.goat.long_jump"));

    /**
     * {@code minecraft:entity.goat.milk}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GOAT_MILK = create(key("entity.goat.milk"));

    /**
     * {@code minecraft:entity.goat.prepare_ram}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GOAT_PREPARE_RAM = create(key("entity.goat.prepare_ram"));

    /**
     * {@code minecraft:entity.goat.ram_impact}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GOAT_RAM_IMPACT = create(key("entity.goat.ram_impact"));

    /**
     * {@code minecraft:entity.goat.screaming.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GOAT_SCREAMING_AMBIENT = create(key("entity.goat.screaming.ambient"));

    /**
     * {@code minecraft:entity.goat.screaming.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GOAT_SCREAMING_DEATH = create(key("entity.goat.screaming.death"));

    /**
     * {@code minecraft:entity.goat.screaming.eat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GOAT_SCREAMING_EAT = create(key("entity.goat.screaming.eat"));

    /**
     * {@code minecraft:entity.goat.screaming.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GOAT_SCREAMING_HURT = create(key("entity.goat.screaming.hurt"));

    /**
     * {@code minecraft:entity.goat.screaming.long_jump}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GOAT_SCREAMING_LONG_JUMP = create(key("entity.goat.screaming.long_jump"));

    /**
     * {@code minecraft:entity.goat.screaming.milk}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GOAT_SCREAMING_MILK = create(key("entity.goat.screaming.milk"));

    /**
     * {@code minecraft:entity.goat.screaming.prepare_ram}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GOAT_SCREAMING_PREPARE_RAM = create(key("entity.goat.screaming.prepare_ram"));

    /**
     * {@code minecraft:entity.goat.screaming.ram_impact}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GOAT_SCREAMING_RAM_IMPACT = create(key("entity.goat.screaming.ram_impact"));

    /**
     * {@code minecraft:entity.goat.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GOAT_STEP = create(key("entity.goat.step"));

    /**
     * {@code minecraft:entity.guardian.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GUARDIAN_AMBIENT = create(key("entity.guardian.ambient"));

    /**
     * {@code minecraft:entity.guardian.ambient_land}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GUARDIAN_AMBIENT_LAND = create(key("entity.guardian.ambient_land"));

    /**
     * {@code minecraft:entity.guardian.attack}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GUARDIAN_ATTACK = create(key("entity.guardian.attack"));

    /**
     * {@code minecraft:entity.guardian.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GUARDIAN_DEATH = create(key("entity.guardian.death"));

    /**
     * {@code minecraft:entity.guardian.death_land}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GUARDIAN_DEATH_LAND = create(key("entity.guardian.death_land"));

    /**
     * {@code minecraft:entity.guardian.flop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GUARDIAN_FLOP = create(key("entity.guardian.flop"));

    /**
     * {@code minecraft:entity.guardian.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GUARDIAN_HURT = create(key("entity.guardian.hurt"));

    /**
     * {@code minecraft:entity.guardian.hurt_land}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_GUARDIAN_HURT_LAND = create(key("entity.guardian.hurt_land"));

    /**
     * {@code minecraft:entity.happy_ghast.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HAPPY_GHAST_AMBIENT = create(key("entity.happy_ghast.ambient"));

    /**
     * {@code minecraft:entity.happy_ghast.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HAPPY_GHAST_DEATH = create(key("entity.happy_ghast.death"));

    /**
     * {@code minecraft:entity.happy_ghast.equip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HAPPY_GHAST_EQUIP = create(key("entity.happy_ghast.equip"));

    /**
     * {@code minecraft:entity.happy_ghast.harness_goggles_down}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HAPPY_GHAST_HARNESS_GOGGLES_DOWN = create(key("entity.happy_ghast.harness_goggles_down"));

    /**
     * {@code minecraft:entity.happy_ghast.harness_goggles_up}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HAPPY_GHAST_HARNESS_GOGGLES_UP = create(key("entity.happy_ghast.harness_goggles_up"));

    /**
     * {@code minecraft:entity.happy_ghast.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HAPPY_GHAST_HURT = create(key("entity.happy_ghast.hurt"));

    /**
     * {@code minecraft:entity.happy_ghast.riding}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HAPPY_GHAST_RIDING = create(key("entity.happy_ghast.riding"));

    /**
     * {@code minecraft:entity.happy_ghast.unequip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HAPPY_GHAST_UNEQUIP = create(key("entity.happy_ghast.unequip"));

    /**
     * {@code minecraft:entity.hoglin.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HOGLIN_AMBIENT = create(key("entity.hoglin.ambient"));

    /**
     * {@code minecraft:entity.hoglin.angry}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HOGLIN_ANGRY = create(key("entity.hoglin.angry"));

    /**
     * {@code minecraft:entity.hoglin.attack}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HOGLIN_ATTACK = create(key("entity.hoglin.attack"));

    /**
     * {@code minecraft:entity.hoglin.converted_to_zombified}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HOGLIN_CONVERTED_TO_ZOMBIFIED = create(key("entity.hoglin.converted_to_zombified"));

    /**
     * {@code minecraft:entity.hoglin.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HOGLIN_DEATH = create(key("entity.hoglin.death"));

    /**
     * {@code minecraft:entity.hoglin.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HOGLIN_HURT = create(key("entity.hoglin.hurt"));

    /**
     * {@code minecraft:entity.hoglin.retreat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HOGLIN_RETREAT = create(key("entity.hoglin.retreat"));

    /**
     * {@code minecraft:entity.hoglin.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HOGLIN_STEP = create(key("entity.hoglin.step"));

    /**
     * {@code minecraft:entity.horse.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HORSE_AMBIENT = create(key("entity.horse.ambient"));

    /**
     * {@code minecraft:entity.horse.angry}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HORSE_ANGRY = create(key("entity.horse.angry"));

    /**
     * {@code minecraft:entity.horse.armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HORSE_ARMOR = create(key("entity.horse.armor"));

    /**
     * {@code minecraft:entity.horse.breathe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HORSE_BREATHE = create(key("entity.horse.breathe"));

    /**
     * {@code minecraft:entity.horse.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HORSE_DEATH = create(key("entity.horse.death"));

    /**
     * {@code minecraft:entity.horse.eat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HORSE_EAT = create(key("entity.horse.eat"));

    /**
     * {@code minecraft:entity.horse.gallop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HORSE_GALLOP = create(key("entity.horse.gallop"));

    /**
     * {@code minecraft:entity.horse.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HORSE_HURT = create(key("entity.horse.hurt"));

    /**
     * {@code minecraft:entity.horse.jump}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HORSE_JUMP = create(key("entity.horse.jump"));

    /**
     * {@code minecraft:entity.horse.land}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HORSE_LAND = create(key("entity.horse.land"));

    /**
     * {@code minecraft:entity.horse.saddle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HORSE_SADDLE = create(key("entity.horse.saddle"));

    /**
     * {@code minecraft:entity.horse.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HORSE_STEP = create(key("entity.horse.step"));

    /**
     * {@code minecraft:entity.horse.step_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HORSE_STEP_WOOD = create(key("entity.horse.step_wood"));

    /**
     * {@code minecraft:entity.hostile.big_fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HOSTILE_BIG_FALL = create(key("entity.hostile.big_fall"));

    /**
     * {@code minecraft:entity.hostile.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HOSTILE_DEATH = create(key("entity.hostile.death"));

    /**
     * {@code minecraft:entity.hostile.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HOSTILE_HURT = create(key("entity.hostile.hurt"));

    /**
     * {@code minecraft:entity.hostile.small_fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HOSTILE_SMALL_FALL = create(key("entity.hostile.small_fall"));

    /**
     * {@code minecraft:entity.hostile.splash}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HOSTILE_SPLASH = create(key("entity.hostile.splash"));

    /**
     * {@code minecraft:entity.hostile.swim}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HOSTILE_SWIM = create(key("entity.hostile.swim"));

    /**
     * {@code minecraft:entity.husk.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HUSK_AMBIENT = create(key("entity.husk.ambient"));

    /**
     * {@code minecraft:entity.husk.converted_to_zombie}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HUSK_CONVERTED_TO_ZOMBIE = create(key("entity.husk.converted_to_zombie"));

    /**
     * {@code minecraft:entity.husk.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HUSK_DEATH = create(key("entity.husk.death"));

    /**
     * {@code minecraft:entity.husk.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HUSK_HURT = create(key("entity.husk.hurt"));

    /**
     * {@code minecraft:entity.husk.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_HUSK_STEP = create(key("entity.husk.step"));

    /**
     * {@code minecraft:entity.illusioner.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ILLUSIONER_AMBIENT = create(key("entity.illusioner.ambient"));

    /**
     * {@code minecraft:entity.illusioner.cast_spell}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ILLUSIONER_CAST_SPELL = create(key("entity.illusioner.cast_spell"));

    /**
     * {@code minecraft:entity.illusioner.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ILLUSIONER_DEATH = create(key("entity.illusioner.death"));

    /**
     * {@code minecraft:entity.illusioner.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ILLUSIONER_HURT = create(key("entity.illusioner.hurt"));

    /**
     * {@code minecraft:entity.illusioner.mirror_move}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ILLUSIONER_MIRROR_MOVE = create(key("entity.illusioner.mirror_move"));

    /**
     * {@code minecraft:entity.illusioner.prepare_blindness}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ILLUSIONER_PREPARE_BLINDNESS = create(key("entity.illusioner.prepare_blindness"));

    /**
     * {@code minecraft:entity.illusioner.prepare_mirror}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ILLUSIONER_PREPARE_MIRROR = create(key("entity.illusioner.prepare_mirror"));

    /**
     * {@code minecraft:entity.iron_golem.attack}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_IRON_GOLEM_ATTACK = create(key("entity.iron_golem.attack"));

    /**
     * {@code minecraft:entity.iron_golem.damage}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_IRON_GOLEM_DAMAGE = create(key("entity.iron_golem.damage"));

    /**
     * {@code minecraft:entity.iron_golem.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_IRON_GOLEM_DEATH = create(key("entity.iron_golem.death"));

    /**
     * {@code minecraft:entity.iron_golem.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_IRON_GOLEM_HURT = create(key("entity.iron_golem.hurt"));

    /**
     * {@code minecraft:entity.iron_golem.repair}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_IRON_GOLEM_REPAIR = create(key("entity.iron_golem.repair"));

    /**
     * {@code minecraft:entity.iron_golem.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_IRON_GOLEM_STEP = create(key("entity.iron_golem.step"));

    /**
     * {@code minecraft:entity.item.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ITEM_BREAK = create(key("entity.item.break"));

    /**
     * {@code minecraft:entity.item.pickup}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ITEM_PICKUP = create(key("entity.item.pickup"));

    /**
     * {@code minecraft:entity.item_frame.add_item}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ITEM_FRAME_ADD_ITEM = create(key("entity.item_frame.add_item"));

    /**
     * {@code minecraft:entity.item_frame.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ITEM_FRAME_BREAK = create(key("entity.item_frame.break"));

    /**
     * {@code minecraft:entity.item_frame.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ITEM_FRAME_PLACE = create(key("entity.item_frame.place"));

    /**
     * {@code minecraft:entity.item_frame.remove_item}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ITEM_FRAME_REMOVE_ITEM = create(key("entity.item_frame.remove_item"));

    /**
     * {@code minecraft:entity.item_frame.rotate_item}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ITEM_FRAME_ROTATE_ITEM = create(key("entity.item_frame.rotate_item"));

    /**
     * {@code minecraft:entity.lightning_bolt.impact}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_LIGHTNING_BOLT_IMPACT = create(key("entity.lightning_bolt.impact"));

    /**
     * {@code minecraft:entity.lightning_bolt.thunder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_LIGHTNING_BOLT_THUNDER = create(key("entity.lightning_bolt.thunder"));

    /**
     * {@code minecraft:entity.lingering_potion.throw}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_LINGERING_POTION_THROW = create(key("entity.lingering_potion.throw"));

    /**
     * {@code minecraft:entity.llama.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_LLAMA_AMBIENT = create(key("entity.llama.ambient"));

    /**
     * {@code minecraft:entity.llama.angry}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_LLAMA_ANGRY = create(key("entity.llama.angry"));

    /**
     * {@code minecraft:entity.llama.chest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_LLAMA_CHEST = create(key("entity.llama.chest"));

    /**
     * {@code minecraft:entity.llama.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_LLAMA_DEATH = create(key("entity.llama.death"));

    /**
     * {@code minecraft:entity.llama.eat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_LLAMA_EAT = create(key("entity.llama.eat"));

    /**
     * {@code minecraft:entity.llama.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_LLAMA_HURT = create(key("entity.llama.hurt"));

    /**
     * {@code minecraft:entity.llama.spit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_LLAMA_SPIT = create(key("entity.llama.spit"));

    /**
     * {@code minecraft:entity.llama.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_LLAMA_STEP = create(key("entity.llama.step"));

    /**
     * {@code minecraft:entity.llama.swag}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_LLAMA_SWAG = create(key("entity.llama.swag"));

    /**
     * {@code minecraft:entity.magma_cube.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MAGMA_CUBE_DEATH = create(key("entity.magma_cube.death"));

    /**
     * {@code minecraft:entity.magma_cube.death_small}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MAGMA_CUBE_DEATH_SMALL = create(key("entity.magma_cube.death_small"));

    /**
     * {@code minecraft:entity.magma_cube.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MAGMA_CUBE_HURT = create(key("entity.magma_cube.hurt"));

    /**
     * {@code minecraft:entity.magma_cube.hurt_small}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MAGMA_CUBE_HURT_SMALL = create(key("entity.magma_cube.hurt_small"));

    /**
     * {@code minecraft:entity.magma_cube.jump}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MAGMA_CUBE_JUMP = create(key("entity.magma_cube.jump"));

    /**
     * {@code minecraft:entity.magma_cube.squish}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MAGMA_CUBE_SQUISH = create(key("entity.magma_cube.squish"));

    /**
     * {@code minecraft:entity.magma_cube.squish_small}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MAGMA_CUBE_SQUISH_SMALL = create(key("entity.magma_cube.squish_small"));

    /**
     * {@code minecraft:entity.minecart.inside}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MINECART_INSIDE = create(key("entity.minecart.inside"));

    /**
     * {@code minecraft:entity.minecart.inside.underwater}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MINECART_INSIDE_UNDERWATER = create(key("entity.minecart.inside.underwater"));

    /**
     * {@code minecraft:entity.minecart.riding}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MINECART_RIDING = create(key("entity.minecart.riding"));

    /**
     * {@code minecraft:entity.mooshroom.convert}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MOOSHROOM_CONVERT = create(key("entity.mooshroom.convert"));

    /**
     * {@code minecraft:entity.mooshroom.eat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MOOSHROOM_EAT = create(key("entity.mooshroom.eat"));

    /**
     * {@code minecraft:entity.mooshroom.milk}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MOOSHROOM_MILK = create(key("entity.mooshroom.milk"));

    /**
     * {@code minecraft:entity.mooshroom.shear}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MOOSHROOM_SHEAR = create(key("entity.mooshroom.shear"));

    /**
     * {@code minecraft:entity.mooshroom.suspicious_milk}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MOOSHROOM_SUSPICIOUS_MILK = create(key("entity.mooshroom.suspicious_milk"));

    /**
     * {@code minecraft:entity.mule.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MULE_AMBIENT = create(key("entity.mule.ambient"));

    /**
     * {@code minecraft:entity.mule.angry}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MULE_ANGRY = create(key("entity.mule.angry"));

    /**
     * {@code minecraft:entity.mule.chest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MULE_CHEST = create(key("entity.mule.chest"));

    /**
     * {@code minecraft:entity.mule.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MULE_DEATH = create(key("entity.mule.death"));

    /**
     * {@code minecraft:entity.mule.eat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MULE_EAT = create(key("entity.mule.eat"));

    /**
     * {@code minecraft:entity.mule.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MULE_HURT = create(key("entity.mule.hurt"));

    /**
     * {@code minecraft:entity.mule.jump}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_MULE_JUMP = create(key("entity.mule.jump"));

    /**
     * {@code minecraft:entity.ocelot.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_OCELOT_AMBIENT = create(key("entity.ocelot.ambient"));

    /**
     * {@code minecraft:entity.ocelot.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_OCELOT_DEATH = create(key("entity.ocelot.death"));

    /**
     * {@code minecraft:entity.ocelot.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_OCELOT_HURT = create(key("entity.ocelot.hurt"));

    /**
     * {@code minecraft:entity.painting.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PAINTING_BREAK = create(key("entity.painting.break"));

    /**
     * {@code minecraft:entity.painting.place}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PAINTING_PLACE = create(key("entity.painting.place"));

    /**
     * {@code minecraft:entity.panda.aggressive_ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PANDA_AGGRESSIVE_AMBIENT = create(key("entity.panda.aggressive_ambient"));

    /**
     * {@code minecraft:entity.panda.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PANDA_AMBIENT = create(key("entity.panda.ambient"));

    /**
     * {@code minecraft:entity.panda.bite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PANDA_BITE = create(key("entity.panda.bite"));

    /**
     * {@code minecraft:entity.panda.cant_breed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PANDA_CANT_BREED = create(key("entity.panda.cant_breed"));

    /**
     * {@code minecraft:entity.panda.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PANDA_DEATH = create(key("entity.panda.death"));

    /**
     * {@code minecraft:entity.panda.eat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PANDA_EAT = create(key("entity.panda.eat"));

    /**
     * {@code minecraft:entity.panda.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PANDA_HURT = create(key("entity.panda.hurt"));

    /**
     * {@code minecraft:entity.panda.pre_sneeze}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PANDA_PRE_SNEEZE = create(key("entity.panda.pre_sneeze"));

    /**
     * {@code minecraft:entity.panda.sneeze}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PANDA_SNEEZE = create(key("entity.panda.sneeze"));

    /**
     * {@code minecraft:entity.panda.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PANDA_STEP = create(key("entity.panda.step"));

    /**
     * {@code minecraft:entity.panda.worried_ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PANDA_WORRIED_AMBIENT = create(key("entity.panda.worried_ambient"));

    /**
     * {@code minecraft:entity.parrot.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_AMBIENT = create(key("entity.parrot.ambient"));

    /**
     * {@code minecraft:entity.parrot.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_DEATH = create(key("entity.parrot.death"));

    /**
     * {@code minecraft:entity.parrot.eat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_EAT = create(key("entity.parrot.eat"));

    /**
     * {@code minecraft:entity.parrot.fly}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_FLY = create(key("entity.parrot.fly"));

    /**
     * {@code minecraft:entity.parrot.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_HURT = create(key("entity.parrot.hurt"));

    /**
     * {@code minecraft:entity.parrot.imitate.blaze}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_BLAZE = create(key("entity.parrot.imitate.blaze"));

    /**
     * {@code minecraft:entity.parrot.imitate.bogged}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_BOGGED = create(key("entity.parrot.imitate.bogged"));

    /**
     * {@code minecraft:entity.parrot.imitate.breeze}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_BREEZE = create(key("entity.parrot.imitate.breeze"));

    /**
     * {@code minecraft:entity.parrot.imitate.creaking}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_CREAKING = create(key("entity.parrot.imitate.creaking"));

    /**
     * {@code minecraft:entity.parrot.imitate.creeper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_CREEPER = create(key("entity.parrot.imitate.creeper"));

    /**
     * {@code minecraft:entity.parrot.imitate.drowned}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_DROWNED = create(key("entity.parrot.imitate.drowned"));

    /**
     * {@code minecraft:entity.parrot.imitate.elder_guardian}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_ELDER_GUARDIAN = create(key("entity.parrot.imitate.elder_guardian"));

    /**
     * {@code minecraft:entity.parrot.imitate.ender_dragon}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_ENDER_DRAGON = create(key("entity.parrot.imitate.ender_dragon"));

    /**
     * {@code minecraft:entity.parrot.imitate.endermite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_ENDERMITE = create(key("entity.parrot.imitate.endermite"));

    /**
     * {@code minecraft:entity.parrot.imitate.evoker}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_EVOKER = create(key("entity.parrot.imitate.evoker"));

    /**
     * {@code minecraft:entity.parrot.imitate.ghast}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_GHAST = create(key("entity.parrot.imitate.ghast"));

    /**
     * {@code minecraft:entity.parrot.imitate.guardian}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_GUARDIAN = create(key("entity.parrot.imitate.guardian"));

    /**
     * {@code minecraft:entity.parrot.imitate.hoglin}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_HOGLIN = create(key("entity.parrot.imitate.hoglin"));

    /**
     * {@code minecraft:entity.parrot.imitate.husk}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_HUSK = create(key("entity.parrot.imitate.husk"));

    /**
     * {@code minecraft:entity.parrot.imitate.illusioner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_ILLUSIONER = create(key("entity.parrot.imitate.illusioner"));

    /**
     * {@code minecraft:entity.parrot.imitate.magma_cube}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_MAGMA_CUBE = create(key("entity.parrot.imitate.magma_cube"));

    /**
     * {@code minecraft:entity.parrot.imitate.phantom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_PHANTOM = create(key("entity.parrot.imitate.phantom"));

    /**
     * {@code minecraft:entity.parrot.imitate.piglin}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_PIGLIN = create(key("entity.parrot.imitate.piglin"));

    /**
     * {@code minecraft:entity.parrot.imitate.piglin_brute}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_PIGLIN_BRUTE = create(key("entity.parrot.imitate.piglin_brute"));

    /**
     * {@code minecraft:entity.parrot.imitate.pillager}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_PILLAGER = create(key("entity.parrot.imitate.pillager"));

    /**
     * {@code minecraft:entity.parrot.imitate.ravager}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_RAVAGER = create(key("entity.parrot.imitate.ravager"));

    /**
     * {@code minecraft:entity.parrot.imitate.shulker}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_SHULKER = create(key("entity.parrot.imitate.shulker"));

    /**
     * {@code minecraft:entity.parrot.imitate.silverfish}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_SILVERFISH = create(key("entity.parrot.imitate.silverfish"));

    /**
     * {@code minecraft:entity.parrot.imitate.skeleton}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_SKELETON = create(key("entity.parrot.imitate.skeleton"));

    /**
     * {@code minecraft:entity.parrot.imitate.slime}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_SLIME = create(key("entity.parrot.imitate.slime"));

    /**
     * {@code minecraft:entity.parrot.imitate.spider}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_SPIDER = create(key("entity.parrot.imitate.spider"));

    /**
     * {@code minecraft:entity.parrot.imitate.stray}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_STRAY = create(key("entity.parrot.imitate.stray"));

    /**
     * {@code minecraft:entity.parrot.imitate.vex}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_VEX = create(key("entity.parrot.imitate.vex"));

    /**
     * {@code minecraft:entity.parrot.imitate.vindicator}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_VINDICATOR = create(key("entity.parrot.imitate.vindicator"));

    /**
     * {@code minecraft:entity.parrot.imitate.warden}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_WARDEN = create(key("entity.parrot.imitate.warden"));

    /**
     * {@code minecraft:entity.parrot.imitate.witch}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_WITCH = create(key("entity.parrot.imitate.witch"));

    /**
     * {@code minecraft:entity.parrot.imitate.wither}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_WITHER = create(key("entity.parrot.imitate.wither"));

    /**
     * {@code minecraft:entity.parrot.imitate.wither_skeleton}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_WITHER_SKELETON = create(key("entity.parrot.imitate.wither_skeleton"));

    /**
     * {@code minecraft:entity.parrot.imitate.zoglin}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_ZOGLIN = create(key("entity.parrot.imitate.zoglin"));

    /**
     * {@code minecraft:entity.parrot.imitate.zombie}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_ZOMBIE = create(key("entity.parrot.imitate.zombie"));

    /**
     * {@code minecraft:entity.parrot.imitate.zombie_villager}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_IMITATE_ZOMBIE_VILLAGER = create(key("entity.parrot.imitate.zombie_villager"));

    /**
     * {@code minecraft:entity.parrot.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PARROT_STEP = create(key("entity.parrot.step"));

    /**
     * {@code minecraft:entity.phantom.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PHANTOM_AMBIENT = create(key("entity.phantom.ambient"));

    /**
     * {@code minecraft:entity.phantom.bite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PHANTOM_BITE = create(key("entity.phantom.bite"));

    /**
     * {@code minecraft:entity.phantom.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PHANTOM_DEATH = create(key("entity.phantom.death"));

    /**
     * {@code minecraft:entity.phantom.flap}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PHANTOM_FLAP = create(key("entity.phantom.flap"));

    /**
     * {@code minecraft:entity.phantom.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PHANTOM_HURT = create(key("entity.phantom.hurt"));

    /**
     * {@code minecraft:entity.phantom.swoop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PHANTOM_SWOOP = create(key("entity.phantom.swoop"));

    /**
     * {@code minecraft:entity.pig.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIG_AMBIENT = create(key("entity.pig.ambient"));

    /**
     * {@code minecraft:entity.pig.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIG_DEATH = create(key("entity.pig.death"));

    /**
     * {@code minecraft:entity.pig.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIG_HURT = create(key("entity.pig.hurt"));

    /**
     * {@code minecraft:entity.pig.saddle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIG_SADDLE = create(key("entity.pig.saddle"));

    /**
     * {@code minecraft:entity.pig.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIG_STEP = create(key("entity.pig.step"));

    /**
     * {@code minecraft:entity.piglin.admiring_item}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIGLIN_ADMIRING_ITEM = create(key("entity.piglin.admiring_item"));

    /**
     * {@code minecraft:entity.piglin.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIGLIN_AMBIENT = create(key("entity.piglin.ambient"));

    /**
     * {@code minecraft:entity.piglin.angry}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIGLIN_ANGRY = create(key("entity.piglin.angry"));

    /**
     * {@code minecraft:entity.piglin.celebrate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIGLIN_CELEBRATE = create(key("entity.piglin.celebrate"));

    /**
     * {@code minecraft:entity.piglin.converted_to_zombified}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIGLIN_CONVERTED_TO_ZOMBIFIED = create(key("entity.piglin.converted_to_zombified"));

    /**
     * {@code minecraft:entity.piglin.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIGLIN_DEATH = create(key("entity.piglin.death"));

    /**
     * {@code minecraft:entity.piglin.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIGLIN_HURT = create(key("entity.piglin.hurt"));

    /**
     * {@code minecraft:entity.piglin.jealous}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIGLIN_JEALOUS = create(key("entity.piglin.jealous"));

    /**
     * {@code minecraft:entity.piglin.retreat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIGLIN_RETREAT = create(key("entity.piglin.retreat"));

    /**
     * {@code minecraft:entity.piglin.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIGLIN_STEP = create(key("entity.piglin.step"));

    /**
     * {@code minecraft:entity.piglin_brute.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIGLIN_BRUTE_AMBIENT = create(key("entity.piglin_brute.ambient"));

    /**
     * {@code minecraft:entity.piglin_brute.angry}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIGLIN_BRUTE_ANGRY = create(key("entity.piglin_brute.angry"));

    /**
     * {@code minecraft:entity.piglin_brute.converted_to_zombified}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIGLIN_BRUTE_CONVERTED_TO_ZOMBIFIED = create(key("entity.piglin_brute.converted_to_zombified"));

    /**
     * {@code minecraft:entity.piglin_brute.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIGLIN_BRUTE_DEATH = create(key("entity.piglin_brute.death"));

    /**
     * {@code minecraft:entity.piglin_brute.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIGLIN_BRUTE_HURT = create(key("entity.piglin_brute.hurt"));

    /**
     * {@code minecraft:entity.piglin_brute.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PIGLIN_BRUTE_STEP = create(key("entity.piglin_brute.step"));

    /**
     * {@code minecraft:entity.pillager.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PILLAGER_AMBIENT = create(key("entity.pillager.ambient"));

    /**
     * {@code minecraft:entity.pillager.celebrate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PILLAGER_CELEBRATE = create(key("entity.pillager.celebrate"));

    /**
     * {@code minecraft:entity.pillager.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PILLAGER_DEATH = create(key("entity.pillager.death"));

    /**
     * {@code minecraft:entity.pillager.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PILLAGER_HURT = create(key("entity.pillager.hurt"));

    /**
     * {@code minecraft:entity.player.attack.crit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_ATTACK_CRIT = create(key("entity.player.attack.crit"));

    /**
     * {@code minecraft:entity.player.attack.knockback}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_ATTACK_KNOCKBACK = create(key("entity.player.attack.knockback"));

    /**
     * {@code minecraft:entity.player.attack.nodamage}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_ATTACK_NODAMAGE = create(key("entity.player.attack.nodamage"));

    /**
     * {@code minecraft:entity.player.attack.strong}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_ATTACK_STRONG = create(key("entity.player.attack.strong"));

    /**
     * {@code minecraft:entity.player.attack.sweep}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_ATTACK_SWEEP = create(key("entity.player.attack.sweep"));

    /**
     * {@code minecraft:entity.player.attack.weak}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_ATTACK_WEAK = create(key("entity.player.attack.weak"));

    /**
     * {@code minecraft:entity.player.big_fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_BIG_FALL = create(key("entity.player.big_fall"));

    /**
     * {@code minecraft:entity.player.breath}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_BREATH = create(key("entity.player.breath"));

    /**
     * {@code minecraft:entity.player.burp}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_BURP = create(key("entity.player.burp"));

    /**
     * {@code minecraft:entity.player.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_DEATH = create(key("entity.player.death"));

    /**
     * {@code minecraft:entity.player.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_HURT = create(key("entity.player.hurt"));

    /**
     * {@code minecraft:entity.player.hurt_drown}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_HURT_DROWN = create(key("entity.player.hurt_drown"));

    /**
     * {@code minecraft:entity.player.hurt_freeze}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_HURT_FREEZE = create(key("entity.player.hurt_freeze"));

    /**
     * {@code minecraft:entity.player.hurt_on_fire}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_HURT_ON_FIRE = create(key("entity.player.hurt_on_fire"));

    /**
     * {@code minecraft:entity.player.hurt_sweet_berry_bush}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_HURT_SWEET_BERRY_BUSH = create(key("entity.player.hurt_sweet_berry_bush"));

    /**
     * {@code minecraft:entity.player.levelup}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_LEVELUP = create(key("entity.player.levelup"));

    /**
     * {@code minecraft:entity.player.small_fall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_SMALL_FALL = create(key("entity.player.small_fall"));

    /**
     * {@code minecraft:entity.player.splash}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_SPLASH = create(key("entity.player.splash"));

    /**
     * {@code minecraft:entity.player.splash.high_speed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_SPLASH_HIGH_SPEED = create(key("entity.player.splash.high_speed"));

    /**
     * {@code minecraft:entity.player.swim}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_SWIM = create(key("entity.player.swim"));

    /**
     * {@code minecraft:entity.player.teleport}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PLAYER_TELEPORT = create(key("entity.player.teleport"));

    /**
     * {@code minecraft:entity.polar_bear.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_POLAR_BEAR_AMBIENT = create(key("entity.polar_bear.ambient"));

    /**
     * {@code minecraft:entity.polar_bear.ambient_baby}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_POLAR_BEAR_AMBIENT_BABY = create(key("entity.polar_bear.ambient_baby"));

    /**
     * {@code minecraft:entity.polar_bear.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_POLAR_BEAR_DEATH = create(key("entity.polar_bear.death"));

    /**
     * {@code minecraft:entity.polar_bear.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_POLAR_BEAR_HURT = create(key("entity.polar_bear.hurt"));

    /**
     * {@code minecraft:entity.polar_bear.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_POLAR_BEAR_STEP = create(key("entity.polar_bear.step"));

    /**
     * {@code minecraft:entity.polar_bear.warning}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_POLAR_BEAR_WARNING = create(key("entity.polar_bear.warning"));

    /**
     * {@code minecraft:entity.puffer_fish.blow_out}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PUFFER_FISH_BLOW_OUT = create(key("entity.puffer_fish.blow_out"));

    /**
     * {@code minecraft:entity.puffer_fish.blow_up}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PUFFER_FISH_BLOW_UP = create(key("entity.puffer_fish.blow_up"));

    /**
     * {@code minecraft:entity.puffer_fish.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PUFFER_FISH_DEATH = create(key("entity.puffer_fish.death"));

    /**
     * {@code minecraft:entity.puffer_fish.flop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PUFFER_FISH_FLOP = create(key("entity.puffer_fish.flop"));

    /**
     * {@code minecraft:entity.puffer_fish.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PUFFER_FISH_HURT = create(key("entity.puffer_fish.hurt"));

    /**
     * {@code minecraft:entity.puffer_fish.sting}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_PUFFER_FISH_STING = create(key("entity.puffer_fish.sting"));

    /**
     * {@code minecraft:entity.rabbit.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_RABBIT_AMBIENT = create(key("entity.rabbit.ambient"));

    /**
     * {@code minecraft:entity.rabbit.attack}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_RABBIT_ATTACK = create(key("entity.rabbit.attack"));

    /**
     * {@code minecraft:entity.rabbit.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_RABBIT_DEATH = create(key("entity.rabbit.death"));

    /**
     * {@code minecraft:entity.rabbit.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_RABBIT_HURT = create(key("entity.rabbit.hurt"));

    /**
     * {@code minecraft:entity.rabbit.jump}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_RABBIT_JUMP = create(key("entity.rabbit.jump"));

    /**
     * {@code minecraft:entity.ravager.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_RAVAGER_AMBIENT = create(key("entity.ravager.ambient"));

    /**
     * {@code minecraft:entity.ravager.attack}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_RAVAGER_ATTACK = create(key("entity.ravager.attack"));

    /**
     * {@code minecraft:entity.ravager.celebrate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_RAVAGER_CELEBRATE = create(key("entity.ravager.celebrate"));

    /**
     * {@code minecraft:entity.ravager.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_RAVAGER_DEATH = create(key("entity.ravager.death"));

    /**
     * {@code minecraft:entity.ravager.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_RAVAGER_HURT = create(key("entity.ravager.hurt"));

    /**
     * {@code minecraft:entity.ravager.roar}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_RAVAGER_ROAR = create(key("entity.ravager.roar"));

    /**
     * {@code minecraft:entity.ravager.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_RAVAGER_STEP = create(key("entity.ravager.step"));

    /**
     * {@code minecraft:entity.ravager.stunned}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_RAVAGER_STUNNED = create(key("entity.ravager.stunned"));

    /**
     * {@code minecraft:entity.salmon.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SALMON_AMBIENT = create(key("entity.salmon.ambient"));

    /**
     * {@code minecraft:entity.salmon.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SALMON_DEATH = create(key("entity.salmon.death"));

    /**
     * {@code minecraft:entity.salmon.flop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SALMON_FLOP = create(key("entity.salmon.flop"));

    /**
     * {@code minecraft:entity.salmon.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SALMON_HURT = create(key("entity.salmon.hurt"));

    /**
     * {@code minecraft:entity.sheep.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SHEEP_AMBIENT = create(key("entity.sheep.ambient"));

    /**
     * {@code minecraft:entity.sheep.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SHEEP_DEATH = create(key("entity.sheep.death"));

    /**
     * {@code minecraft:entity.sheep.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SHEEP_HURT = create(key("entity.sheep.hurt"));

    /**
     * {@code minecraft:entity.sheep.shear}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SHEEP_SHEAR = create(key("entity.sheep.shear"));

    /**
     * {@code minecraft:entity.sheep.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SHEEP_STEP = create(key("entity.sheep.step"));

    /**
     * {@code minecraft:entity.shulker.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SHULKER_AMBIENT = create(key("entity.shulker.ambient"));

    /**
     * {@code minecraft:entity.shulker.close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SHULKER_CLOSE = create(key("entity.shulker.close"));

    /**
     * {@code minecraft:entity.shulker.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SHULKER_DEATH = create(key("entity.shulker.death"));

    /**
     * {@code minecraft:entity.shulker.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SHULKER_HURT = create(key("entity.shulker.hurt"));

    /**
     * {@code minecraft:entity.shulker.hurt_closed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SHULKER_HURT_CLOSED = create(key("entity.shulker.hurt_closed"));

    /**
     * {@code minecraft:entity.shulker.open}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SHULKER_OPEN = create(key("entity.shulker.open"));

    /**
     * {@code minecraft:entity.shulker.shoot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SHULKER_SHOOT = create(key("entity.shulker.shoot"));

    /**
     * {@code minecraft:entity.shulker.teleport}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SHULKER_TELEPORT = create(key("entity.shulker.teleport"));

    /**
     * {@code minecraft:entity.shulker_bullet.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SHULKER_BULLET_HIT = create(key("entity.shulker_bullet.hit"));

    /**
     * {@code minecraft:entity.shulker_bullet.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SHULKER_BULLET_HURT = create(key("entity.shulker_bullet.hurt"));

    /**
     * {@code minecraft:entity.silverfish.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SILVERFISH_AMBIENT = create(key("entity.silverfish.ambient"));

    /**
     * {@code minecraft:entity.silverfish.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SILVERFISH_DEATH = create(key("entity.silverfish.death"));

    /**
     * {@code minecraft:entity.silverfish.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SILVERFISH_HURT = create(key("entity.silverfish.hurt"));

    /**
     * {@code minecraft:entity.silverfish.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SILVERFISH_STEP = create(key("entity.silverfish.step"));

    /**
     * {@code minecraft:entity.skeleton.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SKELETON_AMBIENT = create(key("entity.skeleton.ambient"));

    /**
     * {@code minecraft:entity.skeleton.converted_to_stray}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SKELETON_CONVERTED_TO_STRAY = create(key("entity.skeleton.converted_to_stray"));

    /**
     * {@code minecraft:entity.skeleton.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SKELETON_DEATH = create(key("entity.skeleton.death"));

    /**
     * {@code minecraft:entity.skeleton.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SKELETON_HURT = create(key("entity.skeleton.hurt"));

    /**
     * {@code minecraft:entity.skeleton.shoot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SKELETON_SHOOT = create(key("entity.skeleton.shoot"));

    /**
     * {@code minecraft:entity.skeleton.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SKELETON_STEP = create(key("entity.skeleton.step"));

    /**
     * {@code minecraft:entity.skeleton_horse.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SKELETON_HORSE_AMBIENT = create(key("entity.skeleton_horse.ambient"));

    /**
     * {@code minecraft:entity.skeleton_horse.ambient_water}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SKELETON_HORSE_AMBIENT_WATER = create(key("entity.skeleton_horse.ambient_water"));

    /**
     * {@code minecraft:entity.skeleton_horse.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SKELETON_HORSE_DEATH = create(key("entity.skeleton_horse.death"));

    /**
     * {@code minecraft:entity.skeleton_horse.gallop_water}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SKELETON_HORSE_GALLOP_WATER = create(key("entity.skeleton_horse.gallop_water"));

    /**
     * {@code minecraft:entity.skeleton_horse.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SKELETON_HORSE_HURT = create(key("entity.skeleton_horse.hurt"));

    /**
     * {@code minecraft:entity.skeleton_horse.jump_water}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SKELETON_HORSE_JUMP_WATER = create(key("entity.skeleton_horse.jump_water"));

    /**
     * {@code minecraft:entity.skeleton_horse.step_water}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SKELETON_HORSE_STEP_WATER = create(key("entity.skeleton_horse.step_water"));

    /**
     * {@code minecraft:entity.skeleton_horse.swim}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SKELETON_HORSE_SWIM = create(key("entity.skeleton_horse.swim"));

    /**
     * {@code minecraft:entity.slime.attack}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SLIME_ATTACK = create(key("entity.slime.attack"));

    /**
     * {@code minecraft:entity.slime.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SLIME_DEATH = create(key("entity.slime.death"));

    /**
     * {@code minecraft:entity.slime.death_small}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SLIME_DEATH_SMALL = create(key("entity.slime.death_small"));

    /**
     * {@code minecraft:entity.slime.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SLIME_HURT = create(key("entity.slime.hurt"));

    /**
     * {@code minecraft:entity.slime.hurt_small}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SLIME_HURT_SMALL = create(key("entity.slime.hurt_small"));

    /**
     * {@code minecraft:entity.slime.jump}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SLIME_JUMP = create(key("entity.slime.jump"));

    /**
     * {@code minecraft:entity.slime.jump_small}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SLIME_JUMP_SMALL = create(key("entity.slime.jump_small"));

    /**
     * {@code minecraft:entity.slime.squish}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SLIME_SQUISH = create(key("entity.slime.squish"));

    /**
     * {@code minecraft:entity.slime.squish_small}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SLIME_SQUISH_SMALL = create(key("entity.slime.squish_small"));

    /**
     * {@code minecraft:entity.sniffer.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SNIFFER_DEATH = create(key("entity.sniffer.death"));

    /**
     * {@code minecraft:entity.sniffer.digging}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SNIFFER_DIGGING = create(key("entity.sniffer.digging"));

    /**
     * {@code minecraft:entity.sniffer.digging_stop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SNIFFER_DIGGING_STOP = create(key("entity.sniffer.digging_stop"));

    /**
     * {@code minecraft:entity.sniffer.drop_seed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SNIFFER_DROP_SEED = create(key("entity.sniffer.drop_seed"));

    /**
     * {@code minecraft:entity.sniffer.eat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SNIFFER_EAT = create(key("entity.sniffer.eat"));

    /**
     * {@code minecraft:entity.sniffer.happy}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SNIFFER_HAPPY = create(key("entity.sniffer.happy"));

    /**
     * {@code minecraft:entity.sniffer.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SNIFFER_HURT = create(key("entity.sniffer.hurt"));

    /**
     * {@code minecraft:entity.sniffer.idle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SNIFFER_IDLE = create(key("entity.sniffer.idle"));

    /**
     * {@code minecraft:entity.sniffer.scenting}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SNIFFER_SCENTING = create(key("entity.sniffer.scenting"));

    /**
     * {@code minecraft:entity.sniffer.searching}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SNIFFER_SEARCHING = create(key("entity.sniffer.searching"));

    /**
     * {@code minecraft:entity.sniffer.sniffing}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SNIFFER_SNIFFING = create(key("entity.sniffer.sniffing"));

    /**
     * {@code minecraft:entity.sniffer.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SNIFFER_STEP = create(key("entity.sniffer.step"));

    /**
     * {@code minecraft:entity.snow_golem.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SNOW_GOLEM_AMBIENT = create(key("entity.snow_golem.ambient"));

    /**
     * {@code minecraft:entity.snow_golem.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SNOW_GOLEM_DEATH = create(key("entity.snow_golem.death"));

    /**
     * {@code minecraft:entity.snow_golem.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SNOW_GOLEM_HURT = create(key("entity.snow_golem.hurt"));

    /**
     * {@code minecraft:entity.snow_golem.shear}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SNOW_GOLEM_SHEAR = create(key("entity.snow_golem.shear"));

    /**
     * {@code minecraft:entity.snow_golem.shoot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SNOW_GOLEM_SHOOT = create(key("entity.snow_golem.shoot"));

    /**
     * {@code minecraft:entity.snowball.throw}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SNOWBALL_THROW = create(key("entity.snowball.throw"));

    /**
     * {@code minecraft:entity.spider.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SPIDER_AMBIENT = create(key("entity.spider.ambient"));

    /**
     * {@code minecraft:entity.spider.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SPIDER_DEATH = create(key("entity.spider.death"));

    /**
     * {@code minecraft:entity.spider.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SPIDER_HURT = create(key("entity.spider.hurt"));

    /**
     * {@code minecraft:entity.spider.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SPIDER_STEP = create(key("entity.spider.step"));

    /**
     * {@code minecraft:entity.splash_potion.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SPLASH_POTION_BREAK = create(key("entity.splash_potion.break"));

    /**
     * {@code minecraft:entity.splash_potion.throw}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SPLASH_POTION_THROW = create(key("entity.splash_potion.throw"));

    /**
     * {@code minecraft:entity.squid.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SQUID_AMBIENT = create(key("entity.squid.ambient"));

    /**
     * {@code minecraft:entity.squid.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SQUID_DEATH = create(key("entity.squid.death"));

    /**
     * {@code minecraft:entity.squid.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SQUID_HURT = create(key("entity.squid.hurt"));

    /**
     * {@code minecraft:entity.squid.squirt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_SQUID_SQUIRT = create(key("entity.squid.squirt"));

    /**
     * {@code minecraft:entity.stray.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_STRAY_AMBIENT = create(key("entity.stray.ambient"));

    /**
     * {@code minecraft:entity.stray.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_STRAY_DEATH = create(key("entity.stray.death"));

    /**
     * {@code minecraft:entity.stray.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_STRAY_HURT = create(key("entity.stray.hurt"));

    /**
     * {@code minecraft:entity.stray.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_STRAY_STEP = create(key("entity.stray.step"));

    /**
     * {@code minecraft:entity.strider.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_STRIDER_AMBIENT = create(key("entity.strider.ambient"));

    /**
     * {@code minecraft:entity.strider.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_STRIDER_DEATH = create(key("entity.strider.death"));

    /**
     * {@code minecraft:entity.strider.eat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_STRIDER_EAT = create(key("entity.strider.eat"));

    /**
     * {@code minecraft:entity.strider.happy}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_STRIDER_HAPPY = create(key("entity.strider.happy"));

    /**
     * {@code minecraft:entity.strider.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_STRIDER_HURT = create(key("entity.strider.hurt"));

    /**
     * {@code minecraft:entity.strider.retreat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_STRIDER_RETREAT = create(key("entity.strider.retreat"));

    /**
     * {@code minecraft:entity.strider.saddle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_STRIDER_SADDLE = create(key("entity.strider.saddle"));

    /**
     * {@code minecraft:entity.strider.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_STRIDER_STEP = create(key("entity.strider.step"));

    /**
     * {@code minecraft:entity.strider.step_lava}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_STRIDER_STEP_LAVA = create(key("entity.strider.step_lava"));

    /**
     * {@code minecraft:entity.tadpole.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TADPOLE_DEATH = create(key("entity.tadpole.death"));

    /**
     * {@code minecraft:entity.tadpole.flop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TADPOLE_FLOP = create(key("entity.tadpole.flop"));

    /**
     * {@code minecraft:entity.tadpole.grow_up}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TADPOLE_GROW_UP = create(key("entity.tadpole.grow_up"));

    /**
     * {@code minecraft:entity.tadpole.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TADPOLE_HURT = create(key("entity.tadpole.hurt"));

    /**
     * {@code minecraft:entity.tnt.primed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TNT_PRIMED = create(key("entity.tnt.primed"));

    /**
     * {@code minecraft:entity.tropical_fish.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TROPICAL_FISH_AMBIENT = create(key("entity.tropical_fish.ambient"));

    /**
     * {@code minecraft:entity.tropical_fish.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TROPICAL_FISH_DEATH = create(key("entity.tropical_fish.death"));

    /**
     * {@code minecraft:entity.tropical_fish.flop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TROPICAL_FISH_FLOP = create(key("entity.tropical_fish.flop"));

    /**
     * {@code minecraft:entity.tropical_fish.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TROPICAL_FISH_HURT = create(key("entity.tropical_fish.hurt"));

    /**
     * {@code minecraft:entity.turtle.ambient_land}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TURTLE_AMBIENT_LAND = create(key("entity.turtle.ambient_land"));

    /**
     * {@code minecraft:entity.turtle.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TURTLE_DEATH = create(key("entity.turtle.death"));

    /**
     * {@code minecraft:entity.turtle.death_baby}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TURTLE_DEATH_BABY = create(key("entity.turtle.death_baby"));

    /**
     * {@code minecraft:entity.turtle.egg_break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TURTLE_EGG_BREAK = create(key("entity.turtle.egg_break"));

    /**
     * {@code minecraft:entity.turtle.egg_crack}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TURTLE_EGG_CRACK = create(key("entity.turtle.egg_crack"));

    /**
     * {@code minecraft:entity.turtle.egg_hatch}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TURTLE_EGG_HATCH = create(key("entity.turtle.egg_hatch"));

    /**
     * {@code minecraft:entity.turtle.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TURTLE_HURT = create(key("entity.turtle.hurt"));

    /**
     * {@code minecraft:entity.turtle.hurt_baby}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TURTLE_HURT_BABY = create(key("entity.turtle.hurt_baby"));

    /**
     * {@code minecraft:entity.turtle.lay_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TURTLE_LAY_EGG = create(key("entity.turtle.lay_egg"));

    /**
     * {@code minecraft:entity.turtle.shamble}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TURTLE_SHAMBLE = create(key("entity.turtle.shamble"));

    /**
     * {@code minecraft:entity.turtle.shamble_baby}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TURTLE_SHAMBLE_BABY = create(key("entity.turtle.shamble_baby"));

    /**
     * {@code minecraft:entity.turtle.swim}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_TURTLE_SWIM = create(key("entity.turtle.swim"));

    /**
     * {@code minecraft:entity.vex.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VEX_AMBIENT = create(key("entity.vex.ambient"));

    /**
     * {@code minecraft:entity.vex.charge}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VEX_CHARGE = create(key("entity.vex.charge"));

    /**
     * {@code minecraft:entity.vex.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VEX_DEATH = create(key("entity.vex.death"));

    /**
     * {@code minecraft:entity.vex.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VEX_HURT = create(key("entity.vex.hurt"));

    /**
     * {@code minecraft:entity.villager.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_AMBIENT = create(key("entity.villager.ambient"));

    /**
     * {@code minecraft:entity.villager.celebrate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_CELEBRATE = create(key("entity.villager.celebrate"));

    /**
     * {@code minecraft:entity.villager.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_DEATH = create(key("entity.villager.death"));

    /**
     * {@code minecraft:entity.villager.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_HURT = create(key("entity.villager.hurt"));

    /**
     * {@code minecraft:entity.villager.no}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_NO = create(key("entity.villager.no"));

    /**
     * {@code minecraft:entity.villager.trade}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_TRADE = create(key("entity.villager.trade"));

    /**
     * {@code minecraft:entity.villager.work_armorer}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_WORK_ARMORER = create(key("entity.villager.work_armorer"));

    /**
     * {@code minecraft:entity.villager.work_butcher}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_WORK_BUTCHER = create(key("entity.villager.work_butcher"));

    /**
     * {@code minecraft:entity.villager.work_cartographer}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_WORK_CARTOGRAPHER = create(key("entity.villager.work_cartographer"));

    /**
     * {@code minecraft:entity.villager.work_cleric}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_WORK_CLERIC = create(key("entity.villager.work_cleric"));

    /**
     * {@code minecraft:entity.villager.work_farmer}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_WORK_FARMER = create(key("entity.villager.work_farmer"));

    /**
     * {@code minecraft:entity.villager.work_fisherman}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_WORK_FISHERMAN = create(key("entity.villager.work_fisherman"));

    /**
     * {@code minecraft:entity.villager.work_fletcher}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_WORK_FLETCHER = create(key("entity.villager.work_fletcher"));

    /**
     * {@code minecraft:entity.villager.work_leatherworker}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_WORK_LEATHERWORKER = create(key("entity.villager.work_leatherworker"));

    /**
     * {@code minecraft:entity.villager.work_librarian}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_WORK_LIBRARIAN = create(key("entity.villager.work_librarian"));

    /**
     * {@code minecraft:entity.villager.work_mason}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_WORK_MASON = create(key("entity.villager.work_mason"));

    /**
     * {@code minecraft:entity.villager.work_shepherd}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_WORK_SHEPHERD = create(key("entity.villager.work_shepherd"));

    /**
     * {@code minecraft:entity.villager.work_toolsmith}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_WORK_TOOLSMITH = create(key("entity.villager.work_toolsmith"));

    /**
     * {@code minecraft:entity.villager.work_weaponsmith}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_WORK_WEAPONSMITH = create(key("entity.villager.work_weaponsmith"));

    /**
     * {@code minecraft:entity.villager.yes}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VILLAGER_YES = create(key("entity.villager.yes"));

    /**
     * {@code minecraft:entity.vindicator.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VINDICATOR_AMBIENT = create(key("entity.vindicator.ambient"));

    /**
     * {@code minecraft:entity.vindicator.celebrate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VINDICATOR_CELEBRATE = create(key("entity.vindicator.celebrate"));

    /**
     * {@code minecraft:entity.vindicator.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VINDICATOR_DEATH = create(key("entity.vindicator.death"));

    /**
     * {@code minecraft:entity.vindicator.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_VINDICATOR_HURT = create(key("entity.vindicator.hurt"));

    /**
     * {@code minecraft:entity.wandering_trader.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WANDERING_TRADER_AMBIENT = create(key("entity.wandering_trader.ambient"));

    /**
     * {@code minecraft:entity.wandering_trader.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WANDERING_TRADER_DEATH = create(key("entity.wandering_trader.death"));

    /**
     * {@code minecraft:entity.wandering_trader.disappeared}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WANDERING_TRADER_DISAPPEARED = create(key("entity.wandering_trader.disappeared"));

    /**
     * {@code minecraft:entity.wandering_trader.drink_milk}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WANDERING_TRADER_DRINK_MILK = create(key("entity.wandering_trader.drink_milk"));

    /**
     * {@code minecraft:entity.wandering_trader.drink_potion}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WANDERING_TRADER_DRINK_POTION = create(key("entity.wandering_trader.drink_potion"));

    /**
     * {@code minecraft:entity.wandering_trader.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WANDERING_TRADER_HURT = create(key("entity.wandering_trader.hurt"));

    /**
     * {@code minecraft:entity.wandering_trader.no}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WANDERING_TRADER_NO = create(key("entity.wandering_trader.no"));

    /**
     * {@code minecraft:entity.wandering_trader.reappeared}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WANDERING_TRADER_REAPPEARED = create(key("entity.wandering_trader.reappeared"));

    /**
     * {@code minecraft:entity.wandering_trader.trade}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WANDERING_TRADER_TRADE = create(key("entity.wandering_trader.trade"));

    /**
     * {@code minecraft:entity.wandering_trader.yes}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WANDERING_TRADER_YES = create(key("entity.wandering_trader.yes"));

    /**
     * {@code minecraft:entity.warden.agitated}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_AGITATED = create(key("entity.warden.agitated"));

    /**
     * {@code minecraft:entity.warden.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_AMBIENT = create(key("entity.warden.ambient"));

    /**
     * {@code minecraft:entity.warden.angry}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_ANGRY = create(key("entity.warden.angry"));

    /**
     * {@code minecraft:entity.warden.attack_impact}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_ATTACK_IMPACT = create(key("entity.warden.attack_impact"));

    /**
     * {@code minecraft:entity.warden.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_DEATH = create(key("entity.warden.death"));

    /**
     * {@code minecraft:entity.warden.dig}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_DIG = create(key("entity.warden.dig"));

    /**
     * {@code minecraft:entity.warden.emerge}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_EMERGE = create(key("entity.warden.emerge"));

    /**
     * {@code minecraft:entity.warden.heartbeat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_HEARTBEAT = create(key("entity.warden.heartbeat"));

    /**
     * {@code minecraft:entity.warden.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_HURT = create(key("entity.warden.hurt"));

    /**
     * {@code minecraft:entity.warden.listening}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_LISTENING = create(key("entity.warden.listening"));

    /**
     * {@code minecraft:entity.warden.listening_angry}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_LISTENING_ANGRY = create(key("entity.warden.listening_angry"));

    /**
     * {@code minecraft:entity.warden.nearby_close}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_NEARBY_CLOSE = create(key("entity.warden.nearby_close"));

    /**
     * {@code minecraft:entity.warden.nearby_closer}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_NEARBY_CLOSER = create(key("entity.warden.nearby_closer"));

    /**
     * {@code minecraft:entity.warden.nearby_closest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_NEARBY_CLOSEST = create(key("entity.warden.nearby_closest"));

    /**
     * {@code minecraft:entity.warden.roar}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_ROAR = create(key("entity.warden.roar"));

    /**
     * {@code minecraft:entity.warden.sniff}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_SNIFF = create(key("entity.warden.sniff"));

    /**
     * {@code minecraft:entity.warden.sonic_boom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_SONIC_BOOM = create(key("entity.warden.sonic_boom"));

    /**
     * {@code minecraft:entity.warden.sonic_charge}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_SONIC_CHARGE = create(key("entity.warden.sonic_charge"));

    /**
     * {@code minecraft:entity.warden.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_STEP = create(key("entity.warden.step"));

    /**
     * {@code minecraft:entity.warden.tendril_clicks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WARDEN_TENDRIL_CLICKS = create(key("entity.warden.tendril_clicks"));

    /**
     * {@code minecraft:entity.wind_charge.throw}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WIND_CHARGE_THROW = create(key("entity.wind_charge.throw"));

    /**
     * {@code minecraft:entity.wind_charge.wind_burst}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WIND_CHARGE_WIND_BURST = create(key("entity.wind_charge.wind_burst"));

    /**
     * {@code minecraft:entity.witch.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WITCH_AMBIENT = create(key("entity.witch.ambient"));

    /**
     * {@code minecraft:entity.witch.celebrate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WITCH_CELEBRATE = create(key("entity.witch.celebrate"));

    /**
     * {@code minecraft:entity.witch.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WITCH_DEATH = create(key("entity.witch.death"));

    /**
     * {@code minecraft:entity.witch.drink}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WITCH_DRINK = create(key("entity.witch.drink"));

    /**
     * {@code minecraft:entity.witch.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WITCH_HURT = create(key("entity.witch.hurt"));

    /**
     * {@code minecraft:entity.witch.throw}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WITCH_THROW = create(key("entity.witch.throw"));

    /**
     * {@code minecraft:entity.wither.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WITHER_AMBIENT = create(key("entity.wither.ambient"));

    /**
     * {@code minecraft:entity.wither.break_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WITHER_BREAK_BLOCK = create(key("entity.wither.break_block"));

    /**
     * {@code minecraft:entity.wither.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WITHER_DEATH = create(key("entity.wither.death"));

    /**
     * {@code minecraft:entity.wither.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WITHER_HURT = create(key("entity.wither.hurt"));

    /**
     * {@code minecraft:entity.wither.shoot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WITHER_SHOOT = create(key("entity.wither.shoot"));

    /**
     * {@code minecraft:entity.wither.spawn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WITHER_SPAWN = create(key("entity.wither.spawn"));

    /**
     * {@code minecraft:entity.wither_skeleton.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WITHER_SKELETON_AMBIENT = create(key("entity.wither_skeleton.ambient"));

    /**
     * {@code minecraft:entity.wither_skeleton.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WITHER_SKELETON_DEATH = create(key("entity.wither_skeleton.death"));

    /**
     * {@code minecraft:entity.wither_skeleton.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WITHER_SKELETON_HURT = create(key("entity.wither_skeleton.hurt"));

    /**
     * {@code minecraft:entity.wither_skeleton.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WITHER_SKELETON_STEP = create(key("entity.wither_skeleton.step"));

    /**
     * {@code minecraft:entity.wolf.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_AMBIENT = create(key("entity.wolf.ambient"));

    /**
     * {@code minecraft:entity.wolf.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_DEATH = create(key("entity.wolf.death"));

    /**
     * {@code minecraft:entity.wolf.growl}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_GROWL = create(key("entity.wolf.growl"));

    /**
     * {@code minecraft:entity.wolf.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_HURT = create(key("entity.wolf.hurt"));

    /**
     * {@code minecraft:entity.wolf.pant}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_PANT = create(key("entity.wolf.pant"));

    /**
     * {@code minecraft:entity.wolf.shake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_SHAKE = create(key("entity.wolf.shake"));

    /**
     * {@code minecraft:entity.wolf.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_STEP = create(key("entity.wolf.step"));

    /**
     * {@code minecraft:entity.wolf.whine}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_WHINE = create(key("entity.wolf.whine"));

    /**
     * {@code minecraft:entity.wolf_angry.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_ANGRY_AMBIENT = create(key("entity.wolf_angry.ambient"));

    /**
     * {@code minecraft:entity.wolf_angry.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_ANGRY_DEATH = create(key("entity.wolf_angry.death"));

    /**
     * {@code minecraft:entity.wolf_angry.growl}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_ANGRY_GROWL = create(key("entity.wolf_angry.growl"));

    /**
     * {@code minecraft:entity.wolf_angry.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_ANGRY_HURT = create(key("entity.wolf_angry.hurt"));

    /**
     * {@code minecraft:entity.wolf_angry.pant}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_ANGRY_PANT = create(key("entity.wolf_angry.pant"));

    /**
     * {@code minecraft:entity.wolf_angry.whine}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_ANGRY_WHINE = create(key("entity.wolf_angry.whine"));

    /**
     * {@code minecraft:entity.wolf_big.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_BIG_AMBIENT = create(key("entity.wolf_big.ambient"));

    /**
     * {@code minecraft:entity.wolf_big.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_BIG_DEATH = create(key("entity.wolf_big.death"));

    /**
     * {@code minecraft:entity.wolf_big.growl}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_BIG_GROWL = create(key("entity.wolf_big.growl"));

    /**
     * {@code minecraft:entity.wolf_big.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_BIG_HURT = create(key("entity.wolf_big.hurt"));

    /**
     * {@code minecraft:entity.wolf_big.pant}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_BIG_PANT = create(key("entity.wolf_big.pant"));

    /**
     * {@code minecraft:entity.wolf_big.whine}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_BIG_WHINE = create(key("entity.wolf_big.whine"));

    /**
     * {@code minecraft:entity.wolf_cute.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_CUTE_AMBIENT = create(key("entity.wolf_cute.ambient"));

    /**
     * {@code minecraft:entity.wolf_cute.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_CUTE_DEATH = create(key("entity.wolf_cute.death"));

    /**
     * {@code minecraft:entity.wolf_cute.growl}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_CUTE_GROWL = create(key("entity.wolf_cute.growl"));

    /**
     * {@code minecraft:entity.wolf_cute.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_CUTE_HURT = create(key("entity.wolf_cute.hurt"));

    /**
     * {@code minecraft:entity.wolf_cute.pant}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_CUTE_PANT = create(key("entity.wolf_cute.pant"));

    /**
     * {@code minecraft:entity.wolf_cute.whine}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_CUTE_WHINE = create(key("entity.wolf_cute.whine"));

    /**
     * {@code minecraft:entity.wolf_grumpy.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_GRUMPY_AMBIENT = create(key("entity.wolf_grumpy.ambient"));

    /**
     * {@code minecraft:entity.wolf_grumpy.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_GRUMPY_DEATH = create(key("entity.wolf_grumpy.death"));

    /**
     * {@code minecraft:entity.wolf_grumpy.growl}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_GRUMPY_GROWL = create(key("entity.wolf_grumpy.growl"));

    /**
     * {@code minecraft:entity.wolf_grumpy.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_GRUMPY_HURT = create(key("entity.wolf_grumpy.hurt"));

    /**
     * {@code minecraft:entity.wolf_grumpy.pant}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_GRUMPY_PANT = create(key("entity.wolf_grumpy.pant"));

    /**
     * {@code minecraft:entity.wolf_grumpy.whine}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_GRUMPY_WHINE = create(key("entity.wolf_grumpy.whine"));

    /**
     * {@code minecraft:entity.wolf_puglin.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_PUGLIN_AMBIENT = create(key("entity.wolf_puglin.ambient"));

    /**
     * {@code minecraft:entity.wolf_puglin.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_PUGLIN_DEATH = create(key("entity.wolf_puglin.death"));

    /**
     * {@code minecraft:entity.wolf_puglin.growl}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_PUGLIN_GROWL = create(key("entity.wolf_puglin.growl"));

    /**
     * {@code minecraft:entity.wolf_puglin.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_PUGLIN_HURT = create(key("entity.wolf_puglin.hurt"));

    /**
     * {@code minecraft:entity.wolf_puglin.pant}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_PUGLIN_PANT = create(key("entity.wolf_puglin.pant"));

    /**
     * {@code minecraft:entity.wolf_puglin.whine}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_PUGLIN_WHINE = create(key("entity.wolf_puglin.whine"));

    /**
     * {@code minecraft:entity.wolf_sad.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_SAD_AMBIENT = create(key("entity.wolf_sad.ambient"));

    /**
     * {@code minecraft:entity.wolf_sad.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_SAD_DEATH = create(key("entity.wolf_sad.death"));

    /**
     * {@code minecraft:entity.wolf_sad.growl}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_SAD_GROWL = create(key("entity.wolf_sad.growl"));

    /**
     * {@code minecraft:entity.wolf_sad.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_SAD_HURT = create(key("entity.wolf_sad.hurt"));

    /**
     * {@code minecraft:entity.wolf_sad.pant}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_SAD_PANT = create(key("entity.wolf_sad.pant"));

    /**
     * {@code minecraft:entity.wolf_sad.whine}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_WOLF_SAD_WHINE = create(key("entity.wolf_sad.whine"));

    /**
     * {@code minecraft:entity.zoglin.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOGLIN_AMBIENT = create(key("entity.zoglin.ambient"));

    /**
     * {@code minecraft:entity.zoglin.angry}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOGLIN_ANGRY = create(key("entity.zoglin.angry"));

    /**
     * {@code minecraft:entity.zoglin.attack}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOGLIN_ATTACK = create(key("entity.zoglin.attack"));

    /**
     * {@code minecraft:entity.zoglin.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOGLIN_DEATH = create(key("entity.zoglin.death"));

    /**
     * {@code minecraft:entity.zoglin.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOGLIN_HURT = create(key("entity.zoglin.hurt"));

    /**
     * {@code minecraft:entity.zoglin.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOGLIN_STEP = create(key("entity.zoglin.step"));

    /**
     * {@code minecraft:entity.zombie.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIE_AMBIENT = create(key("entity.zombie.ambient"));

    /**
     * {@code minecraft:entity.zombie.attack_iron_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIE_ATTACK_IRON_DOOR = create(key("entity.zombie.attack_iron_door"));

    /**
     * {@code minecraft:entity.zombie.attack_wooden_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIE_ATTACK_WOODEN_DOOR = create(key("entity.zombie.attack_wooden_door"));

    /**
     * {@code minecraft:entity.zombie.break_wooden_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIE_BREAK_WOODEN_DOOR = create(key("entity.zombie.break_wooden_door"));

    /**
     * {@code minecraft:entity.zombie.converted_to_drowned}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIE_CONVERTED_TO_DROWNED = create(key("entity.zombie.converted_to_drowned"));

    /**
     * {@code minecraft:entity.zombie.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIE_DEATH = create(key("entity.zombie.death"));

    /**
     * {@code minecraft:entity.zombie.destroy_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIE_DESTROY_EGG = create(key("entity.zombie.destroy_egg"));

    /**
     * {@code minecraft:entity.zombie.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIE_HURT = create(key("entity.zombie.hurt"));

    /**
     * {@code minecraft:entity.zombie.infect}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIE_INFECT = create(key("entity.zombie.infect"));

    /**
     * {@code minecraft:entity.zombie.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIE_STEP = create(key("entity.zombie.step"));

    /**
     * {@code minecraft:entity.zombie_horse.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIE_HORSE_AMBIENT = create(key("entity.zombie_horse.ambient"));

    /**
     * {@code minecraft:entity.zombie_horse.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIE_HORSE_DEATH = create(key("entity.zombie_horse.death"));

    /**
     * {@code minecraft:entity.zombie_horse.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIE_HORSE_HURT = create(key("entity.zombie_horse.hurt"));

    /**
     * {@code minecraft:entity.zombie_villager.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIE_VILLAGER_AMBIENT = create(key("entity.zombie_villager.ambient"));

    /**
     * {@code minecraft:entity.zombie_villager.converted}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIE_VILLAGER_CONVERTED = create(key("entity.zombie_villager.converted"));

    /**
     * {@code minecraft:entity.zombie_villager.cure}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIE_VILLAGER_CURE = create(key("entity.zombie_villager.cure"));

    /**
     * {@code minecraft:entity.zombie_villager.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIE_VILLAGER_DEATH = create(key("entity.zombie_villager.death"));

    /**
     * {@code minecraft:entity.zombie_villager.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIE_VILLAGER_HURT = create(key("entity.zombie_villager.hurt"));

    /**
     * {@code minecraft:entity.zombie_villager.step}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIE_VILLAGER_STEP = create(key("entity.zombie_villager.step"));

    /**
     * {@code minecraft:entity.zombified_piglin.ambient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIFIED_PIGLIN_AMBIENT = create(key("entity.zombified_piglin.ambient"));

    /**
     * {@code minecraft:entity.zombified_piglin.angry}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIFIED_PIGLIN_ANGRY = create(key("entity.zombified_piglin.angry"));

    /**
     * {@code minecraft:entity.zombified_piglin.death}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIFIED_PIGLIN_DEATH = create(key("entity.zombified_piglin.death"));

    /**
     * {@code minecraft:entity.zombified_piglin.hurt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ENTITY_ZOMBIFIED_PIGLIN_HURT = create(key("entity.zombified_piglin.hurt"));

    /**
     * {@code minecraft:event.mob_effect.bad_omen}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> EVENT_MOB_EFFECT_BAD_OMEN = create(key("event.mob_effect.bad_omen"));

    /**
     * {@code minecraft:event.mob_effect.raid_omen}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> EVENT_MOB_EFFECT_RAID_OMEN = create(key("event.mob_effect.raid_omen"));

    /**
     * {@code minecraft:event.mob_effect.trial_omen}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> EVENT_MOB_EFFECT_TRIAL_OMEN = create(key("event.mob_effect.trial_omen"));

    /**
     * {@code minecraft:event.raid.horn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> EVENT_RAID_HORN = create(key("event.raid.horn"));

    /**
     * {@code minecraft:intentionally_empty}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> INTENTIONALLY_EMPTY = create(key("intentionally_empty"));

    /**
     * {@code minecraft:item.armor.equip_chain}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_ARMOR_EQUIP_CHAIN = create(key("item.armor.equip_chain"));

    /**
     * {@code minecraft:item.armor.equip_diamond}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_ARMOR_EQUIP_DIAMOND = create(key("item.armor.equip_diamond"));

    /**
     * {@code minecraft:item.armor.equip_elytra}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_ARMOR_EQUIP_ELYTRA = create(key("item.armor.equip_elytra"));

    /**
     * {@code minecraft:item.armor.equip_generic}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_ARMOR_EQUIP_GENERIC = create(key("item.armor.equip_generic"));

    /**
     * {@code minecraft:item.armor.equip_gold}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_ARMOR_EQUIP_GOLD = create(key("item.armor.equip_gold"));

    /**
     * {@code minecraft:item.armor.equip_iron}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_ARMOR_EQUIP_IRON = create(key("item.armor.equip_iron"));

    /**
     * {@code minecraft:item.armor.equip_leather}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_ARMOR_EQUIP_LEATHER = create(key("item.armor.equip_leather"));

    /**
     * {@code minecraft:item.armor.equip_netherite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_ARMOR_EQUIP_NETHERITE = create(key("item.armor.equip_netherite"));

    /**
     * {@code minecraft:item.armor.equip_turtle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_ARMOR_EQUIP_TURTLE = create(key("item.armor.equip_turtle"));

    /**
     * {@code minecraft:item.armor.equip_wolf}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_ARMOR_EQUIP_WOLF = create(key("item.armor.equip_wolf"));

    /**
     * {@code minecraft:item.armor.unequip_wolf}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_ARMOR_UNEQUIP_WOLF = create(key("item.armor.unequip_wolf"));

    /**
     * {@code minecraft:item.axe.scrape}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_AXE_SCRAPE = create(key("item.axe.scrape"));

    /**
     * {@code minecraft:item.axe.strip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_AXE_STRIP = create(key("item.axe.strip"));

    /**
     * {@code minecraft:item.axe.wax_off}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_AXE_WAX_OFF = create(key("item.axe.wax_off"));

    /**
     * {@code minecraft:item.bone_meal.use}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BONE_MEAL_USE = create(key("item.bone_meal.use"));

    /**
     * {@code minecraft:item.book.page_turn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BOOK_PAGE_TURN = create(key("item.book.page_turn"));

    /**
     * {@code minecraft:item.book.put}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BOOK_PUT = create(key("item.book.put"));

    /**
     * {@code minecraft:item.bottle.empty}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BOTTLE_EMPTY = create(key("item.bottle.empty"));

    /**
     * {@code minecraft:item.bottle.fill}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BOTTLE_FILL = create(key("item.bottle.fill"));

    /**
     * {@code minecraft:item.bottle.fill_dragonbreath}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BOTTLE_FILL_DRAGONBREATH = create(key("item.bottle.fill_dragonbreath"));

    /**
     * {@code minecraft:item.brush.brushing.generic}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BRUSH_BRUSHING_GENERIC = create(key("item.brush.brushing.generic"));

    /**
     * {@code minecraft:item.brush.brushing.gravel}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BRUSH_BRUSHING_GRAVEL = create(key("item.brush.brushing.gravel"));

    /**
     * {@code minecraft:item.brush.brushing.gravel.complete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BRUSH_BRUSHING_GRAVEL_COMPLETE = create(key("item.brush.brushing.gravel.complete"));

    /**
     * {@code minecraft:item.brush.brushing.sand}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BRUSH_BRUSHING_SAND = create(key("item.brush.brushing.sand"));

    /**
     * {@code minecraft:item.brush.brushing.sand.complete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BRUSH_BRUSHING_SAND_COMPLETE = create(key("item.brush.brushing.sand.complete"));

    /**
     * {@code minecraft:item.bucket.empty}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BUCKET_EMPTY = create(key("item.bucket.empty"));

    /**
     * {@code minecraft:item.bucket.empty_axolotl}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BUCKET_EMPTY_AXOLOTL = create(key("item.bucket.empty_axolotl"));

    /**
     * {@code minecraft:item.bucket.empty_fish}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BUCKET_EMPTY_FISH = create(key("item.bucket.empty_fish"));

    /**
     * {@code minecraft:item.bucket.empty_lava}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BUCKET_EMPTY_LAVA = create(key("item.bucket.empty_lava"));

    /**
     * {@code minecraft:item.bucket.empty_powder_snow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BUCKET_EMPTY_POWDER_SNOW = create(key("item.bucket.empty_powder_snow"));

    /**
     * {@code minecraft:item.bucket.empty_tadpole}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BUCKET_EMPTY_TADPOLE = create(key("item.bucket.empty_tadpole"));

    /**
     * {@code minecraft:item.bucket.fill}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BUCKET_FILL = create(key("item.bucket.fill"));

    /**
     * {@code minecraft:item.bucket.fill_axolotl}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BUCKET_FILL_AXOLOTL = create(key("item.bucket.fill_axolotl"));

    /**
     * {@code minecraft:item.bucket.fill_fish}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BUCKET_FILL_FISH = create(key("item.bucket.fill_fish"));

    /**
     * {@code minecraft:item.bucket.fill_lava}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BUCKET_FILL_LAVA = create(key("item.bucket.fill_lava"));

    /**
     * {@code minecraft:item.bucket.fill_powder_snow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BUCKET_FILL_POWDER_SNOW = create(key("item.bucket.fill_powder_snow"));

    /**
     * {@code minecraft:item.bucket.fill_tadpole}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BUCKET_FILL_TADPOLE = create(key("item.bucket.fill_tadpole"));

    /**
     * {@code minecraft:item.bundle.drop_contents}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BUNDLE_DROP_CONTENTS = create(key("item.bundle.drop_contents"));

    /**
     * {@code minecraft:item.bundle.insert}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BUNDLE_INSERT = create(key("item.bundle.insert"));

    /**
     * {@code minecraft:item.bundle.insert_fail}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BUNDLE_INSERT_FAIL = create(key("item.bundle.insert_fail"));

    /**
     * {@code minecraft:item.bundle.remove_one}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_BUNDLE_REMOVE_ONE = create(key("item.bundle.remove_one"));

    /**
     * {@code minecraft:item.chorus_fruit.teleport}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_CHORUS_FRUIT_TELEPORT = create(key("item.chorus_fruit.teleport"));

    /**
     * {@code minecraft:item.crop.plant}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_CROP_PLANT = create(key("item.crop.plant"));

    /**
     * {@code minecraft:item.crossbow.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_CROSSBOW_HIT = create(key("item.crossbow.hit"));

    /**
     * {@code minecraft:item.crossbow.loading_end}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_CROSSBOW_LOADING_END = create(key("item.crossbow.loading_end"));

    /**
     * {@code minecraft:item.crossbow.loading_middle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_CROSSBOW_LOADING_MIDDLE = create(key("item.crossbow.loading_middle"));

    /**
     * {@code minecraft:item.crossbow.loading_start}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_CROSSBOW_LOADING_START = create(key("item.crossbow.loading_start"));

    /**
     * {@code minecraft:item.crossbow.quick_charge_1}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_CROSSBOW_QUICK_CHARGE_1 = create(key("item.crossbow.quick_charge_1"));

    /**
     * {@code minecraft:item.crossbow.quick_charge_2}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_CROSSBOW_QUICK_CHARGE_2 = create(key("item.crossbow.quick_charge_2"));

    /**
     * {@code minecraft:item.crossbow.quick_charge_3}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_CROSSBOW_QUICK_CHARGE_3 = create(key("item.crossbow.quick_charge_3"));

    /**
     * {@code minecraft:item.crossbow.shoot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_CROSSBOW_SHOOT = create(key("item.crossbow.shoot"));

    /**
     * {@code minecraft:item.dye.use}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_DYE_USE = create(key("item.dye.use"));

    /**
     * {@code minecraft:item.elytra.flying}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_ELYTRA_FLYING = create(key("item.elytra.flying"));

    /**
     * {@code minecraft:item.firecharge.use}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_FIRECHARGE_USE = create(key("item.firecharge.use"));

    /**
     * {@code minecraft:item.flintandsteel.use}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_FLINTANDSTEEL_USE = create(key("item.flintandsteel.use"));

    /**
     * {@code minecraft:item.glow_ink_sac.use}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_GLOW_INK_SAC_USE = create(key("item.glow_ink_sac.use"));

    /**
     * {@code minecraft:item.goat_horn.sound.0}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_GOAT_HORN_SOUND_0 = create(key("item.goat_horn.sound.0"));

    /**
     * {@code minecraft:item.goat_horn.sound.1}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_GOAT_HORN_SOUND_1 = create(key("item.goat_horn.sound.1"));

    /**
     * {@code minecraft:item.goat_horn.sound.2}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_GOAT_HORN_SOUND_2 = create(key("item.goat_horn.sound.2"));

    /**
     * {@code minecraft:item.goat_horn.sound.3}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_GOAT_HORN_SOUND_3 = create(key("item.goat_horn.sound.3"));

    /**
     * {@code minecraft:item.goat_horn.sound.4}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_GOAT_HORN_SOUND_4 = create(key("item.goat_horn.sound.4"));

    /**
     * {@code minecraft:item.goat_horn.sound.5}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_GOAT_HORN_SOUND_5 = create(key("item.goat_horn.sound.5"));

    /**
     * {@code minecraft:item.goat_horn.sound.6}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_GOAT_HORN_SOUND_6 = create(key("item.goat_horn.sound.6"));

    /**
     * {@code minecraft:item.goat_horn.sound.7}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_GOAT_HORN_SOUND_7 = create(key("item.goat_horn.sound.7"));

    /**
     * {@code minecraft:item.hoe.till}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_HOE_TILL = create(key("item.hoe.till"));

    /**
     * {@code minecraft:item.honey_bottle.drink}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_HONEY_BOTTLE_DRINK = create(key("item.honey_bottle.drink"));

    /**
     * {@code minecraft:item.honeycomb.wax_on}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_HONEYCOMB_WAX_ON = create(key("item.honeycomb.wax_on"));

    /**
     * {@code minecraft:item.horse_armor.unequip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_HORSE_ARMOR_UNEQUIP = create(key("item.horse_armor.unequip"));

    /**
     * {@code minecraft:item.ink_sac.use}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_INK_SAC_USE = create(key("item.ink_sac.use"));

    /**
     * {@code minecraft:item.lead.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_LEAD_BREAK = create(key("item.lead.break"));

    /**
     * {@code minecraft:item.lead.tied}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_LEAD_TIED = create(key("item.lead.tied"));

    /**
     * {@code minecraft:item.lead.untied}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_LEAD_UNTIED = create(key("item.lead.untied"));

    /**
     * {@code minecraft:item.llama_carpet.unequip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_LLAMA_CARPET_UNEQUIP = create(key("item.llama_carpet.unequip"));

    /**
     * {@code minecraft:item.lodestone_compass.lock}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_LODESTONE_COMPASS_LOCK = create(key("item.lodestone_compass.lock"));

    /**
     * {@code minecraft:item.mace.smash_air}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_MACE_SMASH_AIR = create(key("item.mace.smash_air"));

    /**
     * {@code minecraft:item.mace.smash_ground}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_MACE_SMASH_GROUND = create(key("item.mace.smash_ground"));

    /**
     * {@code minecraft:item.mace.smash_ground_heavy}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_MACE_SMASH_GROUND_HEAVY = create(key("item.mace.smash_ground_heavy"));

    /**
     * {@code minecraft:item.nether_wart.plant}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_NETHER_WART_PLANT = create(key("item.nether_wart.plant"));

    /**
     * {@code minecraft:item.ominous_bottle.dispose}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_OMINOUS_BOTTLE_DISPOSE = create(key("item.ominous_bottle.dispose"));

    /**
     * {@code minecraft:item.saddle.unequip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_SADDLE_UNEQUIP = create(key("item.saddle.unequip"));

    /**
     * {@code minecraft:item.shears.snip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_SHEARS_SNIP = create(key("item.shears.snip"));

    /**
     * {@code minecraft:item.shield.block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_SHIELD_BLOCK = create(key("item.shield.block"));

    /**
     * {@code minecraft:item.shield.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_SHIELD_BREAK = create(key("item.shield.break"));

    /**
     * {@code minecraft:item.shovel.flatten}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_SHOVEL_FLATTEN = create(key("item.shovel.flatten"));

    /**
     * {@code minecraft:item.spyglass.stop_using}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_SPYGLASS_STOP_USING = create(key("item.spyglass.stop_using"));

    /**
     * {@code minecraft:item.spyglass.use}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_SPYGLASS_USE = create(key("item.spyglass.use"));

    /**
     * {@code minecraft:item.totem.use}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_TOTEM_USE = create(key("item.totem.use"));

    /**
     * {@code minecraft:item.trident.hit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_TRIDENT_HIT = create(key("item.trident.hit"));

    /**
     * {@code minecraft:item.trident.hit_ground}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_TRIDENT_HIT_GROUND = create(key("item.trident.hit_ground"));

    /**
     * {@code minecraft:item.trident.return}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_TRIDENT_RETURN = create(key("item.trident.return"));

    /**
     * {@code minecraft:item.trident.riptide_1}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_TRIDENT_RIPTIDE_1 = create(key("item.trident.riptide_1"));

    /**
     * {@code minecraft:item.trident.riptide_2}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_TRIDENT_RIPTIDE_2 = create(key("item.trident.riptide_2"));

    /**
     * {@code minecraft:item.trident.riptide_3}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_TRIDENT_RIPTIDE_3 = create(key("item.trident.riptide_3"));

    /**
     * {@code minecraft:item.trident.throw}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_TRIDENT_THROW = create(key("item.trident.throw"));

    /**
     * {@code minecraft:item.trident.thunder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_TRIDENT_THUNDER = create(key("item.trident.thunder"));

    /**
     * {@code minecraft:item.wolf_armor.break}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_WOLF_ARMOR_BREAK = create(key("item.wolf_armor.break"));

    /**
     * {@code minecraft:item.wolf_armor.crack}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_WOLF_ARMOR_CRACK = create(key("item.wolf_armor.crack"));

    /**
     * {@code minecraft:item.wolf_armor.damage}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_WOLF_ARMOR_DAMAGE = create(key("item.wolf_armor.damage"));

    /**
     * {@code minecraft:item.wolf_armor.repair}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> ITEM_WOLF_ARMOR_REPAIR = create(key("item.wolf_armor.repair"));

    /**
     * {@code minecraft:music.creative}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_CREATIVE = create(key("music.creative"));

    /**
     * {@code minecraft:music.credits}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_CREDITS = create(key("music.credits"));

    /**
     * {@code minecraft:music.dragon}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DRAGON = create(key("music.dragon"));

    /**
     * {@code minecraft:music.end}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_END = create(key("music.end"));

    /**
     * {@code minecraft:music.game}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_GAME = create(key("music.game"));

    /**
     * {@code minecraft:music.menu}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_MENU = create(key("music.menu"));

    /**
     * {@code minecraft:music.nether.basalt_deltas}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_NETHER_BASALT_DELTAS = create(key("music.nether.basalt_deltas"));

    /**
     * {@code minecraft:music.nether.crimson_forest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_NETHER_CRIMSON_FOREST = create(key("music.nether.crimson_forest"));

    /**
     * {@code minecraft:music.nether.nether_wastes}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_NETHER_NETHER_WASTES = create(key("music.nether.nether_wastes"));

    /**
     * {@code minecraft:music.nether.soul_sand_valley}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_NETHER_SOUL_SAND_VALLEY = create(key("music.nether.soul_sand_valley"));

    /**
     * {@code minecraft:music.nether.warped_forest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_NETHER_WARPED_FOREST = create(key("music.nether.warped_forest"));

    /**
     * {@code minecraft:music.overworld.badlands}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_OVERWORLD_BADLANDS = create(key("music.overworld.badlands"));

    /**
     * {@code minecraft:music.overworld.bamboo_jungle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_OVERWORLD_BAMBOO_JUNGLE = create(key("music.overworld.bamboo_jungle"));

    /**
     * {@code minecraft:music.overworld.cherry_grove}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_OVERWORLD_CHERRY_GROVE = create(key("music.overworld.cherry_grove"));

    /**
     * {@code minecraft:music.overworld.deep_dark}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_OVERWORLD_DEEP_DARK = create(key("music.overworld.deep_dark"));

    /**
     * {@code minecraft:music.overworld.desert}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_OVERWORLD_DESERT = create(key("music.overworld.desert"));

    /**
     * {@code minecraft:music.overworld.dripstone_caves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_OVERWORLD_DRIPSTONE_CAVES = create(key("music.overworld.dripstone_caves"));

    /**
     * {@code minecraft:music.overworld.flower_forest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_OVERWORLD_FLOWER_FOREST = create(key("music.overworld.flower_forest"));

    /**
     * {@code minecraft:music.overworld.forest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_OVERWORLD_FOREST = create(key("music.overworld.forest"));

    /**
     * {@code minecraft:music.overworld.frozen_peaks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_OVERWORLD_FROZEN_PEAKS = create(key("music.overworld.frozen_peaks"));

    /**
     * {@code minecraft:music.overworld.grove}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_OVERWORLD_GROVE = create(key("music.overworld.grove"));

    /**
     * {@code minecraft:music.overworld.jagged_peaks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_OVERWORLD_JAGGED_PEAKS = create(key("music.overworld.jagged_peaks"));

    /**
     * {@code minecraft:music.overworld.jungle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_OVERWORLD_JUNGLE = create(key("music.overworld.jungle"));

    /**
     * {@code minecraft:music.overworld.lush_caves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_OVERWORLD_LUSH_CAVES = create(key("music.overworld.lush_caves"));

    /**
     * {@code minecraft:music.overworld.meadow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_OVERWORLD_MEADOW = create(key("music.overworld.meadow"));

    /**
     * {@code minecraft:music.overworld.old_growth_taiga}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_OVERWORLD_OLD_GROWTH_TAIGA = create(key("music.overworld.old_growth_taiga"));

    /**
     * {@code minecraft:music.overworld.snowy_slopes}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_OVERWORLD_SNOWY_SLOPES = create(key("music.overworld.snowy_slopes"));

    /**
     * {@code minecraft:music.overworld.sparse_jungle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_OVERWORLD_SPARSE_JUNGLE = create(key("music.overworld.sparse_jungle"));

    /**
     * {@code minecraft:music.overworld.stony_peaks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_OVERWORLD_STONY_PEAKS = create(key("music.overworld.stony_peaks"));

    /**
     * {@code minecraft:music.overworld.swamp}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_OVERWORLD_SWAMP = create(key("music.overworld.swamp"));

    /**
     * {@code minecraft:music.under_water}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_UNDER_WATER = create(key("music.under_water"));

    /**
     * {@code minecraft:music_disc.11}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_11 = create(key("music_disc.11"));

    /**
     * {@code minecraft:music_disc.13}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_13 = create(key("music_disc.13"));

    /**
     * {@code minecraft:music_disc.5}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_5 = create(key("music_disc.5"));

    /**
     * {@code minecraft:music_disc.blocks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_BLOCKS = create(key("music_disc.blocks"));

    /**
     * {@code minecraft:music_disc.cat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_CAT = create(key("music_disc.cat"));

    /**
     * {@code minecraft:music_disc.chirp}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_CHIRP = create(key("music_disc.chirp"));

    /**
     * {@code minecraft:music_disc.creator}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_CREATOR = create(key("music_disc.creator"));

    /**
     * {@code minecraft:music_disc.creator_music_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_CREATOR_MUSIC_BOX = create(key("music_disc.creator_music_box"));

    /**
     * {@code minecraft:music_disc.far}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_FAR = create(key("music_disc.far"));

    /**
     * {@code minecraft:music_disc.lava_chicken}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_LAVA_CHICKEN = create(key("music_disc.lava_chicken"));

    /**
     * {@code minecraft:music_disc.mall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_MALL = create(key("music_disc.mall"));

    /**
     * {@code minecraft:music_disc.mellohi}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_MELLOHI = create(key("music_disc.mellohi"));

    /**
     * {@code minecraft:music_disc.otherside}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_OTHERSIDE = create(key("music_disc.otherside"));

    /**
     * {@code minecraft:music_disc.pigstep}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_PIGSTEP = create(key("music_disc.pigstep"));

    /**
     * {@code minecraft:music_disc.precipice}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_PRECIPICE = create(key("music_disc.precipice"));

    /**
     * {@code minecraft:music_disc.relic}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_RELIC = create(key("music_disc.relic"));

    /**
     * {@code minecraft:music_disc.stal}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_STAL = create(key("music_disc.stal"));

    /**
     * {@code minecraft:music_disc.strad}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_STRAD = create(key("music_disc.strad"));

    /**
     * {@code minecraft:music_disc.tears}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_TEARS = create(key("music_disc.tears"));

    /**
     * {@code minecraft:music_disc.wait}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_WAIT = create(key("music_disc.wait"));

    /**
     * {@code minecraft:music_disc.ward}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> MUSIC_DISC_WARD = create(key("music_disc.ward"));

    /**
     * {@code minecraft:particle.soul_escape}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> PARTICLE_SOUL_ESCAPE = create(key("particle.soul_escape"));

    /**
     * {@code minecraft:ui.button.click}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> UI_BUTTON_CLICK = create(key("ui.button.click"));

    /**
     * {@code minecraft:ui.cartography_table.take_result}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> UI_CARTOGRAPHY_TABLE_TAKE_RESULT = create(key("ui.cartography_table.take_result"));

    /**
     * {@code minecraft:ui.hud.bubble_pop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> UI_HUD_BUBBLE_POP = create(key("ui.hud.bubble_pop"));

    /**
     * {@code minecraft:ui.loom.select_pattern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> UI_LOOM_SELECT_PATTERN = create(key("ui.loom.select_pattern"));

    /**
     * {@code minecraft:ui.loom.take_result}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> UI_LOOM_TAKE_RESULT = create(key("ui.loom.take_result"));

    /**
     * {@code minecraft:ui.stonecutter.select_recipe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> UI_STONECUTTER_SELECT_RECIPE = create(key("ui.stonecutter.select_recipe"));

    /**
     * {@code minecraft:ui.stonecutter.take_result}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> UI_STONECUTTER_TAKE_RESULT = create(key("ui.stonecutter.take_result"));

    /**
     * {@code minecraft:ui.toast.challenge_complete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> UI_TOAST_CHALLENGE_COMPLETE = create(key("ui.toast.challenge_complete"));

    /**
     * {@code minecraft:ui.toast.in}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> UI_TOAST_IN = create(key("ui.toast.in"));

    /**
     * {@code minecraft:ui.toast.out}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> UI_TOAST_OUT = create(key("ui.toast.out"));

    /**
     * {@code minecraft:weather.rain}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> WEATHER_RAIN = create(key("weather.rain"));

    /**
     * {@code minecraft:weather.rain.above}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Sound> WEATHER_RAIN_ABOVE = create(key("weather.rain.above"));

    private SoundEventKeys() {
    }

    private static TypedKey<Sound> create(final Key key) {
        return TypedKey.create(RegistryKey.SOUND_EVENT, key);
    }
}
