/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.server;

import com.google.common.base.Preconditions;
import io.papermc.paper.util.TransformingRandomAccessList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.examination.Examinable;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.string.StringExaminer;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class AsyncTabCompleteEvent
extends Event
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final CommandSender sender;
    private final String buffer;
    private final boolean isCommand;
    private final @Nullable Location location;
    private final List<Completion> completions = new ArrayList<Completion>();
    private final List<String> stringCompletions = new TransformingRandomAccessList<Completion, String>(this.completions, Completion::suggestion, Completion::completion);
    private boolean handled;
    private boolean cancelled;

    @ApiStatus.Internal
    public AsyncTabCompleteEvent(CommandSender sender, String buffer, boolean isCommand, @Nullable Location loc) {
        super(true);
        this.sender = sender;
        this.buffer = buffer;
        this.isCommand = isCommand;
        this.location = loc;
    }

    @Deprecated
    @ApiStatus.Internal
    public AsyncTabCompleteEvent(CommandSender sender, List<String> completions, String buffer, boolean isCommand, @Nullable Location loc) {
        super(true);
        this.sender = sender;
        this.completions.addAll(AsyncTabCompleteEvent.fromStrings(completions));
        this.buffer = buffer;
        this.isCommand = isCommand;
        this.location = loc;
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public List<String> getCompletions() {
        return this.stringCompletions;
    }

    public void setCompletions(List<String> completions) {
        Preconditions.checkArgument((completions != null ? 1 : 0) != 0, (Object)"Completions list cannot be null");
        if (completions == this.stringCompletions) {
            return;
        }
        this.completions.clear();
        this.completions.addAll(AsyncTabCompleteEvent.fromStrings(completions));
    }

    public List<Completion> completions() {
        return this.completions;
    }

    public void completions(List<Completion> newCompletions) {
        Preconditions.checkArgument((newCompletions != null ? 1 : 0) != 0, (Object)"new completions cannot be null");
        this.completions.clear();
        this.completions.addAll(newCompletions);
    }

    public String getBuffer() {
        return this.buffer;
    }

    public boolean isCommand() {
        return this.isCommand;
    }

    public @Nullable Location getLocation() {
        return this.location != null ? this.location.clone() : null;
    }

    public boolean isHandled() {
        return !this.completions.isEmpty() || this.handled;
    }

    public void setHandled(boolean handled) {
        this.handled = handled;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    private static List<Completion> fromStrings(List<String> suggestions) {
        ArrayList<Completion> list = new ArrayList<Completion>(suggestions.size());
        for (String suggestion : suggestions) {
            list.add(new CompletionImpl(suggestion, null));
        }
        return list;
    }

    @ApiStatus.Internal
    static final class CompletionImpl
    implements Completion {
        private final String suggestion;
        private final @Nullable Component tooltip;

        CompletionImpl(String suggestion, @Nullable Component tooltip) {
            this.suggestion = suggestion;
            this.tooltip = tooltip;
        }

        @Override
        public String suggestion() {
            return this.suggestion;
        }

        @Override
        public @Nullable Component tooltip() {
            return this.tooltip;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompletionImpl that = (CompletionImpl)o;
            return this.suggestion.equals(that.suggestion) && Objects.equals(this.tooltip, that.tooltip);
        }

        public int hashCode() {
            return Objects.hash(this.suggestion, this.tooltip);
        }

        public String toString() {
            return (String)StringExaminer.simpleEscaping().examine((Examinable)this);
        }
    }

    public static interface Completion
    extends Examinable {
        public String suggestion();

        public @Nullable Component tooltip();

        default public Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of((String)"suggestion", (String)this.suggestion()), ExaminableProperty.of((String)"tooltip", (Object)this.tooltip()));
        }

        public static Completion completion(String suggestion) {
            return new CompletionImpl(suggestion, null);
        }

        public static Completion completion(String suggestion, @Nullable Component tooltip) {
            return new CompletionImpl(suggestion, tooltip);
        }
    }
}

