package io.papermc.paper.registry.keys;

import static net.kyori.adventure.key.Key.key;

import io.papermc.paper.generated.GeneratedFrom;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import net.kyori.adventure.key.Key;
import org.bukkit.generator.structure.Structure;
import org.jspecify.annotations.NullMarked;

/**
 * Vanilla keys for {@link RegistryKey#STRUCTURE}.
 *
 * @apiNote The fields provided here are a direct representation of
 * what is available from the vanilla game source. They may be
 * changed (including removals) on any Minecraft version
 * bump, so cross-version compatibility is not provided on the
 * same level as it is on most of the other API.
 */
@SuppressWarnings({
        "unused",
        "SpellCheckingInspection"
})
@NullMarked
@GeneratedFrom("1.21.6")
public final class StructureKeys {
    /**
     * {@code minecraft:ancient_city}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> ANCIENT_CITY = create(key("ancient_city"));

    /**
     * {@code minecraft:bastion_remnant}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> BASTION_REMNANT = create(key("bastion_remnant"));

    /**
     * {@code minecraft:buried_treasure}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> BURIED_TREASURE = create(key("buried_treasure"));

    /**
     * {@code minecraft:desert_pyramid}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> DESERT_PYRAMID = create(key("desert_pyramid"));

    /**
     * {@code minecraft:end_city}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> END_CITY = create(key("end_city"));

    /**
     * {@code minecraft:fortress}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> FORTRESS = create(key("fortress"));

    /**
     * {@code minecraft:igloo}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> IGLOO = create(key("igloo"));

    /**
     * {@code minecraft:jungle_pyramid}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> JUNGLE_PYRAMID = create(key("jungle_pyramid"));

    /**
     * {@code minecraft:mansion}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> MANSION = create(key("mansion"));

    /**
     * {@code minecraft:mineshaft}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> MINESHAFT = create(key("mineshaft"));

    /**
     * {@code minecraft:mineshaft_mesa}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> MINESHAFT_MESA = create(key("mineshaft_mesa"));

    /**
     * {@code minecraft:monument}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> MONUMENT = create(key("monument"));

    /**
     * {@code minecraft:nether_fossil}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> NETHER_FOSSIL = create(key("nether_fossil"));

    /**
     * {@code minecraft:ocean_ruin_cold}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> OCEAN_RUIN_COLD = create(key("ocean_ruin_cold"));

    /**
     * {@code minecraft:ocean_ruin_warm}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> OCEAN_RUIN_WARM = create(key("ocean_ruin_warm"));

    /**
     * {@code minecraft:pillager_outpost}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> PILLAGER_OUTPOST = create(key("pillager_outpost"));

    /**
     * {@code minecraft:ruined_portal}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> RUINED_PORTAL = create(key("ruined_portal"));

    /**
     * {@code minecraft:ruined_portal_desert}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> RUINED_PORTAL_DESERT = create(key("ruined_portal_desert"));

    /**
     * {@code minecraft:ruined_portal_jungle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> RUINED_PORTAL_JUNGLE = create(key("ruined_portal_jungle"));

    /**
     * {@code minecraft:ruined_portal_mountain}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> RUINED_PORTAL_MOUNTAIN = create(key("ruined_portal_mountain"));

    /**
     * {@code minecraft:ruined_portal_nether}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> RUINED_PORTAL_NETHER = create(key("ruined_portal_nether"));

    /**
     * {@code minecraft:ruined_portal_ocean}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> RUINED_PORTAL_OCEAN = create(key("ruined_portal_ocean"));

    /**
     * {@code minecraft:ruined_portal_swamp}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> RUINED_PORTAL_SWAMP = create(key("ruined_portal_swamp"));

    /**
     * {@code minecraft:shipwreck}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> SHIPWRECK = create(key("shipwreck"));

    /**
     * {@code minecraft:shipwreck_beached}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> SHIPWRECK_BEACHED = create(key("shipwreck_beached"));

    /**
     * {@code minecraft:stronghold}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> STRONGHOLD = create(key("stronghold"));

    /**
     * {@code minecraft:swamp_hut}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> SWAMP_HUT = create(key("swamp_hut"));

    /**
     * {@code minecraft:trail_ruins}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> TRAIL_RUINS = create(key("trail_ruins"));

    /**
     * {@code minecraft:trial_chambers}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> TRIAL_CHAMBERS = create(key("trial_chambers"));

    /**
     * {@code minecraft:village_desert}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> VILLAGE_DESERT = create(key("village_desert"));

    /**
     * {@code minecraft:village_plains}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> VILLAGE_PLAINS = create(key("village_plains"));

    /**
     * {@code minecraft:village_savanna}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> VILLAGE_SAVANNA = create(key("village_savanna"));

    /**
     * {@code minecraft:village_snowy}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> VILLAGE_SNOWY = create(key("village_snowy"));

    /**
     * {@code minecraft:village_taiga}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Structure> VILLAGE_TAIGA = create(key("village_taiga"));

    private StructureKeys() {
    }

    /**
     * Creates a typed key for {@link Structure} in the registry {@code minecraft:worldgen/structure}.
     *
     * @param key the value's key in the registry
     * @return a new typed key
     */
    public static TypedKey<Structure> create(final Key key) {
        return TypedKey.create(RegistryKey.STRUCTURE, key);
    }
}
