package io.papermc.paper.registry.keys;

import static net.kyori.adventure.key.Key.key;

import io.papermc.paper.generated.GeneratedFrom;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import net.kyori.adventure.key.Key;
import org.bukkit.block.BlockType;
import org.jspecify.annotations.NullMarked;

/**
 * Vanilla keys for {@link RegistryKey#BLOCK}.
 *
 * @apiNote The fields provided here are a direct representation of
 * what is available from the vanilla game source. They may be
 * changed (including removals) on any Minecraft version
 * bump, so cross-version compatibility is not provided on the
 * same level as it is on most of the other API.
 */
@SuppressWarnings({
        "unused",
        "SpellCheckingInspection"
})
@NullMarked
@GeneratedFrom("1.21.6")
public final class BlockTypeKeys {
    /**
     * {@code minecraft:acacia_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ACACIA_BUTTON = create(key("acacia_button"));

    /**
     * {@code minecraft:acacia_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ACACIA_DOOR = create(key("acacia_door"));

    /**
     * {@code minecraft:acacia_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ACACIA_FENCE = create(key("acacia_fence"));

    /**
     * {@code minecraft:acacia_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ACACIA_FENCE_GATE = create(key("acacia_fence_gate"));

    /**
     * {@code minecraft:acacia_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ACACIA_HANGING_SIGN = create(key("acacia_hanging_sign"));

    /**
     * {@code minecraft:acacia_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ACACIA_LEAVES = create(key("acacia_leaves"));

    /**
     * {@code minecraft:acacia_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ACACIA_LOG = create(key("acacia_log"));

    /**
     * {@code minecraft:acacia_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ACACIA_PLANKS = create(key("acacia_planks"));

    /**
     * {@code minecraft:acacia_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ACACIA_PRESSURE_PLATE = create(key("acacia_pressure_plate"));

    /**
     * {@code minecraft:acacia_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ACACIA_SAPLING = create(key("acacia_sapling"));

    /**
     * {@code minecraft:acacia_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ACACIA_SIGN = create(key("acacia_sign"));

    /**
     * {@code minecraft:acacia_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ACACIA_SLAB = create(key("acacia_slab"));

    /**
     * {@code minecraft:acacia_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ACACIA_STAIRS = create(key("acacia_stairs"));

    /**
     * {@code minecraft:acacia_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ACACIA_TRAPDOOR = create(key("acacia_trapdoor"));

    /**
     * {@code minecraft:acacia_wall_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ACACIA_WALL_HANGING_SIGN = create(key("acacia_wall_hanging_sign"));

    /**
     * {@code minecraft:acacia_wall_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ACACIA_WALL_SIGN = create(key("acacia_wall_sign"));

    /**
     * {@code minecraft:acacia_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ACACIA_WOOD = create(key("acacia_wood"));

    /**
     * {@code minecraft:activator_rail}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ACTIVATOR_RAIL = create(key("activator_rail"));

    /**
     * {@code minecraft:air}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> AIR = create(key("air"));

    /**
     * {@code minecraft:allium}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ALLIUM = create(key("allium"));

    /**
     * {@code minecraft:amethyst_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> AMETHYST_BLOCK = create(key("amethyst_block"));

    /**
     * {@code minecraft:amethyst_cluster}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> AMETHYST_CLUSTER = create(key("amethyst_cluster"));

    /**
     * {@code minecraft:ancient_debris}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ANCIENT_DEBRIS = create(key("ancient_debris"));

    /**
     * {@code minecraft:andesite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ANDESITE = create(key("andesite"));

    /**
     * {@code minecraft:andesite_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ANDESITE_SLAB = create(key("andesite_slab"));

    /**
     * {@code minecraft:andesite_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ANDESITE_STAIRS = create(key("andesite_stairs"));

    /**
     * {@code minecraft:andesite_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ANDESITE_WALL = create(key("andesite_wall"));

    /**
     * {@code minecraft:anvil}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ANVIL = create(key("anvil"));

    /**
     * {@code minecraft:attached_melon_stem}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ATTACHED_MELON_STEM = create(key("attached_melon_stem"));

    /**
     * {@code minecraft:attached_pumpkin_stem}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ATTACHED_PUMPKIN_STEM = create(key("attached_pumpkin_stem"));

    /**
     * {@code minecraft:azalea}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> AZALEA = create(key("azalea"));

    /**
     * {@code minecraft:azalea_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> AZALEA_LEAVES = create(key("azalea_leaves"));

    /**
     * {@code minecraft:azure_bluet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> AZURE_BLUET = create(key("azure_bluet"));

    /**
     * {@code minecraft:bamboo}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BAMBOO = create(key("bamboo"));

    /**
     * {@code minecraft:bamboo_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BAMBOO_BLOCK = create(key("bamboo_block"));

    /**
     * {@code minecraft:bamboo_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BAMBOO_BUTTON = create(key("bamboo_button"));

    /**
     * {@code minecraft:bamboo_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BAMBOO_DOOR = create(key("bamboo_door"));

    /**
     * {@code minecraft:bamboo_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BAMBOO_FENCE = create(key("bamboo_fence"));

    /**
     * {@code minecraft:bamboo_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BAMBOO_FENCE_GATE = create(key("bamboo_fence_gate"));

    /**
     * {@code minecraft:bamboo_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BAMBOO_HANGING_SIGN = create(key("bamboo_hanging_sign"));

    /**
     * {@code minecraft:bamboo_mosaic}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BAMBOO_MOSAIC = create(key("bamboo_mosaic"));

    /**
     * {@code minecraft:bamboo_mosaic_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BAMBOO_MOSAIC_SLAB = create(key("bamboo_mosaic_slab"));

    /**
     * {@code minecraft:bamboo_mosaic_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BAMBOO_MOSAIC_STAIRS = create(key("bamboo_mosaic_stairs"));

    /**
     * {@code minecraft:bamboo_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BAMBOO_PLANKS = create(key("bamboo_planks"));

    /**
     * {@code minecraft:bamboo_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BAMBOO_PRESSURE_PLATE = create(key("bamboo_pressure_plate"));

    /**
     * {@code minecraft:bamboo_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BAMBOO_SAPLING = create(key("bamboo_sapling"));

    /**
     * {@code minecraft:bamboo_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BAMBOO_SIGN = create(key("bamboo_sign"));

    /**
     * {@code minecraft:bamboo_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BAMBOO_SLAB = create(key("bamboo_slab"));

    /**
     * {@code minecraft:bamboo_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BAMBOO_STAIRS = create(key("bamboo_stairs"));

    /**
     * {@code minecraft:bamboo_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BAMBOO_TRAPDOOR = create(key("bamboo_trapdoor"));

    /**
     * {@code minecraft:bamboo_wall_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BAMBOO_WALL_HANGING_SIGN = create(key("bamboo_wall_hanging_sign"));

    /**
     * {@code minecraft:bamboo_wall_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BAMBOO_WALL_SIGN = create(key("bamboo_wall_sign"));

    /**
     * {@code minecraft:barrel}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BARREL = create(key("barrel"));

    /**
     * {@code minecraft:barrier}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BARRIER = create(key("barrier"));

    /**
     * {@code minecraft:basalt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BASALT = create(key("basalt"));

    /**
     * {@code minecraft:beacon}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BEACON = create(key("beacon"));

    /**
     * {@code minecraft:bedrock}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BEDROCK = create(key("bedrock"));

    /**
     * {@code minecraft:bee_nest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BEE_NEST = create(key("bee_nest"));

    /**
     * {@code minecraft:beehive}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BEEHIVE = create(key("beehive"));

    /**
     * {@code minecraft:beetroots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BEETROOTS = create(key("beetroots"));

    /**
     * {@code minecraft:bell}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BELL = create(key("bell"));

    /**
     * {@code minecraft:big_dripleaf}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BIG_DRIPLEAF = create(key("big_dripleaf"));

    /**
     * {@code minecraft:big_dripleaf_stem}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BIG_DRIPLEAF_STEM = create(key("big_dripleaf_stem"));

    /**
     * {@code minecraft:birch_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BIRCH_BUTTON = create(key("birch_button"));

    /**
     * {@code minecraft:birch_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BIRCH_DOOR = create(key("birch_door"));

    /**
     * {@code minecraft:birch_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BIRCH_FENCE = create(key("birch_fence"));

    /**
     * {@code minecraft:birch_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BIRCH_FENCE_GATE = create(key("birch_fence_gate"));

    /**
     * {@code minecraft:birch_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BIRCH_HANGING_SIGN = create(key("birch_hanging_sign"));

    /**
     * {@code minecraft:birch_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BIRCH_LEAVES = create(key("birch_leaves"));

    /**
     * {@code minecraft:birch_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BIRCH_LOG = create(key("birch_log"));

    /**
     * {@code minecraft:birch_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BIRCH_PLANKS = create(key("birch_planks"));

    /**
     * {@code minecraft:birch_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BIRCH_PRESSURE_PLATE = create(key("birch_pressure_plate"));

    /**
     * {@code minecraft:birch_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BIRCH_SAPLING = create(key("birch_sapling"));

    /**
     * {@code minecraft:birch_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BIRCH_SIGN = create(key("birch_sign"));

    /**
     * {@code minecraft:birch_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BIRCH_SLAB = create(key("birch_slab"));

    /**
     * {@code minecraft:birch_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BIRCH_STAIRS = create(key("birch_stairs"));

    /**
     * {@code minecraft:birch_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BIRCH_TRAPDOOR = create(key("birch_trapdoor"));

    /**
     * {@code minecraft:birch_wall_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BIRCH_WALL_HANGING_SIGN = create(key("birch_wall_hanging_sign"));

    /**
     * {@code minecraft:birch_wall_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BIRCH_WALL_SIGN = create(key("birch_wall_sign"));

    /**
     * {@code minecraft:birch_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BIRCH_WOOD = create(key("birch_wood"));

    /**
     * {@code minecraft:black_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLACK_BANNER = create(key("black_banner"));

    /**
     * {@code minecraft:black_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLACK_BED = create(key("black_bed"));

    /**
     * {@code minecraft:black_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLACK_CANDLE = create(key("black_candle"));

    /**
     * {@code minecraft:black_candle_cake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLACK_CANDLE_CAKE = create(key("black_candle_cake"));

    /**
     * {@code minecraft:black_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLACK_CARPET = create(key("black_carpet"));

    /**
     * {@code minecraft:black_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLACK_CONCRETE = create(key("black_concrete"));

    /**
     * {@code minecraft:black_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLACK_CONCRETE_POWDER = create(key("black_concrete_powder"));

    /**
     * {@code minecraft:black_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLACK_GLAZED_TERRACOTTA = create(key("black_glazed_terracotta"));

    /**
     * {@code minecraft:black_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLACK_SHULKER_BOX = create(key("black_shulker_box"));

    /**
     * {@code minecraft:black_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLACK_STAINED_GLASS = create(key("black_stained_glass"));

    /**
     * {@code minecraft:black_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLACK_STAINED_GLASS_PANE = create(key("black_stained_glass_pane"));

    /**
     * {@code minecraft:black_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLACK_TERRACOTTA = create(key("black_terracotta"));

    /**
     * {@code minecraft:black_wall_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLACK_WALL_BANNER = create(key("black_wall_banner"));

    /**
     * {@code minecraft:black_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLACK_WOOL = create(key("black_wool"));

    /**
     * {@code minecraft:blackstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLACKSTONE = create(key("blackstone"));

    /**
     * {@code minecraft:blackstone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLACKSTONE_SLAB = create(key("blackstone_slab"));

    /**
     * {@code minecraft:blackstone_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLACKSTONE_STAIRS = create(key("blackstone_stairs"));

    /**
     * {@code minecraft:blackstone_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLACKSTONE_WALL = create(key("blackstone_wall"));

    /**
     * {@code minecraft:blast_furnace}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLAST_FURNACE = create(key("blast_furnace"));

    /**
     * {@code minecraft:blue_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLUE_BANNER = create(key("blue_banner"));

    /**
     * {@code minecraft:blue_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLUE_BED = create(key("blue_bed"));

    /**
     * {@code minecraft:blue_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLUE_CANDLE = create(key("blue_candle"));

    /**
     * {@code minecraft:blue_candle_cake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLUE_CANDLE_CAKE = create(key("blue_candle_cake"));

    /**
     * {@code minecraft:blue_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLUE_CARPET = create(key("blue_carpet"));

    /**
     * {@code minecraft:blue_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLUE_CONCRETE = create(key("blue_concrete"));

    /**
     * {@code minecraft:blue_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLUE_CONCRETE_POWDER = create(key("blue_concrete_powder"));

    /**
     * {@code minecraft:blue_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLUE_GLAZED_TERRACOTTA = create(key("blue_glazed_terracotta"));

    /**
     * {@code minecraft:blue_ice}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLUE_ICE = create(key("blue_ice"));

    /**
     * {@code minecraft:blue_orchid}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLUE_ORCHID = create(key("blue_orchid"));

    /**
     * {@code minecraft:blue_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLUE_SHULKER_BOX = create(key("blue_shulker_box"));

    /**
     * {@code minecraft:blue_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLUE_STAINED_GLASS = create(key("blue_stained_glass"));

    /**
     * {@code minecraft:blue_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLUE_STAINED_GLASS_PANE = create(key("blue_stained_glass_pane"));

    /**
     * {@code minecraft:blue_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLUE_TERRACOTTA = create(key("blue_terracotta"));

    /**
     * {@code minecraft:blue_wall_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLUE_WALL_BANNER = create(key("blue_wall_banner"));

    /**
     * {@code minecraft:blue_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BLUE_WOOL = create(key("blue_wool"));

    /**
     * {@code minecraft:bone_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BONE_BLOCK = create(key("bone_block"));

    /**
     * {@code minecraft:bookshelf}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BOOKSHELF = create(key("bookshelf"));

    /**
     * {@code minecraft:brain_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BRAIN_CORAL = create(key("brain_coral"));

    /**
     * {@code minecraft:brain_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BRAIN_CORAL_BLOCK = create(key("brain_coral_block"));

    /**
     * {@code minecraft:brain_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BRAIN_CORAL_FAN = create(key("brain_coral_fan"));

    /**
     * {@code minecraft:brain_coral_wall_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BRAIN_CORAL_WALL_FAN = create(key("brain_coral_wall_fan"));

    /**
     * {@code minecraft:brewing_stand}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BREWING_STAND = create(key("brewing_stand"));

    /**
     * {@code minecraft:brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BRICK_SLAB = create(key("brick_slab"));

    /**
     * {@code minecraft:brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BRICK_STAIRS = create(key("brick_stairs"));

    /**
     * {@code minecraft:brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BRICK_WALL = create(key("brick_wall"));

    /**
     * {@code minecraft:bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BRICKS = create(key("bricks"));

    /**
     * {@code minecraft:brown_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BROWN_BANNER = create(key("brown_banner"));

    /**
     * {@code minecraft:brown_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BROWN_BED = create(key("brown_bed"));

    /**
     * {@code minecraft:brown_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BROWN_CANDLE = create(key("brown_candle"));

    /**
     * {@code minecraft:brown_candle_cake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BROWN_CANDLE_CAKE = create(key("brown_candle_cake"));

    /**
     * {@code minecraft:brown_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BROWN_CARPET = create(key("brown_carpet"));

    /**
     * {@code minecraft:brown_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BROWN_CONCRETE = create(key("brown_concrete"));

    /**
     * {@code minecraft:brown_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BROWN_CONCRETE_POWDER = create(key("brown_concrete_powder"));

    /**
     * {@code minecraft:brown_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BROWN_GLAZED_TERRACOTTA = create(key("brown_glazed_terracotta"));

    /**
     * {@code minecraft:brown_mushroom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BROWN_MUSHROOM = create(key("brown_mushroom"));

    /**
     * {@code minecraft:brown_mushroom_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BROWN_MUSHROOM_BLOCK = create(key("brown_mushroom_block"));

    /**
     * {@code minecraft:brown_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BROWN_SHULKER_BOX = create(key("brown_shulker_box"));

    /**
     * {@code minecraft:brown_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BROWN_STAINED_GLASS = create(key("brown_stained_glass"));

    /**
     * {@code minecraft:brown_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BROWN_STAINED_GLASS_PANE = create(key("brown_stained_glass_pane"));

    /**
     * {@code minecraft:brown_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BROWN_TERRACOTTA = create(key("brown_terracotta"));

    /**
     * {@code minecraft:brown_wall_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BROWN_WALL_BANNER = create(key("brown_wall_banner"));

    /**
     * {@code minecraft:brown_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BROWN_WOOL = create(key("brown_wool"));

    /**
     * {@code minecraft:bubble_column}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BUBBLE_COLUMN = create(key("bubble_column"));

    /**
     * {@code minecraft:bubble_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BUBBLE_CORAL = create(key("bubble_coral"));

    /**
     * {@code minecraft:bubble_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BUBBLE_CORAL_BLOCK = create(key("bubble_coral_block"));

    /**
     * {@code minecraft:bubble_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BUBBLE_CORAL_FAN = create(key("bubble_coral_fan"));

    /**
     * {@code minecraft:bubble_coral_wall_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BUBBLE_CORAL_WALL_FAN = create(key("bubble_coral_wall_fan"));

    /**
     * {@code minecraft:budding_amethyst}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BUDDING_AMETHYST = create(key("budding_amethyst"));

    /**
     * {@code minecraft:bush}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> BUSH = create(key("bush"));

    /**
     * {@code minecraft:cactus}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CACTUS = create(key("cactus"));

    /**
     * {@code minecraft:cactus_flower}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CACTUS_FLOWER = create(key("cactus_flower"));

    /**
     * {@code minecraft:cake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CAKE = create(key("cake"));

    /**
     * {@code minecraft:calcite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CALCITE = create(key("calcite"));

    /**
     * {@code minecraft:calibrated_sculk_sensor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CALIBRATED_SCULK_SENSOR = create(key("calibrated_sculk_sensor"));

    /**
     * {@code minecraft:campfire}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CAMPFIRE = create(key("campfire"));

    /**
     * {@code minecraft:candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CANDLE = create(key("candle"));

    /**
     * {@code minecraft:candle_cake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CANDLE_CAKE = create(key("candle_cake"));

    /**
     * {@code minecraft:carrots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CARROTS = create(key("carrots"));

    /**
     * {@code minecraft:cartography_table}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CARTOGRAPHY_TABLE = create(key("cartography_table"));

    /**
     * {@code minecraft:carved_pumpkin}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CARVED_PUMPKIN = create(key("carved_pumpkin"));

    /**
     * {@code minecraft:cauldron}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CAULDRON = create(key("cauldron"));

    /**
     * {@code minecraft:cave_air}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CAVE_AIR = create(key("cave_air"));

    /**
     * {@code minecraft:cave_vines}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CAVE_VINES = create(key("cave_vines"));

    /**
     * {@code minecraft:cave_vines_plant}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CAVE_VINES_PLANT = create(key("cave_vines_plant"));

    /**
     * {@code minecraft:chain}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHAIN = create(key("chain"));

    /**
     * {@code minecraft:chain_command_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHAIN_COMMAND_BLOCK = create(key("chain_command_block"));

    /**
     * {@code minecraft:cherry_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHERRY_BUTTON = create(key("cherry_button"));

    /**
     * {@code minecraft:cherry_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHERRY_DOOR = create(key("cherry_door"));

    /**
     * {@code minecraft:cherry_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHERRY_FENCE = create(key("cherry_fence"));

    /**
     * {@code minecraft:cherry_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHERRY_FENCE_GATE = create(key("cherry_fence_gate"));

    /**
     * {@code minecraft:cherry_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHERRY_HANGING_SIGN = create(key("cherry_hanging_sign"));

    /**
     * {@code minecraft:cherry_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHERRY_LEAVES = create(key("cherry_leaves"));

    /**
     * {@code minecraft:cherry_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHERRY_LOG = create(key("cherry_log"));

    /**
     * {@code minecraft:cherry_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHERRY_PLANKS = create(key("cherry_planks"));

    /**
     * {@code minecraft:cherry_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHERRY_PRESSURE_PLATE = create(key("cherry_pressure_plate"));

    /**
     * {@code minecraft:cherry_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHERRY_SAPLING = create(key("cherry_sapling"));

    /**
     * {@code minecraft:cherry_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHERRY_SIGN = create(key("cherry_sign"));

    /**
     * {@code minecraft:cherry_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHERRY_SLAB = create(key("cherry_slab"));

    /**
     * {@code minecraft:cherry_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHERRY_STAIRS = create(key("cherry_stairs"));

    /**
     * {@code minecraft:cherry_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHERRY_TRAPDOOR = create(key("cherry_trapdoor"));

    /**
     * {@code minecraft:cherry_wall_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHERRY_WALL_HANGING_SIGN = create(key("cherry_wall_hanging_sign"));

    /**
     * {@code minecraft:cherry_wall_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHERRY_WALL_SIGN = create(key("cherry_wall_sign"));

    /**
     * {@code minecraft:cherry_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHERRY_WOOD = create(key("cherry_wood"));

    /**
     * {@code minecraft:chest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHEST = create(key("chest"));

    /**
     * {@code minecraft:chipped_anvil}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHIPPED_ANVIL = create(key("chipped_anvil"));

    /**
     * {@code minecraft:chiseled_bookshelf}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHISELED_BOOKSHELF = create(key("chiseled_bookshelf"));

    /**
     * {@code minecraft:chiseled_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHISELED_COPPER = create(key("chiseled_copper"));

    /**
     * {@code minecraft:chiseled_deepslate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHISELED_DEEPSLATE = create(key("chiseled_deepslate"));

    /**
     * {@code minecraft:chiseled_nether_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHISELED_NETHER_BRICKS = create(key("chiseled_nether_bricks"));

    /**
     * {@code minecraft:chiseled_polished_blackstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHISELED_POLISHED_BLACKSTONE = create(key("chiseled_polished_blackstone"));

    /**
     * {@code minecraft:chiseled_quartz_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHISELED_QUARTZ_BLOCK = create(key("chiseled_quartz_block"));

    /**
     * {@code minecraft:chiseled_red_sandstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHISELED_RED_SANDSTONE = create(key("chiseled_red_sandstone"));

    /**
     * {@code minecraft:chiseled_resin_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHISELED_RESIN_BRICKS = create(key("chiseled_resin_bricks"));

    /**
     * {@code minecraft:chiseled_sandstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHISELED_SANDSTONE = create(key("chiseled_sandstone"));

    /**
     * {@code minecraft:chiseled_stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHISELED_STONE_BRICKS = create(key("chiseled_stone_bricks"));

    /**
     * {@code minecraft:chiseled_tuff}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHISELED_TUFF = create(key("chiseled_tuff"));

    /**
     * {@code minecraft:chiseled_tuff_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHISELED_TUFF_BRICKS = create(key("chiseled_tuff_bricks"));

    /**
     * {@code minecraft:chorus_flower}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHORUS_FLOWER = create(key("chorus_flower"));

    /**
     * {@code minecraft:chorus_plant}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CHORUS_PLANT = create(key("chorus_plant"));

    /**
     * {@code minecraft:clay}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CLAY = create(key("clay"));

    /**
     * {@code minecraft:closed_eyeblossom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CLOSED_EYEBLOSSOM = create(key("closed_eyeblossom"));

    /**
     * {@code minecraft:coal_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COAL_BLOCK = create(key("coal_block"));

    /**
     * {@code minecraft:coal_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COAL_ORE = create(key("coal_ore"));

    /**
     * {@code minecraft:coarse_dirt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COARSE_DIRT = create(key("coarse_dirt"));

    /**
     * {@code minecraft:cobbled_deepslate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COBBLED_DEEPSLATE = create(key("cobbled_deepslate"));

    /**
     * {@code minecraft:cobbled_deepslate_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COBBLED_DEEPSLATE_SLAB = create(key("cobbled_deepslate_slab"));

    /**
     * {@code minecraft:cobbled_deepslate_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COBBLED_DEEPSLATE_STAIRS = create(key("cobbled_deepslate_stairs"));

    /**
     * {@code minecraft:cobbled_deepslate_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COBBLED_DEEPSLATE_WALL = create(key("cobbled_deepslate_wall"));

    /**
     * {@code minecraft:cobblestone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COBBLESTONE = create(key("cobblestone"));

    /**
     * {@code minecraft:cobblestone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COBBLESTONE_SLAB = create(key("cobblestone_slab"));

    /**
     * {@code minecraft:cobblestone_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COBBLESTONE_STAIRS = create(key("cobblestone_stairs"));

    /**
     * {@code minecraft:cobblestone_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COBBLESTONE_WALL = create(key("cobblestone_wall"));

    /**
     * {@code minecraft:cobweb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COBWEB = create(key("cobweb"));

    /**
     * {@code minecraft:cocoa}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COCOA = create(key("cocoa"));

    /**
     * {@code minecraft:command_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COMMAND_BLOCK = create(key("command_block"));

    /**
     * {@code minecraft:comparator}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COMPARATOR = create(key("comparator"));

    /**
     * {@code minecraft:composter}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COMPOSTER = create(key("composter"));

    /**
     * {@code minecraft:conduit}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CONDUIT = create(key("conduit"));

    /**
     * {@code minecraft:copper_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COPPER_BLOCK = create(key("copper_block"));

    /**
     * {@code minecraft:copper_bulb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COPPER_BULB = create(key("copper_bulb"));

    /**
     * {@code minecraft:copper_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COPPER_DOOR = create(key("copper_door"));

    /**
     * {@code minecraft:copper_grate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COPPER_GRATE = create(key("copper_grate"));

    /**
     * {@code minecraft:copper_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COPPER_ORE = create(key("copper_ore"));

    /**
     * {@code minecraft:copper_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> COPPER_TRAPDOOR = create(key("copper_trapdoor"));

    /**
     * {@code minecraft:cornflower}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CORNFLOWER = create(key("cornflower"));

    /**
     * {@code minecraft:cracked_deepslate_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRACKED_DEEPSLATE_BRICKS = create(key("cracked_deepslate_bricks"));

    /**
     * {@code minecraft:cracked_deepslate_tiles}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRACKED_DEEPSLATE_TILES = create(key("cracked_deepslate_tiles"));

    /**
     * {@code minecraft:cracked_nether_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRACKED_NETHER_BRICKS = create(key("cracked_nether_bricks"));

    /**
     * {@code minecraft:cracked_polished_blackstone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRACKED_POLISHED_BLACKSTONE_BRICKS = create(key("cracked_polished_blackstone_bricks"));

    /**
     * {@code minecraft:cracked_stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRACKED_STONE_BRICKS = create(key("cracked_stone_bricks"));

    /**
     * {@code minecraft:crafter}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRAFTER = create(key("crafter"));

    /**
     * {@code minecraft:crafting_table}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRAFTING_TABLE = create(key("crafting_table"));

    /**
     * {@code minecraft:creaking_heart}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CREAKING_HEART = create(key("creaking_heart"));

    /**
     * {@code minecraft:creeper_head}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CREEPER_HEAD = create(key("creeper_head"));

    /**
     * {@code minecraft:creeper_wall_head}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CREEPER_WALL_HEAD = create(key("creeper_wall_head"));

    /**
     * {@code minecraft:crimson_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRIMSON_BUTTON = create(key("crimson_button"));

    /**
     * {@code minecraft:crimson_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRIMSON_DOOR = create(key("crimson_door"));

    /**
     * {@code minecraft:crimson_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRIMSON_FENCE = create(key("crimson_fence"));

    /**
     * {@code minecraft:crimson_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRIMSON_FENCE_GATE = create(key("crimson_fence_gate"));

    /**
     * {@code minecraft:crimson_fungus}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRIMSON_FUNGUS = create(key("crimson_fungus"));

    /**
     * {@code minecraft:crimson_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRIMSON_HANGING_SIGN = create(key("crimson_hanging_sign"));

    /**
     * {@code minecraft:crimson_hyphae}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRIMSON_HYPHAE = create(key("crimson_hyphae"));

    /**
     * {@code minecraft:crimson_nylium}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRIMSON_NYLIUM = create(key("crimson_nylium"));

    /**
     * {@code minecraft:crimson_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRIMSON_PLANKS = create(key("crimson_planks"));

    /**
     * {@code minecraft:crimson_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRIMSON_PRESSURE_PLATE = create(key("crimson_pressure_plate"));

    /**
     * {@code minecraft:crimson_roots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRIMSON_ROOTS = create(key("crimson_roots"));

    /**
     * {@code minecraft:crimson_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRIMSON_SIGN = create(key("crimson_sign"));

    /**
     * {@code minecraft:crimson_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRIMSON_SLAB = create(key("crimson_slab"));

    /**
     * {@code minecraft:crimson_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRIMSON_STAIRS = create(key("crimson_stairs"));

    /**
     * {@code minecraft:crimson_stem}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRIMSON_STEM = create(key("crimson_stem"));

    /**
     * {@code minecraft:crimson_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRIMSON_TRAPDOOR = create(key("crimson_trapdoor"));

    /**
     * {@code minecraft:crimson_wall_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRIMSON_WALL_HANGING_SIGN = create(key("crimson_wall_hanging_sign"));

    /**
     * {@code minecraft:crimson_wall_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRIMSON_WALL_SIGN = create(key("crimson_wall_sign"));

    /**
     * {@code minecraft:crying_obsidian}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CRYING_OBSIDIAN = create(key("crying_obsidian"));

    /**
     * {@code minecraft:cut_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CUT_COPPER = create(key("cut_copper"));

    /**
     * {@code minecraft:cut_copper_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CUT_COPPER_SLAB = create(key("cut_copper_slab"));

    /**
     * {@code minecraft:cut_copper_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CUT_COPPER_STAIRS = create(key("cut_copper_stairs"));

    /**
     * {@code minecraft:cut_red_sandstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CUT_RED_SANDSTONE = create(key("cut_red_sandstone"));

    /**
     * {@code minecraft:cut_red_sandstone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CUT_RED_SANDSTONE_SLAB = create(key("cut_red_sandstone_slab"));

    /**
     * {@code minecraft:cut_sandstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CUT_SANDSTONE = create(key("cut_sandstone"));

    /**
     * {@code minecraft:cut_sandstone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CUT_SANDSTONE_SLAB = create(key("cut_sandstone_slab"));

    /**
     * {@code minecraft:cyan_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CYAN_BANNER = create(key("cyan_banner"));

    /**
     * {@code minecraft:cyan_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CYAN_BED = create(key("cyan_bed"));

    /**
     * {@code minecraft:cyan_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CYAN_CANDLE = create(key("cyan_candle"));

    /**
     * {@code minecraft:cyan_candle_cake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CYAN_CANDLE_CAKE = create(key("cyan_candle_cake"));

    /**
     * {@code minecraft:cyan_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CYAN_CARPET = create(key("cyan_carpet"));

    /**
     * {@code minecraft:cyan_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CYAN_CONCRETE = create(key("cyan_concrete"));

    /**
     * {@code minecraft:cyan_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CYAN_CONCRETE_POWDER = create(key("cyan_concrete_powder"));

    /**
     * {@code minecraft:cyan_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CYAN_GLAZED_TERRACOTTA = create(key("cyan_glazed_terracotta"));

    /**
     * {@code minecraft:cyan_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CYAN_SHULKER_BOX = create(key("cyan_shulker_box"));

    /**
     * {@code minecraft:cyan_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CYAN_STAINED_GLASS = create(key("cyan_stained_glass"));

    /**
     * {@code minecraft:cyan_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CYAN_STAINED_GLASS_PANE = create(key("cyan_stained_glass_pane"));

    /**
     * {@code minecraft:cyan_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CYAN_TERRACOTTA = create(key("cyan_terracotta"));

    /**
     * {@code minecraft:cyan_wall_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CYAN_WALL_BANNER = create(key("cyan_wall_banner"));

    /**
     * {@code minecraft:cyan_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> CYAN_WOOL = create(key("cyan_wool"));

    /**
     * {@code minecraft:damaged_anvil}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DAMAGED_ANVIL = create(key("damaged_anvil"));

    /**
     * {@code minecraft:dandelion}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DANDELION = create(key("dandelion"));

    /**
     * {@code minecraft:dark_oak_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_OAK_BUTTON = create(key("dark_oak_button"));

    /**
     * {@code minecraft:dark_oak_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_OAK_DOOR = create(key("dark_oak_door"));

    /**
     * {@code minecraft:dark_oak_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_OAK_FENCE = create(key("dark_oak_fence"));

    /**
     * {@code minecraft:dark_oak_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_OAK_FENCE_GATE = create(key("dark_oak_fence_gate"));

    /**
     * {@code minecraft:dark_oak_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_OAK_HANGING_SIGN = create(key("dark_oak_hanging_sign"));

    /**
     * {@code minecraft:dark_oak_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_OAK_LEAVES = create(key("dark_oak_leaves"));

    /**
     * {@code minecraft:dark_oak_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_OAK_LOG = create(key("dark_oak_log"));

    /**
     * {@code minecraft:dark_oak_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_OAK_PLANKS = create(key("dark_oak_planks"));

    /**
     * {@code minecraft:dark_oak_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_OAK_PRESSURE_PLATE = create(key("dark_oak_pressure_plate"));

    /**
     * {@code minecraft:dark_oak_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_OAK_SAPLING = create(key("dark_oak_sapling"));

    /**
     * {@code minecraft:dark_oak_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_OAK_SIGN = create(key("dark_oak_sign"));

    /**
     * {@code minecraft:dark_oak_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_OAK_SLAB = create(key("dark_oak_slab"));

    /**
     * {@code minecraft:dark_oak_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_OAK_STAIRS = create(key("dark_oak_stairs"));

    /**
     * {@code minecraft:dark_oak_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_OAK_TRAPDOOR = create(key("dark_oak_trapdoor"));

    /**
     * {@code minecraft:dark_oak_wall_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_OAK_WALL_HANGING_SIGN = create(key("dark_oak_wall_hanging_sign"));

    /**
     * {@code minecraft:dark_oak_wall_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_OAK_WALL_SIGN = create(key("dark_oak_wall_sign"));

    /**
     * {@code minecraft:dark_oak_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_OAK_WOOD = create(key("dark_oak_wood"));

    /**
     * {@code minecraft:dark_prismarine}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_PRISMARINE = create(key("dark_prismarine"));

    /**
     * {@code minecraft:dark_prismarine_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_PRISMARINE_SLAB = create(key("dark_prismarine_slab"));

    /**
     * {@code minecraft:dark_prismarine_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DARK_PRISMARINE_STAIRS = create(key("dark_prismarine_stairs"));

    /**
     * {@code minecraft:daylight_detector}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DAYLIGHT_DETECTOR = create(key("daylight_detector"));

    /**
     * {@code minecraft:dead_brain_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_BRAIN_CORAL = create(key("dead_brain_coral"));

    /**
     * {@code minecraft:dead_brain_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_BRAIN_CORAL_BLOCK = create(key("dead_brain_coral_block"));

    /**
     * {@code minecraft:dead_brain_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_BRAIN_CORAL_FAN = create(key("dead_brain_coral_fan"));

    /**
     * {@code minecraft:dead_brain_coral_wall_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_BRAIN_CORAL_WALL_FAN = create(key("dead_brain_coral_wall_fan"));

    /**
     * {@code minecraft:dead_bubble_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_BUBBLE_CORAL = create(key("dead_bubble_coral"));

    /**
     * {@code minecraft:dead_bubble_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_BUBBLE_CORAL_BLOCK = create(key("dead_bubble_coral_block"));

    /**
     * {@code minecraft:dead_bubble_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_BUBBLE_CORAL_FAN = create(key("dead_bubble_coral_fan"));

    /**
     * {@code minecraft:dead_bubble_coral_wall_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_BUBBLE_CORAL_WALL_FAN = create(key("dead_bubble_coral_wall_fan"));

    /**
     * {@code minecraft:dead_bush}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_BUSH = create(key("dead_bush"));

    /**
     * {@code minecraft:dead_fire_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_FIRE_CORAL = create(key("dead_fire_coral"));

    /**
     * {@code minecraft:dead_fire_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_FIRE_CORAL_BLOCK = create(key("dead_fire_coral_block"));

    /**
     * {@code minecraft:dead_fire_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_FIRE_CORAL_FAN = create(key("dead_fire_coral_fan"));

    /**
     * {@code minecraft:dead_fire_coral_wall_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_FIRE_CORAL_WALL_FAN = create(key("dead_fire_coral_wall_fan"));

    /**
     * {@code minecraft:dead_horn_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_HORN_CORAL = create(key("dead_horn_coral"));

    /**
     * {@code minecraft:dead_horn_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_HORN_CORAL_BLOCK = create(key("dead_horn_coral_block"));

    /**
     * {@code minecraft:dead_horn_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_HORN_CORAL_FAN = create(key("dead_horn_coral_fan"));

    /**
     * {@code minecraft:dead_horn_coral_wall_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_HORN_CORAL_WALL_FAN = create(key("dead_horn_coral_wall_fan"));

    /**
     * {@code minecraft:dead_tube_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_TUBE_CORAL = create(key("dead_tube_coral"));

    /**
     * {@code minecraft:dead_tube_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_TUBE_CORAL_BLOCK = create(key("dead_tube_coral_block"));

    /**
     * {@code minecraft:dead_tube_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_TUBE_CORAL_FAN = create(key("dead_tube_coral_fan"));

    /**
     * {@code minecraft:dead_tube_coral_wall_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEAD_TUBE_CORAL_WALL_FAN = create(key("dead_tube_coral_wall_fan"));

    /**
     * {@code minecraft:decorated_pot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DECORATED_POT = create(key("decorated_pot"));

    /**
     * {@code minecraft:deepslate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEEPSLATE = create(key("deepslate"));

    /**
     * {@code minecraft:deepslate_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEEPSLATE_BRICK_SLAB = create(key("deepslate_brick_slab"));

    /**
     * {@code minecraft:deepslate_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEEPSLATE_BRICK_STAIRS = create(key("deepslate_brick_stairs"));

    /**
     * {@code minecraft:deepslate_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEEPSLATE_BRICK_WALL = create(key("deepslate_brick_wall"));

    /**
     * {@code minecraft:deepslate_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEEPSLATE_BRICKS = create(key("deepslate_bricks"));

    /**
     * {@code minecraft:deepslate_coal_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEEPSLATE_COAL_ORE = create(key("deepslate_coal_ore"));

    /**
     * {@code minecraft:deepslate_copper_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEEPSLATE_COPPER_ORE = create(key("deepslate_copper_ore"));

    /**
     * {@code minecraft:deepslate_diamond_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEEPSLATE_DIAMOND_ORE = create(key("deepslate_diamond_ore"));

    /**
     * {@code minecraft:deepslate_emerald_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEEPSLATE_EMERALD_ORE = create(key("deepslate_emerald_ore"));

    /**
     * {@code minecraft:deepslate_gold_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEEPSLATE_GOLD_ORE = create(key("deepslate_gold_ore"));

    /**
     * {@code minecraft:deepslate_iron_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEEPSLATE_IRON_ORE = create(key("deepslate_iron_ore"));

    /**
     * {@code minecraft:deepslate_lapis_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEEPSLATE_LAPIS_ORE = create(key("deepslate_lapis_ore"));

    /**
     * {@code minecraft:deepslate_redstone_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEEPSLATE_REDSTONE_ORE = create(key("deepslate_redstone_ore"));

    /**
     * {@code minecraft:deepslate_tile_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEEPSLATE_TILE_SLAB = create(key("deepslate_tile_slab"));

    /**
     * {@code minecraft:deepslate_tile_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEEPSLATE_TILE_STAIRS = create(key("deepslate_tile_stairs"));

    /**
     * {@code minecraft:deepslate_tile_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEEPSLATE_TILE_WALL = create(key("deepslate_tile_wall"));

    /**
     * {@code minecraft:deepslate_tiles}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DEEPSLATE_TILES = create(key("deepslate_tiles"));

    /**
     * {@code minecraft:detector_rail}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DETECTOR_RAIL = create(key("detector_rail"));

    /**
     * {@code minecraft:diamond_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DIAMOND_BLOCK = create(key("diamond_block"));

    /**
     * {@code minecraft:diamond_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DIAMOND_ORE = create(key("diamond_ore"));

    /**
     * {@code minecraft:diorite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DIORITE = create(key("diorite"));

    /**
     * {@code minecraft:diorite_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DIORITE_SLAB = create(key("diorite_slab"));

    /**
     * {@code minecraft:diorite_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DIORITE_STAIRS = create(key("diorite_stairs"));

    /**
     * {@code minecraft:diorite_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DIORITE_WALL = create(key("diorite_wall"));

    /**
     * {@code minecraft:dirt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DIRT = create(key("dirt"));

    /**
     * {@code minecraft:dirt_path}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DIRT_PATH = create(key("dirt_path"));

    /**
     * {@code minecraft:dispenser}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DISPENSER = create(key("dispenser"));

    /**
     * {@code minecraft:dragon_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DRAGON_EGG = create(key("dragon_egg"));

    /**
     * {@code minecraft:dragon_head}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DRAGON_HEAD = create(key("dragon_head"));

    /**
     * {@code minecraft:dragon_wall_head}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DRAGON_WALL_HEAD = create(key("dragon_wall_head"));

    /**
     * {@code minecraft:dried_ghast}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DRIED_GHAST = create(key("dried_ghast"));

    /**
     * {@code minecraft:dried_kelp_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DRIED_KELP_BLOCK = create(key("dried_kelp_block"));

    /**
     * {@code minecraft:dripstone_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DRIPSTONE_BLOCK = create(key("dripstone_block"));

    /**
     * {@code minecraft:dropper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> DROPPER = create(key("dropper"));

    /**
     * {@code minecraft:emerald_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> EMERALD_BLOCK = create(key("emerald_block"));

    /**
     * {@code minecraft:emerald_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> EMERALD_ORE = create(key("emerald_ore"));

    /**
     * {@code minecraft:enchanting_table}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ENCHANTING_TABLE = create(key("enchanting_table"));

    /**
     * {@code minecraft:end_gateway}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> END_GATEWAY = create(key("end_gateway"));

    /**
     * {@code minecraft:end_portal}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> END_PORTAL = create(key("end_portal"));

    /**
     * {@code minecraft:end_portal_frame}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> END_PORTAL_FRAME = create(key("end_portal_frame"));

    /**
     * {@code minecraft:end_rod}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> END_ROD = create(key("end_rod"));

    /**
     * {@code minecraft:end_stone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> END_STONE = create(key("end_stone"));

    /**
     * {@code minecraft:end_stone_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> END_STONE_BRICK_SLAB = create(key("end_stone_brick_slab"));

    /**
     * {@code minecraft:end_stone_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> END_STONE_BRICK_STAIRS = create(key("end_stone_brick_stairs"));

    /**
     * {@code minecraft:end_stone_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> END_STONE_BRICK_WALL = create(key("end_stone_brick_wall"));

    /**
     * {@code minecraft:end_stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> END_STONE_BRICKS = create(key("end_stone_bricks"));

    /**
     * {@code minecraft:ender_chest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ENDER_CHEST = create(key("ender_chest"));

    /**
     * {@code minecraft:exposed_chiseled_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> EXPOSED_CHISELED_COPPER = create(key("exposed_chiseled_copper"));

    /**
     * {@code minecraft:exposed_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> EXPOSED_COPPER = create(key("exposed_copper"));

    /**
     * {@code minecraft:exposed_copper_bulb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> EXPOSED_COPPER_BULB = create(key("exposed_copper_bulb"));

    /**
     * {@code minecraft:exposed_copper_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> EXPOSED_COPPER_DOOR = create(key("exposed_copper_door"));

    /**
     * {@code minecraft:exposed_copper_grate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> EXPOSED_COPPER_GRATE = create(key("exposed_copper_grate"));

    /**
     * {@code minecraft:exposed_copper_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> EXPOSED_COPPER_TRAPDOOR = create(key("exposed_copper_trapdoor"));

    /**
     * {@code minecraft:exposed_cut_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> EXPOSED_CUT_COPPER = create(key("exposed_cut_copper"));

    /**
     * {@code minecraft:exposed_cut_copper_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> EXPOSED_CUT_COPPER_SLAB = create(key("exposed_cut_copper_slab"));

    /**
     * {@code minecraft:exposed_cut_copper_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> EXPOSED_CUT_COPPER_STAIRS = create(key("exposed_cut_copper_stairs"));

    /**
     * {@code minecraft:farmland}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> FARMLAND = create(key("farmland"));

    /**
     * {@code minecraft:fern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> FERN = create(key("fern"));

    /**
     * {@code minecraft:fire}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> FIRE = create(key("fire"));

    /**
     * {@code minecraft:fire_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> FIRE_CORAL = create(key("fire_coral"));

    /**
     * {@code minecraft:fire_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> FIRE_CORAL_BLOCK = create(key("fire_coral_block"));

    /**
     * {@code minecraft:fire_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> FIRE_CORAL_FAN = create(key("fire_coral_fan"));

    /**
     * {@code minecraft:fire_coral_wall_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> FIRE_CORAL_WALL_FAN = create(key("fire_coral_wall_fan"));

    /**
     * {@code minecraft:firefly_bush}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> FIREFLY_BUSH = create(key("firefly_bush"));

    /**
     * {@code minecraft:fletching_table}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> FLETCHING_TABLE = create(key("fletching_table"));

    /**
     * {@code minecraft:flower_pot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> FLOWER_POT = create(key("flower_pot"));

    /**
     * {@code minecraft:flowering_azalea}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> FLOWERING_AZALEA = create(key("flowering_azalea"));

    /**
     * {@code minecraft:flowering_azalea_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> FLOWERING_AZALEA_LEAVES = create(key("flowering_azalea_leaves"));

    /**
     * {@code minecraft:frogspawn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> FROGSPAWN = create(key("frogspawn"));

    /**
     * {@code minecraft:frosted_ice}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> FROSTED_ICE = create(key("frosted_ice"));

    /**
     * {@code minecraft:furnace}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> FURNACE = create(key("furnace"));

    /**
     * {@code minecraft:gilded_blackstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GILDED_BLACKSTONE = create(key("gilded_blackstone"));

    /**
     * {@code minecraft:glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GLASS = create(key("glass"));

    /**
     * {@code minecraft:glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GLASS_PANE = create(key("glass_pane"));

    /**
     * {@code minecraft:glow_lichen}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GLOW_LICHEN = create(key("glow_lichen"));

    /**
     * {@code minecraft:glowstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GLOWSTONE = create(key("glowstone"));

    /**
     * {@code minecraft:gold_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GOLD_BLOCK = create(key("gold_block"));

    /**
     * {@code minecraft:gold_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GOLD_ORE = create(key("gold_ore"));

    /**
     * {@code minecraft:granite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRANITE = create(key("granite"));

    /**
     * {@code minecraft:granite_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRANITE_SLAB = create(key("granite_slab"));

    /**
     * {@code minecraft:granite_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRANITE_STAIRS = create(key("granite_stairs"));

    /**
     * {@code minecraft:granite_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRANITE_WALL = create(key("granite_wall"));

    /**
     * {@code minecraft:grass_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRASS_BLOCK = create(key("grass_block"));

    /**
     * {@code minecraft:gravel}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRAVEL = create(key("gravel"));

    /**
     * {@code minecraft:gray_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRAY_BANNER = create(key("gray_banner"));

    /**
     * {@code minecraft:gray_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRAY_BED = create(key("gray_bed"));

    /**
     * {@code minecraft:gray_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRAY_CANDLE = create(key("gray_candle"));

    /**
     * {@code minecraft:gray_candle_cake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRAY_CANDLE_CAKE = create(key("gray_candle_cake"));

    /**
     * {@code minecraft:gray_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRAY_CARPET = create(key("gray_carpet"));

    /**
     * {@code minecraft:gray_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRAY_CONCRETE = create(key("gray_concrete"));

    /**
     * {@code minecraft:gray_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRAY_CONCRETE_POWDER = create(key("gray_concrete_powder"));

    /**
     * {@code minecraft:gray_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRAY_GLAZED_TERRACOTTA = create(key("gray_glazed_terracotta"));

    /**
     * {@code minecraft:gray_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRAY_SHULKER_BOX = create(key("gray_shulker_box"));

    /**
     * {@code minecraft:gray_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRAY_STAINED_GLASS = create(key("gray_stained_glass"));

    /**
     * {@code minecraft:gray_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRAY_STAINED_GLASS_PANE = create(key("gray_stained_glass_pane"));

    /**
     * {@code minecraft:gray_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRAY_TERRACOTTA = create(key("gray_terracotta"));

    /**
     * {@code minecraft:gray_wall_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRAY_WALL_BANNER = create(key("gray_wall_banner"));

    /**
     * {@code minecraft:gray_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRAY_WOOL = create(key("gray_wool"));

    /**
     * {@code minecraft:green_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GREEN_BANNER = create(key("green_banner"));

    /**
     * {@code minecraft:green_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GREEN_BED = create(key("green_bed"));

    /**
     * {@code minecraft:green_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GREEN_CANDLE = create(key("green_candle"));

    /**
     * {@code minecraft:green_candle_cake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GREEN_CANDLE_CAKE = create(key("green_candle_cake"));

    /**
     * {@code minecraft:green_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GREEN_CARPET = create(key("green_carpet"));

    /**
     * {@code minecraft:green_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GREEN_CONCRETE = create(key("green_concrete"));

    /**
     * {@code minecraft:green_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GREEN_CONCRETE_POWDER = create(key("green_concrete_powder"));

    /**
     * {@code minecraft:green_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GREEN_GLAZED_TERRACOTTA = create(key("green_glazed_terracotta"));

    /**
     * {@code minecraft:green_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GREEN_SHULKER_BOX = create(key("green_shulker_box"));

    /**
     * {@code minecraft:green_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GREEN_STAINED_GLASS = create(key("green_stained_glass"));

    /**
     * {@code minecraft:green_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GREEN_STAINED_GLASS_PANE = create(key("green_stained_glass_pane"));

    /**
     * {@code minecraft:green_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GREEN_TERRACOTTA = create(key("green_terracotta"));

    /**
     * {@code minecraft:green_wall_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GREEN_WALL_BANNER = create(key("green_wall_banner"));

    /**
     * {@code minecraft:green_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GREEN_WOOL = create(key("green_wool"));

    /**
     * {@code minecraft:grindstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> GRINDSTONE = create(key("grindstone"));

    /**
     * {@code minecraft:hanging_roots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> HANGING_ROOTS = create(key("hanging_roots"));

    /**
     * {@code minecraft:hay_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> HAY_BLOCK = create(key("hay_block"));

    /**
     * {@code minecraft:heavy_core}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> HEAVY_CORE = create(key("heavy_core"));

    /**
     * {@code minecraft:heavy_weighted_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> HEAVY_WEIGHTED_PRESSURE_PLATE = create(key("heavy_weighted_pressure_plate"));

    /**
     * {@code minecraft:honey_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> HONEY_BLOCK = create(key("honey_block"));

    /**
     * {@code minecraft:honeycomb_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> HONEYCOMB_BLOCK = create(key("honeycomb_block"));

    /**
     * {@code minecraft:hopper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> HOPPER = create(key("hopper"));

    /**
     * {@code minecraft:horn_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> HORN_CORAL = create(key("horn_coral"));

    /**
     * {@code minecraft:horn_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> HORN_CORAL_BLOCK = create(key("horn_coral_block"));

    /**
     * {@code minecraft:horn_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> HORN_CORAL_FAN = create(key("horn_coral_fan"));

    /**
     * {@code minecraft:horn_coral_wall_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> HORN_CORAL_WALL_FAN = create(key("horn_coral_wall_fan"));

    /**
     * {@code minecraft:ice}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ICE = create(key("ice"));

    /**
     * {@code minecraft:infested_chiseled_stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> INFESTED_CHISELED_STONE_BRICKS = create(key("infested_chiseled_stone_bricks"));

    /**
     * {@code minecraft:infested_cobblestone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> INFESTED_COBBLESTONE = create(key("infested_cobblestone"));

    /**
     * {@code minecraft:infested_cracked_stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> INFESTED_CRACKED_STONE_BRICKS = create(key("infested_cracked_stone_bricks"));

    /**
     * {@code minecraft:infested_deepslate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> INFESTED_DEEPSLATE = create(key("infested_deepslate"));

    /**
     * {@code minecraft:infested_mossy_stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> INFESTED_MOSSY_STONE_BRICKS = create(key("infested_mossy_stone_bricks"));

    /**
     * {@code minecraft:infested_stone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> INFESTED_STONE = create(key("infested_stone"));

    /**
     * {@code minecraft:infested_stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> INFESTED_STONE_BRICKS = create(key("infested_stone_bricks"));

    /**
     * {@code minecraft:iron_bars}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> IRON_BARS = create(key("iron_bars"));

    /**
     * {@code minecraft:iron_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> IRON_BLOCK = create(key("iron_block"));

    /**
     * {@code minecraft:iron_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> IRON_DOOR = create(key("iron_door"));

    /**
     * {@code minecraft:iron_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> IRON_ORE = create(key("iron_ore"));

    /**
     * {@code minecraft:iron_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> IRON_TRAPDOOR = create(key("iron_trapdoor"));

    /**
     * {@code minecraft:jack_o_lantern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JACK_O_LANTERN = create(key("jack_o_lantern"));

    /**
     * {@code minecraft:jigsaw}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JIGSAW = create(key("jigsaw"));

    /**
     * {@code minecraft:jukebox}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JUKEBOX = create(key("jukebox"));

    /**
     * {@code minecraft:jungle_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JUNGLE_BUTTON = create(key("jungle_button"));

    /**
     * {@code minecraft:jungle_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JUNGLE_DOOR = create(key("jungle_door"));

    /**
     * {@code minecraft:jungle_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JUNGLE_FENCE = create(key("jungle_fence"));

    /**
     * {@code minecraft:jungle_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JUNGLE_FENCE_GATE = create(key("jungle_fence_gate"));

    /**
     * {@code minecraft:jungle_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JUNGLE_HANGING_SIGN = create(key("jungle_hanging_sign"));

    /**
     * {@code minecraft:jungle_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JUNGLE_LEAVES = create(key("jungle_leaves"));

    /**
     * {@code minecraft:jungle_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JUNGLE_LOG = create(key("jungle_log"));

    /**
     * {@code minecraft:jungle_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JUNGLE_PLANKS = create(key("jungle_planks"));

    /**
     * {@code minecraft:jungle_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JUNGLE_PRESSURE_PLATE = create(key("jungle_pressure_plate"));

    /**
     * {@code minecraft:jungle_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JUNGLE_SAPLING = create(key("jungle_sapling"));

    /**
     * {@code minecraft:jungle_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JUNGLE_SIGN = create(key("jungle_sign"));

    /**
     * {@code minecraft:jungle_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JUNGLE_SLAB = create(key("jungle_slab"));

    /**
     * {@code minecraft:jungle_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JUNGLE_STAIRS = create(key("jungle_stairs"));

    /**
     * {@code minecraft:jungle_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JUNGLE_TRAPDOOR = create(key("jungle_trapdoor"));

    /**
     * {@code minecraft:jungle_wall_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JUNGLE_WALL_HANGING_SIGN = create(key("jungle_wall_hanging_sign"));

    /**
     * {@code minecraft:jungle_wall_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JUNGLE_WALL_SIGN = create(key("jungle_wall_sign"));

    /**
     * {@code minecraft:jungle_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> JUNGLE_WOOD = create(key("jungle_wood"));

    /**
     * {@code minecraft:kelp}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> KELP = create(key("kelp"));

    /**
     * {@code minecraft:kelp_plant}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> KELP_PLANT = create(key("kelp_plant"));

    /**
     * {@code minecraft:ladder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LADDER = create(key("ladder"));

    /**
     * {@code minecraft:lantern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LANTERN = create(key("lantern"));

    /**
     * {@code minecraft:lapis_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LAPIS_BLOCK = create(key("lapis_block"));

    /**
     * {@code minecraft:lapis_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LAPIS_ORE = create(key("lapis_ore"));

    /**
     * {@code minecraft:large_amethyst_bud}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LARGE_AMETHYST_BUD = create(key("large_amethyst_bud"));

    /**
     * {@code minecraft:large_fern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LARGE_FERN = create(key("large_fern"));

    /**
     * {@code minecraft:lava}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LAVA = create(key("lava"));

    /**
     * {@code minecraft:lava_cauldron}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LAVA_CAULDRON = create(key("lava_cauldron"));

    /**
     * {@code minecraft:leaf_litter}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LEAF_LITTER = create(key("leaf_litter"));

    /**
     * {@code minecraft:lectern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LECTERN = create(key("lectern"));

    /**
     * {@code minecraft:lever}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LEVER = create(key("lever"));

    /**
     * {@code minecraft:light}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT = create(key("light"));

    /**
     * {@code minecraft:light_blue_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_BLUE_BANNER = create(key("light_blue_banner"));

    /**
     * {@code minecraft:light_blue_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_BLUE_BED = create(key("light_blue_bed"));

    /**
     * {@code minecraft:light_blue_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_BLUE_CANDLE = create(key("light_blue_candle"));

    /**
     * {@code minecraft:light_blue_candle_cake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_BLUE_CANDLE_CAKE = create(key("light_blue_candle_cake"));

    /**
     * {@code minecraft:light_blue_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_BLUE_CARPET = create(key("light_blue_carpet"));

    /**
     * {@code minecraft:light_blue_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_BLUE_CONCRETE = create(key("light_blue_concrete"));

    /**
     * {@code minecraft:light_blue_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_BLUE_CONCRETE_POWDER = create(key("light_blue_concrete_powder"));

    /**
     * {@code minecraft:light_blue_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_BLUE_GLAZED_TERRACOTTA = create(key("light_blue_glazed_terracotta"));

    /**
     * {@code minecraft:light_blue_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_BLUE_SHULKER_BOX = create(key("light_blue_shulker_box"));

    /**
     * {@code minecraft:light_blue_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_BLUE_STAINED_GLASS = create(key("light_blue_stained_glass"));

    /**
     * {@code minecraft:light_blue_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_BLUE_STAINED_GLASS_PANE = create(key("light_blue_stained_glass_pane"));

    /**
     * {@code minecraft:light_blue_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_BLUE_TERRACOTTA = create(key("light_blue_terracotta"));

    /**
     * {@code minecraft:light_blue_wall_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_BLUE_WALL_BANNER = create(key("light_blue_wall_banner"));

    /**
     * {@code minecraft:light_blue_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_BLUE_WOOL = create(key("light_blue_wool"));

    /**
     * {@code minecraft:light_gray_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_GRAY_BANNER = create(key("light_gray_banner"));

    /**
     * {@code minecraft:light_gray_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_GRAY_BED = create(key("light_gray_bed"));

    /**
     * {@code minecraft:light_gray_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_GRAY_CANDLE = create(key("light_gray_candle"));

    /**
     * {@code minecraft:light_gray_candle_cake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_GRAY_CANDLE_CAKE = create(key("light_gray_candle_cake"));

    /**
     * {@code minecraft:light_gray_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_GRAY_CARPET = create(key("light_gray_carpet"));

    /**
     * {@code minecraft:light_gray_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_GRAY_CONCRETE = create(key("light_gray_concrete"));

    /**
     * {@code minecraft:light_gray_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_GRAY_CONCRETE_POWDER = create(key("light_gray_concrete_powder"));

    /**
     * {@code minecraft:light_gray_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_GRAY_GLAZED_TERRACOTTA = create(key("light_gray_glazed_terracotta"));

    /**
     * {@code minecraft:light_gray_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_GRAY_SHULKER_BOX = create(key("light_gray_shulker_box"));

    /**
     * {@code minecraft:light_gray_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_GRAY_STAINED_GLASS = create(key("light_gray_stained_glass"));

    /**
     * {@code minecraft:light_gray_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_GRAY_STAINED_GLASS_PANE = create(key("light_gray_stained_glass_pane"));

    /**
     * {@code minecraft:light_gray_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_GRAY_TERRACOTTA = create(key("light_gray_terracotta"));

    /**
     * {@code minecraft:light_gray_wall_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_GRAY_WALL_BANNER = create(key("light_gray_wall_banner"));

    /**
     * {@code minecraft:light_gray_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_GRAY_WOOL = create(key("light_gray_wool"));

    /**
     * {@code minecraft:light_weighted_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHT_WEIGHTED_PRESSURE_PLATE = create(key("light_weighted_pressure_plate"));

    /**
     * {@code minecraft:lightning_rod}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIGHTNING_ROD = create(key("lightning_rod"));

    /**
     * {@code minecraft:lilac}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LILAC = create(key("lilac"));

    /**
     * {@code minecraft:lily_of_the_valley}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LILY_OF_THE_VALLEY = create(key("lily_of_the_valley"));

    /**
     * {@code minecraft:lily_pad}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LILY_PAD = create(key("lily_pad"));

    /**
     * {@code minecraft:lime_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIME_BANNER = create(key("lime_banner"));

    /**
     * {@code minecraft:lime_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIME_BED = create(key("lime_bed"));

    /**
     * {@code minecraft:lime_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIME_CANDLE = create(key("lime_candle"));

    /**
     * {@code minecraft:lime_candle_cake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIME_CANDLE_CAKE = create(key("lime_candle_cake"));

    /**
     * {@code minecraft:lime_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIME_CARPET = create(key("lime_carpet"));

    /**
     * {@code minecraft:lime_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIME_CONCRETE = create(key("lime_concrete"));

    /**
     * {@code minecraft:lime_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIME_CONCRETE_POWDER = create(key("lime_concrete_powder"));

    /**
     * {@code minecraft:lime_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIME_GLAZED_TERRACOTTA = create(key("lime_glazed_terracotta"));

    /**
     * {@code minecraft:lime_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIME_SHULKER_BOX = create(key("lime_shulker_box"));

    /**
     * {@code minecraft:lime_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIME_STAINED_GLASS = create(key("lime_stained_glass"));

    /**
     * {@code minecraft:lime_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIME_STAINED_GLASS_PANE = create(key("lime_stained_glass_pane"));

    /**
     * {@code minecraft:lime_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIME_TERRACOTTA = create(key("lime_terracotta"));

    /**
     * {@code minecraft:lime_wall_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIME_WALL_BANNER = create(key("lime_wall_banner"));

    /**
     * {@code minecraft:lime_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LIME_WOOL = create(key("lime_wool"));

    /**
     * {@code minecraft:lodestone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LODESTONE = create(key("lodestone"));

    /**
     * {@code minecraft:loom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> LOOM = create(key("loom"));

    /**
     * {@code minecraft:magenta_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MAGENTA_BANNER = create(key("magenta_banner"));

    /**
     * {@code minecraft:magenta_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MAGENTA_BED = create(key("magenta_bed"));

    /**
     * {@code minecraft:magenta_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MAGENTA_CANDLE = create(key("magenta_candle"));

    /**
     * {@code minecraft:magenta_candle_cake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MAGENTA_CANDLE_CAKE = create(key("magenta_candle_cake"));

    /**
     * {@code minecraft:magenta_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MAGENTA_CARPET = create(key("magenta_carpet"));

    /**
     * {@code minecraft:magenta_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MAGENTA_CONCRETE = create(key("magenta_concrete"));

    /**
     * {@code minecraft:magenta_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MAGENTA_CONCRETE_POWDER = create(key("magenta_concrete_powder"));

    /**
     * {@code minecraft:magenta_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MAGENTA_GLAZED_TERRACOTTA = create(key("magenta_glazed_terracotta"));

    /**
     * {@code minecraft:magenta_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MAGENTA_SHULKER_BOX = create(key("magenta_shulker_box"));

    /**
     * {@code minecraft:magenta_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MAGENTA_STAINED_GLASS = create(key("magenta_stained_glass"));

    /**
     * {@code minecraft:magenta_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MAGENTA_STAINED_GLASS_PANE = create(key("magenta_stained_glass_pane"));

    /**
     * {@code minecraft:magenta_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MAGENTA_TERRACOTTA = create(key("magenta_terracotta"));

    /**
     * {@code minecraft:magenta_wall_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MAGENTA_WALL_BANNER = create(key("magenta_wall_banner"));

    /**
     * {@code minecraft:magenta_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MAGENTA_WOOL = create(key("magenta_wool"));

    /**
     * {@code minecraft:magma_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MAGMA_BLOCK = create(key("magma_block"));

    /**
     * {@code minecraft:mangrove_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MANGROVE_BUTTON = create(key("mangrove_button"));

    /**
     * {@code minecraft:mangrove_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MANGROVE_DOOR = create(key("mangrove_door"));

    /**
     * {@code minecraft:mangrove_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MANGROVE_FENCE = create(key("mangrove_fence"));

    /**
     * {@code minecraft:mangrove_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MANGROVE_FENCE_GATE = create(key("mangrove_fence_gate"));

    /**
     * {@code minecraft:mangrove_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MANGROVE_HANGING_SIGN = create(key("mangrove_hanging_sign"));

    /**
     * {@code minecraft:mangrove_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MANGROVE_LEAVES = create(key("mangrove_leaves"));

    /**
     * {@code minecraft:mangrove_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MANGROVE_LOG = create(key("mangrove_log"));

    /**
     * {@code minecraft:mangrove_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MANGROVE_PLANKS = create(key("mangrove_planks"));

    /**
     * {@code minecraft:mangrove_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MANGROVE_PRESSURE_PLATE = create(key("mangrove_pressure_plate"));

    /**
     * {@code minecraft:mangrove_propagule}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MANGROVE_PROPAGULE = create(key("mangrove_propagule"));

    /**
     * {@code minecraft:mangrove_roots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MANGROVE_ROOTS = create(key("mangrove_roots"));

    /**
     * {@code minecraft:mangrove_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MANGROVE_SIGN = create(key("mangrove_sign"));

    /**
     * {@code minecraft:mangrove_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MANGROVE_SLAB = create(key("mangrove_slab"));

    /**
     * {@code minecraft:mangrove_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MANGROVE_STAIRS = create(key("mangrove_stairs"));

    /**
     * {@code minecraft:mangrove_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MANGROVE_TRAPDOOR = create(key("mangrove_trapdoor"));

    /**
     * {@code minecraft:mangrove_wall_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MANGROVE_WALL_HANGING_SIGN = create(key("mangrove_wall_hanging_sign"));

    /**
     * {@code minecraft:mangrove_wall_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MANGROVE_WALL_SIGN = create(key("mangrove_wall_sign"));

    /**
     * {@code minecraft:mangrove_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MANGROVE_WOOD = create(key("mangrove_wood"));

    /**
     * {@code minecraft:medium_amethyst_bud}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MEDIUM_AMETHYST_BUD = create(key("medium_amethyst_bud"));

    /**
     * {@code minecraft:melon}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MELON = create(key("melon"));

    /**
     * {@code minecraft:melon_stem}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MELON_STEM = create(key("melon_stem"));

    /**
     * {@code minecraft:moss_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MOSS_BLOCK = create(key("moss_block"));

    /**
     * {@code minecraft:moss_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MOSS_CARPET = create(key("moss_carpet"));

    /**
     * {@code minecraft:mossy_cobblestone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MOSSY_COBBLESTONE = create(key("mossy_cobblestone"));

    /**
     * {@code minecraft:mossy_cobblestone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MOSSY_COBBLESTONE_SLAB = create(key("mossy_cobblestone_slab"));

    /**
     * {@code minecraft:mossy_cobblestone_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MOSSY_COBBLESTONE_STAIRS = create(key("mossy_cobblestone_stairs"));

    /**
     * {@code minecraft:mossy_cobblestone_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MOSSY_COBBLESTONE_WALL = create(key("mossy_cobblestone_wall"));

    /**
     * {@code minecraft:mossy_stone_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MOSSY_STONE_BRICK_SLAB = create(key("mossy_stone_brick_slab"));

    /**
     * {@code minecraft:mossy_stone_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MOSSY_STONE_BRICK_STAIRS = create(key("mossy_stone_brick_stairs"));

    /**
     * {@code minecraft:mossy_stone_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MOSSY_STONE_BRICK_WALL = create(key("mossy_stone_brick_wall"));

    /**
     * {@code minecraft:mossy_stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MOSSY_STONE_BRICKS = create(key("mossy_stone_bricks"));

    /**
     * {@code minecraft:moving_piston}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MOVING_PISTON = create(key("moving_piston"));

    /**
     * {@code minecraft:mud}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MUD = create(key("mud"));

    /**
     * {@code minecraft:mud_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MUD_BRICK_SLAB = create(key("mud_brick_slab"));

    /**
     * {@code minecraft:mud_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MUD_BRICK_STAIRS = create(key("mud_brick_stairs"));

    /**
     * {@code minecraft:mud_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MUD_BRICK_WALL = create(key("mud_brick_wall"));

    /**
     * {@code minecraft:mud_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MUD_BRICKS = create(key("mud_bricks"));

    /**
     * {@code minecraft:muddy_mangrove_roots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MUDDY_MANGROVE_ROOTS = create(key("muddy_mangrove_roots"));

    /**
     * {@code minecraft:mushroom_stem}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MUSHROOM_STEM = create(key("mushroom_stem"));

    /**
     * {@code minecraft:mycelium}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> MYCELIUM = create(key("mycelium"));

    /**
     * {@code minecraft:nether_brick_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> NETHER_BRICK_FENCE = create(key("nether_brick_fence"));

    /**
     * {@code minecraft:nether_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> NETHER_BRICK_SLAB = create(key("nether_brick_slab"));

    /**
     * {@code minecraft:nether_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> NETHER_BRICK_STAIRS = create(key("nether_brick_stairs"));

    /**
     * {@code minecraft:nether_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> NETHER_BRICK_WALL = create(key("nether_brick_wall"));

    /**
     * {@code minecraft:nether_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> NETHER_BRICKS = create(key("nether_bricks"));

    /**
     * {@code minecraft:nether_gold_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> NETHER_GOLD_ORE = create(key("nether_gold_ore"));

    /**
     * {@code minecraft:nether_portal}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> NETHER_PORTAL = create(key("nether_portal"));

    /**
     * {@code minecraft:nether_quartz_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> NETHER_QUARTZ_ORE = create(key("nether_quartz_ore"));

    /**
     * {@code minecraft:nether_sprouts}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> NETHER_SPROUTS = create(key("nether_sprouts"));

    /**
     * {@code minecraft:nether_wart}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> NETHER_WART = create(key("nether_wart"));

    /**
     * {@code minecraft:nether_wart_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> NETHER_WART_BLOCK = create(key("nether_wart_block"));

    /**
     * {@code minecraft:netherite_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> NETHERITE_BLOCK = create(key("netherite_block"));

    /**
     * {@code minecraft:netherrack}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> NETHERRACK = create(key("netherrack"));

    /**
     * {@code minecraft:note_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> NOTE_BLOCK = create(key("note_block"));

    /**
     * {@code minecraft:oak_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OAK_BUTTON = create(key("oak_button"));

    /**
     * {@code minecraft:oak_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OAK_DOOR = create(key("oak_door"));

    /**
     * {@code minecraft:oak_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OAK_FENCE = create(key("oak_fence"));

    /**
     * {@code minecraft:oak_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OAK_FENCE_GATE = create(key("oak_fence_gate"));

    /**
     * {@code minecraft:oak_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OAK_HANGING_SIGN = create(key("oak_hanging_sign"));

    /**
     * {@code minecraft:oak_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OAK_LEAVES = create(key("oak_leaves"));

    /**
     * {@code minecraft:oak_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OAK_LOG = create(key("oak_log"));

    /**
     * {@code minecraft:oak_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OAK_PLANKS = create(key("oak_planks"));

    /**
     * {@code minecraft:oak_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OAK_PRESSURE_PLATE = create(key("oak_pressure_plate"));

    /**
     * {@code minecraft:oak_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OAK_SAPLING = create(key("oak_sapling"));

    /**
     * {@code minecraft:oak_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OAK_SIGN = create(key("oak_sign"));

    /**
     * {@code minecraft:oak_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OAK_SLAB = create(key("oak_slab"));

    /**
     * {@code minecraft:oak_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OAK_STAIRS = create(key("oak_stairs"));

    /**
     * {@code minecraft:oak_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OAK_TRAPDOOR = create(key("oak_trapdoor"));

    /**
     * {@code minecraft:oak_wall_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OAK_WALL_HANGING_SIGN = create(key("oak_wall_hanging_sign"));

    /**
     * {@code minecraft:oak_wall_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OAK_WALL_SIGN = create(key("oak_wall_sign"));

    /**
     * {@code minecraft:oak_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OAK_WOOD = create(key("oak_wood"));

    /**
     * {@code minecraft:observer}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OBSERVER = create(key("observer"));

    /**
     * {@code minecraft:obsidian}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OBSIDIAN = create(key("obsidian"));

    /**
     * {@code minecraft:ochre_froglight}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OCHRE_FROGLIGHT = create(key("ochre_froglight"));

    /**
     * {@code minecraft:open_eyeblossom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OPEN_EYEBLOSSOM = create(key("open_eyeblossom"));

    /**
     * {@code minecraft:orange_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ORANGE_BANNER = create(key("orange_banner"));

    /**
     * {@code minecraft:orange_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ORANGE_BED = create(key("orange_bed"));

    /**
     * {@code minecraft:orange_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ORANGE_CANDLE = create(key("orange_candle"));

    /**
     * {@code minecraft:orange_candle_cake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ORANGE_CANDLE_CAKE = create(key("orange_candle_cake"));

    /**
     * {@code minecraft:orange_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ORANGE_CARPET = create(key("orange_carpet"));

    /**
     * {@code minecraft:orange_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ORANGE_CONCRETE = create(key("orange_concrete"));

    /**
     * {@code minecraft:orange_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ORANGE_CONCRETE_POWDER = create(key("orange_concrete_powder"));

    /**
     * {@code minecraft:orange_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ORANGE_GLAZED_TERRACOTTA = create(key("orange_glazed_terracotta"));

    /**
     * {@code minecraft:orange_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ORANGE_SHULKER_BOX = create(key("orange_shulker_box"));

    /**
     * {@code minecraft:orange_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ORANGE_STAINED_GLASS = create(key("orange_stained_glass"));

    /**
     * {@code minecraft:orange_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ORANGE_STAINED_GLASS_PANE = create(key("orange_stained_glass_pane"));

    /**
     * {@code minecraft:orange_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ORANGE_TERRACOTTA = create(key("orange_terracotta"));

    /**
     * {@code minecraft:orange_tulip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ORANGE_TULIP = create(key("orange_tulip"));

    /**
     * {@code minecraft:orange_wall_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ORANGE_WALL_BANNER = create(key("orange_wall_banner"));

    /**
     * {@code minecraft:orange_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ORANGE_WOOL = create(key("orange_wool"));

    /**
     * {@code minecraft:oxeye_daisy}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OXEYE_DAISY = create(key("oxeye_daisy"));

    /**
     * {@code minecraft:oxidized_chiseled_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OXIDIZED_CHISELED_COPPER = create(key("oxidized_chiseled_copper"));

    /**
     * {@code minecraft:oxidized_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OXIDIZED_COPPER = create(key("oxidized_copper"));

    /**
     * {@code minecraft:oxidized_copper_bulb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OXIDIZED_COPPER_BULB = create(key("oxidized_copper_bulb"));

    /**
     * {@code minecraft:oxidized_copper_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OXIDIZED_COPPER_DOOR = create(key("oxidized_copper_door"));

    /**
     * {@code minecraft:oxidized_copper_grate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OXIDIZED_COPPER_GRATE = create(key("oxidized_copper_grate"));

    /**
     * {@code minecraft:oxidized_copper_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OXIDIZED_COPPER_TRAPDOOR = create(key("oxidized_copper_trapdoor"));

    /**
     * {@code minecraft:oxidized_cut_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OXIDIZED_CUT_COPPER = create(key("oxidized_cut_copper"));

    /**
     * {@code minecraft:oxidized_cut_copper_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OXIDIZED_CUT_COPPER_SLAB = create(key("oxidized_cut_copper_slab"));

    /**
     * {@code minecraft:oxidized_cut_copper_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> OXIDIZED_CUT_COPPER_STAIRS = create(key("oxidized_cut_copper_stairs"));

    /**
     * {@code minecraft:packed_ice}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PACKED_ICE = create(key("packed_ice"));

    /**
     * {@code minecraft:packed_mud}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PACKED_MUD = create(key("packed_mud"));

    /**
     * {@code minecraft:pale_hanging_moss}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_HANGING_MOSS = create(key("pale_hanging_moss"));

    /**
     * {@code minecraft:pale_moss_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_MOSS_BLOCK = create(key("pale_moss_block"));

    /**
     * {@code minecraft:pale_moss_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_MOSS_CARPET = create(key("pale_moss_carpet"));

    /**
     * {@code minecraft:pale_oak_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_OAK_BUTTON = create(key("pale_oak_button"));

    /**
     * {@code minecraft:pale_oak_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_OAK_DOOR = create(key("pale_oak_door"));

    /**
     * {@code minecraft:pale_oak_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_OAK_FENCE = create(key("pale_oak_fence"));

    /**
     * {@code minecraft:pale_oak_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_OAK_FENCE_GATE = create(key("pale_oak_fence_gate"));

    /**
     * {@code minecraft:pale_oak_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_OAK_HANGING_SIGN = create(key("pale_oak_hanging_sign"));

    /**
     * {@code minecraft:pale_oak_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_OAK_LEAVES = create(key("pale_oak_leaves"));

    /**
     * {@code minecraft:pale_oak_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_OAK_LOG = create(key("pale_oak_log"));

    /**
     * {@code minecraft:pale_oak_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_OAK_PLANKS = create(key("pale_oak_planks"));

    /**
     * {@code minecraft:pale_oak_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_OAK_PRESSURE_PLATE = create(key("pale_oak_pressure_plate"));

    /**
     * {@code minecraft:pale_oak_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_OAK_SAPLING = create(key("pale_oak_sapling"));

    /**
     * {@code minecraft:pale_oak_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_OAK_SIGN = create(key("pale_oak_sign"));

    /**
     * {@code minecraft:pale_oak_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_OAK_SLAB = create(key("pale_oak_slab"));

    /**
     * {@code minecraft:pale_oak_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_OAK_STAIRS = create(key("pale_oak_stairs"));

    /**
     * {@code minecraft:pale_oak_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_OAK_TRAPDOOR = create(key("pale_oak_trapdoor"));

    /**
     * {@code minecraft:pale_oak_wall_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_OAK_WALL_HANGING_SIGN = create(key("pale_oak_wall_hanging_sign"));

    /**
     * {@code minecraft:pale_oak_wall_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_OAK_WALL_SIGN = create(key("pale_oak_wall_sign"));

    /**
     * {@code minecraft:pale_oak_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PALE_OAK_WOOD = create(key("pale_oak_wood"));

    /**
     * {@code minecraft:pearlescent_froglight}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PEARLESCENT_FROGLIGHT = create(key("pearlescent_froglight"));

    /**
     * {@code minecraft:peony}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PEONY = create(key("peony"));

    /**
     * {@code minecraft:petrified_oak_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PETRIFIED_OAK_SLAB = create(key("petrified_oak_slab"));

    /**
     * {@code minecraft:piglin_head}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PIGLIN_HEAD = create(key("piglin_head"));

    /**
     * {@code minecraft:piglin_wall_head}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PIGLIN_WALL_HEAD = create(key("piglin_wall_head"));

    /**
     * {@code minecraft:pink_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PINK_BANNER = create(key("pink_banner"));

    /**
     * {@code minecraft:pink_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PINK_BED = create(key("pink_bed"));

    /**
     * {@code minecraft:pink_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PINK_CANDLE = create(key("pink_candle"));

    /**
     * {@code minecraft:pink_candle_cake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PINK_CANDLE_CAKE = create(key("pink_candle_cake"));

    /**
     * {@code minecraft:pink_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PINK_CARPET = create(key("pink_carpet"));

    /**
     * {@code minecraft:pink_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PINK_CONCRETE = create(key("pink_concrete"));

    /**
     * {@code minecraft:pink_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PINK_CONCRETE_POWDER = create(key("pink_concrete_powder"));

    /**
     * {@code minecraft:pink_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PINK_GLAZED_TERRACOTTA = create(key("pink_glazed_terracotta"));

    /**
     * {@code minecraft:pink_petals}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PINK_PETALS = create(key("pink_petals"));

    /**
     * {@code minecraft:pink_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PINK_SHULKER_BOX = create(key("pink_shulker_box"));

    /**
     * {@code minecraft:pink_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PINK_STAINED_GLASS = create(key("pink_stained_glass"));

    /**
     * {@code minecraft:pink_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PINK_STAINED_GLASS_PANE = create(key("pink_stained_glass_pane"));

    /**
     * {@code minecraft:pink_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PINK_TERRACOTTA = create(key("pink_terracotta"));

    /**
     * {@code minecraft:pink_tulip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PINK_TULIP = create(key("pink_tulip"));

    /**
     * {@code minecraft:pink_wall_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PINK_WALL_BANNER = create(key("pink_wall_banner"));

    /**
     * {@code minecraft:pink_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PINK_WOOL = create(key("pink_wool"));

    /**
     * {@code minecraft:piston}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PISTON = create(key("piston"));

    /**
     * {@code minecraft:piston_head}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PISTON_HEAD = create(key("piston_head"));

    /**
     * {@code minecraft:pitcher_crop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PITCHER_CROP = create(key("pitcher_crop"));

    /**
     * {@code minecraft:pitcher_plant}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PITCHER_PLANT = create(key("pitcher_plant"));

    /**
     * {@code minecraft:player_head}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PLAYER_HEAD = create(key("player_head"));

    /**
     * {@code minecraft:player_wall_head}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PLAYER_WALL_HEAD = create(key("player_wall_head"));

    /**
     * {@code minecraft:podzol}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PODZOL = create(key("podzol"));

    /**
     * {@code minecraft:pointed_dripstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POINTED_DRIPSTONE = create(key("pointed_dripstone"));

    /**
     * {@code minecraft:polished_andesite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_ANDESITE = create(key("polished_andesite"));

    /**
     * {@code minecraft:polished_andesite_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_ANDESITE_SLAB = create(key("polished_andesite_slab"));

    /**
     * {@code minecraft:polished_andesite_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_ANDESITE_STAIRS = create(key("polished_andesite_stairs"));

    /**
     * {@code minecraft:polished_basalt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_BASALT = create(key("polished_basalt"));

    /**
     * {@code minecraft:polished_blackstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_BLACKSTONE = create(key("polished_blackstone"));

    /**
     * {@code minecraft:polished_blackstone_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_BLACKSTONE_BRICK_SLAB = create(key("polished_blackstone_brick_slab"));

    /**
     * {@code minecraft:polished_blackstone_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_BLACKSTONE_BRICK_STAIRS = create(key("polished_blackstone_brick_stairs"));

    /**
     * {@code minecraft:polished_blackstone_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_BLACKSTONE_BRICK_WALL = create(key("polished_blackstone_brick_wall"));

    /**
     * {@code minecraft:polished_blackstone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_BLACKSTONE_BRICKS = create(key("polished_blackstone_bricks"));

    /**
     * {@code minecraft:polished_blackstone_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_BLACKSTONE_BUTTON = create(key("polished_blackstone_button"));

    /**
     * {@code minecraft:polished_blackstone_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_BLACKSTONE_PRESSURE_PLATE = create(key("polished_blackstone_pressure_plate"));

    /**
     * {@code minecraft:polished_blackstone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_BLACKSTONE_SLAB = create(key("polished_blackstone_slab"));

    /**
     * {@code minecraft:polished_blackstone_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_BLACKSTONE_STAIRS = create(key("polished_blackstone_stairs"));

    /**
     * {@code minecraft:polished_blackstone_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_BLACKSTONE_WALL = create(key("polished_blackstone_wall"));

    /**
     * {@code minecraft:polished_deepslate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_DEEPSLATE = create(key("polished_deepslate"));

    /**
     * {@code minecraft:polished_deepslate_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_DEEPSLATE_SLAB = create(key("polished_deepslate_slab"));

    /**
     * {@code minecraft:polished_deepslate_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_DEEPSLATE_STAIRS = create(key("polished_deepslate_stairs"));

    /**
     * {@code minecraft:polished_deepslate_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_DEEPSLATE_WALL = create(key("polished_deepslate_wall"));

    /**
     * {@code minecraft:polished_diorite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_DIORITE = create(key("polished_diorite"));

    /**
     * {@code minecraft:polished_diorite_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_DIORITE_SLAB = create(key("polished_diorite_slab"));

    /**
     * {@code minecraft:polished_diorite_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_DIORITE_STAIRS = create(key("polished_diorite_stairs"));

    /**
     * {@code minecraft:polished_granite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_GRANITE = create(key("polished_granite"));

    /**
     * {@code minecraft:polished_granite_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_GRANITE_SLAB = create(key("polished_granite_slab"));

    /**
     * {@code minecraft:polished_granite_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_GRANITE_STAIRS = create(key("polished_granite_stairs"));

    /**
     * {@code minecraft:polished_tuff}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_TUFF = create(key("polished_tuff"));

    /**
     * {@code minecraft:polished_tuff_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_TUFF_SLAB = create(key("polished_tuff_slab"));

    /**
     * {@code minecraft:polished_tuff_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_TUFF_STAIRS = create(key("polished_tuff_stairs"));

    /**
     * {@code minecraft:polished_tuff_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POLISHED_TUFF_WALL = create(key("polished_tuff_wall"));

    /**
     * {@code minecraft:poppy}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POPPY = create(key("poppy"));

    /**
     * {@code minecraft:potatoes}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTATOES = create(key("potatoes"));

    /**
     * {@code minecraft:potted_acacia_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_ACACIA_SAPLING = create(key("potted_acacia_sapling"));

    /**
     * {@code minecraft:potted_allium}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_ALLIUM = create(key("potted_allium"));

    /**
     * {@code minecraft:potted_azalea_bush}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_AZALEA_BUSH = create(key("potted_azalea_bush"));

    /**
     * {@code minecraft:potted_azure_bluet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_AZURE_BLUET = create(key("potted_azure_bluet"));

    /**
     * {@code minecraft:potted_bamboo}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_BAMBOO = create(key("potted_bamboo"));

    /**
     * {@code minecraft:potted_birch_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_BIRCH_SAPLING = create(key("potted_birch_sapling"));

    /**
     * {@code minecraft:potted_blue_orchid}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_BLUE_ORCHID = create(key("potted_blue_orchid"));

    /**
     * {@code minecraft:potted_brown_mushroom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_BROWN_MUSHROOM = create(key("potted_brown_mushroom"));

    /**
     * {@code minecraft:potted_cactus}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_CACTUS = create(key("potted_cactus"));

    /**
     * {@code minecraft:potted_cherry_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_CHERRY_SAPLING = create(key("potted_cherry_sapling"));

    /**
     * {@code minecraft:potted_closed_eyeblossom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_CLOSED_EYEBLOSSOM = create(key("potted_closed_eyeblossom"));

    /**
     * {@code minecraft:potted_cornflower}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_CORNFLOWER = create(key("potted_cornflower"));

    /**
     * {@code minecraft:potted_crimson_fungus}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_CRIMSON_FUNGUS = create(key("potted_crimson_fungus"));

    /**
     * {@code minecraft:potted_crimson_roots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_CRIMSON_ROOTS = create(key("potted_crimson_roots"));

    /**
     * {@code minecraft:potted_dandelion}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_DANDELION = create(key("potted_dandelion"));

    /**
     * {@code minecraft:potted_dark_oak_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_DARK_OAK_SAPLING = create(key("potted_dark_oak_sapling"));

    /**
     * {@code minecraft:potted_dead_bush}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_DEAD_BUSH = create(key("potted_dead_bush"));

    /**
     * {@code minecraft:potted_fern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_FERN = create(key("potted_fern"));

    /**
     * {@code minecraft:potted_flowering_azalea_bush}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_FLOWERING_AZALEA_BUSH = create(key("potted_flowering_azalea_bush"));

    /**
     * {@code minecraft:potted_jungle_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_JUNGLE_SAPLING = create(key("potted_jungle_sapling"));

    /**
     * {@code minecraft:potted_lily_of_the_valley}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_LILY_OF_THE_VALLEY = create(key("potted_lily_of_the_valley"));

    /**
     * {@code minecraft:potted_mangrove_propagule}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_MANGROVE_PROPAGULE = create(key("potted_mangrove_propagule"));

    /**
     * {@code minecraft:potted_oak_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_OAK_SAPLING = create(key("potted_oak_sapling"));

    /**
     * {@code minecraft:potted_open_eyeblossom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_OPEN_EYEBLOSSOM = create(key("potted_open_eyeblossom"));

    /**
     * {@code minecraft:potted_orange_tulip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_ORANGE_TULIP = create(key("potted_orange_tulip"));

    /**
     * {@code minecraft:potted_oxeye_daisy}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_OXEYE_DAISY = create(key("potted_oxeye_daisy"));

    /**
     * {@code minecraft:potted_pale_oak_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_PALE_OAK_SAPLING = create(key("potted_pale_oak_sapling"));

    /**
     * {@code minecraft:potted_pink_tulip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_PINK_TULIP = create(key("potted_pink_tulip"));

    /**
     * {@code minecraft:potted_poppy}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_POPPY = create(key("potted_poppy"));

    /**
     * {@code minecraft:potted_red_mushroom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_RED_MUSHROOM = create(key("potted_red_mushroom"));

    /**
     * {@code minecraft:potted_red_tulip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_RED_TULIP = create(key("potted_red_tulip"));

    /**
     * {@code minecraft:potted_spruce_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_SPRUCE_SAPLING = create(key("potted_spruce_sapling"));

    /**
     * {@code minecraft:potted_torchflower}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_TORCHFLOWER = create(key("potted_torchflower"));

    /**
     * {@code minecraft:potted_warped_fungus}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_WARPED_FUNGUS = create(key("potted_warped_fungus"));

    /**
     * {@code minecraft:potted_warped_roots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_WARPED_ROOTS = create(key("potted_warped_roots"));

    /**
     * {@code minecraft:potted_white_tulip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_WHITE_TULIP = create(key("potted_white_tulip"));

    /**
     * {@code minecraft:potted_wither_rose}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POTTED_WITHER_ROSE = create(key("potted_wither_rose"));

    /**
     * {@code minecraft:powder_snow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POWDER_SNOW = create(key("powder_snow"));

    /**
     * {@code minecraft:powder_snow_cauldron}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POWDER_SNOW_CAULDRON = create(key("powder_snow_cauldron"));

    /**
     * {@code minecraft:powered_rail}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> POWERED_RAIL = create(key("powered_rail"));

    /**
     * {@code minecraft:prismarine}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PRISMARINE = create(key("prismarine"));

    /**
     * {@code minecraft:prismarine_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PRISMARINE_BRICK_SLAB = create(key("prismarine_brick_slab"));

    /**
     * {@code minecraft:prismarine_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PRISMARINE_BRICK_STAIRS = create(key("prismarine_brick_stairs"));

    /**
     * {@code minecraft:prismarine_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PRISMARINE_BRICKS = create(key("prismarine_bricks"));

    /**
     * {@code minecraft:prismarine_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PRISMARINE_SLAB = create(key("prismarine_slab"));

    /**
     * {@code minecraft:prismarine_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PRISMARINE_STAIRS = create(key("prismarine_stairs"));

    /**
     * {@code minecraft:prismarine_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PRISMARINE_WALL = create(key("prismarine_wall"));

    /**
     * {@code minecraft:pumpkin}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PUMPKIN = create(key("pumpkin"));

    /**
     * {@code minecraft:pumpkin_stem}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PUMPKIN_STEM = create(key("pumpkin_stem"));

    /**
     * {@code minecraft:purple_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PURPLE_BANNER = create(key("purple_banner"));

    /**
     * {@code minecraft:purple_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PURPLE_BED = create(key("purple_bed"));

    /**
     * {@code minecraft:purple_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PURPLE_CANDLE = create(key("purple_candle"));

    /**
     * {@code minecraft:purple_candle_cake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PURPLE_CANDLE_CAKE = create(key("purple_candle_cake"));

    /**
     * {@code minecraft:purple_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PURPLE_CARPET = create(key("purple_carpet"));

    /**
     * {@code minecraft:purple_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PURPLE_CONCRETE = create(key("purple_concrete"));

    /**
     * {@code minecraft:purple_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PURPLE_CONCRETE_POWDER = create(key("purple_concrete_powder"));

    /**
     * {@code minecraft:purple_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PURPLE_GLAZED_TERRACOTTA = create(key("purple_glazed_terracotta"));

    /**
     * {@code minecraft:purple_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PURPLE_SHULKER_BOX = create(key("purple_shulker_box"));

    /**
     * {@code minecraft:purple_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PURPLE_STAINED_GLASS = create(key("purple_stained_glass"));

    /**
     * {@code minecraft:purple_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PURPLE_STAINED_GLASS_PANE = create(key("purple_stained_glass_pane"));

    /**
     * {@code minecraft:purple_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PURPLE_TERRACOTTA = create(key("purple_terracotta"));

    /**
     * {@code minecraft:purple_wall_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PURPLE_WALL_BANNER = create(key("purple_wall_banner"));

    /**
     * {@code minecraft:purple_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PURPLE_WOOL = create(key("purple_wool"));

    /**
     * {@code minecraft:purpur_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PURPUR_BLOCK = create(key("purpur_block"));

    /**
     * {@code minecraft:purpur_pillar}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PURPUR_PILLAR = create(key("purpur_pillar"));

    /**
     * {@code minecraft:purpur_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PURPUR_SLAB = create(key("purpur_slab"));

    /**
     * {@code minecraft:purpur_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> PURPUR_STAIRS = create(key("purpur_stairs"));

    /**
     * {@code minecraft:quartz_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> QUARTZ_BLOCK = create(key("quartz_block"));

    /**
     * {@code minecraft:quartz_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> QUARTZ_BRICKS = create(key("quartz_bricks"));

    /**
     * {@code minecraft:quartz_pillar}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> QUARTZ_PILLAR = create(key("quartz_pillar"));

    /**
     * {@code minecraft:quartz_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> QUARTZ_SLAB = create(key("quartz_slab"));

    /**
     * {@code minecraft:quartz_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> QUARTZ_STAIRS = create(key("quartz_stairs"));

    /**
     * {@code minecraft:rail}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RAIL = create(key("rail"));

    /**
     * {@code minecraft:raw_copper_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RAW_COPPER_BLOCK = create(key("raw_copper_block"));

    /**
     * {@code minecraft:raw_gold_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RAW_GOLD_BLOCK = create(key("raw_gold_block"));

    /**
     * {@code minecraft:raw_iron_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RAW_IRON_BLOCK = create(key("raw_iron_block"));

    /**
     * {@code minecraft:red_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_BANNER = create(key("red_banner"));

    /**
     * {@code minecraft:red_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_BED = create(key("red_bed"));

    /**
     * {@code minecraft:red_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_CANDLE = create(key("red_candle"));

    /**
     * {@code minecraft:red_candle_cake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_CANDLE_CAKE = create(key("red_candle_cake"));

    /**
     * {@code minecraft:red_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_CARPET = create(key("red_carpet"));

    /**
     * {@code minecraft:red_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_CONCRETE = create(key("red_concrete"));

    /**
     * {@code minecraft:red_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_CONCRETE_POWDER = create(key("red_concrete_powder"));

    /**
     * {@code minecraft:red_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_GLAZED_TERRACOTTA = create(key("red_glazed_terracotta"));

    /**
     * {@code minecraft:red_mushroom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_MUSHROOM = create(key("red_mushroom"));

    /**
     * {@code minecraft:red_mushroom_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_MUSHROOM_BLOCK = create(key("red_mushroom_block"));

    /**
     * {@code minecraft:red_nether_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_NETHER_BRICK_SLAB = create(key("red_nether_brick_slab"));

    /**
     * {@code minecraft:red_nether_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_NETHER_BRICK_STAIRS = create(key("red_nether_brick_stairs"));

    /**
     * {@code minecraft:red_nether_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_NETHER_BRICK_WALL = create(key("red_nether_brick_wall"));

    /**
     * {@code minecraft:red_nether_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_NETHER_BRICKS = create(key("red_nether_bricks"));

    /**
     * {@code minecraft:red_sand}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_SAND = create(key("red_sand"));

    /**
     * {@code minecraft:red_sandstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_SANDSTONE = create(key("red_sandstone"));

    /**
     * {@code minecraft:red_sandstone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_SANDSTONE_SLAB = create(key("red_sandstone_slab"));

    /**
     * {@code minecraft:red_sandstone_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_SANDSTONE_STAIRS = create(key("red_sandstone_stairs"));

    /**
     * {@code minecraft:red_sandstone_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_SANDSTONE_WALL = create(key("red_sandstone_wall"));

    /**
     * {@code minecraft:red_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_SHULKER_BOX = create(key("red_shulker_box"));

    /**
     * {@code minecraft:red_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_STAINED_GLASS = create(key("red_stained_glass"));

    /**
     * {@code minecraft:red_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_STAINED_GLASS_PANE = create(key("red_stained_glass_pane"));

    /**
     * {@code minecraft:red_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_TERRACOTTA = create(key("red_terracotta"));

    /**
     * {@code minecraft:red_tulip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_TULIP = create(key("red_tulip"));

    /**
     * {@code minecraft:red_wall_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_WALL_BANNER = create(key("red_wall_banner"));

    /**
     * {@code minecraft:red_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RED_WOOL = create(key("red_wool"));

    /**
     * {@code minecraft:redstone_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> REDSTONE_BLOCK = create(key("redstone_block"));

    /**
     * {@code minecraft:redstone_lamp}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> REDSTONE_LAMP = create(key("redstone_lamp"));

    /**
     * {@code minecraft:redstone_ore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> REDSTONE_ORE = create(key("redstone_ore"));

    /**
     * {@code minecraft:redstone_torch}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> REDSTONE_TORCH = create(key("redstone_torch"));

    /**
     * {@code minecraft:redstone_wall_torch}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> REDSTONE_WALL_TORCH = create(key("redstone_wall_torch"));

    /**
     * {@code minecraft:redstone_wire}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> REDSTONE_WIRE = create(key("redstone_wire"));

    /**
     * {@code minecraft:reinforced_deepslate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> REINFORCED_DEEPSLATE = create(key("reinforced_deepslate"));

    /**
     * {@code minecraft:repeater}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> REPEATER = create(key("repeater"));

    /**
     * {@code minecraft:repeating_command_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> REPEATING_COMMAND_BLOCK = create(key("repeating_command_block"));

    /**
     * {@code minecraft:resin_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RESIN_BLOCK = create(key("resin_block"));

    /**
     * {@code minecraft:resin_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RESIN_BRICK_SLAB = create(key("resin_brick_slab"));

    /**
     * {@code minecraft:resin_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RESIN_BRICK_STAIRS = create(key("resin_brick_stairs"));

    /**
     * {@code minecraft:resin_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RESIN_BRICK_WALL = create(key("resin_brick_wall"));

    /**
     * {@code minecraft:resin_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RESIN_BRICKS = create(key("resin_bricks"));

    /**
     * {@code minecraft:resin_clump}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RESIN_CLUMP = create(key("resin_clump"));

    /**
     * {@code minecraft:respawn_anchor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> RESPAWN_ANCHOR = create(key("respawn_anchor"));

    /**
     * {@code minecraft:rooted_dirt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ROOTED_DIRT = create(key("rooted_dirt"));

    /**
     * {@code minecraft:rose_bush}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ROSE_BUSH = create(key("rose_bush"));

    /**
     * {@code minecraft:sand}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SAND = create(key("sand"));

    /**
     * {@code minecraft:sandstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SANDSTONE = create(key("sandstone"));

    /**
     * {@code minecraft:sandstone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SANDSTONE_SLAB = create(key("sandstone_slab"));

    /**
     * {@code minecraft:sandstone_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SANDSTONE_STAIRS = create(key("sandstone_stairs"));

    /**
     * {@code minecraft:sandstone_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SANDSTONE_WALL = create(key("sandstone_wall"));

    /**
     * {@code minecraft:scaffolding}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SCAFFOLDING = create(key("scaffolding"));

    /**
     * {@code minecraft:sculk}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SCULK = create(key("sculk"));

    /**
     * {@code minecraft:sculk_catalyst}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SCULK_CATALYST = create(key("sculk_catalyst"));

    /**
     * {@code minecraft:sculk_sensor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SCULK_SENSOR = create(key("sculk_sensor"));

    /**
     * {@code minecraft:sculk_shrieker}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SCULK_SHRIEKER = create(key("sculk_shrieker"));

    /**
     * {@code minecraft:sculk_vein}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SCULK_VEIN = create(key("sculk_vein"));

    /**
     * {@code minecraft:sea_lantern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SEA_LANTERN = create(key("sea_lantern"));

    /**
     * {@code minecraft:sea_pickle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SEA_PICKLE = create(key("sea_pickle"));

    /**
     * {@code minecraft:seagrass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SEAGRASS = create(key("seagrass"));

    /**
     * {@code minecraft:short_dry_grass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SHORT_DRY_GRASS = create(key("short_dry_grass"));

    /**
     * {@code minecraft:short_grass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SHORT_GRASS = create(key("short_grass"));

    /**
     * {@code minecraft:shroomlight}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SHROOMLIGHT = create(key("shroomlight"));

    /**
     * {@code minecraft:shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SHULKER_BOX = create(key("shulker_box"));

    /**
     * {@code minecraft:skeleton_skull}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SKELETON_SKULL = create(key("skeleton_skull"));

    /**
     * {@code minecraft:skeleton_wall_skull}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SKELETON_WALL_SKULL = create(key("skeleton_wall_skull"));

    /**
     * {@code minecraft:slime_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SLIME_BLOCK = create(key("slime_block"));

    /**
     * {@code minecraft:small_amethyst_bud}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SMALL_AMETHYST_BUD = create(key("small_amethyst_bud"));

    /**
     * {@code minecraft:small_dripleaf}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SMALL_DRIPLEAF = create(key("small_dripleaf"));

    /**
     * {@code minecraft:smithing_table}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SMITHING_TABLE = create(key("smithing_table"));

    /**
     * {@code minecraft:smoker}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SMOKER = create(key("smoker"));

    /**
     * {@code minecraft:smooth_basalt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SMOOTH_BASALT = create(key("smooth_basalt"));

    /**
     * {@code minecraft:smooth_quartz}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SMOOTH_QUARTZ = create(key("smooth_quartz"));

    /**
     * {@code minecraft:smooth_quartz_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SMOOTH_QUARTZ_SLAB = create(key("smooth_quartz_slab"));

    /**
     * {@code minecraft:smooth_quartz_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SMOOTH_QUARTZ_STAIRS = create(key("smooth_quartz_stairs"));

    /**
     * {@code minecraft:smooth_red_sandstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SMOOTH_RED_SANDSTONE = create(key("smooth_red_sandstone"));

    /**
     * {@code minecraft:smooth_red_sandstone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SMOOTH_RED_SANDSTONE_SLAB = create(key("smooth_red_sandstone_slab"));

    /**
     * {@code minecraft:smooth_red_sandstone_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SMOOTH_RED_SANDSTONE_STAIRS = create(key("smooth_red_sandstone_stairs"));

    /**
     * {@code minecraft:smooth_sandstone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SMOOTH_SANDSTONE = create(key("smooth_sandstone"));

    /**
     * {@code minecraft:smooth_sandstone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SMOOTH_SANDSTONE_SLAB = create(key("smooth_sandstone_slab"));

    /**
     * {@code minecraft:smooth_sandstone_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SMOOTH_SANDSTONE_STAIRS = create(key("smooth_sandstone_stairs"));

    /**
     * {@code minecraft:smooth_stone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SMOOTH_STONE = create(key("smooth_stone"));

    /**
     * {@code minecraft:smooth_stone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SMOOTH_STONE_SLAB = create(key("smooth_stone_slab"));

    /**
     * {@code minecraft:sniffer_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SNIFFER_EGG = create(key("sniffer_egg"));

    /**
     * {@code minecraft:snow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SNOW = create(key("snow"));

    /**
     * {@code minecraft:snow_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SNOW_BLOCK = create(key("snow_block"));

    /**
     * {@code minecraft:soul_campfire}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SOUL_CAMPFIRE = create(key("soul_campfire"));

    /**
     * {@code minecraft:soul_fire}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SOUL_FIRE = create(key("soul_fire"));

    /**
     * {@code minecraft:soul_lantern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SOUL_LANTERN = create(key("soul_lantern"));

    /**
     * {@code minecraft:soul_sand}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SOUL_SAND = create(key("soul_sand"));

    /**
     * {@code minecraft:soul_soil}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SOUL_SOIL = create(key("soul_soil"));

    /**
     * {@code minecraft:soul_torch}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SOUL_TORCH = create(key("soul_torch"));

    /**
     * {@code minecraft:soul_wall_torch}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SOUL_WALL_TORCH = create(key("soul_wall_torch"));

    /**
     * {@code minecraft:spawner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPAWNER = create(key("spawner"));

    /**
     * {@code minecraft:sponge}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPONGE = create(key("sponge"));

    /**
     * {@code minecraft:spore_blossom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPORE_BLOSSOM = create(key("spore_blossom"));

    /**
     * {@code minecraft:spruce_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPRUCE_BUTTON = create(key("spruce_button"));

    /**
     * {@code minecraft:spruce_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPRUCE_DOOR = create(key("spruce_door"));

    /**
     * {@code minecraft:spruce_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPRUCE_FENCE = create(key("spruce_fence"));

    /**
     * {@code minecraft:spruce_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPRUCE_FENCE_GATE = create(key("spruce_fence_gate"));

    /**
     * {@code minecraft:spruce_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPRUCE_HANGING_SIGN = create(key("spruce_hanging_sign"));

    /**
     * {@code minecraft:spruce_leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPRUCE_LEAVES = create(key("spruce_leaves"));

    /**
     * {@code minecraft:spruce_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPRUCE_LOG = create(key("spruce_log"));

    /**
     * {@code minecraft:spruce_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPRUCE_PLANKS = create(key("spruce_planks"));

    /**
     * {@code minecraft:spruce_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPRUCE_PRESSURE_PLATE = create(key("spruce_pressure_plate"));

    /**
     * {@code minecraft:spruce_sapling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPRUCE_SAPLING = create(key("spruce_sapling"));

    /**
     * {@code minecraft:spruce_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPRUCE_SIGN = create(key("spruce_sign"));

    /**
     * {@code minecraft:spruce_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPRUCE_SLAB = create(key("spruce_slab"));

    /**
     * {@code minecraft:spruce_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPRUCE_STAIRS = create(key("spruce_stairs"));

    /**
     * {@code minecraft:spruce_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPRUCE_TRAPDOOR = create(key("spruce_trapdoor"));

    /**
     * {@code minecraft:spruce_wall_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPRUCE_WALL_HANGING_SIGN = create(key("spruce_wall_hanging_sign"));

    /**
     * {@code minecraft:spruce_wall_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPRUCE_WALL_SIGN = create(key("spruce_wall_sign"));

    /**
     * {@code minecraft:spruce_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SPRUCE_WOOD = create(key("spruce_wood"));

    /**
     * {@code minecraft:sticky_piston}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STICKY_PISTON = create(key("sticky_piston"));

    /**
     * {@code minecraft:stone}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STONE = create(key("stone"));

    /**
     * {@code minecraft:stone_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STONE_BRICK_SLAB = create(key("stone_brick_slab"));

    /**
     * {@code minecraft:stone_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STONE_BRICK_STAIRS = create(key("stone_brick_stairs"));

    /**
     * {@code minecraft:stone_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STONE_BRICK_WALL = create(key("stone_brick_wall"));

    /**
     * {@code minecraft:stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STONE_BRICKS = create(key("stone_bricks"));

    /**
     * {@code minecraft:stone_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STONE_BUTTON = create(key("stone_button"));

    /**
     * {@code minecraft:stone_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STONE_PRESSURE_PLATE = create(key("stone_pressure_plate"));

    /**
     * {@code minecraft:stone_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STONE_SLAB = create(key("stone_slab"));

    /**
     * {@code minecraft:stone_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STONE_STAIRS = create(key("stone_stairs"));

    /**
     * {@code minecraft:stonecutter}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STONECUTTER = create(key("stonecutter"));

    /**
     * {@code minecraft:stripped_acacia_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_ACACIA_LOG = create(key("stripped_acacia_log"));

    /**
     * {@code minecraft:stripped_acacia_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_ACACIA_WOOD = create(key("stripped_acacia_wood"));

    /**
     * {@code minecraft:stripped_bamboo_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_BAMBOO_BLOCK = create(key("stripped_bamboo_block"));

    /**
     * {@code minecraft:stripped_birch_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_BIRCH_LOG = create(key("stripped_birch_log"));

    /**
     * {@code minecraft:stripped_birch_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_BIRCH_WOOD = create(key("stripped_birch_wood"));

    /**
     * {@code minecraft:stripped_cherry_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_CHERRY_LOG = create(key("stripped_cherry_log"));

    /**
     * {@code minecraft:stripped_cherry_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_CHERRY_WOOD = create(key("stripped_cherry_wood"));

    /**
     * {@code minecraft:stripped_crimson_hyphae}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_CRIMSON_HYPHAE = create(key("stripped_crimson_hyphae"));

    /**
     * {@code minecraft:stripped_crimson_stem}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_CRIMSON_STEM = create(key("stripped_crimson_stem"));

    /**
     * {@code minecraft:stripped_dark_oak_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_DARK_OAK_LOG = create(key("stripped_dark_oak_log"));

    /**
     * {@code minecraft:stripped_dark_oak_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_DARK_OAK_WOOD = create(key("stripped_dark_oak_wood"));

    /**
     * {@code minecraft:stripped_jungle_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_JUNGLE_LOG = create(key("stripped_jungle_log"));

    /**
     * {@code minecraft:stripped_jungle_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_JUNGLE_WOOD = create(key("stripped_jungle_wood"));

    /**
     * {@code minecraft:stripped_mangrove_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_MANGROVE_LOG = create(key("stripped_mangrove_log"));

    /**
     * {@code minecraft:stripped_mangrove_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_MANGROVE_WOOD = create(key("stripped_mangrove_wood"));

    /**
     * {@code minecraft:stripped_oak_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_OAK_LOG = create(key("stripped_oak_log"));

    /**
     * {@code minecraft:stripped_oak_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_OAK_WOOD = create(key("stripped_oak_wood"));

    /**
     * {@code minecraft:stripped_pale_oak_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_PALE_OAK_LOG = create(key("stripped_pale_oak_log"));

    /**
     * {@code minecraft:stripped_pale_oak_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_PALE_OAK_WOOD = create(key("stripped_pale_oak_wood"));

    /**
     * {@code minecraft:stripped_spruce_log}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_SPRUCE_LOG = create(key("stripped_spruce_log"));

    /**
     * {@code minecraft:stripped_spruce_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_SPRUCE_WOOD = create(key("stripped_spruce_wood"));

    /**
     * {@code minecraft:stripped_warped_hyphae}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_WARPED_HYPHAE = create(key("stripped_warped_hyphae"));

    /**
     * {@code minecraft:stripped_warped_stem}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRIPPED_WARPED_STEM = create(key("stripped_warped_stem"));

    /**
     * {@code minecraft:structure_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRUCTURE_BLOCK = create(key("structure_block"));

    /**
     * {@code minecraft:structure_void}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> STRUCTURE_VOID = create(key("structure_void"));

    /**
     * {@code minecraft:sugar_cane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SUGAR_CANE = create(key("sugar_cane"));

    /**
     * {@code minecraft:sunflower}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SUNFLOWER = create(key("sunflower"));

    /**
     * {@code minecraft:suspicious_gravel}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SUSPICIOUS_GRAVEL = create(key("suspicious_gravel"));

    /**
     * {@code minecraft:suspicious_sand}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SUSPICIOUS_SAND = create(key("suspicious_sand"));

    /**
     * {@code minecraft:sweet_berry_bush}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> SWEET_BERRY_BUSH = create(key("sweet_berry_bush"));

    /**
     * {@code minecraft:tall_dry_grass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TALL_DRY_GRASS = create(key("tall_dry_grass"));

    /**
     * {@code minecraft:tall_grass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TALL_GRASS = create(key("tall_grass"));

    /**
     * {@code minecraft:tall_seagrass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TALL_SEAGRASS = create(key("tall_seagrass"));

    /**
     * {@code minecraft:target}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TARGET = create(key("target"));

    /**
     * {@code minecraft:terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TERRACOTTA = create(key("terracotta"));

    /**
     * {@code minecraft:test_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TEST_BLOCK = create(key("test_block"));

    /**
     * {@code minecraft:test_instance_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TEST_INSTANCE_BLOCK = create(key("test_instance_block"));

    /**
     * {@code minecraft:tinted_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TINTED_GLASS = create(key("tinted_glass"));

    /**
     * {@code minecraft:tnt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TNT = create(key("tnt"));

    /**
     * {@code minecraft:torch}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TORCH = create(key("torch"));

    /**
     * {@code minecraft:torchflower}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TORCHFLOWER = create(key("torchflower"));

    /**
     * {@code minecraft:torchflower_crop}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TORCHFLOWER_CROP = create(key("torchflower_crop"));

    /**
     * {@code minecraft:trapped_chest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TRAPPED_CHEST = create(key("trapped_chest"));

    /**
     * {@code minecraft:trial_spawner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TRIAL_SPAWNER = create(key("trial_spawner"));

    /**
     * {@code minecraft:tripwire}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TRIPWIRE = create(key("tripwire"));

    /**
     * {@code minecraft:tripwire_hook}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TRIPWIRE_HOOK = create(key("tripwire_hook"));

    /**
     * {@code minecraft:tube_coral}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TUBE_CORAL = create(key("tube_coral"));

    /**
     * {@code minecraft:tube_coral_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TUBE_CORAL_BLOCK = create(key("tube_coral_block"));

    /**
     * {@code minecraft:tube_coral_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TUBE_CORAL_FAN = create(key("tube_coral_fan"));

    /**
     * {@code minecraft:tube_coral_wall_fan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TUBE_CORAL_WALL_FAN = create(key("tube_coral_wall_fan"));

    /**
     * {@code minecraft:tuff}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TUFF = create(key("tuff"));

    /**
     * {@code minecraft:tuff_brick_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TUFF_BRICK_SLAB = create(key("tuff_brick_slab"));

    /**
     * {@code minecraft:tuff_brick_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TUFF_BRICK_STAIRS = create(key("tuff_brick_stairs"));

    /**
     * {@code minecraft:tuff_brick_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TUFF_BRICK_WALL = create(key("tuff_brick_wall"));

    /**
     * {@code minecraft:tuff_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TUFF_BRICKS = create(key("tuff_bricks"));

    /**
     * {@code minecraft:tuff_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TUFF_SLAB = create(key("tuff_slab"));

    /**
     * {@code minecraft:tuff_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TUFF_STAIRS = create(key("tuff_stairs"));

    /**
     * {@code minecraft:tuff_wall}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TUFF_WALL = create(key("tuff_wall"));

    /**
     * {@code minecraft:turtle_egg}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TURTLE_EGG = create(key("turtle_egg"));

    /**
     * {@code minecraft:twisting_vines}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TWISTING_VINES = create(key("twisting_vines"));

    /**
     * {@code minecraft:twisting_vines_plant}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> TWISTING_VINES_PLANT = create(key("twisting_vines_plant"));

    /**
     * {@code minecraft:vault}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> VAULT = create(key("vault"));

    /**
     * {@code minecraft:verdant_froglight}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> VERDANT_FROGLIGHT = create(key("verdant_froglight"));

    /**
     * {@code minecraft:vine}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> VINE = create(key("vine"));

    /**
     * {@code minecraft:void_air}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> VOID_AIR = create(key("void_air"));

    /**
     * {@code minecraft:wall_torch}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WALL_TORCH = create(key("wall_torch"));

    /**
     * {@code minecraft:warped_button}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WARPED_BUTTON = create(key("warped_button"));

    /**
     * {@code minecraft:warped_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WARPED_DOOR = create(key("warped_door"));

    /**
     * {@code minecraft:warped_fence}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WARPED_FENCE = create(key("warped_fence"));

    /**
     * {@code minecraft:warped_fence_gate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WARPED_FENCE_GATE = create(key("warped_fence_gate"));

    /**
     * {@code minecraft:warped_fungus}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WARPED_FUNGUS = create(key("warped_fungus"));

    /**
     * {@code minecraft:warped_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WARPED_HANGING_SIGN = create(key("warped_hanging_sign"));

    /**
     * {@code minecraft:warped_hyphae}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WARPED_HYPHAE = create(key("warped_hyphae"));

    /**
     * {@code minecraft:warped_nylium}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WARPED_NYLIUM = create(key("warped_nylium"));

    /**
     * {@code minecraft:warped_planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WARPED_PLANKS = create(key("warped_planks"));

    /**
     * {@code minecraft:warped_pressure_plate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WARPED_PRESSURE_PLATE = create(key("warped_pressure_plate"));

    /**
     * {@code minecraft:warped_roots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WARPED_ROOTS = create(key("warped_roots"));

    /**
     * {@code minecraft:warped_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WARPED_SIGN = create(key("warped_sign"));

    /**
     * {@code minecraft:warped_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WARPED_SLAB = create(key("warped_slab"));

    /**
     * {@code minecraft:warped_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WARPED_STAIRS = create(key("warped_stairs"));

    /**
     * {@code minecraft:warped_stem}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WARPED_STEM = create(key("warped_stem"));

    /**
     * {@code minecraft:warped_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WARPED_TRAPDOOR = create(key("warped_trapdoor"));

    /**
     * {@code minecraft:warped_wall_hanging_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WARPED_WALL_HANGING_SIGN = create(key("warped_wall_hanging_sign"));

    /**
     * {@code minecraft:warped_wall_sign}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WARPED_WALL_SIGN = create(key("warped_wall_sign"));

    /**
     * {@code minecraft:warped_wart_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WARPED_WART_BLOCK = create(key("warped_wart_block"));

    /**
     * {@code minecraft:water}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WATER = create(key("water"));

    /**
     * {@code minecraft:water_cauldron}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WATER_CAULDRON = create(key("water_cauldron"));

    /**
     * {@code minecraft:waxed_chiseled_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_CHISELED_COPPER = create(key("waxed_chiseled_copper"));

    /**
     * {@code minecraft:waxed_copper_block}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_COPPER_BLOCK = create(key("waxed_copper_block"));

    /**
     * {@code minecraft:waxed_copper_bulb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_COPPER_BULB = create(key("waxed_copper_bulb"));

    /**
     * {@code minecraft:waxed_copper_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_COPPER_DOOR = create(key("waxed_copper_door"));

    /**
     * {@code minecraft:waxed_copper_grate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_COPPER_GRATE = create(key("waxed_copper_grate"));

    /**
     * {@code minecraft:waxed_copper_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_COPPER_TRAPDOOR = create(key("waxed_copper_trapdoor"));

    /**
     * {@code minecraft:waxed_cut_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_CUT_COPPER = create(key("waxed_cut_copper"));

    /**
     * {@code minecraft:waxed_cut_copper_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_CUT_COPPER_SLAB = create(key("waxed_cut_copper_slab"));

    /**
     * {@code minecraft:waxed_cut_copper_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_CUT_COPPER_STAIRS = create(key("waxed_cut_copper_stairs"));

    /**
     * {@code minecraft:waxed_exposed_chiseled_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_EXPOSED_CHISELED_COPPER = create(key("waxed_exposed_chiseled_copper"));

    /**
     * {@code minecraft:waxed_exposed_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_EXPOSED_COPPER = create(key("waxed_exposed_copper"));

    /**
     * {@code minecraft:waxed_exposed_copper_bulb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_EXPOSED_COPPER_BULB = create(key("waxed_exposed_copper_bulb"));

    /**
     * {@code minecraft:waxed_exposed_copper_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_EXPOSED_COPPER_DOOR = create(key("waxed_exposed_copper_door"));

    /**
     * {@code minecraft:waxed_exposed_copper_grate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_EXPOSED_COPPER_GRATE = create(key("waxed_exposed_copper_grate"));

    /**
     * {@code minecraft:waxed_exposed_copper_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_EXPOSED_COPPER_TRAPDOOR = create(key("waxed_exposed_copper_trapdoor"));

    /**
     * {@code minecraft:waxed_exposed_cut_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_EXPOSED_CUT_COPPER = create(key("waxed_exposed_cut_copper"));

    /**
     * {@code minecraft:waxed_exposed_cut_copper_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_EXPOSED_CUT_COPPER_SLAB = create(key("waxed_exposed_cut_copper_slab"));

    /**
     * {@code minecraft:waxed_exposed_cut_copper_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_EXPOSED_CUT_COPPER_STAIRS = create(key("waxed_exposed_cut_copper_stairs"));

    /**
     * {@code minecraft:waxed_oxidized_chiseled_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_OXIDIZED_CHISELED_COPPER = create(key("waxed_oxidized_chiseled_copper"));

    /**
     * {@code minecraft:waxed_oxidized_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_OXIDIZED_COPPER = create(key("waxed_oxidized_copper"));

    /**
     * {@code minecraft:waxed_oxidized_copper_bulb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_OXIDIZED_COPPER_BULB = create(key("waxed_oxidized_copper_bulb"));

    /**
     * {@code minecraft:waxed_oxidized_copper_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_OXIDIZED_COPPER_DOOR = create(key("waxed_oxidized_copper_door"));

    /**
     * {@code minecraft:waxed_oxidized_copper_grate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_OXIDIZED_COPPER_GRATE = create(key("waxed_oxidized_copper_grate"));

    /**
     * {@code minecraft:waxed_oxidized_copper_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_OXIDIZED_COPPER_TRAPDOOR = create(key("waxed_oxidized_copper_trapdoor"));

    /**
     * {@code minecraft:waxed_oxidized_cut_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_OXIDIZED_CUT_COPPER = create(key("waxed_oxidized_cut_copper"));

    /**
     * {@code minecraft:waxed_oxidized_cut_copper_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_OXIDIZED_CUT_COPPER_SLAB = create(key("waxed_oxidized_cut_copper_slab"));

    /**
     * {@code minecraft:waxed_oxidized_cut_copper_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_OXIDIZED_CUT_COPPER_STAIRS = create(key("waxed_oxidized_cut_copper_stairs"));

    /**
     * {@code minecraft:waxed_weathered_chiseled_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_WEATHERED_CHISELED_COPPER = create(key("waxed_weathered_chiseled_copper"));

    /**
     * {@code minecraft:waxed_weathered_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_WEATHERED_COPPER = create(key("waxed_weathered_copper"));

    /**
     * {@code minecraft:waxed_weathered_copper_bulb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_WEATHERED_COPPER_BULB = create(key("waxed_weathered_copper_bulb"));

    /**
     * {@code minecraft:waxed_weathered_copper_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_WEATHERED_COPPER_DOOR = create(key("waxed_weathered_copper_door"));

    /**
     * {@code minecraft:waxed_weathered_copper_grate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_WEATHERED_COPPER_GRATE = create(key("waxed_weathered_copper_grate"));

    /**
     * {@code minecraft:waxed_weathered_copper_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_WEATHERED_COPPER_TRAPDOOR = create(key("waxed_weathered_copper_trapdoor"));

    /**
     * {@code minecraft:waxed_weathered_cut_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_WEATHERED_CUT_COPPER = create(key("waxed_weathered_cut_copper"));

    /**
     * {@code minecraft:waxed_weathered_cut_copper_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_WEATHERED_CUT_COPPER_SLAB = create(key("waxed_weathered_cut_copper_slab"));

    /**
     * {@code minecraft:waxed_weathered_cut_copper_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WAXED_WEATHERED_CUT_COPPER_STAIRS = create(key("waxed_weathered_cut_copper_stairs"));

    /**
     * {@code minecraft:weathered_chiseled_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WEATHERED_CHISELED_COPPER = create(key("weathered_chiseled_copper"));

    /**
     * {@code minecraft:weathered_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WEATHERED_COPPER = create(key("weathered_copper"));

    /**
     * {@code minecraft:weathered_copper_bulb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WEATHERED_COPPER_BULB = create(key("weathered_copper_bulb"));

    /**
     * {@code minecraft:weathered_copper_door}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WEATHERED_COPPER_DOOR = create(key("weathered_copper_door"));

    /**
     * {@code minecraft:weathered_copper_grate}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WEATHERED_COPPER_GRATE = create(key("weathered_copper_grate"));

    /**
     * {@code minecraft:weathered_copper_trapdoor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WEATHERED_COPPER_TRAPDOOR = create(key("weathered_copper_trapdoor"));

    /**
     * {@code minecraft:weathered_cut_copper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WEATHERED_CUT_COPPER = create(key("weathered_cut_copper"));

    /**
     * {@code minecraft:weathered_cut_copper_slab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WEATHERED_CUT_COPPER_SLAB = create(key("weathered_cut_copper_slab"));

    /**
     * {@code minecraft:weathered_cut_copper_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WEATHERED_CUT_COPPER_STAIRS = create(key("weathered_cut_copper_stairs"));

    /**
     * {@code minecraft:weeping_vines}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WEEPING_VINES = create(key("weeping_vines"));

    /**
     * {@code minecraft:weeping_vines_plant}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WEEPING_VINES_PLANT = create(key("weeping_vines_plant"));

    /**
     * {@code minecraft:wet_sponge}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WET_SPONGE = create(key("wet_sponge"));

    /**
     * {@code minecraft:wheat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WHEAT = create(key("wheat"));

    /**
     * {@code minecraft:white_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WHITE_BANNER = create(key("white_banner"));

    /**
     * {@code minecraft:white_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WHITE_BED = create(key("white_bed"));

    /**
     * {@code minecraft:white_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WHITE_CANDLE = create(key("white_candle"));

    /**
     * {@code minecraft:white_candle_cake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WHITE_CANDLE_CAKE = create(key("white_candle_cake"));

    /**
     * {@code minecraft:white_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WHITE_CARPET = create(key("white_carpet"));

    /**
     * {@code minecraft:white_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WHITE_CONCRETE = create(key("white_concrete"));

    /**
     * {@code minecraft:white_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WHITE_CONCRETE_POWDER = create(key("white_concrete_powder"));

    /**
     * {@code minecraft:white_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WHITE_GLAZED_TERRACOTTA = create(key("white_glazed_terracotta"));

    /**
     * {@code minecraft:white_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WHITE_SHULKER_BOX = create(key("white_shulker_box"));

    /**
     * {@code minecraft:white_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WHITE_STAINED_GLASS = create(key("white_stained_glass"));

    /**
     * {@code minecraft:white_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WHITE_STAINED_GLASS_PANE = create(key("white_stained_glass_pane"));

    /**
     * {@code minecraft:white_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WHITE_TERRACOTTA = create(key("white_terracotta"));

    /**
     * {@code minecraft:white_tulip}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WHITE_TULIP = create(key("white_tulip"));

    /**
     * {@code minecraft:white_wall_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WHITE_WALL_BANNER = create(key("white_wall_banner"));

    /**
     * {@code minecraft:white_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WHITE_WOOL = create(key("white_wool"));

    /**
     * {@code minecraft:wildflowers}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WILDFLOWERS = create(key("wildflowers"));

    /**
     * {@code minecraft:wither_rose}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WITHER_ROSE = create(key("wither_rose"));

    /**
     * {@code minecraft:wither_skeleton_skull}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WITHER_SKELETON_SKULL = create(key("wither_skeleton_skull"));

    /**
     * {@code minecraft:wither_skeleton_wall_skull}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> WITHER_SKELETON_WALL_SKULL = create(key("wither_skeleton_wall_skull"));

    /**
     * {@code minecraft:yellow_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> YELLOW_BANNER = create(key("yellow_banner"));

    /**
     * {@code minecraft:yellow_bed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> YELLOW_BED = create(key("yellow_bed"));

    /**
     * {@code minecraft:yellow_candle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> YELLOW_CANDLE = create(key("yellow_candle"));

    /**
     * {@code minecraft:yellow_candle_cake}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> YELLOW_CANDLE_CAKE = create(key("yellow_candle_cake"));

    /**
     * {@code minecraft:yellow_carpet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> YELLOW_CARPET = create(key("yellow_carpet"));

    /**
     * {@code minecraft:yellow_concrete}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> YELLOW_CONCRETE = create(key("yellow_concrete"));

    /**
     * {@code minecraft:yellow_concrete_powder}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> YELLOW_CONCRETE_POWDER = create(key("yellow_concrete_powder"));

    /**
     * {@code minecraft:yellow_glazed_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> YELLOW_GLAZED_TERRACOTTA = create(key("yellow_glazed_terracotta"));

    /**
     * {@code minecraft:yellow_shulker_box}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> YELLOW_SHULKER_BOX = create(key("yellow_shulker_box"));

    /**
     * {@code minecraft:yellow_stained_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> YELLOW_STAINED_GLASS = create(key("yellow_stained_glass"));

    /**
     * {@code minecraft:yellow_stained_glass_pane}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> YELLOW_STAINED_GLASS_PANE = create(key("yellow_stained_glass_pane"));

    /**
     * {@code minecraft:yellow_terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> YELLOW_TERRACOTTA = create(key("yellow_terracotta"));

    /**
     * {@code minecraft:yellow_wall_banner}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> YELLOW_WALL_BANNER = create(key("yellow_wall_banner"));

    /**
     * {@code minecraft:yellow_wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> YELLOW_WOOL = create(key("yellow_wool"));

    /**
     * {@code minecraft:zombie_head}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ZOMBIE_HEAD = create(key("zombie_head"));

    /**
     * {@code minecraft:zombie_wall_head}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<BlockType> ZOMBIE_WALL_HEAD = create(key("zombie_wall_head"));

    private BlockTypeKeys() {
    }

    private static TypedKey<BlockType> create(final Key key) {
        return TypedKey.create(RegistryKey.BLOCK, key);
    }
}
