/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.destroystokyo.paper.Namespaced;
import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.OptionalInt;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NamespacedKey
implements Key,
Namespaced {
    public static final String MINECRAFT = "minecraft";
    public static final String BUKKIT = "bukkit";
    private final String namespace;
    private final String key;

    public NamespacedKey(@NotNull String namespace, @NotNull String key) {
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"Namespace cannot be null");
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        this.namespace = namespace;
        this.key = key;
        this.validate();
    }

    public NamespacedKey(@NotNull Plugin plugin, @NotNull String key) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        this.namespace = plugin.getName().toLowerCase(Locale.ROOT);
        this.key = key.toLowerCase(Locale.ROOT);
        this.validate();
    }

    private void validate() {
        Preconditions.checkArgument((this.namespace.length() + 1 + this.key.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (Object)"NamespacedKey must be less than 32768 characters");
        NamespacedKey.checkError("[a-z0-9_-.]", "namespace", this.namespace, Key.checkNamespace((String)this.namespace));
        NamespacedKey.checkError("[a-z0-9_-./]", "key", this.key, Key.checkValue((String)this.key));
    }

    private static void checkError(String pattern, String name, String value, OptionalInt index) {
        index.ifPresent(indexValue -> {
            char character = value.charAt(indexValue);
            throw new IllegalArgumentException(String.format("Non %s character in %s '%s' at index %d ('%s', bytes: %s)", pattern, name, value, indexValue, Character.valueOf(character), Arrays.toString(String.valueOf(character).getBytes(StandardCharsets.UTF_8))));
        });
    }

    @Override
    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        int result = this.namespace.hashCode();
        result = 31 * result + this.key.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Key)) {
            return false;
        }
        Key key = (Key)obj;
        return this.namespace.equals(key.namespace()) && this.key.equals(key.value());
    }

    public String toString() {
        return this.namespace + ":" + this.key;
    }

    @Deprecated(since="1.20.5")
    @ApiStatus.Internal
    @NotNull
    public static NamespacedKey randomKey() {
        return new NamespacedKey(BUKKIT, UUID.randomUUID().toString());
    }

    @NotNull
    public static NamespacedKey minecraft(@NotNull String key) {
        return new NamespacedKey(MINECRAFT, key);
    }

    @Nullable
    public static NamespacedKey fromString(@NotNull String string, @Nullable Plugin defaultNamespace) {
        String key;
        Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)"Input string must not be null");
        if (string.isEmpty() || string.length() > Short.MAX_VALUE) {
            return null;
        }
        String[] components = string.split(":", 3);
        if (components.length > 2) {
            return null;
        }
        String string2 = key = components.length == 2 ? components[1] : "";
        if (components.length == 1) {
            String value = components[0];
            if (value.isEmpty() || !Key.parseableValue((String)value)) {
                return null;
            }
            return defaultNamespace != null ? new NamespacedKey(defaultNamespace, value) : NamespacedKey.minecraft(value);
        }
        if (components.length == 2 && !Key.parseableValue((String)key)) {
            return null;
        }
        String namespace = components[0];
        if (namespace.isEmpty()) {
            return defaultNamespace != null ? new NamespacedKey(defaultNamespace, key) : NamespacedKey.minecraft(key);
        }
        if (!Key.parseableNamespace((String)namespace)) {
            return null;
        }
        return new NamespacedKey(namespace, key);
    }

    @Nullable
    public static NamespacedKey fromString(@NotNull String key) {
        return NamespacedKey.fromString(key, null);
    }

    @NotNull
    public String namespace() {
        return this.getNamespace();
    }

    @NotNull
    public String value() {
        return this.getKey();
    }

    @NotNull
    public String asString() {
        return this.toString();
    }
}

