/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.player;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerJoinEvent
extends PlayerEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private Component joinMessage;

    @ApiStatus.Internal
    public PlayerJoinEvent(@NotNull Player playerJoined, @Nullable Component joinMessage) {
        super(playerJoined);
        this.joinMessage = joinMessage;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public PlayerJoinEvent(@NotNull Player playerJoined, @Nullable String joinMessage) {
        super(playerJoined);
        this.joinMessage = joinMessage != null ? LegacyComponentSerializer.legacySection().deserialize(joinMessage) : null;
    }

    @Nullable
    public Component joinMessage() {
        return this.joinMessage;
    }

    public void joinMessage(@Nullable Component joinMessage) {
        this.joinMessage = joinMessage;
    }

    @Deprecated
    @Nullable
    public String getJoinMessage() {
        return this.joinMessage == null ? null : LegacyComponentSerializer.legacySection().serialize(this.joinMessage);
    }

    @Deprecated
    public void setJoinMessage(@Nullable String joinMessage) {
        this.joinMessage = joinMessage != null ? LegacyComponentSerializer.legacySection().deserialize(joinMessage) : null;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

