package org.bukkit.event;

/**
 * A type characterizing events that may be cancelled by a plugin or the server.
 */
public interface Cancellable {

    /**
     * Gets the cancellation state of this event. A cancelled event will not
     * be executed in the server, but will still pass to other plugins
     *
     * @return {@code true} if this event is cancelled
     */
    boolean isCancelled();

    /**
     * Sets the cancellation state of this event. A cancelled event will not
     * be executed in the server, but will still pass to other plugins.
     *
     * @param cancel {@code true} if you wish to cancel this event
     */
    void setCancelled(boolean cancel);
}
