package io.papermc.paper.registry.keys.tags;

import static net.kyori.adventure.key.Key.key;

import io.papermc.paper.generated.GeneratedFrom;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.tag.TagKey;
import net.kyori.adventure.key.Key;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

/**
 * Vanilla tag keys for {@link RegistryKey#ITEM}.
 *
 * @apiNote The fields provided here are a direct representation of
 * what is available from the vanilla game source. They may be
 * changed (including removals) on any Minecraft version
 * bump, so cross-version compatibility is not provided on the
 * same level as it is on most of the other API.
 */
@SuppressWarnings({
        "unused",
        "SpellCheckingInspection"
})
@NullMarked
@GeneratedFrom("1.21.6-pre2")
@ApiStatus.Experimental
public final class ItemTypeTagKeys {
    /**
     * {@code #minecraft:acacia_logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ACACIA_LOGS = create(key("acacia_logs"));

    /**
     * {@code #minecraft:anvil}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ANVIL = create(key("anvil"));

    /**
     * {@code #minecraft:armadillo_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ARMADILLO_FOOD = create(key("armadillo_food"));

    /**
     * {@code #minecraft:arrows}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ARROWS = create(key("arrows"));

    /**
     * {@code #minecraft:axes}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> AXES = create(key("axes"));

    /**
     * {@code #minecraft:axolotl_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> AXOLOTL_FOOD = create(key("axolotl_food"));

    /**
     * {@code #minecraft:bamboo_blocks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> BAMBOO_BLOCKS = create(key("bamboo_blocks"));

    /**
     * {@code #minecraft:banners}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> BANNERS = create(key("banners"));

    /**
     * {@code #minecraft:beacon_payment_items}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> BEACON_PAYMENT_ITEMS = create(key("beacon_payment_items"));

    /**
     * {@code #minecraft:beds}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> BEDS = create(key("beds"));

    /**
     * {@code #minecraft:bee_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> BEE_FOOD = create(key("bee_food"));

    /**
     * {@code #minecraft:birch_logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> BIRCH_LOGS = create(key("birch_logs"));

    /**
     * {@code #minecraft:boats}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> BOATS = create(key("boats"));

    /**
     * {@code #minecraft:book_cloning_target}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> BOOK_CLONING_TARGET = create(key("book_cloning_target"));

    /**
     * {@code #minecraft:bookshelf_books}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> BOOKSHELF_BOOKS = create(key("bookshelf_books"));

    /**
     * {@code #minecraft:breaks_decorated_pots}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> BREAKS_DECORATED_POTS = create(key("breaks_decorated_pots"));

    /**
     * {@code #minecraft:brewing_fuel}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> BREWING_FUEL = create(key("brewing_fuel"));

    /**
     * {@code #minecraft:bundles}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> BUNDLES = create(key("bundles"));

    /**
     * {@code #minecraft:buttons}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> BUTTONS = create(key("buttons"));

    /**
     * {@code #minecraft:camel_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> CAMEL_FOOD = create(key("camel_food"));

    /**
     * {@code #minecraft:candles}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> CANDLES = create(key("candles"));

    /**
     * {@code #minecraft:cat_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> CAT_FOOD = create(key("cat_food"));

    /**
     * {@code #minecraft:cherry_logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> CHERRY_LOGS = create(key("cherry_logs"));

    /**
     * {@code #minecraft:chest_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> CHEST_ARMOR = create(key("chest_armor"));

    /**
     * {@code #minecraft:chest_boats}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> CHEST_BOATS = create(key("chest_boats"));

    /**
     * {@code #minecraft:chicken_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> CHICKEN_FOOD = create(key("chicken_food"));

    /**
     * {@code #minecraft:cluster_max_harvestables}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> CLUSTER_MAX_HARVESTABLES = create(key("cluster_max_harvestables"));

    /**
     * {@code #minecraft:coal_ores}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> COAL_ORES = create(key("coal_ores"));

    /**
     * {@code #minecraft:coals}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> COALS = create(key("coals"));

    /**
     * {@code #minecraft:compasses}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> COMPASSES = create(key("compasses"));

    /**
     * {@code #minecraft:completes_find_tree_tutorial}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> COMPLETES_FIND_TREE_TUTORIAL = create(key("completes_find_tree_tutorial"));

    /**
     * {@code #minecraft:copper_ores}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> COPPER_ORES = create(key("copper_ores"));

    /**
     * {@code #minecraft:cow_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> COW_FOOD = create(key("cow_food"));

    /**
     * {@code #minecraft:creeper_drop_music_discs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> CREEPER_DROP_MUSIC_DISCS = create(key("creeper_drop_music_discs"));

    /**
     * {@code #minecraft:creeper_igniters}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> CREEPER_IGNITERS = create(key("creeper_igniters"));

    /**
     * {@code #minecraft:crimson_stems}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> CRIMSON_STEMS = create(key("crimson_stems"));

    /**
     * {@code #minecraft:dampens_vibrations}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> DAMPENS_VIBRATIONS = create(key("dampens_vibrations"));

    /**
     * {@code #minecraft:dark_oak_logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> DARK_OAK_LOGS = create(key("dark_oak_logs"));

    /**
     * {@code #minecraft:decorated_pot_ingredients}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> DECORATED_POT_INGREDIENTS = create(key("decorated_pot_ingredients"));

    /**
     * {@code #minecraft:decorated_pot_sherds}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> DECORATED_POT_SHERDS = create(key("decorated_pot_sherds"));

    /**
     * {@code #minecraft:diamond_ores}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> DIAMOND_ORES = create(key("diamond_ores"));

    /**
     * {@code #minecraft:diamond_tool_materials}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> DIAMOND_TOOL_MATERIALS = create(key("diamond_tool_materials"));

    /**
     * {@code #minecraft:dirt}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> DIRT = create(key("dirt"));

    /**
     * {@code #minecraft:doors}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> DOORS = create(key("doors"));

    /**
     * {@code #minecraft:drowned_preferred_weapons}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> DROWNED_PREFERRED_WEAPONS = create(key("drowned_preferred_weapons"));

    /**
     * {@code #minecraft:duplicates_allays}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> DUPLICATES_ALLAYS = create(key("duplicates_allays"));

    /**
     * {@code #minecraft:dyeable}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> DYEABLE = create(key("dyeable"));

    /**
     * {@code #minecraft:eggs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> EGGS = create(key("eggs"));

    /**
     * {@code #minecraft:emerald_ores}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> EMERALD_ORES = create(key("emerald_ores"));

    /**
     * {@code #minecraft:enchantable/armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ENCHANTABLE_ARMOR = create(key("enchantable/armor"));

    /**
     * {@code #minecraft:enchantable/bow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ENCHANTABLE_BOW = create(key("enchantable/bow"));

    /**
     * {@code #minecraft:enchantable/chest_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ENCHANTABLE_CHEST_ARMOR = create(key("enchantable/chest_armor"));

    /**
     * {@code #minecraft:enchantable/crossbow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ENCHANTABLE_CROSSBOW = create(key("enchantable/crossbow"));

    /**
     * {@code #minecraft:enchantable/durability}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ENCHANTABLE_DURABILITY = create(key("enchantable/durability"));

    /**
     * {@code #minecraft:enchantable/equippable}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ENCHANTABLE_EQUIPPABLE = create(key("enchantable/equippable"));

    /**
     * {@code #minecraft:enchantable/fire_aspect}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ENCHANTABLE_FIRE_ASPECT = create(key("enchantable/fire_aspect"));

    /**
     * {@code #minecraft:enchantable/fishing}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ENCHANTABLE_FISHING = create(key("enchantable/fishing"));

    /**
     * {@code #minecraft:enchantable/foot_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ENCHANTABLE_FOOT_ARMOR = create(key("enchantable/foot_armor"));

    /**
     * {@code #minecraft:enchantable/head_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ENCHANTABLE_HEAD_ARMOR = create(key("enchantable/head_armor"));

    /**
     * {@code #minecraft:enchantable/leg_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ENCHANTABLE_LEG_ARMOR = create(key("enchantable/leg_armor"));

    /**
     * {@code #minecraft:enchantable/mace}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ENCHANTABLE_MACE = create(key("enchantable/mace"));

    /**
     * {@code #minecraft:enchantable/mining}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ENCHANTABLE_MINING = create(key("enchantable/mining"));

    /**
     * {@code #minecraft:enchantable/mining_loot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ENCHANTABLE_MINING_LOOT = create(key("enchantable/mining_loot"));

    /**
     * {@code #minecraft:enchantable/sharp_weapon}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ENCHANTABLE_SHARP_WEAPON = create(key("enchantable/sharp_weapon"));

    /**
     * {@code #minecraft:enchantable/sword}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ENCHANTABLE_SWORD = create(key("enchantable/sword"));

    /**
     * {@code #minecraft:enchantable/trident}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ENCHANTABLE_TRIDENT = create(key("enchantable/trident"));

    /**
     * {@code #minecraft:enchantable/vanishing}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ENCHANTABLE_VANISHING = create(key("enchantable/vanishing"));

    /**
     * {@code #minecraft:enchantable/weapon}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> ENCHANTABLE_WEAPON = create(key("enchantable/weapon"));

    /**
     * {@code #minecraft:fence_gates}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> FENCE_GATES = create(key("fence_gates"));

    /**
     * {@code #minecraft:fences}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> FENCES = create(key("fences"));

    /**
     * {@code #minecraft:fishes}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> FISHES = create(key("fishes"));

    /**
     * {@code #minecraft:flowers}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> FLOWERS = create(key("flowers"));

    /**
     * {@code #minecraft:foot_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> FOOT_ARMOR = create(key("foot_armor"));

    /**
     * {@code #minecraft:fox_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> FOX_FOOD = create(key("fox_food"));

    /**
     * {@code #minecraft:freeze_immune_wearables}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> FREEZE_IMMUNE_WEARABLES = create(key("freeze_immune_wearables"));

    /**
     * {@code #minecraft:frog_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> FROG_FOOD = create(key("frog_food"));

    /**
     * {@code #minecraft:furnace_minecart_fuel}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> FURNACE_MINECART_FUEL = create(key("furnace_minecart_fuel"));

    /**
     * {@code #minecraft:gaze_disguise_equipment}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> GAZE_DISGUISE_EQUIPMENT = create(key("gaze_disguise_equipment"));

    /**
     * {@code #minecraft:goat_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> GOAT_FOOD = create(key("goat_food"));

    /**
     * {@code #minecraft:gold_ores}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> GOLD_ORES = create(key("gold_ores"));

    /**
     * {@code #minecraft:gold_tool_materials}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> GOLD_TOOL_MATERIALS = create(key("gold_tool_materials"));

    /**
     * {@code #minecraft:hanging_signs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> HANGING_SIGNS = create(key("hanging_signs"));

    /**
     * {@code #minecraft:happy_ghast_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> HAPPY_GHAST_FOOD = create(key("happy_ghast_food"));

    /**
     * {@code #minecraft:happy_ghast_tempt_items}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> HAPPY_GHAST_TEMPT_ITEMS = create(key("happy_ghast_tempt_items"));

    /**
     * {@code #minecraft:harnesses}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> HARNESSES = create(key("harnesses"));

    /**
     * {@code #minecraft:head_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> HEAD_ARMOR = create(key("head_armor"));

    /**
     * {@code #minecraft:hoes}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> HOES = create(key("hoes"));

    /**
     * {@code #minecraft:hoglin_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> HOGLIN_FOOD = create(key("hoglin_food"));

    /**
     * {@code #minecraft:horse_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> HORSE_FOOD = create(key("horse_food"));

    /**
     * {@code #minecraft:horse_tempt_items}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> HORSE_TEMPT_ITEMS = create(key("horse_tempt_items"));

    /**
     * {@code #minecraft:ignored_by_piglin_babies}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> IGNORED_BY_PIGLIN_BABIES = create(key("ignored_by_piglin_babies"));

    /**
     * {@code #minecraft:iron_ores}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> IRON_ORES = create(key("iron_ores"));

    /**
     * {@code #minecraft:iron_tool_materials}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> IRON_TOOL_MATERIALS = create(key("iron_tool_materials"));

    /**
     * {@code #minecraft:jungle_logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> JUNGLE_LOGS = create(key("jungle_logs"));

    /**
     * {@code #minecraft:lapis_ores}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> LAPIS_ORES = create(key("lapis_ores"));

    /**
     * {@code #minecraft:leaves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> LEAVES = create(key("leaves"));

    /**
     * {@code #minecraft:lectern_books}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> LECTERN_BOOKS = create(key("lectern_books"));

    /**
     * {@code #minecraft:leg_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> LEG_ARMOR = create(key("leg_armor"));

    /**
     * {@code #minecraft:llama_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> LLAMA_FOOD = create(key("llama_food"));

    /**
     * {@code #minecraft:llama_tempt_items}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> LLAMA_TEMPT_ITEMS = create(key("llama_tempt_items"));

    /**
     * {@code #minecraft:logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> LOGS = create(key("logs"));

    /**
     * {@code #minecraft:logs_that_burn}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> LOGS_THAT_BURN = create(key("logs_that_burn"));

    /**
     * {@code #minecraft:mangrove_logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> MANGROVE_LOGS = create(key("mangrove_logs"));

    /**
     * {@code #minecraft:map_invisibility_equipment}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> MAP_INVISIBILITY_EQUIPMENT = create(key("map_invisibility_equipment"));

    /**
     * {@code #minecraft:meat}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> MEAT = create(key("meat"));

    /**
     * {@code #minecraft:netherite_tool_materials}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> NETHERITE_TOOL_MATERIALS = create(key("netherite_tool_materials"));

    /**
     * {@code #minecraft:non_flammable_wood}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> NON_FLAMMABLE_WOOD = create(key("non_flammable_wood"));

    /**
     * {@code #minecraft:noteblock_top_instruments}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> NOTEBLOCK_TOP_INSTRUMENTS = create(key("noteblock_top_instruments"));

    /**
     * {@code #minecraft:oak_logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> OAK_LOGS = create(key("oak_logs"));

    /**
     * {@code #minecraft:ocelot_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> OCELOT_FOOD = create(key("ocelot_food"));

    /**
     * {@code #minecraft:pale_oak_logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> PALE_OAK_LOGS = create(key("pale_oak_logs"));

    /**
     * {@code #minecraft:panda_eats_from_ground}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> PANDA_EATS_FROM_GROUND = create(key("panda_eats_from_ground"));

    /**
     * {@code #minecraft:panda_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> PANDA_FOOD = create(key("panda_food"));

    /**
     * {@code #minecraft:parrot_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> PARROT_FOOD = create(key("parrot_food"));

    /**
     * {@code #minecraft:parrot_poisonous_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> PARROT_POISONOUS_FOOD = create(key("parrot_poisonous_food"));

    /**
     * {@code #minecraft:pickaxes}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> PICKAXES = create(key("pickaxes"));

    /**
     * {@code #minecraft:pig_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> PIG_FOOD = create(key("pig_food"));

    /**
     * {@code #minecraft:piglin_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> PIGLIN_FOOD = create(key("piglin_food"));

    /**
     * {@code #minecraft:piglin_loved}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> PIGLIN_LOVED = create(key("piglin_loved"));

    /**
     * {@code #minecraft:piglin_preferred_weapons}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> PIGLIN_PREFERRED_WEAPONS = create(key("piglin_preferred_weapons"));

    /**
     * {@code #minecraft:piglin_repellents}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> PIGLIN_REPELLENTS = create(key("piglin_repellents"));

    /**
     * {@code #minecraft:piglin_safe_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> PIGLIN_SAFE_ARMOR = create(key("piglin_safe_armor"));

    /**
     * {@code #minecraft:pillager_preferred_weapons}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> PILLAGER_PREFERRED_WEAPONS = create(key("pillager_preferred_weapons"));

    /**
     * {@code #minecraft:planks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> PLANKS = create(key("planks"));

    /**
     * {@code #minecraft:rabbit_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> RABBIT_FOOD = create(key("rabbit_food"));

    /**
     * {@code #minecraft:rails}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> RAILS = create(key("rails"));

    /**
     * {@code #minecraft:redstone_ores}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> REDSTONE_ORES = create(key("redstone_ores"));

    /**
     * {@code #minecraft:repairs_chain_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> REPAIRS_CHAIN_ARMOR = create(key("repairs_chain_armor"));

    /**
     * {@code #minecraft:repairs_diamond_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> REPAIRS_DIAMOND_ARMOR = create(key("repairs_diamond_armor"));

    /**
     * {@code #minecraft:repairs_gold_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> REPAIRS_GOLD_ARMOR = create(key("repairs_gold_armor"));

    /**
     * {@code #minecraft:repairs_iron_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> REPAIRS_IRON_ARMOR = create(key("repairs_iron_armor"));

    /**
     * {@code #minecraft:repairs_leather_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> REPAIRS_LEATHER_ARMOR = create(key("repairs_leather_armor"));

    /**
     * {@code #minecraft:repairs_netherite_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> REPAIRS_NETHERITE_ARMOR = create(key("repairs_netherite_armor"));

    /**
     * {@code #minecraft:repairs_turtle_helmet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> REPAIRS_TURTLE_HELMET = create(key("repairs_turtle_helmet"));

    /**
     * {@code #minecraft:repairs_wolf_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> REPAIRS_WOLF_ARMOR = create(key("repairs_wolf_armor"));

    /**
     * {@code #minecraft:sand}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> SAND = create(key("sand"));

    /**
     * {@code #minecraft:saplings}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> SAPLINGS = create(key("saplings"));

    /**
     * {@code #minecraft:sheep_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> SHEEP_FOOD = create(key("sheep_food"));

    /**
     * {@code #minecraft:shovels}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> SHOVELS = create(key("shovels"));

    /**
     * {@code #minecraft:shulker_boxes}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> SHULKER_BOXES = create(key("shulker_boxes"));

    /**
     * {@code #minecraft:signs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> SIGNS = create(key("signs"));

    /**
     * {@code #minecraft:skeleton_preferred_weapons}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> SKELETON_PREFERRED_WEAPONS = create(key("skeleton_preferred_weapons"));

    /**
     * {@code #minecraft:skulls}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> SKULLS = create(key("skulls"));

    /**
     * {@code #minecraft:slabs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> SLABS = create(key("slabs"));

    /**
     * {@code #minecraft:small_flowers}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> SMALL_FLOWERS = create(key("small_flowers"));

    /**
     * {@code #minecraft:smelts_to_glass}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> SMELTS_TO_GLASS = create(key("smelts_to_glass"));

    /**
     * {@code #minecraft:sniffer_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> SNIFFER_FOOD = create(key("sniffer_food"));

    /**
     * {@code #minecraft:soul_fire_base_blocks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> SOUL_FIRE_BASE_BLOCKS = create(key("soul_fire_base_blocks"));

    /**
     * {@code #minecraft:spruce_logs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> SPRUCE_LOGS = create(key("spruce_logs"));

    /**
     * {@code #minecraft:stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> STAIRS = create(key("stairs"));

    /**
     * {@code #minecraft:stone_bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> STONE_BRICKS = create(key("stone_bricks"));

    /**
     * {@code #minecraft:stone_buttons}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> STONE_BUTTONS = create(key("stone_buttons"));

    /**
     * {@code #minecraft:stone_crafting_materials}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> STONE_CRAFTING_MATERIALS = create(key("stone_crafting_materials"));

    /**
     * {@code #minecraft:stone_tool_materials}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> STONE_TOOL_MATERIALS = create(key("stone_tool_materials"));

    /**
     * {@code #minecraft:strider_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> STRIDER_FOOD = create(key("strider_food"));

    /**
     * {@code #minecraft:strider_tempt_items}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> STRIDER_TEMPT_ITEMS = create(key("strider_tempt_items"));

    /**
     * {@code #minecraft:swords}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> SWORDS = create(key("swords"));

    /**
     * {@code #minecraft:terracotta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> TERRACOTTA = create(key("terracotta"));

    /**
     * {@code #minecraft:trapdoors}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> TRAPDOORS = create(key("trapdoors"));

    /**
     * {@code #minecraft:trim_materials}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> TRIM_MATERIALS = create(key("trim_materials"));

    /**
     * {@code #minecraft:trimmable_armor}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> TRIMMABLE_ARMOR = create(key("trimmable_armor"));

    /**
     * {@code #minecraft:turtle_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> TURTLE_FOOD = create(key("turtle_food"));

    /**
     * {@code #minecraft:villager_picks_up}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> VILLAGER_PICKS_UP = create(key("villager_picks_up"));

    /**
     * {@code #minecraft:villager_plantable_seeds}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> VILLAGER_PLANTABLE_SEEDS = create(key("villager_plantable_seeds"));

    /**
     * {@code #minecraft:walls}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> WALLS = create(key("walls"));

    /**
     * {@code #minecraft:warped_stems}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> WARPED_STEMS = create(key("warped_stems"));

    /**
     * {@code #minecraft:wart_blocks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> WART_BLOCKS = create(key("wart_blocks"));

    /**
     * {@code #minecraft:wither_skeleton_disliked_weapons}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> WITHER_SKELETON_DISLIKED_WEAPONS = create(key("wither_skeleton_disliked_weapons"));

    /**
     * {@code #minecraft:wolf_food}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> WOLF_FOOD = create(key("wolf_food"));

    /**
     * {@code #minecraft:wooden_buttons}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> WOODEN_BUTTONS = create(key("wooden_buttons"));

    /**
     * {@code #minecraft:wooden_doors}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> WOODEN_DOORS = create(key("wooden_doors"));

    /**
     * {@code #minecraft:wooden_fences}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> WOODEN_FENCES = create(key("wooden_fences"));

    /**
     * {@code #minecraft:wooden_pressure_plates}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> WOODEN_PRESSURE_PLATES = create(key("wooden_pressure_plates"));

    /**
     * {@code #minecraft:wooden_slabs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> WOODEN_SLABS = create(key("wooden_slabs"));

    /**
     * {@code #minecraft:wooden_stairs}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> WOODEN_STAIRS = create(key("wooden_stairs"));

    /**
     * {@code #minecraft:wooden_tool_materials}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> WOODEN_TOOL_MATERIALS = create(key("wooden_tool_materials"));

    /**
     * {@code #minecraft:wooden_trapdoors}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> WOODEN_TRAPDOORS = create(key("wooden_trapdoors"));

    /**
     * {@code #minecraft:wool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> WOOL = create(key("wool"));

    /**
     * {@code #minecraft:wool_carpets}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<ItemType> WOOL_CARPETS = create(key("wool_carpets"));

    private ItemTypeTagKeys() {
    }

    /**
     * Creates a tag key for {@link ItemType} in the registry {@code minecraft:item}.
     *
     * @param key the tag key's key
     * @return a new tag key
     */
    @ApiStatus.Experimental
    public static TagKey<ItemType> create(final Key key) {
        return TagKey.create(RegistryKey.ITEM, key);
    }
}
