package io.papermc.paper.registry.keys;

import static net.kyori.adventure.key.Key.key;

import io.papermc.paper.generated.GeneratedFrom;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import net.kyori.adventure.key.Key;
import org.bukkit.block.banner.PatternType;
import org.jspecify.annotations.NullMarked;

/**
 * Vanilla keys for {@link RegistryKey#BANNER_PATTERN}.
 *
 * @apiNote The fields provided here are a direct representation of
 * what is available from the vanilla game source. They may be
 * changed (including removals) on any Minecraft version
 * bump, so cross-version compatibility is not provided on the
 * same level as it is on most of the other API.
 */
@SuppressWarnings({
        "unused",
        "SpellCheckingInspection"
})
@NullMarked
@GeneratedFrom("1.21.6-pre2")
public final class BannerPatternKeys {
    /**
     * {@code minecraft:base}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> BASE = create(key("base"));

    /**
     * {@code minecraft:border}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> BORDER = create(key("border"));

    /**
     * {@code minecraft:bricks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> BRICKS = create(key("bricks"));

    /**
     * {@code minecraft:circle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> CIRCLE = create(key("circle"));

    /**
     * {@code minecraft:creeper}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> CREEPER = create(key("creeper"));

    /**
     * {@code minecraft:cross}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> CROSS = create(key("cross"));

    /**
     * {@code minecraft:curly_border}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> CURLY_BORDER = create(key("curly_border"));

    /**
     * {@code minecraft:diagonal_left}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> DIAGONAL_LEFT = create(key("diagonal_left"));

    /**
     * {@code minecraft:diagonal_right}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> DIAGONAL_RIGHT = create(key("diagonal_right"));

    /**
     * {@code minecraft:diagonal_up_left}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> DIAGONAL_UP_LEFT = create(key("diagonal_up_left"));

    /**
     * {@code minecraft:diagonal_up_right}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> DIAGONAL_UP_RIGHT = create(key("diagonal_up_right"));

    /**
     * {@code minecraft:flow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> FLOW = create(key("flow"));

    /**
     * {@code minecraft:flower}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> FLOWER = create(key("flower"));

    /**
     * {@code minecraft:globe}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> GLOBE = create(key("globe"));

    /**
     * {@code minecraft:gradient}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> GRADIENT = create(key("gradient"));

    /**
     * {@code minecraft:gradient_up}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> GRADIENT_UP = create(key("gradient_up"));

    /**
     * {@code minecraft:guster}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> GUSTER = create(key("guster"));

    /**
     * {@code minecraft:half_horizontal}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> HALF_HORIZONTAL = create(key("half_horizontal"));

    /**
     * {@code minecraft:half_horizontal_bottom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> HALF_HORIZONTAL_BOTTOM = create(key("half_horizontal_bottom"));

    /**
     * {@code minecraft:half_vertical}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> HALF_VERTICAL = create(key("half_vertical"));

    /**
     * {@code minecraft:half_vertical_right}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> HALF_VERTICAL_RIGHT = create(key("half_vertical_right"));

    /**
     * {@code minecraft:mojang}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> MOJANG = create(key("mojang"));

    /**
     * {@code minecraft:piglin}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> PIGLIN = create(key("piglin"));

    /**
     * {@code minecraft:rhombus}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> RHOMBUS = create(key("rhombus"));

    /**
     * {@code minecraft:skull}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> SKULL = create(key("skull"));

    /**
     * {@code minecraft:small_stripes}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> SMALL_STRIPES = create(key("small_stripes"));

    /**
     * {@code minecraft:square_bottom_left}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> SQUARE_BOTTOM_LEFT = create(key("square_bottom_left"));

    /**
     * {@code minecraft:square_bottom_right}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> SQUARE_BOTTOM_RIGHT = create(key("square_bottom_right"));

    /**
     * {@code minecraft:square_top_left}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> SQUARE_TOP_LEFT = create(key("square_top_left"));

    /**
     * {@code minecraft:square_top_right}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> SQUARE_TOP_RIGHT = create(key("square_top_right"));

    /**
     * {@code minecraft:straight_cross}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> STRAIGHT_CROSS = create(key("straight_cross"));

    /**
     * {@code minecraft:stripe_bottom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> STRIPE_BOTTOM = create(key("stripe_bottom"));

    /**
     * {@code minecraft:stripe_center}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> STRIPE_CENTER = create(key("stripe_center"));

    /**
     * {@code minecraft:stripe_downleft}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> STRIPE_DOWNLEFT = create(key("stripe_downleft"));

    /**
     * {@code minecraft:stripe_downright}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> STRIPE_DOWNRIGHT = create(key("stripe_downright"));

    /**
     * {@code minecraft:stripe_left}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> STRIPE_LEFT = create(key("stripe_left"));

    /**
     * {@code minecraft:stripe_middle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> STRIPE_MIDDLE = create(key("stripe_middle"));

    /**
     * {@code minecraft:stripe_right}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> STRIPE_RIGHT = create(key("stripe_right"));

    /**
     * {@code minecraft:stripe_top}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> STRIPE_TOP = create(key("stripe_top"));

    /**
     * {@code minecraft:triangle_bottom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> TRIANGLE_BOTTOM = create(key("triangle_bottom"));

    /**
     * {@code minecraft:triangle_top}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> TRIANGLE_TOP = create(key("triangle_top"));

    /**
     * {@code minecraft:triangles_bottom}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> TRIANGLES_BOTTOM = create(key("triangles_bottom"));

    /**
     * {@code minecraft:triangles_top}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<PatternType> TRIANGLES_TOP = create(key("triangles_top"));

    private BannerPatternKeys() {
    }

    /**
     * Creates a typed key for {@link PatternType} in the registry {@code minecraft:banner_pattern}.
     *
     * @param key the value's key in the registry
     * @return a new typed key
     */
    public static TypedKey<PatternType> create(final Key key) {
        return TypedKey.create(RegistryKey.BANNER_PATTERN, key);
    }
}
