package io.papermc.paper.registry.keys;

import static net.kyori.adventure.key.Key.key;

import io.papermc.paper.generated.GeneratedFrom;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import net.kyori.adventure.key.Key;
import org.bukkit.enchantments.Enchantment;
import org.jspecify.annotations.NullMarked;

/**
 * Vanilla keys for {@link RegistryKey#ENCHANTMENT}.
 *
 * @apiNote The fields provided here are a direct representation of
 * what is available from the vanilla game source. They may be
 * changed (including removals) on any Minecraft version
 * bump, so cross-version compatibility is not provided on the
 * same level as it is on most of the other API.
 */
@SuppressWarnings({
        "unused",
        "SpellCheckingInspection"
})
@NullMarked
@GeneratedFrom("1.21.5")
public final class EnchantmentKeys {
    /**
     * {@code minecraft:aqua_affinity}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> AQUA_AFFINITY = create(key("aqua_affinity"));

    /**
     * {@code minecraft:bane_of_arthropods}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> BANE_OF_ARTHROPODS = create(key("bane_of_arthropods"));

    /**
     * {@code minecraft:binding_curse}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> BINDING_CURSE = create(key("binding_curse"));

    /**
     * {@code minecraft:blast_protection}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> BLAST_PROTECTION = create(key("blast_protection"));

    /**
     * {@code minecraft:breach}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> BREACH = create(key("breach"));

    /**
     * {@code minecraft:channeling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> CHANNELING = create(key("channeling"));

    /**
     * {@code minecraft:density}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> DENSITY = create(key("density"));

    /**
     * {@code minecraft:depth_strider}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> DEPTH_STRIDER = create(key("depth_strider"));

    /**
     * {@code minecraft:efficiency}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> EFFICIENCY = create(key("efficiency"));

    /**
     * {@code minecraft:feather_falling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> FEATHER_FALLING = create(key("feather_falling"));

    /**
     * {@code minecraft:fire_aspect}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> FIRE_ASPECT = create(key("fire_aspect"));

    /**
     * {@code minecraft:fire_protection}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> FIRE_PROTECTION = create(key("fire_protection"));

    /**
     * {@code minecraft:flame}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> FLAME = create(key("flame"));

    /**
     * {@code minecraft:fortune}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> FORTUNE = create(key("fortune"));

    /**
     * {@code minecraft:frost_walker}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> FROST_WALKER = create(key("frost_walker"));

    /**
     * {@code minecraft:impaling}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> IMPALING = create(key("impaling"));

    /**
     * {@code minecraft:infinity}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> INFINITY = create(key("infinity"));

    /**
     * {@code minecraft:knockback}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> KNOCKBACK = create(key("knockback"));

    /**
     * {@code minecraft:looting}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> LOOTING = create(key("looting"));

    /**
     * {@code minecraft:loyalty}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> LOYALTY = create(key("loyalty"));

    /**
     * {@code minecraft:luck_of_the_sea}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> LUCK_OF_THE_SEA = create(key("luck_of_the_sea"));

    /**
     * {@code minecraft:lure}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> LURE = create(key("lure"));

    /**
     * {@code minecraft:mending}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> MENDING = create(key("mending"));

    /**
     * {@code minecraft:multishot}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> MULTISHOT = create(key("multishot"));

    /**
     * {@code minecraft:piercing}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> PIERCING = create(key("piercing"));

    /**
     * {@code minecraft:power}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> POWER = create(key("power"));

    /**
     * {@code minecraft:projectile_protection}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> PROJECTILE_PROTECTION = create(key("projectile_protection"));

    /**
     * {@code minecraft:protection}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> PROTECTION = create(key("protection"));

    /**
     * {@code minecraft:punch}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> PUNCH = create(key("punch"));

    /**
     * {@code minecraft:quick_charge}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> QUICK_CHARGE = create(key("quick_charge"));

    /**
     * {@code minecraft:respiration}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> RESPIRATION = create(key("respiration"));

    /**
     * {@code minecraft:riptide}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> RIPTIDE = create(key("riptide"));

    /**
     * {@code minecraft:sharpness}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> SHARPNESS = create(key("sharpness"));

    /**
     * {@code minecraft:silk_touch}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> SILK_TOUCH = create(key("silk_touch"));

    /**
     * {@code minecraft:smite}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> SMITE = create(key("smite"));

    /**
     * {@code minecraft:soul_speed}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> SOUL_SPEED = create(key("soul_speed"));

    /**
     * {@code minecraft:sweeping_edge}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> SWEEPING_EDGE = create(key("sweeping_edge"));

    /**
     * {@code minecraft:swift_sneak}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> SWIFT_SNEAK = create(key("swift_sneak"));

    /**
     * {@code minecraft:thorns}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> THORNS = create(key("thorns"));

    /**
     * {@code minecraft:unbreaking}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> UNBREAKING = create(key("unbreaking"));

    /**
     * {@code minecraft:vanishing_curse}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> VANISHING_CURSE = create(key("vanishing_curse"));

    /**
     * {@code minecraft:wind_burst}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Enchantment> WIND_BURST = create(key("wind_burst"));

    private EnchantmentKeys() {
    }

    /**
     * Creates a typed key for {@link Enchantment} in the registry {@code minecraft:enchantment}.
     *
     * @param key the value's key in the registry
     * @return a new typed key
     */
    public static TypedKey<Enchantment> create(final Key key) {
        return TypedKey.create(RegistryKey.ENCHANTMENT, key);
    }
}
