/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.tag.Tag;
import io.papermc.paper.registry.tag.TagKey;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.kyori.adventure.key.Key;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Fluid;
import org.bukkit.GameEvent;
import org.bukkit.JukeboxSong;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.advancement.Advancement;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockType;
import org.bukkit.block.banner.PatternType;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Cat;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructureType;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.loot.LootTables;
import org.bukkit.map.MapCursor;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface Registry<T extends Keyed>
extends Iterable<T> {
    @Deprecated(since="1.21.4", forRemoval=true)
    public static final Registry<Advancement> ADVANCEMENT = new NotARegistry<Advancement>(){

        @Override
        public @Nullable Advancement get(NamespacedKey key) {
            return Bukkit.getAdvancement(key);
        }

        @Override
        public Iterator<Advancement> iterator() {
            return Bukkit.advancementIterator();
        }
    };
    @Deprecated(since="1.21.3")
    public static final Registry<Art> ART = Registry.legacyRegistryFor(Art.class);
    public static final Registry<Attribute> ATTRIBUTE = Registry.registryFor(RegistryKey.ATTRIBUTE);
    @Deprecated(since="1.21")
    public static final Registry<PatternType> BANNER_PATTERN = Registry.legacyRegistryFor(PatternType.class);
    @Deprecated(since="1.21.3")
    public static final Registry<Biome> BIOME = Registry.legacyRegistryFor(Biome.class);
    @ApiStatus.Experimental
    public static final Registry<BlockType> BLOCK = Registry.registryFor(RegistryKey.BLOCK);
    @Deprecated(since="1.21.4", forRemoval=true)
    public static final Registry<KeyedBossBar> BOSS_BARS = new NotARegistry<KeyedBossBar>(){

        @Override
        public @Nullable KeyedBossBar get(NamespacedKey key) {
            return Bukkit.getBossBar(key);
        }

        @Override
        public Iterator<KeyedBossBar> iterator() {
            return Bukkit.getBossBars();
        }
    };
    @Deprecated(since="1.21.5")
    public static final Registry<Cat.Type> CAT_VARIANT = Registry.legacyRegistryFor(Cat.Type.class);
    @Deprecated(since="1.21")
    public static final Registry<Enchantment> ENCHANTMENT = Registry.legacyRegistryFor(Enchantment.class);
    public static final Registry<EntityType> ENTITY_TYPE = Registry.registryFor(RegistryKey.ENTITY_TYPE);
    @Deprecated(since="1.21.2")
    public static final Registry<MusicInstrument> INSTRUMENT = Registry.legacyRegistryFor(MusicInstrument.class);
    @ApiStatus.Experimental
    public static final Registry<ItemType> ITEM = Registry.registryFor(RegistryKey.ITEM);
    public static final Registry<LootTables> LOOT_TABLES = new SimpleRegistry<LootTables>(LootTables.class);
    public static final Registry<Material> MATERIAL = new SimpleRegistry<Material>(Material.class, mat -> !mat.isLegacy());
    @ApiStatus.Experimental
    public static final Registry<MenuType> MENU = Registry.registryFor(RegistryKey.MENU);
    public static final Registry<PotionEffectType> MOB_EFFECT = Registry.registryFor(RegistryKey.MOB_EFFECT);
    public static final Registry<Particle> PARTICLE_TYPE = Registry.registryFor(RegistryKey.PARTICLE_TYPE);
    public static final Registry<PotionType> POTION = Registry.registryFor(RegistryKey.POTION);
    public static final Registry<Statistic> STATISTIC = new SimpleRegistry<Statistic>(Statistic.class);
    @Deprecated(since="1.20.6")
    public static final Registry<Structure> STRUCTURE = Registry.legacyRegistryFor(Structure.class);
    public static final Registry<StructureType> STRUCTURE_TYPE = Registry.registryFor(RegistryKey.STRUCTURE_TYPE);
    public static final Registry<Sound> SOUND_EVENT = Registry.registryFor(RegistryKey.SOUND_EVENT);
    @Deprecated(since="1.20.6")
    public static final Registry<TrimMaterial> TRIM_MATERIAL = Registry.legacyRegistryFor(TrimMaterial.class);
    @Deprecated(since="1.20.6")
    public static final Registry<TrimPattern> TRIM_PATTERN = Registry.legacyRegistryFor(TrimPattern.class);
    @Deprecated(since="1.20.6")
    public static final Registry<DamageType> DAMAGE_TYPE = Registry.legacyRegistryFor(DamageType.class);
    @Deprecated(since="1.21")
    public static final Registry<JukeboxSong> JUKEBOX_SONG = Registry.legacyRegistryFor(JukeboxSong.class);
    public static final Registry<Villager.Profession> VILLAGER_PROFESSION = Registry.registryFor(RegistryKey.VILLAGER_PROFESSION);
    public static final Registry<Villager.Type> VILLAGER_TYPE = Registry.registryFor(RegistryKey.VILLAGER_TYPE);
    public static final Registry<MemoryKey<?>> MEMORY_MODULE_TYPE = new NotARegistry<MemoryKey<?>>(){

        @Override
        public Iterator<MemoryKey<?>> iterator() {
            return MemoryKey.values().iterator();
        }

        @Override
        public int size() {
            return MemoryKey.values().size();
        }

        @Override
        public @Nullable MemoryKey<?> get(NamespacedKey key) {
            return MemoryKey.getByKey(key);
        }
    };
    public static final Registry<Fluid> FLUID = Registry.registryFor(RegistryKey.FLUID);
    @Deprecated(since="1.21.5")
    public static final Registry<Frog.Variant> FROG_VARIANT = Registry.legacyRegistryFor(Frog.Variant.class);
    @Deprecated(since="1.20.6")
    public static final Registry<Wolf.Variant> WOLF_VARIANT = Registry.legacyRegistryFor(Wolf.Variant.class);
    public static final Registry<MapCursor.Type> MAP_DECORATION_TYPE = Registry.registryFor(RegistryKey.MAP_DECORATION_TYPE);
    public static final Registry<GameEvent> GAME_EVENT = Registry.registryFor(RegistryKey.GAME_EVENT);
    public static final Registry<DataComponentType> DATA_COMPONENT_TYPE = Registry.registryFor(RegistryKey.DATA_COMPONENT_TYPE);
    @ApiStatus.Obsolete(since="1.21.4")
    public static final Registry<PotionEffectType> EFFECT = MOB_EFFECT;
    @ApiStatus.Obsolete(since="1.21.4")
    public static final Registry<PotionEffectType> POTION_EFFECT_TYPE = EFFECT;
    @ApiStatus.Obsolete(since="1.21.4")
    public static final Registry<Sound> SOUNDS = Registry.registryFor(RegistryKey.SOUND_EVENT);

    private static <A extends Keyed> Registry<A> registryFor(RegistryKey<A> registryKey) {
        return RegistryAccess.registryAccess().getRegistry(registryKey);
    }

    @Deprecated(forRemoval=true, since="1.21.4")
    private static <A extends Keyed> Registry<A> legacyRegistryFor(Class<A> clazz) {
        return Objects.requireNonNull(RegistryAccess.registryAccess().getRegistry(clazz), () -> "No registry present for " + clazz.getSimpleName() + ". This is a bug.");
    }

    public @Nullable T get(NamespacedKey var1);

    default public @Nullable T get(Key key) {
        T t;
        if (key instanceof NamespacedKey) {
            NamespacedKey nsKey = (NamespacedKey)key;
            t = this.get(nsKey);
        } else {
            t = this.get(new NamespacedKey(key.namespace(), key.value()));
        }
        return t;
    }

    default public @Nullable T get(TypedKey<T> typedKey) {
        Preconditions.checkArgument((typedKey != null ? 1 : 0) != 0, (Object)"typedKey cannot be null");
        return this.get(typedKey.key());
    }

    default public T getOrThrow(Key key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key cannot be null");
        T value = this.get(key);
        if (value == null) {
            throw new NoSuchElementException("No value for " + String.valueOf(key) + " in " + String.valueOf(this));
        }
        return value;
    }

    default public T getOrThrow(TypedKey<T> key) {
        T value = this.get(key);
        if (value == null) {
            throw new NoSuchElementException("No value for " + String.valueOf(key) + " in " + String.valueOf(this));
        }
        return value;
    }

    default public NamespacedKey getKeyOrThrow(T value) {
        NamespacedKey key = this.getKey(value);
        if (key == null) {
            throw new NoSuchElementException(String.valueOf(value) + " has no key in " + String.valueOf(this));
        }
        return key;
    }

    public @Nullable NamespacedKey getKey(T var1);

    @ApiStatus.Experimental
    public boolean hasTag(TagKey<T> var1);

    @ApiStatus.Experimental
    public Tag<T> getTag(TagKey<T> var1);

    @ApiStatus.Experimental
    default public Collection<T> getTagValues(TagKey<T> key) {
        Tag<T> tag = this.getTag(key);
        return tag.resolve(this);
    }

    @ApiStatus.Experimental
    public Collection<Tag<T>> getTags();

    default public T getOrThrow(NamespacedKey key) {
        return this.getOrThrow((Key)key);
    }

    public Stream<T> stream();

    public Stream<NamespacedKey> keyStream();

    @Deprecated(forRemoval=true)
    default public @Nullable T match(String input) {
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"input must not be null");
        String filtered = input.toLowerCase(Locale.ROOT).replaceAll("\\s+", "_");
        NamespacedKey namespacedKey = NamespacedKey.fromString(filtered);
        return namespacedKey != null ? (T)this.get(namespacedKey) : null;
    }

    public int size();

    @ApiStatus.Internal
    public static class SimpleRegistry<T extends Enum<T>>
    extends NotARegistry<T> {
        private final Class<T> type;
        private final Map<NamespacedKey, T> map;

        protected SimpleRegistry(Class<T> type) {
            this(type, (Predicate<T>)Predicates.alwaysTrue());
        }

        protected SimpleRegistry(Class<T> type, Predicate<T> predicate) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Enum entry : (Enum[])type.getEnumConstants()) {
                if (!predicate.test(entry)) continue;
                builder.put((Object)((Keyed)((Object)entry)).getKey(), (Object)entry);
            }
            this.map = builder.build();
            this.type = type;
        }

        @Override
        public @Nullable T get(NamespacedKey key) {
            return (T)((Enum)this.map.get(key));
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Iterator<T> iterator() {
            return this.map.values().iterator();
        }

        @Override
        public Stream<NamespacedKey> keyStream() {
            return this.map.keySet().stream();
        }

        @Deprecated(since="1.20.6", forRemoval=true)
        @ApiStatus.Internal
        public Class<T> getType() {
            return this.type;
        }
    }

    @ApiStatus.Internal
    public static abstract class NotARegistry<A extends Keyed>
    implements Registry<A> {
        @Override
        public Stream<A> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        public Stream<NamespacedKey> keyStream() {
            return this.stream().map(this::getKey);
        }

        @Override
        public int size() {
            return Iterables.size((Iterable)this);
        }

        @Override
        public NamespacedKey getKey(A value) {
            return value.getKey();
        }

        @Override
        public boolean hasTag(TagKey<A> key) {
            throw new UnsupportedOperationException("This is not a real registry and therefore cannot support tags");
        }

        @Override
        public Tag<A> getTag(TagKey<A> key) {
            throw new UnsupportedOperationException("This is not a real registry and therefore cannot support tags");
        }

        @Override
        public Collection<Tag<A>> getTags() {
            throw new UnsupportedOperationException("This is not a real registry and therefore cannot support tags");
        }
    }
}

