/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.block;

import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.BlockEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class BlockFromToEvent
extends BlockEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    protected Block to;
    protected BlockFace face;
    protected boolean cancelled;

    @ApiStatus.Internal
    public BlockFromToEvent(@NotNull Block block, @NotNull BlockFace face) {
        super(block);
        this.face = face;
    }

    @ApiStatus.Internal
    public BlockFromToEvent(@NotNull Block block, @NotNull Block toBlock) {
        this(block, BlockFace.SELF);
        this.to = toBlock;
    }

    @NotNull
    public BlockFace getFace() {
        return this.face;
    }

    @NotNull
    public Block getToBlock() {
        if (this.to == null) {
            this.to = this.block.getRelative(this.face);
        }
        return this.to;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

