/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.player;

import io.papermc.paper.entity.TeleportFlag;
import java.util.Collections;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerMoveEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class PlayerTeleportEvent
extends PlayerMoveEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Set<TeleportFlag.Relative> teleportFlags;
    private TeleportCause cause = TeleportCause.UNKNOWN;

    @ApiStatus.Internal
    public PlayerTeleportEvent(@NotNull Player player, @NotNull Location from, @Nullable Location to) {
        super(player, from, to);
        this.teleportFlags = Collections.emptySet();
    }

    @ApiStatus.Internal
    public PlayerTeleportEvent(@NotNull Player player, @NotNull Location from, @Nullable Location to, @NotNull TeleportCause cause) {
        this(player, from, to);
        this.cause = cause;
    }

    @ApiStatus.Internal
    public PlayerTeleportEvent(@NotNull Player player, @NotNull Location from, @Nullable Location to, @NotNull TeleportCause cause, @NotNull Set<TeleportFlag.Relative> teleportFlags) {
        super(player, from, to);
        this.cause = cause;
        this.teleportFlags = teleportFlags;
    }

    @NotNull
    public TeleportCause getCause() {
        return this.cause;
    }

    @NotNull
    public @Unmodifiable Set<TeleportFlag.Relative> getRelativeTeleportationFlags() {
        return this.teleportFlags;
    }

    @Deprecated(forRemoval=true)
    @Contract(value="-> true")
    public boolean willDismountPlayer() {
        return true;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public static enum TeleportCause {
        ENDER_PEARL,
        COMMAND,
        PLUGIN,
        NETHER_PORTAL,
        END_PORTAL,
        SPECTATE,
        END_GATEWAY,
        CHORUS_FRUIT,
        DISMOUNT,
        EXIT_BED,
        UNKNOWN;

    }
}

