/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.destroystokyo.paper.profile.PlayerProfile;
import io.papermc.paper.persistence.PersistentDataContainerView;
import io.papermc.paper.persistence.PersistentDataViewHolder;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.permissions.ServerOperator;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface OfflinePlayer
extends ServerOperator,
AnimalTamer,
ConfigurationSerializable,
PersistentDataViewHolder {
    public boolean isOnline();

    public boolean isConnected();

    @Override
    public @Nullable String getName();

    @Override
    public UUID getUniqueId();

    public PlayerProfile getPlayerProfile();

    public boolean isBanned();

    @Deprecated(since="1.20.4")
    default public BanEntry banPlayer(@Nullable String reason) {
        return this.banPlayer(reason, null, null);
    }

    @Deprecated(since="1.20.4")
    default public BanEntry banPlayer(@Nullable String reason, @Nullable String source) {
        return this.banPlayer(reason, null, source);
    }

    @Deprecated(since="1.20.4")
    default public BanEntry banPlayer(@Nullable String reason, @Nullable Date expires) {
        return this.banPlayer(reason, expires, null);
    }

    @Deprecated(since="1.20.4")
    default public BanEntry banPlayer(@Nullable String reason, @Nullable Date expires, @Nullable String source) {
        return this.banPlayer(reason, expires, source, true);
    }

    @Deprecated(since="1.20.4")
    default public BanEntry banPlayer(@Nullable String reason, @Nullable Date expires, @Nullable String source, boolean kickIfOnline) {
        BanEntry<String> banEntry = Bukkit.getServer().getBanList(BanList.Type.NAME).addBan((String)this.getName(), reason, expires, source);
        if (kickIfOnline && this.isOnline()) {
            this.getPlayer().kickPlayer(reason);
        }
        return banEntry;
    }

    public <E extends BanEntry<? super PlayerProfile>> @Nullable E ban(@Nullable String var1, @Nullable Date var2, @Nullable String var3);

    public <E extends BanEntry<? super PlayerProfile>> @Nullable E ban(@Nullable String var1, @Nullable Instant var2, @Nullable String var3);

    public <E extends BanEntry<? super PlayerProfile>> @Nullable E ban(@Nullable String var1, @Nullable Duration var2, @Nullable String var3);

    public boolean isWhitelisted();

    public void setWhitelisted(boolean var1);

    public @Nullable Player getPlayer();

    public long getFirstPlayed();

    @Deprecated
    public long getLastPlayed();

    public boolean hasPlayedBefore();

    @Deprecated(since="1.20.4")
    default public @Nullable Location getBedSpawnLocation() {
        return this.getRespawnLocation();
    }

    public long getLastLogin();

    public long getLastSeen();

    default public @Nullable Location getRespawnLocation() {
        return this.getRespawnLocation(false);
    }

    public @Nullable Location getRespawnLocation(boolean var1);

    public void incrementStatistic(Statistic var1) throws IllegalArgumentException;

    public void decrementStatistic(Statistic var1) throws IllegalArgumentException;

    public void incrementStatistic(Statistic var1, int var2) throws IllegalArgumentException;

    public void decrementStatistic(Statistic var1, int var2) throws IllegalArgumentException;

    public void setStatistic(Statistic var1, int var2) throws IllegalArgumentException;

    public int getStatistic(Statistic var1) throws IllegalArgumentException;

    public void incrementStatistic(Statistic var1, Material var2) throws IllegalArgumentException;

    public void decrementStatistic(Statistic var1, Material var2) throws IllegalArgumentException;

    public int getStatistic(Statistic var1, Material var2) throws IllegalArgumentException;

    public void incrementStatistic(Statistic var1, Material var2, int var3) throws IllegalArgumentException;

    public void decrementStatistic(Statistic var1, Material var2, int var3) throws IllegalArgumentException;

    public void setStatistic(Statistic var1, Material var2, int var3) throws IllegalArgumentException;

    public void incrementStatistic(Statistic var1, EntityType var2) throws IllegalArgumentException;

    public void decrementStatistic(Statistic var1, EntityType var2) throws IllegalArgumentException;

    public int getStatistic(Statistic var1, EntityType var2) throws IllegalArgumentException;

    public void incrementStatistic(Statistic var1, EntityType var2, int var3) throws IllegalArgumentException;

    public void decrementStatistic(Statistic var1, EntityType var2, int var3);

    public void setStatistic(Statistic var1, EntityType var2, int var3);

    public @Nullable Location getLastDeathLocation();

    public @Nullable Location getLocation();

    @Override
    public PersistentDataContainerView getPersistentDataContainer();
}

