/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.enchantment;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class EnchantItemEvent
extends InventoryEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Player enchanter;
    private final Block table;
    private ItemStack item;
    private int level;
    private final Map<Enchantment, Integer> enchants;
    private final Enchantment enchantmentHint;
    private final int levelHint;
    private final int button;
    private boolean cancelled;

    @ApiStatus.Internal
    public EnchantItemEvent(@NotNull Player enchanter, @NotNull InventoryView view, @NotNull Block table, @NotNull ItemStack item, int level, @NotNull Map<Enchantment, Integer> enchants, @NotNull Enchantment enchantmentHint, int levelHint, int button) {
        super(view);
        this.enchanter = enchanter;
        this.table = table;
        this.item = item;
        this.level = level;
        this.enchants = new HashMap<Enchantment, Integer>(enchants);
        this.enchantmentHint = enchantmentHint;
        this.levelHint = levelHint;
        this.button = button;
    }

    @NotNull
    public Player getEnchanter() {
        return this.enchanter;
    }

    @NotNull
    public Block getEnchantBlock() {
        return this.table;
    }

    @NotNull
    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(@NotNull ItemStack item) {
        this.item = item;
    }

    public int getExpLevelCost() {
        return this.level;
    }

    public void setExpLevelCost(int level) {
        Preconditions.checkArgument((level > 0 ? 1 : 0) != 0, (Object)"The cost must be greater than 0!");
        this.level = level;
    }

    @NotNull
    public Map<Enchantment, Integer> getEnchantsToAdd() {
        return this.enchants;
    }

    @NotNull
    public Enchantment getEnchantmentHint() {
        return this.enchantmentHint;
    }

    public int getLevelHint() {
        return this.levelHint;
    }

    public int whichButton() {
        return this.button;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

