/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.player;

import com.google.common.base.Preconditions;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PlayerPickItemEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private int targetSlot;
    private int sourceSlot;
    private boolean cancelled;

    @ApiStatus.Internal
    public PlayerPickItemEvent(Player player, int targetSlot, int sourceSlot) {
        super(player);
        this.targetSlot = targetSlot;
        this.sourceSlot = sourceSlot;
    }

    public @Range(from=0L, to=8L) int getTargetSlot() {
        return this.targetSlot;
    }

    public void setTargetSlot(@Range(from=0L, to=8L) int targetSlot) {
        Preconditions.checkArgument((targetSlot >= 0 && targetSlot <= 8 ? 1 : 0) != 0, (Object)"Target slot must be in range 0 - 8 (inclusive)");
        this.targetSlot = targetSlot;
    }

    public @Range(from=-1L, to=35L) int getSourceSlot() {
        return this.sourceSlot;
    }

    public void setSourceSlot(@Range(from=-1L, to=35L) int sourceSlot) {
        Preconditions.checkArgument((sourceSlot >= -1 && sourceSlot <= 35 ? 1 : 0) != 0, (Object)"Source slot must be in range of the player's inventory slot, or -1");
        this.sourceSlot = sourceSlot;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

