/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.player;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class PlayerRespawnEvent
extends PlayerEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final boolean isBedSpawn;
    private final boolean isAnchorSpawn;
    private final boolean missingRespawnBlock;
    private final RespawnReason respawnReason;
    private final Set<RespawnFlag> respawnFlags;
    private Location respawnLocation;

    @Deprecated(since="1.16.1", forRemoval=true)
    @ApiStatus.Internal
    public PlayerRespawnEvent(@NotNull Player respawnPlayer, @NotNull Location respawnLocation, boolean isBedSpawn) {
        this(respawnPlayer, respawnLocation, isBedSpawn, false);
    }

    @Deprecated(since="1.19.4", forRemoval=true)
    @ApiStatus.Internal
    public PlayerRespawnEvent(@NotNull Player respawnPlayer, @NotNull Location respawnLocation, boolean isBedSpawn, boolean isAnchorSpawn) {
        this(respawnPlayer, respawnLocation, isBedSpawn, isAnchorSpawn, RespawnReason.PLUGIN);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public PlayerRespawnEvent(@NotNull Player respawnPlayer, @NotNull Location respawnLocation, boolean isBedSpawn, boolean isAnchorSpawn, @NotNull RespawnReason respawnReason) {
        this(respawnPlayer, respawnLocation, isBedSpawn, isAnchorSpawn, false, respawnReason, (ImmutableSet.Builder<RespawnFlag>)ImmutableSet.builder());
    }

    @ApiStatus.Internal
    public PlayerRespawnEvent(@NotNull Player respawnPlayer, @NotNull Location respawnLocation, boolean isBedSpawn, boolean isAnchorSpawn, boolean missingRespawnBlock, @NotNull RespawnReason respawnReason, @NotNull ImmutableSet.Builder<RespawnFlag> respawnFlags) {
        super(respawnPlayer);
        this.respawnLocation = respawnLocation;
        this.isBedSpawn = isBedSpawn;
        this.isAnchorSpawn = isAnchorSpawn;
        this.respawnReason = respawnReason;
        this.missingRespawnBlock = missingRespawnBlock;
        if (this.isBedSpawn) {
            respawnFlags.add((Object)RespawnFlag.BED_SPAWN);
        }
        if (this.isAnchorSpawn) {
            respawnFlags.add((Object)RespawnFlag.ANCHOR_SPAWN);
        }
        this.respawnFlags = respawnFlags.build();
    }

    @NotNull
    public Location getRespawnLocation() {
        return this.respawnLocation;
    }

    public void setRespawnLocation(@NotNull Location respawnLocation) {
        Preconditions.checkArgument((respawnLocation != null ? 1 : 0) != 0, (Object)"Respawn location can not be null");
        Preconditions.checkArgument((respawnLocation.getWorld() != null ? 1 : 0) != 0, (Object)"Respawn world can not be null");
        this.respawnLocation = respawnLocation.clone();
    }

    public boolean isBedSpawn() {
        return this.isBedSpawn;
    }

    public boolean isAnchorSpawn() {
        return this.isAnchorSpawn;
    }

    public boolean isMissingRespawnBlock() {
        return this.missingRespawnBlock;
    }

    @NotNull
    public RespawnReason getRespawnReason() {
        return this.respawnReason;
    }

    @NotNull
    public @Unmodifiable Set<RespawnFlag> getRespawnFlags() {
        return this.respawnFlags;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public static enum RespawnReason {
        DEATH,
        END_PORTAL,
        PLUGIN;

    }

    public static enum RespawnFlag {
        BED_SPAWN,
        ANCHOR_SPAWN,
        END_PORTAL;

    }
}

