/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.jar.Manifest;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@ApiStatus.Internal
public final class JarManifests {
    private static final Map<ClassLoader, Manifest> MANIFESTS = Collections.synchronizedMap(new WeakHashMap());

    private JarManifests() {
    }

    public static @Nullable Manifest manifest(Class<?> clazz) {
        return MANIFESTS.computeIfAbsent(clazz.getClassLoader(), classLoader -> {
            Manifest manifest;
            block9: {
                String classLocation = "/" + clazz.getName().replace(".", "/") + ".class";
                URL resource = clazz.getResource(classLocation);
                if (resource == null) {
                    return null;
                }
                String classFilePath = resource.toString().replace("\\", "/");
                String archivePath = classFilePath.substring(0, classFilePath.length() - classLocation.length());
                InputStream stream = new URL(archivePath + "/META-INF/MANIFEST.MF").openStream();
                try {
                    manifest = new Manifest(stream);
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        return null;
                    }
                }
                stream.close();
            }
            return manifest;
        });
    }
}

