/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.inventory;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.bukkit.event.HandlerList;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryDragEvent
extends InventoryInteractEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final DragType type;
    private final Map<Integer, ItemStack> addedItems;
    private final Set<Integer> containerSlots;
    private final ItemStack oldCursor;
    private ItemStack newCursor;

    @ApiStatus.Internal
    public InventoryDragEvent(@NotNull InventoryView view, @Nullable ItemStack newCursor, @NotNull ItemStack oldCursor, boolean right, @NotNull Map<Integer, ItemStack> slots) {
        super(view);
        this.type = right ? DragType.SINGLE : DragType.EVEN;
        this.newCursor = newCursor;
        this.oldCursor = oldCursor;
        this.addedItems = slots;
        ImmutableSet.Builder b = ImmutableSet.builder();
        for (Integer slot : slots.keySet()) {
            b.add((Object)view.convertSlot(slot));
        }
        this.containerSlots = b.build();
    }

    @NotNull
    public DragType getType() {
        return this.type;
    }

    @Nullable
    public ItemStack getCursor() {
        return this.newCursor;
    }

    public void setCursor(@Nullable ItemStack newCursor) {
        this.newCursor = newCursor;
    }

    @NotNull
    public ItemStack getOldCursor() {
        return this.oldCursor.clone();
    }

    @NotNull
    public Map<Integer, ItemStack> getNewItems() {
        return Collections.unmodifiableMap(this.addedItems);
    }

    @NotNull
    public Set<Integer> getRawSlots() {
        return this.addedItems.keySet();
    }

    @NotNull
    public Set<Integer> getInventorySlots() {
        return this.containerSlots;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

