/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.entity;

import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class EntityExhaustionEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final ExhaustionReason exhaustionReason;
    private float exhaustion;
    private boolean cancelled;

    @ApiStatus.Internal
    public EntityExhaustionEvent(@NotNull HumanEntity human, @NotNull ExhaustionReason exhaustionReason, float exhaustion) {
        super(human);
        this.exhaustionReason = exhaustionReason;
        this.exhaustion = exhaustion;
    }

    @Override
    @NotNull
    public HumanEntity getEntity() {
        return (HumanEntity)this.entity;
    }

    @NotNull
    public ExhaustionReason getExhaustionReason() {
        return this.exhaustionReason;
    }

    public float getExhaustion() {
        return this.exhaustion;
    }

    public void setExhaustion(float exhaustion) {
        this.exhaustion = exhaustion;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public static enum ExhaustionReason {
        BLOCK_MINED,
        HUNGER_EFFECT,
        DAMAGED,
        ATTACK,
        JUMP_SPRINT,
        JUMP,
        SWIM,
        WALK_UNDERWATER,
        WALK_ON_WATER,
        SPRINT,
        CROUCH,
        WALK,
        REGEN,
        UNKNOWN;

    }
}

