package io.papermc.paper.registry.keys;

import static net.kyori.adventure.key.Key.key;

import io.papermc.paper.annotation.GeneratedClass;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import net.kyori.adventure.key.Key;
import org.bukkit.Art;
import org.jspecify.annotations.NullMarked;

/**
 * Vanilla keys for {@link RegistryKey#PAINTING_VARIANT}.
 *
 * @apiNote The fields provided here are a direct representation of
 * what is available from the vanilla game source. They may be
 * changed (including removals) on any Minecraft version
 * bump, so cross-version compatibility is not provided on the
 * same level as it is on most of the other API.
 */
@SuppressWarnings({
        "unused",
        "SpellCheckingInspection"
})
@NullMarked
@GeneratedClass
public final class PaintingVariantKeys {
    /**
     * {@code minecraft:alban}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> ALBAN = create(key("alban"));

    /**
     * {@code minecraft:aztec}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> AZTEC = create(key("aztec"));

    /**
     * {@code minecraft:aztec2}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> AZTEC2 = create(key("aztec2"));

    /**
     * {@code minecraft:backyard}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> BACKYARD = create(key("backyard"));

    /**
     * {@code minecraft:baroque}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> BAROQUE = create(key("baroque"));

    /**
     * {@code minecraft:bomb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> BOMB = create(key("bomb"));

    /**
     * {@code minecraft:bouquet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> BOUQUET = create(key("bouquet"));

    /**
     * {@code minecraft:burning_skull}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> BURNING_SKULL = create(key("burning_skull"));

    /**
     * {@code minecraft:bust}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> BUST = create(key("bust"));

    /**
     * {@code minecraft:cavebird}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> CAVEBIRD = create(key("cavebird"));

    /**
     * {@code minecraft:changing}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> CHANGING = create(key("changing"));

    /**
     * {@code minecraft:cotan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> COTAN = create(key("cotan"));

    /**
     * {@code minecraft:courbet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> COURBET = create(key("courbet"));

    /**
     * {@code minecraft:creebet}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> CREEBET = create(key("creebet"));

    /**
     * {@code minecraft:dennis}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> DENNIS = create(key("dennis"));

    /**
     * {@code minecraft:donkey_kong}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> DONKEY_KONG = create(key("donkey_kong"));

    /**
     * {@code minecraft:earth}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> EARTH = create(key("earth"));

    /**
     * {@code minecraft:endboss}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> ENDBOSS = create(key("endboss"));

    /**
     * {@code minecraft:fern}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> FERN = create(key("fern"));

    /**
     * {@code minecraft:fighters}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> FIGHTERS = create(key("fighters"));

    /**
     * {@code minecraft:finding}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> FINDING = create(key("finding"));

    /**
     * {@code minecraft:fire}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> FIRE = create(key("fire"));

    /**
     * {@code minecraft:graham}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> GRAHAM = create(key("graham"));

    /**
     * {@code minecraft:humble}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> HUMBLE = create(key("humble"));

    /**
     * {@code minecraft:kebab}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> KEBAB = create(key("kebab"));

    /**
     * {@code minecraft:lowmist}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> LOWMIST = create(key("lowmist"));

    /**
     * {@code minecraft:match}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> MATCH = create(key("match"));

    /**
     * {@code minecraft:meditative}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> MEDITATIVE = create(key("meditative"));

    /**
     * {@code minecraft:orb}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> ORB = create(key("orb"));

    /**
     * {@code minecraft:owlemons}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> OWLEMONS = create(key("owlemons"));

    /**
     * {@code minecraft:passage}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> PASSAGE = create(key("passage"));

    /**
     * {@code minecraft:pigscene}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> PIGSCENE = create(key("pigscene"));

    /**
     * {@code minecraft:plant}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> PLANT = create(key("plant"));

    /**
     * {@code minecraft:pointer}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> POINTER = create(key("pointer"));

    /**
     * {@code minecraft:pond}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> POND = create(key("pond"));

    /**
     * {@code minecraft:pool}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> POOL = create(key("pool"));

    /**
     * {@code minecraft:prairie_ride}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> PRAIRIE_RIDE = create(key("prairie_ride"));

    /**
     * {@code minecraft:sea}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> SEA = create(key("sea"));

    /**
     * {@code minecraft:skeleton}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> SKELETON = create(key("skeleton"));

    /**
     * {@code minecraft:skull_and_roses}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> SKULL_AND_ROSES = create(key("skull_and_roses"));

    /**
     * {@code minecraft:stage}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> STAGE = create(key("stage"));

    /**
     * {@code minecraft:sunflowers}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> SUNFLOWERS = create(key("sunflowers"));

    /**
     * {@code minecraft:sunset}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> SUNSET = create(key("sunset"));

    /**
     * {@code minecraft:tides}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> TIDES = create(key("tides"));

    /**
     * {@code minecraft:unpacked}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> UNPACKED = create(key("unpacked"));

    /**
     * {@code minecraft:void}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> VOID = create(key("void"));

    /**
     * {@code minecraft:wanderer}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> WANDERER = create(key("wanderer"));

    /**
     * {@code minecraft:wasteland}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> WASTELAND = create(key("wasteland"));

    /**
     * {@code minecraft:water}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> WATER = create(key("water"));

    /**
     * {@code minecraft:wind}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> WIND = create(key("wind"));

    /**
     * {@code minecraft:wither}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Art> WITHER = create(key("wither"));

    private PaintingVariantKeys() {
    }

    /**
     * Creates a typed key for {@link Art} in the registry {@code minecraft:painting_variant}.
     *
     * @param key the value's key in the registry
     * @return a new typed key
     */
    public static TypedKey<Art> create(final Key key) {
        return TypedKey.create(RegistryKey.PAINTING_VARIANT, key);
    }
}
