package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.entity.Fireball;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class CraftFireball extends AbstractProjectile implements Fireball {
    public CraftFireball(CraftServer server, AbstractHurtingProjectile entity) {
        super(server, entity);
    }

    @Override
    public float getYield() {
        return this.getHandle().bukkitYield;
    }

    @Override
    public boolean isIncendiary() {
        return this.getHandle().isIncendiary;
    }

    @Override
    public void setIsIncendiary(boolean isIncendiary) {
        this.getHandle().isIncendiary = isIncendiary;
    }

    @Override
    public void setYield(float yield) {
        this.getHandle().bukkitYield = yield;
    }

    // Paper - moved to AbstractProjectile

    @Override
    public Vector getDirection() {
        return new Vector(this.getHandle().xPower, this.getHandle().yPower, this.getHandle().zPower);
    }

    @Override
    public void setDirection(Vector direction) {
        Preconditions.checkArgument(direction != null, "Vector direction cannot be null");
        if (direction.isZero()) {
            this.setVelocity(direction);
            return;
        }
        this.getHandle().assignPower(direction.getX(), direction.getY(), direction.getZ());
        this.update(); // SPIGOT-6579
    }

    @Override
    public void setVelocity(Vector velocity) {
        Preconditions.checkArgument(velocity != null, "Vector velocity cannot be null");
        // SPIGOT-6993: Allow power to be higher / lower than the normalized direction enforced by #setDirection(Vector)
        // Note: Because of MC-80142 the fireball will stutter on the client when setting the velocity to something other than 0 or the normalized vector * 0.1
        this.getHandle().xPower = velocity.getX();
        this.getHandle().yPower = velocity.getY();
        this.getHandle().zPower = velocity.getZ();
        this.update(); // SPIGOT-6579
    }

    // Paper start - Expose power on fireball projectiles
    @Override
    public void setPower(final Vector power) {
        this.getHandle().xPower = power.getX();
        this.getHandle().yPower = power.getY();
        this.getHandle().zPower = power.getZ();
    }

    @Override
    public Vector getPower() {
        return new Vector(this.getHandle().xPower, this.getHandle().yPower, this.getHandle().zPower);
    }
    // Paper end - Expose power on fireball projectiles

    @Override
    public AbstractHurtingProjectile getHandle() {
        return (AbstractHurtingProjectile) this.entity;
    }

    @Override
    public String toString() {
        return "CraftFireball";
    }
}
