package io.papermc.paper.plugin.provider.configuration.type;

import org.spongepowered.configurate.objectmapping.ConfigSerializable;

@ConfigSerializable
public record DependencyConfiguration(
    LoadOrder load,
    boolean required,
    boolean joinClasspath
) {

    public DependencyConfiguration(boolean required, boolean joinClasspath) {
        this(LoadOrder.OMIT, required, joinClasspath);
    }

    public DependencyConfiguration(boolean required) {
        this(required, true);
    }

    public DependencyConfiguration() {
        this(true);
    }

    @ConfigSerializable
    public enum LoadOrder {
        // dependency will now load BEFORE your plugin
        BEFORE,
        // the dependency will now load AFTER your plugin
        AFTER,
        OMIT
    }
}
