package io.papermc.paper.plugin.entrypoint.dependency;

import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.provider.entrypoint.DependencyContext;

import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("UnstableApiUsage")
public class DependencyUtil {

    public static List<String> validateSimple(PluginMeta meta, DependencyContext dependencyContext) {
        List<String> missingDependencies = new ArrayList<>();
        for (String hardDependency : meta.getPluginDependencies()) {
            if (!dependencyContext.hasDependency(hardDependency)) {
                missingDependencies.add(hardDependency);
            }
        }

        return missingDependencies;
    }
}
