package io.papermc.paper.command.subcommands;

import io.papermc.paper.adventure.providers.ClickCallbackProviderImpl;
import io.papermc.paper.command.PaperSubcommand;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;

import java.time.Duration;

@DefaultQualifier(NonNull.class)
public final class CallbackCommand implements PaperSubcommand {
    @Override
    public boolean execute(final CommandSender sender, final String subCommand, final String[] args) {
        if (args.length != 1) {
            return false;
        }

        final long id;
        try {
            id = Long.parseLong(args[0]);
        } catch (final NumberFormatException ignored) {
            return false;
        }

        ClickCallbackProviderImpl.CALLBACK_MANAGER.runCallback(sender, id);
        return true;
    }

    @Override
    public boolean tabCompletes() {
        return false;
    }
}
