/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.io.gson.metadata;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import org.parchmentmc.feather.metadata.RecordMetadata;
import org.parchmentmc.feather.metadata.RecordMetadataBuilder;
import org.parchmentmc.feather.metadata.Reference;
import org.parchmentmc.feather.named.Named;

class RecordMetadataAdapter
extends TypeAdapter<RecordMetadata> {
    private final Gson gson;

    public RecordMetadataAdapter(Gson gson) {
        this.gson = gson;
    }

    @Override
    public void write(JsonWriter out, RecordMetadata value) throws IOException {
        out.beginObject();
        out.name("owner");
        this.gson.toJson((Object)value.getOwner(), (Type)((Object)Named.class), out);
        out.name("field");
        this.gson.toJson((Object)value.getField(), (Type)((Object)Reference.class), out);
        out.name("getter");
        this.gson.toJson((Object)value.getGetter(), (Type)((Object)Reference.class), out);
        out.endObject();
    }

    @Override
    public RecordMetadata read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        Named owner = Named.empty();
        Reference field = null;
        Reference getter = null;
        in.beginObject();
        block10: while (in.hasNext()) {
            String propertyName;
            switch (propertyName = in.nextName()) {
                case "owner": {
                    owner = (Named)this.gson.fromJson(in, (Type)((Object)Named.class));
                    continue block10;
                }
                case "field": {
                    field = (Reference)this.gson.fromJson(in, (Type)((Object)Reference.class));
                    continue block10;
                }
                case "getter": {
                    getter = (Reference)this.gson.fromJson(in, (Type)((Object)Reference.class));
                    continue block10;
                }
            }
            in.skipValue();
        }
        in.endObject();
        if (owner.isEmpty()) {
            throw new JsonParseException("Field owner is not present or empty");
        }
        if (field == null) {
            throw new JsonParseException("Field field is not present or empty");
        }
        if (getter == null) {
            throw new JsonParseException("Field getter is not present or empty");
        }
        return RecordMetadataBuilder.create().withOwner(owner).withField(field).withGetter(getter).build();
    }
}

