/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.scoring;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.interfaces.VertexScoringAlgorithm;
import org.jheaps.AddressableHeap;
import org.jheaps.tree.PairingHeap;

public class BetweennessCentrality<V, E>
implements VertexScoringAlgorithm<V, Double> {
    private final Graph<V, E> graph;
    private final boolean normalize;
    private Map<V, Double> scores;

    public BetweennessCentrality(Graph<V, E> graph) {
        this(graph, false);
    }

    public BetweennessCentrality(Graph<V, E> graph, boolean normalize) {
        this.graph = Objects.requireNonNull(graph, "Graph cannot be null");
        this.scores = null;
        this.normalize = normalize;
    }

    @Override
    public Map<V, Double> getScores() {
        if (this.scores == null) {
            this.compute();
        }
        return Collections.unmodifiableMap(this.scores);
    }

    @Override
    public Double getVertexScore(V v) {
        if (!this.graph.containsVertex(v)) {
            throw new IllegalArgumentException("Cannot return score of unknown vertex");
        }
        if (this.scores == null) {
            this.compute();
        }
        return this.scores.get(v);
    }

    private void compute() {
        int n;
        int normalizationFactor;
        this.scores = new HashMap<V, Double>();
        this.graph.vertexSet().forEach(v -> this.scores.put((Double)v, 0.0));
        this.graph.vertexSet().forEach(this::compute);
        if (!this.graph.getType().isDirected()) {
            this.scores.forEach((v, score) -> this.scores.put((Double)v, score / 2.0));
        }
        if (this.normalize && (normalizationFactor = ((n = this.graph.vertexSet().size()) - 1) * (n - 2)) != 0) {
            this.scores.forEach((v, score) -> this.scores.put((Double)v, score / (double)normalizationFactor));
        }
    }

    private void compute(V s2) {
        ArrayDeque stack = new ArrayDeque();
        HashMap predecessors = new HashMap();
        this.graph.vertexSet().forEach(w -> predecessors.put(w, new ArrayList()));
        HashMap sigma = new HashMap();
        this.graph.vertexSet().forEach(t2 -> sigma.put(t2, 0.0));
        sigma.put(s2, 1.0);
        HashMap distance = new HashMap();
        this.graph.vertexSet().forEach(t2 -> distance.put(t2, Double.POSITIVE_INFINITY));
        distance.put(s2, 0.0);
        MyQueue queue = this.graph.getType().isWeighted() ? new WeightedQueue() : new UnweightedQueue();
        queue.insert(s2, 0.0);
        while (!queue.isEmpty()) {
            Object v2 = queue.remove();
            stack.push(v2);
            for (E e : this.graph.outgoingEdgesOf(v2)) {
                V w2 = Graphs.getOppositeVertex(this.graph, e, v2);
                double eWeight = this.graph.getEdgeWeight(e);
                if (eWeight < 0.0) {
                    throw new IllegalArgumentException("Negative edge weight not allowed");
                }
                double d = (Double)distance.get(v2) + eWeight;
                if ((Double)distance.get(w2) == Double.POSITIVE_INFINITY) {
                    queue.insert(w2, d);
                    distance.put(w2, d);
                    sigma.put(w2, (Double)sigma.get(v2));
                    ((List)predecessors.get(w2)).add(v2);
                    continue;
                }
                if ((Double)distance.get(w2) == d) {
                    sigma.put(w2, (Double)sigma.get(w2) + (Double)sigma.get(v2));
                    ((List)predecessors.get(w2)).add(v2);
                    continue;
                }
                if (!((Double)distance.get(w2) > d)) continue;
                queue.update(w2, d);
                distance.put(w2, d);
                sigma.put(w2, (Double)sigma.get(v2));
                ((List)predecessors.get(w2)).clear();
                ((List)predecessors.get(w2)).add(v2);
            }
        }
        HashMap dependency = new HashMap();
        this.graph.vertexSet().forEach(v -> dependency.put(v, 0.0));
        while (!stack.isEmpty()) {
            Object w3 = stack.pop();
            for (Object v3 : (List)predecessors.get(w3)) {
                dependency.put(v3, (Double)dependency.get(v3) + (Double)sigma.get(v3) / (Double)sigma.get(w3) * (1.0 + (Double)dependency.get(w3)));
            }
            if (w3.equals(s2)) continue;
            this.scores.put((Double)w3, this.scores.get(w3) + (Double)dependency.get(w3));
        }
    }

    private class UnweightedQueue
    implements MyQueue<V, Double> {
        Queue<V> delegate = new ArrayDeque();

        private UnweightedQueue() {
        }

        @Override
        public void insert(V t2, Double d) {
            this.delegate.add(t2);
        }

        @Override
        public void update(V t2, Double d) {
        }

        @Override
        public V remove() {
            return this.delegate.remove();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }
    }

    private class WeightedQueue
    implements MyQueue<V, Double> {
        AddressableHeap<Double, V> delegate = new PairingHeap();
        Map<V, AddressableHeap.Handle<Double, V>> seen = new HashMap();

        private WeightedQueue() {
        }

        @Override
        public void insert(V t2, Double d) {
            AddressableHeap.Handle node = this.delegate.insert(d, t2);
            this.seen.put((AddressableHeap.Handle)t2, (AddressableHeap.Handle)node);
        }

        @Override
        public void update(V t2, Double d) {
            if (!this.seen.containsKey(t2)) {
                throw new IllegalArgumentException("Element " + t2 + " does not exist in queue");
            }
            this.seen.get(t2).decreaseKey(d);
        }

        @Override
        public V remove() {
            return this.delegate.deleteMin().getValue();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }
    }

    private static interface MyQueue<T, D> {
        public void insert(T var1, D var2);

        public void update(T var1, D var2);

        public T remove();

        public boolean isEmpty();
    }
}

