/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.bombe.type;

import me.jamiemansfield.string.StringReader;
import org.cadixdev.bombe.type.ArrayType;
import org.cadixdev.bombe.type.BaseType;
import org.cadixdev.bombe.type.FieldType;
import org.cadixdev.bombe.type.ObjectType;
import org.cadixdev.bombe.type.PrimitiveType;
import org.cadixdev.bombe.type.Type;
import org.cadixdev.bombe.type.VoidType;

public class TypeReader
extends StringReader {
    public TypeReader(String source) {
        super(source);
    }

    public Type readType() {
        if (this.peek() == 'V') {
            this.advance();
            return VoidType.INSTANCE;
        }
        return this.readFieldType();
    }

    public FieldType readFieldType() {
        if (this.peek() == '[') {
            return this.readArrayType();
        }
        if (BaseType.isValidBase(this.peek())) {
            return this.readBaseType();
        }
        if (this.peek() == 'L') {
            return this.readObjectType();
        }
        throw new IllegalStateException("Invalid descriptor provided!");
    }

    public ArrayType readArrayType() {
        int count = 0;
        while (this.available() && this.peek() == '[') {
            this.advance();
            ++count;
        }
        return new ArrayType(count, this.readFieldType());
    }

    public BaseType readBaseType() {
        return BaseType.getFromKey(this.advance());
    }

    public ObjectType readObjectType() {
        int start = this.index();
        this.advance();
        while (this.available() && this.peek() != ';') {
            this.advance();
        }
        if (this.peek() != ';') {
            throw new IllegalStateException("Incomplete descriptor provided!");
        }
        this.advance();
        return new ObjectType(this.substring(start + 1, this.index() - 1));
    }

    public PrimitiveType readPrimitiveType() {
        if (this.peek() == 'V') {
            this.advance();
            return VoidType.INSTANCE;
        }
        if (BaseType.isValidBase(this.peek())) {
            return this.readBaseType();
        }
        throw new IllegalStateException("Invalid descriptor provided!");
    }
}

