/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.bombe.jar;

import java.util.jar.JarFile;
import org.cadixdev.bombe.jar.ClassLoaderClassProvider;
import org.cadixdev.bombe.jar.JarFileClassProvider;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.ClassNode;

@FunctionalInterface
public interface ClassProvider {
    public static ClassProvider of(ClassLoader loader) {
        return new ClassLoaderClassProvider(loader);
    }

    public static ClassProvider of(JarFile jar) {
        return new JarFileClassProvider(jar);
    }

    public byte[] get(String var1);

    default public ClassNode getAsNode(String klass, int parsingOptions) {
        byte[] contents = this.get(klass);
        if (contents == null) {
            return null;
        }
        ClassReader reader = new ClassReader(contents);
        ClassNode node = new ClassNode();
        reader.accept(node, parsingOptions);
        return node;
    }

    default public ClassNode getAsNode(String klass) {
        return this.getAsNode(klass, 0);
    }
}

