/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.util;

import at.favre.lib.bytes.Bytes;
import com.google.gson.Gson;
import io.papermc.codebook.exceptions.UnexpectedException;
import io.papermc.codebook.exceptions.UserErrorException;
import io.papermc.codebook.util.DownloadSpec;
import io.papermc.codebook.util.IOUtil;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Downloader {
    public static final String PARCHMENT_MAVEN = "https://maven.parchmentmc.org/";
    public static final String NEO_MAVEN = "https://maven.neoforged.net/releases/";
    private static final HttpClient client = HttpClient.newHttpClient();
    private static final Gson gson = new Gson();

    private Downloader() {
    }

    public static URI getDownloadUri(String mavenBaseUrl, String mavenCoords) {
        int extensionIndex = mavenCoords.indexOf(64);
        String coords = extensionIndex == -1 ? mavenCoords : mavenCoords.substring(0, extensionIndex);
        String[] parts = coords.split(":");
        if (parts.length != 3 && parts.length != 4) {
            throw new UserErrorException("Invalid Maven coordinates: " + mavenCoords);
        }
        StringBuilder sb = new StringBuilder(mavenBaseUrl);
        if (!mavenBaseUrl.endsWith("/")) {
            sb.append('/');
        }
        sb.append(parts[0].replace('.', '/')).append('/');
        sb.append(parts[1]).append('/');
        sb.append(parts[2]).append('/');
        sb.append(parts[1]).append('-').append(parts[2]);
        if (parts.length == 4) {
            sb.append('-').append(parts[3]);
        }
        if (extensionIndex == -1) {
            sb.append(".jar");
        } else {
            sb.append('.').append(mavenCoords.substring(extensionIndex + 1));
        }
        return URI.create(sb.toString());
    }

    public static <T> T getJson(String url, Class<T> type) {
        HttpRequest request = HttpRequest.newBuilder(URI.create(url)).GET().build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            return gson.fromJson(response.body(), type);
        }
        catch (Exception e) {
            throw new UnexpectedException("Failed to download json from " + url, e);
        }
    }

    public static void downloadFile(DownloadSpec spec, Path targetFile) {
        Downloader.downloadFile(spec.uri(), spec.sha1(), targetFile);
    }

    public static void downloadFile(URI uri, Path targetFile) {
        Downloader.downloadFile(uri, null, targetFile);
    }

    public static void downloadFile(URI uri, @Nullable String sha1, Path targetFile) {
        Path file;
        HttpRequest request = HttpRequest.newBuilder(uri).GET().build();
        IOUtil.createParentDirectories(targetFile);
        try {
            HttpResponse<Path> response = client.send(request, HttpResponse.BodyHandlers.ofFile(targetFile));
            file = response.body();
            if (response.statusCode() < 200 || response.statusCode() > 299) {
                throw new UnexpectedException("Failed to download file from " + String.valueOf(uri) + " - status code: " + response.statusCode());
            }
        }
        catch (IOException | InterruptedException e) {
            throw new UnexpectedException("Failed to download file from " + String.valueOf(uri), e);
        }
        if (sha1 == null) {
            return;
        }
        String actualSha1 = Bytes.from(file.toFile()).hashSha1().encodeHex();
        if (!actualSha1.equalsIgnoreCase(sha1)) {
            throw new UnexpectedException("Downloaded file SHA-1 hash did not match expected hash");
        }
    }
}

