/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.pages;

import dev.denwav.hypo.asm.AsmClassData;
import dev.denwav.hypo.core.HypoContext;
import io.papermc.codebook.exceptions.UnexpectedException;
import io.papermc.codebook.lvt.LvtNamer;
import io.papermc.codebook.pages.AsmProcessorPage;
import io.papermc.codebook.pages.CodeBookPage;
import io.papermc.codebook.report.Reports;
import jakarta.inject.Inject;
import java.io.IOException;
import org.cadixdev.lorenz.MappingSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class RemapLvtPage
extends AsmProcessorPage {
    private final @Nullable MappingSet paramMappings;
    private final Reports reports;
    private @Nullable LvtNamer lvtNamer;

    @Inject
    public RemapLvtPage(@CodeBookPage.Hypo HypoContext hypoContext, @CodeBookPage.ParamMappings @Nullable MappingSet paramMappings, @CodeBookPage.Report Reports reports) {
        super(hypoContext);
        this.paramMappings = paramMappings;
        this.reports = reports;
    }

    @Override
    public void exec() {
        if (this.paramMappings == null) {
            return;
        }
        try {
            this.lvtNamer = new LvtNamer(this.context, this.paramMappings, this.reports);
        }
        catch (IOException e) {
            throw new UnexpectedException("Failed to create LVT namer", e);
        }
        this.processClasses();
    }

    @Override
    protected void processClass(AsmClassData classData) throws IOException {
        if (this.lvtNamer != null) {
            this.lvtNamer.processClass(classData);
        }
    }
}

