/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.pages;

import at.favre.lib.bytes.Bytes;
import io.papermc.codebook.exceptions.UnexpectedException;
import io.papermc.codebook.pages.CodeBookPage;
import io.papermc.codebook.util.IOUtil;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ExtractVanillaJarPage
extends CodeBookPage {
    private final Path inputJar;
    private final @Nullable List<Path> classpathJars;
    private final Path tempDir;

    @Inject
    public ExtractVanillaJarPage(@CodeBookPage.InputJar Path inputJar, @CodeBookPage.ClasspathJars @Nullable List<Path> classpathJars, @CodeBookPage.TempDir Path tempDir) {
        this.inputJar = inputJar;
        this.classpathJars = classpathJars;
        this.tempDir = tempDir;
    }

    @Override
    public void exec() {
        if (this.classpathJars != null) {
            return;
        }
        try (FileSystem inFs = FileSystems.newFileSystem(this.inputJar);){
            Path rootDir = inFs.getPath("/", new String[0]);
            Path versionsDir = rootDir.resolve("META-INF/versions");
            Path librariesDir = rootDir.resolve("META-INF/libraries");
            Path versionsFile = rootDir.resolve("META-INF/versions.list");
            Version version = Version.parseFile(versionsFile);
            Path librariesFile = rootDir.resolve("META-INF/libraries.list");
            List<Library> libraries = Library.parseFile(librariesFile);
            Path internalPath = Path.of(version.filePath, new String[0]);
            Path serverJar = this.tempDir.resolve(internalPath.getFileName());
            IOUtil.copy(versionsDir.resolve(version.filePath), serverJar);
            String actualHash = Bytes.from(serverJar.toFile()).hashSha256().encodeHex();
            if (!version.sha256.equalsIgnoreCase(actualHash)) {
                throw new UnexpectedException("Failed to copy " + String.valueOf(internalPath.getFileName()) + " from vanilla jar successfully (hash does not match)");
            }
            ArrayList<Path> libs = new ArrayList<Path>();
            this.bind(CodeBookPage.ClasspathJars.KEY).to(libs);
            Path outLibsDir = this.tempDir.resolve("libraries");
            IOUtil.createDirectories(outLibsDir);
            for (Library library : libraries) {
                Path libInternalPath = Path.of(library.filePath, new String[0]);
                Path libFile = outLibsDir.resolve(libInternalPath.getFileName());
                IOUtil.copy(librariesDir.resolve(library.filePath), libFile);
                libs.add(libFile);
                String libActualHash = Bytes.from(libFile.toFile()).hashSha256().encodeHex();
                if (library.sha256.equalsIgnoreCase(libActualHash)) continue;
                throw new UnexpectedException("Failed to copy " + String.valueOf(libInternalPath.getFileName()) + " from vanilla jar successfully (hash does not match)");
            }
            this.bind(CodeBookPage.InputJar.KEY).to(serverJar);
        }
        catch (IOException e) {
            throw new UnexpectedException("Failed to filter jar", e);
        }
    }

    private record Version(String sha256, String version, String filePath) {
        private static Version parseFile(Path file) {
            List<String> lines;
            try {
                lines = Files.readAllLines(file);
            }
            catch (IOException e) {
                throw new UnexpectedException("Failed to read versions.list file", e);
            }
            if (lines.isEmpty()) {
                throw new UnexpectedException("versions.list file is empty");
            }
            String[] parts = lines.get(0).split("\t");
            if (parts.length != 3) {
                throw new UnexpectedException("versions.list file is invalid");
            }
            return new Version(parts[0], parts[1], parts[2]);
        }
    }

    private record Library(String sha256, String mavenCoords, String filePath) {
        private static List<Library> parseFile(Path file) {
            List<String> lines;
            try {
                lines = Files.readAllLines(file);
            }
            catch (IOException e) {
                throw new UnexpectedException("Failed to read libraries.list file", e);
            }
            if (lines.isEmpty()) {
                throw new UnexpectedException("libraries.list file is empty");
            }
            return lines.stream().map(l -> {
                String[] parts = l.split("\t");
                if (parts.length != 3) {
                    throw new UnexpectedException("versions.list file is invalid");
                }
                return new Library(parts[0], parts[1], parts[2]);
            }).toList();
        }
    }
}

