/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.mojangapi;

import io.papermc.codebook.exceptions.UserErrorException;
import io.papermc.codebook.mojangapi.MinecraftManifest;
import io.papermc.codebook.mojangapi.MinecraftVersion;
import io.papermc.codebook.mojangapi.MinecraftVersionDownload;
import io.papermc.codebook.util.Downloader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public record MinecraftVersionManifest(Map<String, MinecraftVersionDownload> downloads) {
    private static final Map<String, MinecraftVersionManifest> instanceMap = new HashMap<String, MinecraftVersionManifest>();

    public static MinecraftVersionManifest getManifestForVersion(MinecraftManifest manifest, String mcVersion) {
        return instanceMap.computeIfAbsent(mcVersion, k -> {
            @Nullable MinecraftVersion version = manifest.versions().stream().filter(v -> v.id().equals(k)).findFirst().orElse(null);
            if (version == null) {
                throw new UserErrorException("MC version not found: " + mcVersion);
            }
            return Downloader.getJson(version.url(), MinecraftVersionManifest.class);
        });
    }

    private MinecraftVersionDownload download(String name) {
        return Objects.requireNonNull(this.downloads.get(name), "No such download '%s' in version manifest".formatted(name));
    }

    public MinecraftVersionDownload serverDownload() {
        return this.download("server");
    }

    public MinecraftVersionDownload serverMappingsDownload() {
        return this.download("server_mappings");
    }
}

