/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.lvt.suggestion;

import io.papermc.codebook.lvt.suggestion.LvtSuggester;
import io.papermc.codebook.lvt.suggestion.context.ContainerContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodCallContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodInsnContext;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StringSuggester
implements LvtSuggester {
    @Override
    public @Nullable String suggestFromMethod(MethodCallContext call, MethodInsnContext insn, ContainerContext container) throws IOException {
        String methodName = call.data().name();
        if (methodName.startsWith("split") && (insn.ownerEqualTo("java/lang/String") || insn.ownerEqualTo("com/google/common/base/Splitter"))) {
            return "parts";
        }
        if (methodName.equals("repeat") && call.data().returnType().asInternalName().equals("Ljava/lang/String;")) {
            return "repeated";
        }
        if (methodName.equals("indexOf") || methodName.equals("lastIndexOf")) {
            return "index";
        }
        if (methodName.equals("substring")) {
            return "sub";
        }
        if (methodName.equals("codePointAt")) {
            return "code";
        }
        if (methodName.equals("trim")) {
            return "trimmed";
        }
        if (methodName.startsWith("strip")) {
            return "stripped";
        }
        if (methodName.equals("formatted")) {
            return "formatted";
        }
        return null;
    }
}

