/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.config;

import io.papermc.codebook.config.CodeBookContext;
import io.papermc.codebook.config.CodeBookInput;
import io.papermc.codebook.config.CodeBookResource;
import io.papermc.codebook.config.CodeBookUriResource;
import io.papermc.codebook.mojangapi.MinecraftManifest;
import io.papermc.codebook.mojangapi.MinecraftVersionDownload;
import io.papermc.codebook.mojangapi.MinecraftVersionManifest;
import io.papermc.codebook.util.Downloader;
import java.nio.file.Path;
import org.checkerframework.checker.nullness.qual.Nullable;

public record CodeBookVersionInput(String mcVersion) implements CodeBookInput
{
    static CodeBookVersionInput of(String mcVersion) {
        return new CodeBookVersionInput(mcVersion);
    }

    @Override
    public Path resolveInputFile(Path tempDir) {
        MinecraftManifest manifest = MinecraftManifest.getManifest();
        MinecraftVersionManifest versionManifest = MinecraftVersionManifest.getManifestForVersion(manifest, this.mcVersion);
        Path targetJar = tempDir.resolve("download/server.jar");
        Downloader.downloadFile(versionManifest.serverDownload(), targetJar);
        return targetJar;
    }

    @Override
    public CodeBookResource resolveMappings(CodeBookContext ctx, Path tempDir) {
        @Nullable CodeBookResource mappings = CodeBookInput.super.resolveMappings(ctx, tempDir);
        if (mappings != null) {
            return mappings;
        }
        MinecraftManifest manifest = MinecraftManifest.getManifest();
        MinecraftVersionManifest versionManifest = MinecraftVersionManifest.getManifestForVersion(manifest, this.mcVersion);
        MinecraftVersionDownload mappingsDownload = versionManifest.serverMappingsDownload();
        return new CodeBookUriResource("server_mappings.txt", mappingsDownload.uri(), mappingsDownload.sha1());
    }
}

