/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.config;

import io.papermc.codebook.config.CodeBookCoordsResource;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeBookCoordsResourceBuilder {
    private String coords;
    private String classifier;
    private String extension;
    private String mavenBaseUrl;

    private CodeBookCoordsResourceBuilder() {
    }

    private CodeBookCoordsResourceBuilder(String coords, String classifier, String extension, String mavenBaseUrl) {
        this.coords = coords;
        this.classifier = classifier;
        this.extension = extension;
        this.mavenBaseUrl = mavenBaseUrl;
    }

    public static CodeBookCoordsResource CodeBookCoordsResource(@NotNull String coords, @Nullable String classifier, @Nullable String extension, @NotNull String mavenBaseUrl) {
        Objects.requireNonNull(coords, "coords is required");
        Objects.requireNonNull(mavenBaseUrl, "mavenBaseUrl is required");
        return new CodeBookCoordsResource(coords, classifier, extension, mavenBaseUrl);
    }

    public static CodeBookCoordsResourceBuilder builder() {
        return new CodeBookCoordsResourceBuilder();
    }

    public static CodeBookCoordsResourceBuilder builder(CodeBookCoordsResource from) {
        return new CodeBookCoordsResourceBuilder(from.coords(), from.classifier(), from.extension(), from.mavenBaseUrl());
    }

    public static With from(CodeBookCoordsResource from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(CodeBookCoordsResource record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, String>("coords", record.coords()), new AbstractMap.SimpleImmutableEntry<String, String>("classifier", record.classifier()), new AbstractMap.SimpleImmutableEntry<String, String>("extension", record.extension()), new AbstractMap.SimpleImmutableEntry<String, String>("mavenBaseUrl", record.mavenBaseUrl()));
    }

    public CodeBookCoordsResource build() {
        Objects.requireNonNull(this.coords, "coords is required");
        Objects.requireNonNull(this.mavenBaseUrl, "mavenBaseUrl is required");
        return new CodeBookCoordsResource(this.coords, this.classifier, this.extension, this.mavenBaseUrl);
    }

    public String toString() {
        return "CodeBookCoordsResourceBuilder[coords=" + this.coords + ", classifier=" + this.classifier + ", extension=" + this.extension + ", mavenBaseUrl=" + this.mavenBaseUrl + "]";
    }

    public int hashCode() {
        return Objects.hash(this.coords, this.classifier, this.extension, this.mavenBaseUrl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof CodeBookCoordsResourceBuilder)) return false;
        CodeBookCoordsResourceBuilder r = (CodeBookCoordsResourceBuilder)o;
        if (!Objects.equals(this.coords, r.coords)) return false;
        if (!Objects.equals(this.classifier, r.classifier)) return false;
        if (!Objects.equals(this.extension, r.extension)) return false;
        if (!Objects.equals(this.mavenBaseUrl, r.mavenBaseUrl)) return false;
        return true;
    }

    public CodeBookCoordsResourceBuilder coords(@NotNull String coords) {
        this.coords = coords;
        return this;
    }

    @NotNull
    public String coords() {
        return this.coords;
    }

    public CodeBookCoordsResourceBuilder classifier(@Nullable String classifier) {
        this.classifier = classifier;
        return this;
    }

    @Nullable
    public String classifier() {
        return this.classifier;
    }

    public CodeBookCoordsResourceBuilder extension(@Nullable String extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    public String extension() {
        return this.extension;
    }

    public CodeBookCoordsResourceBuilder mavenBaseUrl(@NotNull String mavenBaseUrl) {
        this.mavenBaseUrl = mavenBaseUrl;
        return this;
    }

    @NotNull
    public String mavenBaseUrl() {
        return this.mavenBaseUrl;
    }

    private static final class _FromWith
    implements With {
        private final CodeBookCoordsResource from;

        private _FromWith(CodeBookCoordsResource from) {
            this.from = from;
        }

        @Override
        public String coords() {
            return this.from.coords();
        }

        @Override
        public String classifier() {
            return this.from.classifier();
        }

        @Override
        public String extension() {
            return this.from.extension();
        }

        @Override
        public String mavenBaseUrl() {
            return this.from.mavenBaseUrl();
        }
    }

    public static interface With {
        @NotNull
        public String coords();

        @Nullable
        public String classifier();

        @Nullable
        public String extension();

        @NotNull
        public String mavenBaseUrl();

        default public CodeBookCoordsResourceBuilder with() {
            return new CodeBookCoordsResourceBuilder(this.coords(), this.classifier(), this.extension(), this.mavenBaseUrl());
        }

        default public CodeBookCoordsResource with(Consumer<CodeBookCoordsResourceBuilder> consumer) {
            CodeBookCoordsResourceBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public CodeBookCoordsResource withCoords(@NotNull String coords) {
            Objects.requireNonNull(coords, "coords is required");
            return new CodeBookCoordsResource(coords, this.classifier(), this.extension(), this.mavenBaseUrl());
        }

        default public CodeBookCoordsResource withClassifier(@Nullable String classifier) {
            return new CodeBookCoordsResource(this.coords(), classifier, this.extension(), this.mavenBaseUrl());
        }

        default public CodeBookCoordsResource withExtension(@Nullable String extension) {
            return new CodeBookCoordsResource(this.coords(), this.classifier(), extension, this.mavenBaseUrl());
        }

        default public CodeBookCoordsResource withMavenBaseUrl(@NotNull String mavenBaseUrl) {
            Objects.requireNonNull(mavenBaseUrl, "mavenBaseUrl is required");
            return new CodeBookCoordsResource(this.coords(), this.classifier(), this.extension(), mavenBaseUrl);
        }
    }
}

