/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.config;

import dev.denwav.hypo.core.HypoConfig;
import io.papermc.codebook.config.CodeBookContext;
import io.papermc.codebook.config.CodeBookInput;
import io.papermc.codebook.config.CodeBookRemapper;
import io.papermc.codebook.config.CodeBookResource;
import io.papermc.codebook.report.Reports;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeBookContextBuilder {
    private Path tempDir;
    private CodeBookRemapper remapperJar;
    private CodeBookResource mappings;
    private CodeBookResource paramMappings;
    private CodeBookResource unpickDefinitions;
    private Path outputJar;
    private boolean overwrite;
    private CodeBookInput input;
    private Reports reports;
    private HypoConfig hypoConfig;

    private CodeBookContextBuilder() {
    }

    private CodeBookContextBuilder(Path tempDir, CodeBookRemapper remapperJar, CodeBookResource mappings, CodeBookResource paramMappings, CodeBookResource unpickDefinitions, Path outputJar, boolean overwrite, CodeBookInput input, Reports reports, HypoConfig hypoConfig) {
        this.tempDir = tempDir;
        this.remapperJar = remapperJar;
        this.mappings = mappings;
        this.paramMappings = paramMappings;
        this.unpickDefinitions = unpickDefinitions;
        this.outputJar = outputJar;
        this.overwrite = overwrite;
        this.input = input;
        this.reports = reports;
        this.hypoConfig = hypoConfig;
    }

    public static CodeBookContext CodeBookContext(@Nullable Path tempDir, @NotNull CodeBookRemapper remapperJar, @Nullable CodeBookResource mappings, @Nullable CodeBookResource paramMappings, @Nullable CodeBookResource unpickDefinitions, @NotNull Path outputJar, boolean overwrite, @NotNull CodeBookInput input, @Nullable Reports reports, @Nullable HypoConfig hypoConfig) {
        Objects.requireNonNull(remapperJar, "remapperJar is required");
        Objects.requireNonNull(outputJar, "outputJar is required");
        Objects.requireNonNull(input, "input is required");
        return new CodeBookContext(tempDir, remapperJar, mappings, paramMappings, unpickDefinitions, outputJar, overwrite, input, reports, hypoConfig);
    }

    public static CodeBookContextBuilder builder() {
        return new CodeBookContextBuilder();
    }

    public static CodeBookContextBuilder builder(CodeBookContext from) {
        return new CodeBookContextBuilder(from.tempDir(), from.remapperJar(), from.mappings(), from.paramMappings(), from.unpickDefinitions(), from.outputJar(), from.overwrite(), from.input(), from.reports(), from.hypoConfig());
    }

    public static With from(CodeBookContext from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(CodeBookContext record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, Path>("tempDir", record.tempDir()), new AbstractMap.SimpleImmutableEntry<String, CodeBookRemapper>("remapperJar", record.remapperJar()), new AbstractMap.SimpleImmutableEntry<String, CodeBookResource>("mappings", record.mappings()), new AbstractMap.SimpleImmutableEntry<String, CodeBookResource>("paramMappings", record.paramMappings()), new AbstractMap.SimpleImmutableEntry<String, CodeBookResource>("unpickDefinitions", record.unpickDefinitions()), new AbstractMap.SimpleImmutableEntry<String, Path>("outputJar", record.outputJar()), new AbstractMap.SimpleImmutableEntry<String, Boolean>("overwrite", record.overwrite()), new AbstractMap.SimpleImmutableEntry<String, CodeBookInput>("input", record.input()), new AbstractMap.SimpleImmutableEntry<String, Reports>("reports", record.reports()), new AbstractMap.SimpleImmutableEntry<String, HypoConfig>("hypoConfig", record.hypoConfig()));
    }

    public CodeBookContext build() {
        Objects.requireNonNull(this.remapperJar, "remapperJar is required");
        Objects.requireNonNull(this.outputJar, "outputJar is required");
        Objects.requireNonNull(this.input, "input is required");
        return new CodeBookContext(this.tempDir, this.remapperJar, this.mappings, this.paramMappings, this.unpickDefinitions, this.outputJar, this.overwrite, this.input, this.reports, this.hypoConfig);
    }

    public String toString() {
        return "CodeBookContextBuilder[tempDir=" + String.valueOf(this.tempDir) + ", remapperJar=" + String.valueOf(this.remapperJar) + ", mappings=" + String.valueOf(this.mappings) + ", paramMappings=" + String.valueOf(this.paramMappings) + ", unpickDefinitions=" + String.valueOf(this.unpickDefinitions) + ", outputJar=" + String.valueOf(this.outputJar) + ", overwrite=" + this.overwrite + ", input=" + String.valueOf(this.input) + ", reports=" + String.valueOf(this.reports) + ", hypoConfig=" + String.valueOf(this.hypoConfig) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.tempDir, this.remapperJar, this.mappings, this.paramMappings, this.unpickDefinitions, this.outputJar, this.overwrite, this.input, this.reports, this.hypoConfig);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof CodeBookContextBuilder)) return false;
        CodeBookContextBuilder r = (CodeBookContextBuilder)o;
        if (!Objects.equals(this.tempDir, r.tempDir)) return false;
        if (!Objects.equals(this.remapperJar, r.remapperJar)) return false;
        if (!Objects.equals(this.mappings, r.mappings)) return false;
        if (!Objects.equals(this.paramMappings, r.paramMappings)) return false;
        if (!Objects.equals(this.unpickDefinitions, r.unpickDefinitions)) return false;
        if (!Objects.equals(this.outputJar, r.outputJar)) return false;
        if (this.overwrite != r.overwrite) return false;
        if (!Objects.equals(this.input, r.input)) return false;
        if (!Objects.equals(this.reports, r.reports)) return false;
        if (!Objects.equals(this.hypoConfig, r.hypoConfig)) return false;
        return true;
    }

    public CodeBookContextBuilder tempDir(@Nullable Path tempDir) {
        this.tempDir = tempDir;
        return this;
    }

    @Nullable
    public Path tempDir() {
        return this.tempDir;
    }

    public CodeBookContextBuilder remapperJar(@NotNull CodeBookRemapper remapperJar) {
        this.remapperJar = remapperJar;
        return this;
    }

    @NotNull
    public CodeBookRemapper remapperJar() {
        return this.remapperJar;
    }

    public CodeBookContextBuilder mappings(@Nullable CodeBookResource mappings) {
        this.mappings = mappings;
        return this;
    }

    @Nullable
    public CodeBookResource mappings() {
        return this.mappings;
    }

    public CodeBookContextBuilder paramMappings(@Nullable CodeBookResource paramMappings) {
        this.paramMappings = paramMappings;
        return this;
    }

    @Nullable
    public CodeBookResource paramMappings() {
        return this.paramMappings;
    }

    public CodeBookContextBuilder unpickDefinitions(@Nullable CodeBookResource unpickDefinitions) {
        this.unpickDefinitions = unpickDefinitions;
        return this;
    }

    @Nullable
    public CodeBookResource unpickDefinitions() {
        return this.unpickDefinitions;
    }

    public CodeBookContextBuilder outputJar(@NotNull Path outputJar) {
        this.outputJar = outputJar;
        return this;
    }

    @NotNull
    public Path outputJar() {
        return this.outputJar;
    }

    public CodeBookContextBuilder overwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    public boolean overwrite() {
        return this.overwrite;
    }

    public CodeBookContextBuilder input(@NotNull CodeBookInput input) {
        this.input = input;
        return this;
    }

    @NotNull
    public CodeBookInput input() {
        return this.input;
    }

    public CodeBookContextBuilder reports(@Nullable Reports reports) {
        this.reports = reports;
        return this;
    }

    @Nullable
    public Reports reports() {
        return this.reports;
    }

    public CodeBookContextBuilder hypoConfig(@Nullable HypoConfig hypoConfig) {
        this.hypoConfig = hypoConfig;
        return this;
    }

    @Nullable
    public HypoConfig hypoConfig() {
        return this.hypoConfig;
    }

    private static final class _FromWith
    implements With {
        private final CodeBookContext from;

        private _FromWith(CodeBookContext from) {
            this.from = from;
        }

        @Override
        public Path tempDir() {
            return this.from.tempDir();
        }

        @Override
        public CodeBookRemapper remapperJar() {
            return this.from.remapperJar();
        }

        @Override
        public CodeBookResource mappings() {
            return this.from.mappings();
        }

        @Override
        public CodeBookResource paramMappings() {
            return this.from.paramMappings();
        }

        @Override
        public CodeBookResource unpickDefinitions() {
            return this.from.unpickDefinitions();
        }

        @Override
        public Path outputJar() {
            return this.from.outputJar();
        }

        @Override
        public boolean overwrite() {
            return this.from.overwrite();
        }

        @Override
        public CodeBookInput input() {
            return this.from.input();
        }

        @Override
        public Reports reports() {
            return this.from.reports();
        }

        @Override
        public HypoConfig hypoConfig() {
            return this.from.hypoConfig();
        }
    }

    public static interface With {
        @Nullable
        public Path tempDir();

        @NotNull
        public CodeBookRemapper remapperJar();

        @Nullable
        public CodeBookResource mappings();

        @Nullable
        public CodeBookResource paramMappings();

        @Nullable
        public CodeBookResource unpickDefinitions();

        @NotNull
        public Path outputJar();

        public boolean overwrite();

        @NotNull
        public CodeBookInput input();

        @Nullable
        public Reports reports();

        @Nullable
        public HypoConfig hypoConfig();

        default public CodeBookContextBuilder with() {
            return new CodeBookContextBuilder(this.tempDir(), this.remapperJar(), this.mappings(), this.paramMappings(), this.unpickDefinitions(), this.outputJar(), this.overwrite(), this.input(), this.reports(), this.hypoConfig());
        }

        default public CodeBookContext with(Consumer<CodeBookContextBuilder> consumer) {
            CodeBookContextBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public CodeBookContext withTempDir(@Nullable Path tempDir) {
            return new CodeBookContext(tempDir, this.remapperJar(), this.mappings(), this.paramMappings(), this.unpickDefinitions(), this.outputJar(), this.overwrite(), this.input(), this.reports(), this.hypoConfig());
        }

        default public CodeBookContext withRemapperJar(@NotNull CodeBookRemapper remapperJar) {
            Objects.requireNonNull(remapperJar, "remapperJar is required");
            return new CodeBookContext(this.tempDir(), remapperJar, this.mappings(), this.paramMappings(), this.unpickDefinitions(), this.outputJar(), this.overwrite(), this.input(), this.reports(), this.hypoConfig());
        }

        default public CodeBookContext withMappings(@Nullable CodeBookResource mappings) {
            return new CodeBookContext(this.tempDir(), this.remapperJar(), mappings, this.paramMappings(), this.unpickDefinitions(), this.outputJar(), this.overwrite(), this.input(), this.reports(), this.hypoConfig());
        }

        default public CodeBookContext withParamMappings(@Nullable CodeBookResource paramMappings) {
            return new CodeBookContext(this.tempDir(), this.remapperJar(), this.mappings(), paramMappings, this.unpickDefinitions(), this.outputJar(), this.overwrite(), this.input(), this.reports(), this.hypoConfig());
        }

        default public CodeBookContext withUnpickDefinitions(@Nullable CodeBookResource unpickDefinitions) {
            return new CodeBookContext(this.tempDir(), this.remapperJar(), this.mappings(), this.paramMappings(), unpickDefinitions, this.outputJar(), this.overwrite(), this.input(), this.reports(), this.hypoConfig());
        }

        default public CodeBookContext withOutputJar(@NotNull Path outputJar) {
            Objects.requireNonNull(outputJar, "outputJar is required");
            return new CodeBookContext(this.tempDir(), this.remapperJar(), this.mappings(), this.paramMappings(), this.unpickDefinitions(), outputJar, this.overwrite(), this.input(), this.reports(), this.hypoConfig());
        }

        default public CodeBookContext withOverwrite(boolean overwrite) {
            return new CodeBookContext(this.tempDir(), this.remapperJar(), this.mappings(), this.paramMappings(), this.unpickDefinitions(), this.outputJar(), overwrite, this.input(), this.reports(), this.hypoConfig());
        }

        default public CodeBookContext withInput(@NotNull CodeBookInput input) {
            Objects.requireNonNull(input, "input is required");
            return new CodeBookContext(this.tempDir(), this.remapperJar(), this.mappings(), this.paramMappings(), this.unpickDefinitions(), this.outputJar(), this.overwrite(), input, this.reports(), this.hypoConfig());
        }

        default public CodeBookContext withReports(@Nullable Reports reports) {
            return new CodeBookContext(this.tempDir(), this.remapperJar(), this.mappings(), this.paramMappings(), this.unpickDefinitions(), this.outputJar(), this.overwrite(), this.input(), reports, this.hypoConfig());
        }

        default public CodeBookContext withHypoConfig(@Nullable HypoConfig hypoConfig) {
            return new CodeBookContext(this.tempDir(), this.remapperJar(), this.mappings(), this.paramMappings(), this.unpickDefinitions(), this.outputJar(), this.overwrite(), this.input(), this.reports(), hypoConfig);
        }
    }
}

