/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.model.data;

import com.google.errorprone.annotations.Immutable;
import dev.denwav.hypo.model.data.types.ArrayType;
import dev.denwav.hypo.model.data.types.ClassType;
import dev.denwav.hypo.model.data.types.JvmType;
import dev.denwav.hypo.model.data.types.PrimitiveType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class MethodDescriptor {
    @NotNull
    private final @NotNull List<@NotNull JvmType> params;
    @NotNull
    private final JvmType returnType;

    public MethodDescriptor(@NotNull @NotNull List<@NotNull JvmType> params, @NotNull JvmType returnType) {
        this.params = List.copyOf(params);
        this.returnType = returnType;
    }

    @NotNull
    public static MethodDescriptor parseDescriptor(@NotNull String desc) {
        if (!desc.startsWith("(")) {
            throw new IllegalArgumentException("desc is invalid: Does not start with '(': " + desc);
        }
        ArrayList<JvmType> params = new ArrayList<JvmType>();
        JvmType returnType = null;
        JvmType[] ref = new JvmType[1];
        int len = desc.length();
        for (int i = 1; i < len; ++i) {
            i = MethodDescriptor.parseType(ref, desc, i);
            JvmType t2 = ref[0];
            if (t2 == null) {
                MethodDescriptor.parseType(ref, desc, i + 1);
                returnType = ref[0];
                break;
            }
            params.add(t2);
        }
        if (returnType == null) {
            throw new IllegalArgumentException("desc is invalid: Does not have a return type: " + desc);
        }
        return new MethodDescriptor(params, returnType);
    }

    private static int parseType(@Nullable JvmType @NotNull [] ref, @NotNull String desc, int index) {
        char c = desc.charAt(index);
        switch (c) {
            case 'B': {
                ref[0] = PrimitiveType.BYTE;
                return index;
            }
            case 'S': {
                ref[0] = PrimitiveType.SHORT;
                return index;
            }
            case 'I': {
                ref[0] = PrimitiveType.INT;
                return index;
            }
            case 'J': {
                ref[0] = PrimitiveType.LONG;
                return index;
            }
            case 'F': {
                ref[0] = PrimitiveType.FLOAT;
                return index;
            }
            case 'D': {
                ref[0] = PrimitiveType.DOUBLE;
                return index;
            }
            case 'C': {
                ref[0] = PrimitiveType.CHAR;
                return index;
            }
            case 'Z': {
                ref[0] = PrimitiveType.BOOLEAN;
                return index;
            }
            case 'V': {
                ref[0] = PrimitiveType.VOID;
                return index;
            }
            case 'L': {
                int end = desc.indexOf(59, index);
                if (end == -1) {
                    throw new IllegalArgumentException("desc is invalid: Class type at index " + index + " is not terminated: " + desc);
                }
                ref[0] = new ClassType(desc.substring(index, end + 1));
                return end;
            }
            case '[': {
                int len = desc.length();
                int dim = 1;
                int i = index;
                ++i;
                while (i < len && desc.charAt(i) == '[') {
                    ++dim;
                    ++i;
                }
                int newIndex = MethodDescriptor.parseType(ref, desc, i);
                JvmType parsed = ref[0];
                if (parsed == null) {
                    throw new IllegalArgumentException("desc is invalid: Array type at index " + index + " is not terminated: " + desc);
                }
                ref[0] = new ArrayType(parsed, dim);
                return newIndex;
            }
            case ')': {
                ref[0] = null;
                return index;
            }
        }
        throw new IllegalArgumentException("desc is invalid: Unknown type char at index " + index + " '" + c + "': " + desc);
    }

    @NotNull
    public @NotNull List<@NotNull JvmType> getParams() {
        return this.params;
    }

    @NotNull
    public JvmType getReturnType() {
        return this.returnType;
    }

    @Contract(pure=true)
    @NotNull
    public String toInternalString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (JvmType param : this.params) {
            param.asInternalName(sb);
        }
        sb.append(')');
        this.returnType.asInternalName(sb);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodDescriptor that = (MethodDescriptor)o;
        return this.params.equals(that.params) && this.returnType.equals(that.returnType);
    }

    public int hashCode() {
        return Objects.hash(this.params, this.returnType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        Iterator<@NotNull JvmType> iter = this.params.iterator();
        while (iter.hasNext()) {
            iter.next().asReadableName(sb);
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(") ");
        this.returnType.asReadableName(sb);
        return sb.toString();
    }
}

