/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.mappings.contributors;

import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.mappings.ChangeRegistry;
import dev.denwav.hypo.mappings.contributors.ChangeContributor;
import dev.denwav.hypo.model.data.ClassData;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.cadixdev.lorenz.model.ClassMapping;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeContributorSet
implements ChangeContributor {
    @NotNull
    private final @NotNull List<@NotNull ChangeContributor> delegateContributors;

    private ChangeContributorSet(@NotNull @NotNull List<@NotNull ChangeContributor> delegateContributors) {
        this.delegateContributors = delegateContributors;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ChangeContributor wrap(@NotNull @NotNull Collection<@NotNull ChangeContributor> delegates) {
        return new ChangeContributorSet(List.copyOf(delegates));
    }

    @Override
    public void contribute(@Nullable ClassData currentClass, @Nullable ClassMapping<?, ?> classMapping, @NotNull HypoContext context, @NotNull ChangeRegistry registry) throws Throwable {
        for (ChangeContributor delegate : this.delegateContributors) {
            delegate.contribute(currentClass, classMapping, context, registry);
        }
    }

    @Override
    @NotNull
    public String name() {
        if (this.delegateContributors.size() == 1) {
            return this.delegateContributors.get(0).name();
        }
        return this.delegateContributors.stream().map(ChangeContributor::name).collect(Collectors.joining(", ", "Set[", "]"));
    }
}

