/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.mappings.changes;

import dev.denwav.hypo.mappings.LorenzUtil;
import dev.denwav.hypo.mappings.MergeResult;
import dev.denwav.hypo.mappings.MergeableMappingsChange;
import dev.denwav.hypo.mappings.changes.AbstractMappingsChange;
import dev.denwav.hypo.mappings.changes.MemberReference;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.cadixdev.lorenz.model.MethodParameterMapping;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class RemoveParameterMappingChange
extends AbstractMappingsChange
implements MergeableMappingsChange<RemoveParameterMappingChange> {
    private final long indices;

    private RemoveParameterMappingChange(@NotNull MemberReference target, long index) {
        super(target);
        this.indices = index;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static RemoveParameterMappingChange of(@NotNull MemberReference target, int index) {
        return new RemoveParameterMappingChange(target, RemoveParameterMappingChange.toBit(index));
    }

    @Override
    public void applyChange(@NotNull MappingSet input, @NotNull MemberReference target) {
        if (target.desc() == null) {
            return;
        }
        ClassMapping<?, ?> classMapping = LorenzUtil.getClassMapping(input, target.className());
        if (classMapping == null) {
            return;
        }
        MethodMapping methodMapping = LorenzUtil.getMethodMapping(classMapping, target.name(), target.desc());
        if (methodMapping == null) {
            return;
        }
        for (int i = 0; i < 64; ++i) {
            MethodParameterMapping paramMapping;
            if (!RemoveParameterMappingChange.isBitSet(this.indices, i) || (paramMapping = LorenzUtil.getParameterMapping(methodMapping, i)) == null) continue;
            LorenzUtil.removeParamMapping(paramMapping);
        }
    }

    @Override
    @NotNull
    public MergeResult<RemoveParameterMappingChange> mergeWith(@NotNull RemoveParameterMappingChange that) {
        return MergeResult.success(new RemoveParameterMappingChange(this.target(), this.indices | that.indices));
    }

    private static long toBit(int number) {
        return 1L << number;
    }

    private static boolean isBitSet(long bitset, int index) {
        return (bitset >> index & 1L) == 1L;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 64; ++i) {
            if (!RemoveParameterMappingChange.isBitSet(this.indices, i)) continue;
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(i);
        }
        return "Remove parameter mappings for indices [" + String.valueOf(sb) + "] from " + String.valueOf(this.target());
    }
}

