/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.mappings.changes;

import dev.denwav.hypo.mappings.changes.AbstractMappingsChange;
import dev.denwav.hypo.mappings.changes.MemberReference;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.cadixdev.lorenz.model.MethodParameterMapping;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CopyLambdaParametersChange
extends AbstractMappingsChange {
    @NotNull
    private final MethodMapping mapping;
    private final int paramOffset;

    private CopyLambdaParametersChange(@NotNull MemberReference target, @NotNull MethodMapping mapping, int paramOffset) {
        super(target);
        this.mapping = mapping;
        this.paramOffset = paramOffset;
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static CopyLambdaParametersChange of(@NotNull MemberReference target, @NotNull MethodMapping mapping, int paramOffset) {
        return new CopyLambdaParametersChange(target, mapping, paramOffset);
    }

    @Override
    public void applyChange(@NotNull MappingSet input, @NotNull MemberReference target) {
        ClassMapping<?, ?> map = input.getOrCreateClassMapping(target.className());
        MethodMapping newMapping = map.getOrCreateMethodMapping(target.name(), target.desc());
        for (MethodParameterMapping paramMapping : this.mapping.getParameterMappings()) {
            newMapping.getOrCreateParameterMapping(paramMapping.getIndex() + this.paramOffset).setDeobfuscatedName(paramMapping.getDeobfuscatedName());
        }
    }

    public String toString() {
        return "Copy interface parameter mappings '" + this.mapping.getFullDeobfuscatedName() + "' to lambda " + String.valueOf(this.target());
    }
}

