/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.mappings.changes;

import dev.denwav.hypo.mappings.MergeResult;
import dev.denwav.hypo.mappings.MergeableMappingsChange;
import dev.denwav.hypo.mappings.changes.AbstractMappingsChange;
import dev.denwav.hypo.mappings.changes.MemberReference;
import org.cadixdev.lorenz.MappingSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class AddNewParameterMappingsChange
extends AbstractMappingsChange
implements MergeableMappingsChange<AddNewParameterMappingsChange> {
    @NotNull
    private final String newName;

    private AddNewParameterMappingsChange(@NotNull MemberReference reference, @NotNull String newName) {
        super(reference);
        this.newName = newName;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static AddNewParameterMappingsChange of(@NotNull MemberReference target, @NotNull String newName) {
        return new AddNewParameterMappingsChange(target, newName);
    }

    @Override
    public void applyChange(@NotNull MappingSet input, @NotNull MemberReference target) {
        if (target.desc() == null) {
            return;
        }
        input.getOrCreateClassMapping(target.className()).getOrCreateMethodMapping(target.name(), target.desc()).getOrCreateParameterMapping(target.index()).setDeobfuscatedName(this.newName);
    }

    @Override
    @NotNull
    public MergeResult<AddNewParameterMappingsChange> mergeWith(@NotNull AddNewParameterMappingsChange that) {
        if (this.newName.equals(that.newName)) {
            return MergeResult.success(this);
        }
        return MergeResult.failure("Cannot merge add parameter mapping changes with different names");
    }

    public String toString() {
        return "Add parameter mapping '" + this.newName + "' to " + String.valueOf(this.target());
    }
}

