/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.mappings;

import dev.denwav.hypo.model.HypoModelUtil;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.FieldData;
import dev.denwav.hypo.model.data.MethodData;
import dev.denwav.hypo.model.data.types.ArrayType;
import dev.denwav.hypo.model.data.types.ClassType;
import dev.denwav.hypo.model.data.types.JvmType;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.cadixdev.bombe.type.FieldType;
import org.cadixdev.bombe.type.MethodDescriptor;
import org.cadixdev.bombe.type.ObjectType;
import org.cadixdev.bombe.type.PrimitiveType;
import org.cadixdev.bombe.type.Type;
import org.cadixdev.bombe.type.signature.FieldSignature;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.impl.MappingSetImpl;
import org.cadixdev.lorenz.impl.model.AbstractClassMappingImpl;
import org.cadixdev.lorenz.impl.model.MethodMappingImpl;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.FieldMapping;
import org.cadixdev.lorenz.model.InnerClassMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.cadixdev.lorenz.model.MethodParameterMapping;
import org.cadixdev.lorenz.model.TopLevelClassMapping;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LorenzUtil {
    private static final VarHandle topLevelClassesHandle;
    private static final VarHandle innerClassesHandle;
    private static final VarHandle fieldsHandle;
    private static final VarHandle fieldsByNameHandle;
    private static final VarHandle methodsHandle;
    private static final VarHandle paramsHandle;

    private LorenzUtil() {
    }

    @Nullable
    public static <T> T unwrap(@Nullable Optional<T> opt) {
        if (opt == null) {
            return null;
        }
        return opt.orElse(null);
    }

    @Contract(pure=true)
    @Nullable
    public static MethodData findMethod(@NotNull ClassData classData, @NotNull MethodMapping mapping) {
        return classData.method(mapping.getObfuscatedName(), LorenzUtil.convertDesc(mapping.getDescriptor()));
    }

    @Contract(pure=true)
    @NotNull
    public static @NotNull List<@NotNull FieldData> findField(@NotNull ClassData classData, @NotNull FieldMapping mapping) {
        FieldType type = LorenzUtil.getType(mapping);
        if (type == null) {
            return classData.fields(mapping.getObfuscatedName());
        }
        FieldData field = classData.field(mapping.getObfuscatedName(), LorenzUtil.convertType(type));
        if (field == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(field);
    }

    @NotNull
    public static dev.denwav.hypo.model.data.MethodDescriptor convertDesc(@NotNull MethodDescriptor desc) {
        ArrayList<JvmType> params = new ArrayList<JvmType>(desc.getParamTypes().size());
        for (FieldType paramType : desc.getParamTypes()) {
            params.add(LorenzUtil.convertType(paramType));
        }
        return new dev.denwav.hypo.model.data.MethodDescriptor(params, LorenzUtil.convertType(desc.getReturnType()));
    }

    @NotNull
    public static JvmType convertType(@NotNull Type type) {
        if (type instanceof org.cadixdev.bombe.type.ArrayType) {
            org.cadixdev.bombe.type.ArrayType array = (org.cadixdev.bombe.type.ArrayType)type;
            return new ArrayType(LorenzUtil.convertType(array.getComponent()), array.getDimCount());
        }
        if (type instanceof PrimitiveType) {
            return dev.denwav.hypo.model.data.types.PrimitiveType.fromChar(((PrimitiveType)type).getKey());
        }
        if (type instanceof ObjectType) {
            ObjectType obj = (ObjectType)type;
            return new ClassType(obj.getClassName());
        }
        throw new IllegalStateException("Unknown type: " + String.valueOf(type));
    }

    @Nullable
    public static ClassMapping<?, ?> getClassMapping(@Nullable MappingSet mappings, @NotNull String obfuscatedName) {
        if (mappings == null) {
            return null;
        }
        return LorenzUtil.unwrap(mappings.getClassMapping(obfuscatedName));
    }

    @Nullable
    public static MethodMapping getMethodMapping(@Nullable ClassMapping<?, ?> mapping, @NotNull String name, @NotNull String desc) {
        if (mapping == null) {
            return null;
        }
        return LorenzUtil.unwrap(mapping.getMethodMapping(name, desc));
    }

    @Nullable
    public static MethodMapping getMethodMapping(@Nullable ClassMapping<?, ?> mapping, @NotNull MethodData method) {
        if (mapping == null) {
            return null;
        }
        return LorenzUtil.unwrap(mapping.getMethodMapping(method.name(), method.descriptorText()));
    }

    @Nullable
    public static FieldMapping getFieldMapping(@Nullable ClassMapping<?, ?> mapping, @NotNull String name) {
        if (mapping == null) {
            return null;
        }
        return LorenzUtil.unwrap(mapping.getFieldMapping(name));
    }

    @Nullable
    public static FieldMapping getFieldMapping(@Nullable ClassMapping<?, ?> mapping, @NotNull FieldSignature sig) {
        if (mapping == null) {
            return null;
        }
        return LorenzUtil.unwrap(mapping.getFieldMapping(sig));
    }

    @Nullable
    public static MethodParameterMapping getParameterMapping(@Nullable MethodMapping mapping, int index) {
        if (mapping == null) {
            return null;
        }
        return LorenzUtil.unwrap(mapping.getParameterMapping(index));
    }

    @Nullable
    public static FieldType getType(@NotNull FieldMapping mapping) {
        return LorenzUtil.unwrap(mapping.getType());
    }

    public static void removeClassMapping(@NotNull ClassMapping<?, ?> mapping) {
        if (mapping instanceof TopLevelClassMapping) {
            LorenzUtil.removeTopLevelClassMapping(mapping, mapping.getMappings());
        } else if (mapping instanceof InnerClassMapping) {
            LorenzUtil.removeInnerClassMapping(mapping, (ClassMapping)((InnerClassMapping)mapping).getParent());
        }
    }

    public static void removeMethodMapping(@NotNull MethodMapping mapping) {
        LorenzUtil.removeMethodMapping(mapping, (ClassMapping)mapping.getParent());
    }

    public static void removeFieldMapping(@NotNull FieldMapping mapping) {
        LorenzUtil.removeFieldMapping(mapping, (ClassMapping)mapping.getParent());
    }

    public static void removeParamMapping(@NotNull MethodParameterMapping mapping) {
        LorenzUtil.removeParamMapping(mapping, (MethodMapping)mapping.getParent());
    }

    public static void removeTopLevelClassMapping(@NotNull ClassMapping<?, ?> topLevelClassMapping, @NotNull MappingSet mappingSet) {
        if (topLevelClassMapping instanceof TopLevelClassMapping) {
            LorenzUtil.getTopLevelClassesMap(mappingSet).values().remove(topLevelClassMapping);
        }
    }

    public static void removeInnerClassMapping(@NotNull ClassMapping<?, ?> innerClassMapping, @NotNull ClassMapping<?, ?> mapping) {
        if (innerClassMapping instanceof InnerClassMapping) {
            LorenzUtil.getInnerClassesMap(mapping).values().remove(innerClassMapping);
        }
    }

    public static void removeFieldMapping(@NotNull FieldMapping fieldMapping, @NotNull ClassMapping<?, ?> mapping) {
        LorenzUtil.getFieldsMap(mapping).values().remove(fieldMapping);
        LorenzUtil.getFieldsByNameMap(mapping).values().remove(fieldMapping);
    }

    public static void removeMethodMapping(@NotNull MethodMapping methodMapping, @NotNull ClassMapping<?, ?> mapping) {
        LorenzUtil.getMethodsMap(mapping).values().remove(methodMapping);
    }

    public static void removeParamMapping(@NotNull MethodParameterMapping paramMappings, @NotNull MethodMapping mapping) {
        LorenzUtil.getParamsMap(mapping).values().remove(paramMappings);
    }

    @Contract(pure=true)
    @NotNull
    public static Map<String, TopLevelClassMapping> getTopLevelClassesMap(@NotNull MappingSet mappingSet) {
        MappingSetImpl castMap = LorenzUtil.checkType(mappingSet);
        Object handleResult = topLevelClassesHandle.get(castMap);
        Map result = (Map)HypoModelUtil.cast(handleResult);
        return LorenzUtil.notNull(result, "topLevelClasses");
    }

    @Contract(pure=true)
    @NotNull
    public static Map<String, InnerClassMapping> getInnerClassesMap(@NotNull ClassMapping<?, ?> mapping) {
        AbstractClassMappingImpl<?, ?> castMap = LorenzUtil.checkType(mapping);
        Object handleResult = innerClassesHandle.get(castMap);
        Map result = (Map)HypoModelUtil.cast(handleResult);
        return LorenzUtil.notNull(result, "innerClasses");
    }

    @Contract(pure=true)
    @NotNull
    public static Map<FieldSignature, FieldMapping> getFieldsMap(@NotNull ClassMapping<?, ?> mapping) {
        AbstractClassMappingImpl<?, ?> castMap = LorenzUtil.checkType(mapping);
        Object handleResult = fieldsHandle.get(castMap);
        Map result = (Map)HypoModelUtil.cast(handleResult);
        return LorenzUtil.notNull(result, "fields");
    }

    @Contract(pure=true)
    @NotNull
    public static Map<String, FieldMapping> getFieldsByNameMap(@NotNull ClassMapping<?, ?> mapping) {
        AbstractClassMappingImpl<?, ?> castMap = LorenzUtil.checkType(mapping);
        Object handleResult = fieldsByNameHandle.get(castMap);
        Map result = (Map)HypoModelUtil.cast(handleResult);
        return LorenzUtil.notNull(result, "fieldsByName");
    }

    @Contract(pure=true)
    @NotNull
    public static Map<MethodSignature, MethodMapping> getMethodsMap(@NotNull ClassMapping<?, ?> mapping) {
        AbstractClassMappingImpl<?, ?> castMap = LorenzUtil.checkType(mapping);
        Object handleResult = methodsHandle.get(castMap);
        Map result = (Map)HypoModelUtil.cast(handleResult);
        return LorenzUtil.notNull(result, "methods");
    }

    @Contract(pure=true)
    @NotNull
    public static Map<Integer, MethodParameterMapping> getParamsMap(@NotNull MethodMapping mapping) {
        MethodMappingImpl castMap = LorenzUtil.checkType(mapping);
        Object handleResult = paramsHandle.get(castMap);
        Map result = (Map)HypoModelUtil.cast(handleResult);
        return LorenzUtil.notNull(result, "parameters");
    }

    @Contract(value="_ -> param1", pure=true)
    @NotNull
    static MappingSetImpl checkType(@NotNull MappingSet mappingSet) {
        if (!(mappingSet instanceof MappingSetImpl)) {
            throw new IllegalArgumentException("Argument is not an instance of " + MappingSetImpl.class.getName());
        }
        return (MappingSetImpl)mappingSet;
    }

    @Contract(value="_ -> param1", pure=true)
    @NotNull
    static AbstractClassMappingImpl<?, ?> checkType(@NotNull ClassMapping<?, ?> mapping) {
        if (!(mapping instanceof AbstractClassMappingImpl)) {
            throw new IllegalArgumentException("Argument is not an instance of " + AbstractClassMappingImpl.class.getName());
        }
        return (AbstractClassMappingImpl)mapping;
    }

    @Contract(value="_ -> param1", pure=true)
    @NotNull
    static MethodMappingImpl checkType(@NotNull MethodMapping mapping) {
        if (!(mapping instanceof MethodMappingImpl)) {
            throw new IllegalArgumentException("Argument is not an instance of " + MethodMappingImpl.class.getName());
        }
        return (MethodMappingImpl)mapping;
    }

    @Contract(value="null, _ -> fail; !null, _ -> param1", pure=true)
    @NotNull
    static <T> T notNull(@Nullable T t2, String fieldName) {
        if (t2 == null) {
            throw new NullPointerException(AbstractClassMappingImpl.class.getName() + "." + fieldName + " is null");
        }
        return t2;
    }

    static {
        try {
            topLevelClassesHandle = MethodHandles.privateLookupIn(MappingSetImpl.class, MethodHandles.lookup()).findVarHandle(MappingSetImpl.class, "topLevelClasses", Map.class);
            innerClassesHandle = MethodHandles.privateLookupIn(AbstractClassMappingImpl.class, MethodHandles.lookup()).findVarHandle(AbstractClassMappingImpl.class, "innerClasses", Map.class);
            fieldsHandle = MethodHandles.privateLookupIn(AbstractClassMappingImpl.class, MethodHandles.lookup()).findVarHandle(AbstractClassMappingImpl.class, "fields", Map.class);
            fieldsByNameHandle = MethodHandles.privateLookupIn(AbstractClassMappingImpl.class, MethodHandles.lookup()).findVarHandle(AbstractClassMappingImpl.class, "fieldsByName", Map.class);
            methodsHandle = MethodHandles.privateLookupIn(AbstractClassMappingImpl.class, MethodHandles.lookup()).findVarHandle(AbstractClassMappingImpl.class, "methods", Map.class);
            paramsHandle = MethodHandles.privateLookupIn(MethodMappingImpl.class, MethodHandles.lookup()).findVarHandle(MethodMappingImpl.class, "parameters", Map.class);
        }
        catch (Throwable t2) {
            throw new AssertionError((Object)t2);
        }
    }
}

